//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// UserConfirmationPasswordServer is a fake server for instances of the armapimanagement.UserConfirmationPasswordClient type.
type UserConfirmationPasswordServer struct {
	// Send is the fake for method UserConfirmationPasswordClient.Send
	// HTTP status codes to indicate success: http.StatusNoContent
	Send func(ctx context.Context, resourceGroupName string, serviceName string, userID string, options *armapimanagement.UserConfirmationPasswordClientSendOptions) (resp azfake.Responder[armapimanagement.UserConfirmationPasswordClientSendResponse], errResp azfake.ErrorResponder)
}

// NewUserConfirmationPasswordServerTransport creates a new instance of UserConfirmationPasswordServerTransport with the provided implementation.
// The returned UserConfirmationPasswordServerTransport instance is connected to an instance of armapimanagement.UserConfirmationPasswordClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUserConfirmationPasswordServerTransport(srv *UserConfirmationPasswordServer) *UserConfirmationPasswordServerTransport {
	return &UserConfirmationPasswordServerTransport{srv: srv}
}

// UserConfirmationPasswordServerTransport connects instances of armapimanagement.UserConfirmationPasswordClient to instances of UserConfirmationPasswordServer.
// Don't use this type directly, use NewUserConfirmationPasswordServerTransport instead.
type UserConfirmationPasswordServerTransport struct {
	srv *UserConfirmationPasswordServer
}

// Do implements the policy.Transporter interface for UserConfirmationPasswordServerTransport.
func (u *UserConfirmationPasswordServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UserConfirmationPasswordClient.Send":
		resp, err = u.dispatchSend(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UserConfirmationPasswordServerTransport) dispatchSend(req *http.Request) (*http.Response, error) {
	if u.srv.Send == nil {
		return nil, &nonRetriableError{errors.New("fake for method Send not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/confirmations/password/send`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	appTypeUnescaped, err := url.QueryUnescape(qp.Get("appType"))
	if err != nil {
		return nil, err
	}
	appTypeParam := getOptional(armapimanagement.AppType(appTypeUnescaped))
	var options *armapimanagement.UserConfirmationPasswordClientSendOptions
	if appTypeParam != nil {
		options = &armapimanagement.UserConfirmationPasswordClientSendOptions{
			AppType: appTypeParam,
		}
	}
	respr, errRespr := u.srv.Send(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
