//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/baremetalinfrastructure/armbaremetalinfrastructure/v2"
	"net/http"
	"net/url"
	"regexp"
)

// AzureBareMetalStorageInstancesServer is a fake server for instances of the armbaremetalinfrastructure.AzureBareMetalStorageInstancesClient type.
type AzureBareMetalStorageInstancesServer struct {
	// Create is the fake for method AzureBareMetalStorageInstancesClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, azureBareMetalStorageInstanceName string, requestBodyParameters armbaremetalinfrastructure.AzureBareMetalStorageInstance, options *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientCreateOptions) (resp azfake.Responder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method AzureBareMetalStorageInstancesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, azureBareMetalStorageInstanceName string, options *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientDeleteOptions) (resp azfake.Responder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AzureBareMetalStorageInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, azureBareMetalStorageInstanceName string, options *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientGetOptions) (resp azfake.Responder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method AzureBareMetalStorageInstancesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method AzureBareMetalStorageInstancesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListBySubscriptionResponse])

	// Update is the fake for method AzureBareMetalStorageInstancesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, azureBareMetalStorageInstanceName string, tagsParameter armbaremetalinfrastructure.Tags, options *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientUpdateOptions) (resp azfake.Responder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAzureBareMetalStorageInstancesServerTransport creates a new instance of AzureBareMetalStorageInstancesServerTransport with the provided implementation.
// The returned AzureBareMetalStorageInstancesServerTransport instance is connected to an instance of armbaremetalinfrastructure.AzureBareMetalStorageInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAzureBareMetalStorageInstancesServerTransport(srv *AzureBareMetalStorageInstancesServer) *AzureBareMetalStorageInstancesServerTransport {
	return &AzureBareMetalStorageInstancesServerTransport{
		srv:                         srv,
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListBySubscriptionResponse]](),
	}
}

// AzureBareMetalStorageInstancesServerTransport connects instances of armbaremetalinfrastructure.AzureBareMetalStorageInstancesClient to instances of AzureBareMetalStorageInstancesServer.
// Don't use this type directly, use NewAzureBareMetalStorageInstancesServerTransport instead.
type AzureBareMetalStorageInstancesServerTransport struct {
	srv                         *AzureBareMetalStorageInstancesServer
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for AzureBareMetalStorageInstancesServerTransport.
func (a *AzureBareMetalStorageInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AzureBareMetalStorageInstancesClient.Create":
		resp, err = a.dispatchCreate(req)
	case "AzureBareMetalStorageInstancesClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "AzureBareMetalStorageInstancesClient.Get":
		resp, err = a.dispatchGet(req)
	case "AzureBareMetalStorageInstancesClient.NewListByResourceGroupPager":
		resp, err = a.dispatchNewListByResourceGroupPager(req)
	case "AzureBareMetalStorageInstancesClient.NewListBySubscriptionPager":
		resp, err = a.dispatchNewListBySubscriptionPager(req)
	case "AzureBareMetalStorageInstancesClient.Update":
		resp, err = a.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AzureBareMetalStorageInstancesServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if a.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BareMetalInfrastructure/bareMetalStorageInstances/(?P<azureBareMetalStorageInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbaremetalinfrastructure.AzureBareMetalStorageInstance](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureBareMetalStorageInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureBareMetalStorageInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Create(req.Context(), resourceGroupNameParam, azureBareMetalStorageInstanceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureBareMetalStorageInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AzureBareMetalStorageInstancesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BareMetalInfrastructure/bareMetalStorageInstances/(?P<azureBareMetalStorageInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureBareMetalStorageInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureBareMetalStorageInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceGroupNameParam, azureBareMetalStorageInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AzureBareMetalStorageInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BareMetalInfrastructure/bareMetalStorageInstances/(?P<azureBareMetalStorageInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureBareMetalStorageInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureBareMetalStorageInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, azureBareMetalStorageInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureBareMetalStorageInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AzureBareMetalStorageInstancesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := a.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BareMetalInfrastructure/bareMetalStorageInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		a.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		a.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AzureBareMetalStorageInstancesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := a.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BareMetalInfrastructure/bareMetalStorageInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		a.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armbaremetalinfrastructure.AzureBareMetalStorageInstancesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		a.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (a *AzureBareMetalStorageInstancesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BareMetalInfrastructure/bareMetalStorageInstances/(?P<azureBareMetalStorageInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbaremetalinfrastructure.Tags](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureBareMetalStorageInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureBareMetalStorageInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Update(req.Context(), resourceGroupNameParam, azureBareMetalStorageInstanceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureBareMetalStorageInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
