//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcontainerservice

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcontainerservice/armhybridcontainerservice"
	moduleVersion = "v0.3.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AddonPhase - Observed phase of the addon on the target cluster. Possible values include: 'pending', 'provisioning', 'provisioning
// {HelmChartInstalled}', 'provisioning {MSICertificateDownloaded}', 'provisioned',
// 'deleting', 'failed', 'upgrading'
type AddonPhase string

const (
	AddonPhaseDeleting                             AddonPhase = "deleting"
	AddonPhaseFailed                               AddonPhase = "failed"
	AddonPhasePending                              AddonPhase = "pending"
	AddonPhaseProvisioned                          AddonPhase = "provisioned"
	AddonPhaseProvisioning                         AddonPhase = "provisioning"
	AddonPhaseProvisioningHelmChartInstalled       AddonPhase = "provisioning {HelmChartInstalled}"
	AddonPhaseProvisioningMSICertificateDownloaded AddonPhase = "provisioning {MSICertificateDownloaded}"
	AddonPhaseUpgrading                            AddonPhase = "upgrading"
)

// PossibleAddonPhaseValues returns the possible values for the AddonPhase const type.
func PossibleAddonPhaseValues() []AddonPhase {
	return []AddonPhase{
		AddonPhaseDeleting,
		AddonPhaseFailed,
		AddonPhasePending,
		AddonPhaseProvisioned,
		AddonPhaseProvisioning,
		AddonPhaseProvisioningHelmChartInstalled,
		AddonPhaseProvisioningMSICertificateDownloaded,
		AddonPhaseUpgrading,
	}
}

// AzureHybridBenefit - Indicates whether Azure Hybrid Benefit is opted in
type AzureHybridBenefit string

const (
	AzureHybridBenefitFalse         AzureHybridBenefit = "False"
	AzureHybridBenefitNotApplicable AzureHybridBenefit = "NotApplicable"
	AzureHybridBenefitTrue          AzureHybridBenefit = "True"
)

// PossibleAzureHybridBenefitValues returns the possible values for the AzureHybridBenefit const type.
func PossibleAzureHybridBenefitValues() []AzureHybridBenefit {
	return []AzureHybridBenefit{
		AzureHybridBenefitFalse,
		AzureHybridBenefitNotApplicable,
		AzureHybridBenefitTrue,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// ExtendedLocationTypes - The extended location type.
type ExtendedLocationTypes string

const (
	ExtendedLocationTypesCustomLocation ExtendedLocationTypes = "CustomLocation"
)

// PossibleExtendedLocationTypesValues returns the possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{
		ExtendedLocationTypesCustomLocation,
	}
}

// NetworkPolicy - NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico',
// 'flannel'. Default is 'calico'
type NetworkPolicy string

const (
	NetworkPolicyCalico  NetworkPolicy = "calico"
	NetworkPolicyFlannel NetworkPolicy = "flannel"
)

// PossibleNetworkPolicyValues returns the possible values for the NetworkPolicy const type.
func PossibleNetworkPolicyValues() []NetworkPolicy {
	return []NetworkPolicy{
		NetworkPolicyCalico,
		NetworkPolicyFlannel,
	}
}

// OSSKU - Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType is Linux. The default is Windows2019
// when OSType is Windows.
type OSSKU string

const (
	// OSSKUCBLMariner - Use Mariner as the OS for node images.
	OSSKUCBLMariner OSSKU = "CBLMariner"
	// OSSKUWindows2019 - Use Windows2019 as the OS for node images.
	OSSKUWindows2019 OSSKU = "Windows2019"
	// OSSKUWindows2022 - Use Windows2022 as the OS for node images.
	OSSKUWindows2022 OSSKU = "Windows2022"
)

// PossibleOSSKUValues returns the possible values for the OSSKU const type.
func PossibleOSSKUValues() []OSSKU {
	return []OSSKU{
		OSSKUCBLMariner,
		OSSKUWindows2019,
		OSSKUWindows2022,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// OsType - The particular KubernetesVersion's Image's OS Type (Linux, Windows)
type OsType string

const (
	OsTypeLinux   OsType = "Linux"
	OsTypeWindows OsType = "Windows"
)

// PossibleOsTypeValues returns the possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{
		OsTypeLinux,
		OsTypeWindows,
	}
}

type ProvisioningState string

const (
	ProvisioningStateAccepted   ProvisioningState = "Accepted"
	ProvisioningStateCanceled   ProvisioningState = "Canceled"
	ProvisioningStateCreated    ProvisioningState = "Created"
	ProvisioningStateDeleting   ProvisioningState = "Deleting"
	ProvisioningStateFailed     ProvisioningState = "Failed"
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	ProvisioningStateSucceeded  ProvisioningState = "Succeeded"
	ProvisioningStateUpdating   ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateCreated,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateInProgress,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// ResourceProvisioningState - Provisioning state of the resource
type ResourceProvisioningState string

const (
	ResourceProvisioningStateAccepted   ResourceProvisioningState = "Accepted"
	ResourceProvisioningStateCanceled   ResourceProvisioningState = "Canceled"
	ResourceProvisioningStateCreated    ResourceProvisioningState = "Created"
	ResourceProvisioningStateCreating   ResourceProvisioningState = "Creating"
	ResourceProvisioningStateDeleting   ResourceProvisioningState = "Deleting"
	ResourceProvisioningStateFailed     ResourceProvisioningState = "Failed"
	ResourceProvisioningStateInProgress ResourceProvisioningState = "InProgress"
	ResourceProvisioningStateSucceeded  ResourceProvisioningState = "Succeeded"
	ResourceProvisioningStateUpdating   ResourceProvisioningState = "Updating"
	ResourceProvisioningStateUpgrading  ResourceProvisioningState = "Upgrading"
)

// PossibleResourceProvisioningStateValues returns the possible values for the ResourceProvisioningState const type.
func PossibleResourceProvisioningStateValues() []ResourceProvisioningState {
	return []ResourceProvisioningState{
		ResourceProvisioningStateAccepted,
		ResourceProvisioningStateCanceled,
		ResourceProvisioningStateCreated,
		ResourceProvisioningStateCreating,
		ResourceProvisioningStateDeleting,
		ResourceProvisioningStateFailed,
		ResourceProvisioningStateInProgress,
		ResourceProvisioningStateSucceeded,
		ResourceProvisioningStateUpdating,
		ResourceProvisioningStateUpgrading,
	}
}
