//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managedservices/armmanagedservices"
	"net/http"
	"net/url"
	"regexp"
)

// MarketplaceRegistrationDefinitionsServer is a fake server for instances of the armmanagedservices.MarketplaceRegistrationDefinitionsClient type.
type MarketplaceRegistrationDefinitionsServer struct {
	// Get is the fake for method MarketplaceRegistrationDefinitionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, marketplaceIdentifier string, options *armmanagedservices.MarketplaceRegistrationDefinitionsClientGetOptions) (resp azfake.Responder[armmanagedservices.MarketplaceRegistrationDefinitionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MarketplaceRegistrationDefinitionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scope string, options *armmanagedservices.MarketplaceRegistrationDefinitionsClientListOptions) (resp azfake.PagerResponder[armmanagedservices.MarketplaceRegistrationDefinitionsClientListResponse])
}

// NewMarketplaceRegistrationDefinitionsServerTransport creates a new instance of MarketplaceRegistrationDefinitionsServerTransport with the provided implementation.
// The returned MarketplaceRegistrationDefinitionsServerTransport instance is connected to an instance of armmanagedservices.MarketplaceRegistrationDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMarketplaceRegistrationDefinitionsServerTransport(srv *MarketplaceRegistrationDefinitionsServer) *MarketplaceRegistrationDefinitionsServerTransport {
	return &MarketplaceRegistrationDefinitionsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmanagedservices.MarketplaceRegistrationDefinitionsClientListResponse]](),
	}
}

// MarketplaceRegistrationDefinitionsServerTransport connects instances of armmanagedservices.MarketplaceRegistrationDefinitionsClient to instances of MarketplaceRegistrationDefinitionsServer.
// Don't use this type directly, use NewMarketplaceRegistrationDefinitionsServerTransport instead.
type MarketplaceRegistrationDefinitionsServerTransport struct {
	srv          *MarketplaceRegistrationDefinitionsServer
	newListPager *tracker[azfake.PagerResponder[armmanagedservices.MarketplaceRegistrationDefinitionsClientListResponse]]
}

// Do implements the policy.Transporter interface for MarketplaceRegistrationDefinitionsServerTransport.
func (m *MarketplaceRegistrationDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MarketplaceRegistrationDefinitionsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MarketplaceRegistrationDefinitionsClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MarketplaceRegistrationDefinitionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedServices/marketplaceRegistrationDefinitions/(?P<marketplaceIdentifier>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	marketplaceIdentifierParam, err := url.PathUnescape(matches[regex.SubexpIndex("marketplaceIdentifier")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), scopeParam, marketplaceIdentifierParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MarketplaceRegistrationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MarketplaceRegistrationDefinitionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedServices/marketplaceRegistrationDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armmanagedservices.MarketplaceRegistrationDefinitionsClientListOptions
		if filterParam != nil {
			options = &armmanagedservices.MarketplaceRegistrationDefinitionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := m.srv.NewListPager(scopeParam, options)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmanagedservices.MarketplaceRegistrationDefinitionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}
