//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// DataCollectionRuleAssociationsServer is a fake server for instances of the armmonitor.DataCollectionRuleAssociationsClient type.
type DataCollectionRuleAssociationsServer struct {
	// Create is the fake for method DataCollectionRuleAssociationsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceURI string, associationName string, options *armmonitor.DataCollectionRuleAssociationsClientCreateOptions) (resp azfake.Responder[armmonitor.DataCollectionRuleAssociationsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method DataCollectionRuleAssociationsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceURI string, associationName string, options *armmonitor.DataCollectionRuleAssociationsClientDeleteOptions) (resp azfake.Responder[armmonitor.DataCollectionRuleAssociationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DataCollectionRuleAssociationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceURI string, associationName string, options *armmonitor.DataCollectionRuleAssociationsClientGetOptions) (resp azfake.Responder[armmonitor.DataCollectionRuleAssociationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataCollectionEndpointPager is the fake for method DataCollectionRuleAssociationsClient.NewListByDataCollectionEndpointPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataCollectionEndpointPager func(resourceGroupName string, dataCollectionEndpointName string, options *armmonitor.DataCollectionRuleAssociationsClientListByDataCollectionEndpointOptions) (resp azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByDataCollectionEndpointResponse])

	// NewListByResourcePager is the fake for method DataCollectionRuleAssociationsClient.NewListByResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourcePager func(resourceURI string, options *armmonitor.DataCollectionRuleAssociationsClientListByResourceOptions) (resp azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByResourceResponse])

	// NewListByRulePager is the fake for method DataCollectionRuleAssociationsClient.NewListByRulePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRulePager func(resourceGroupName string, dataCollectionRuleName string, options *armmonitor.DataCollectionRuleAssociationsClientListByRuleOptions) (resp azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByRuleResponse])
}

// NewDataCollectionRuleAssociationsServerTransport creates a new instance of DataCollectionRuleAssociationsServerTransport with the provided implementation.
// The returned DataCollectionRuleAssociationsServerTransport instance is connected to an instance of armmonitor.DataCollectionRuleAssociationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataCollectionRuleAssociationsServerTransport(srv *DataCollectionRuleAssociationsServer) *DataCollectionRuleAssociationsServerTransport {
	return &DataCollectionRuleAssociationsServerTransport{
		srv:                                  srv,
		newListByDataCollectionEndpointPager: newTracker[azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByDataCollectionEndpointResponse]](),
		newListByResourcePager:               newTracker[azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByResourceResponse]](),
		newListByRulePager:                   newTracker[azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByRuleResponse]](),
	}
}

// DataCollectionRuleAssociationsServerTransport connects instances of armmonitor.DataCollectionRuleAssociationsClient to instances of DataCollectionRuleAssociationsServer.
// Don't use this type directly, use NewDataCollectionRuleAssociationsServerTransport instead.
type DataCollectionRuleAssociationsServerTransport struct {
	srv                                  *DataCollectionRuleAssociationsServer
	newListByDataCollectionEndpointPager *tracker[azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByDataCollectionEndpointResponse]]
	newListByResourcePager               *tracker[azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByResourceResponse]]
	newListByRulePager                   *tracker[azfake.PagerResponder[armmonitor.DataCollectionRuleAssociationsClientListByRuleResponse]]
}

// Do implements the policy.Transporter interface for DataCollectionRuleAssociationsServerTransport.
func (d *DataCollectionRuleAssociationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataCollectionRuleAssociationsClient.Create":
		resp, err = d.dispatchCreate(req)
	case "DataCollectionRuleAssociationsClient.Delete":
		resp, err = d.dispatchDelete(req)
	case "DataCollectionRuleAssociationsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataCollectionRuleAssociationsClient.NewListByDataCollectionEndpointPager":
		resp, err = d.dispatchNewListByDataCollectionEndpointPager(req)
	case "DataCollectionRuleAssociationsClient.NewListByResourcePager":
		resp, err = d.dispatchNewListByResourcePager(req)
	case "DataCollectionRuleAssociationsClient.NewListByRulePager":
		resp, err = d.dispatchNewListByRulePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataCollectionRuleAssociationsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if d.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/dataCollectionRuleAssociations/(?P<associationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmonitor.DataCollectionRuleAssociationProxyOnlyResource](req)
	if err != nil {
		return nil, err
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	associationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("associationName")])
	if err != nil {
		return nil, err
	}
	var options *armmonitor.DataCollectionRuleAssociationsClientCreateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmonitor.DataCollectionRuleAssociationsClientCreateOptions{
			Body: &body,
		}
	}
	respr, errRespr := d.srv.Create(req.Context(), resourceURIParam, associationNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataCollectionRuleAssociationProxyOnlyResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataCollectionRuleAssociationsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if d.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/dataCollectionRuleAssociations/(?P<associationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	associationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("associationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Delete(req.Context(), resourceURIParam, associationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataCollectionRuleAssociationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/dataCollectionRuleAssociations/(?P<associationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	associationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("associationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceURIParam, associationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataCollectionRuleAssociationProxyOnlyResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataCollectionRuleAssociationsServerTransport) dispatchNewListByDataCollectionEndpointPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDataCollectionEndpointPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataCollectionEndpointPager not implemented")}
	}
	newListByDataCollectionEndpointPager := d.newListByDataCollectionEndpointPager.get(req)
	if newListByDataCollectionEndpointPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/dataCollectionEndpoints/(?P<dataCollectionEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/associations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataCollectionEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataCollectionEndpointName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByDataCollectionEndpointPager(resourceGroupNameParam, dataCollectionEndpointNameParam, nil)
		newListByDataCollectionEndpointPager = &resp
		d.newListByDataCollectionEndpointPager.add(req, newListByDataCollectionEndpointPager)
		server.PagerResponderInjectNextLinks(newListByDataCollectionEndpointPager, req, func(page *armmonitor.DataCollectionRuleAssociationsClientListByDataCollectionEndpointResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataCollectionEndpointPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDataCollectionEndpointPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataCollectionEndpointPager) {
		d.newListByDataCollectionEndpointPager.remove(req)
	}
	return resp, nil
}

func (d *DataCollectionRuleAssociationsServerTransport) dispatchNewListByResourcePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourcePager not implemented")}
	}
	newListByResourcePager := d.newListByResourcePager.get(req)
	if newListByResourcePager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/dataCollectionRuleAssociations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByResourcePager(resourceURIParam, nil)
		newListByResourcePager = &resp
		d.newListByResourcePager.add(req, newListByResourcePager)
		server.PagerResponderInjectNextLinks(newListByResourcePager, req, func(page *armmonitor.DataCollectionRuleAssociationsClientListByResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourcePager) {
		d.newListByResourcePager.remove(req)
	}
	return resp, nil
}

func (d *DataCollectionRuleAssociationsServerTransport) dispatchNewListByRulePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByRulePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRulePager not implemented")}
	}
	newListByRulePager := d.newListByRulePager.get(req)
	if newListByRulePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/dataCollectionRules/(?P<dataCollectionRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/associations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataCollectionRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataCollectionRuleName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByRulePager(resourceGroupNameParam, dataCollectionRuleNameParam, nil)
		newListByRulePager = &resp
		d.newListByRulePager.add(req, newListByRulePager)
		server.PagerResponderInjectNextLinks(newListByRulePager, req, func(page *armmonitor.DataCollectionRuleAssociationsClientListByRuleResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByRulePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByRulePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRulePager) {
		d.newListByRulePager.remove(req)
	}
	return resp, nil
}
