//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicyinsights_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_ListSubscriptionScope.json
func ExampleAttestationsClient_NewListForSubscriptionPager_listAttestationsAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAttestationsClient().NewListForSubscriptionPager(&armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AttestationListResult = armpolicyinsights.AttestationListResult{
		// 	Value: []*armpolicyinsights.Attestation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
		// 				Comments: to.Ptr("This subscription has passed a security audit."),
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				Evidence: []*armpolicyinsights.AttestationEvidence{
		// 					{
		// 						Description: to.Ptr("The results of the security audit."),
		// 						SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
		// 				}},
		// 				ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				Metadata: map[string]any{
		// 					"departmentId": "NYC-MARKETING-1",
		// 				},
		// 				Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("689bfc0c-a012-49fc-af40-3ebea35ff3ed"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.policyinsights/attestations/689bfc0c-a012-49fc-af40-3ebea35ff3ed"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/090a47f8-13e9-441e-ad90-dc666cc5d487"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("34709f31-f267-4eee-8479-0da11925f2f2"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("34709f31-f267-4eee-8479-0da11925f2f2"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_ListSubscriptionScope_WithQuery.json
func ExampleAttestationsClient_NewListForSubscriptionPager_listAttestationsAtSubscriptionScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAttestationsClient().NewListForSubscriptionPager(&armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5' AND PolicyDefinitionReferenceId eq '0b158b46-ff42-4799-8e39-08a5c23b4551'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AttestationListResult = armpolicyinsights.AttestationListResult{
		// 	Value: []*armpolicyinsights.Attestation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
		// 				Comments: to.Ptr("This subscription has passed a security audit."),
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				Evidence: []*armpolicyinsights.AttestationEvidence{
		// 					{
		// 						Description: to.Ptr("The results of the security audit."),
		// 						SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
		// 				}},
		// 				ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				Metadata: map[string]any{
		// 					"departmentId": "NYC-MARKETING-1",
		// 				},
		// 				Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_CreateSubscriptionScope.json
func ExampleAttestationsClient_BeginCreateOrUpdateAtSubscription_createAttestationAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAttestationsClient().BeginCreateOrUpdateAtSubscription(ctx, "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", armpolicyinsights.Attestation{
		Properties: &armpolicyinsights.AttestationProperties{
			ComplianceState:    to.Ptr(armpolicyinsights.ComplianceStateCompliant),
			PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_CreateSubscriptionScope_AllProperties.json
func ExampleAttestationsClient_BeginCreateOrUpdateAtSubscription_createAttestationAtSubscriptionScopeWithAllProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAttestationsClient().BeginCreateOrUpdateAtSubscription(ctx, "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", armpolicyinsights.Attestation{
		Properties: &armpolicyinsights.AttestationProperties{
			AssessmentDate:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t }()),
			Comments:        to.Ptr("This subscription has passed a security audit."),
			ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
			Evidence: []*armpolicyinsights.AttestationEvidence{
				{
					Description: to.Ptr("The results of the security audit."),
					SourceURI:   to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
				}},
			ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t }()),
			Metadata: map[string]any{
				"departmentId": "NYC-MARKETING-1",
			},
			Owner:                       to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
			PolicyAssignmentID:          to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
			PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
	// 		Comments: to.Ptr("This subscription has passed a security audit."),
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		Evidence: []*armpolicyinsights.AttestationEvidence{
	// 			{
	// 				Description: to.Ptr("The results of the security audit."),
	// 				SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
	// 		}},
	// 		ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		Metadata: map[string]any{
	// 			"departmentId": "NYC-MARKETING-1",
	// 		},
	// 		Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_GetSubscriptionScope.json
func ExampleAttestationsClient_GetAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAttestationsClient().GetAtSubscription(ctx, "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
	// 		Comments: to.Ptr("This subscription has passed a security audit."),
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		Evidence: []*armpolicyinsights.AttestationEvidence{
	// 			{
	// 				Description: to.Ptr("The results of the security audit."),
	// 				SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
	// 		}},
	// 		ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		Metadata: map[string]any{
	// 			"departmentId": "NYC-MARKETING-1",
	// 		},
	// 		Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_DeleteSubscriptionScope.json
func ExampleAttestationsClient_DeleteAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAttestationsClient().DeleteAtSubscription(ctx, "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_ListResourceGroupScope.json
func ExampleAttestationsClient_NewListForResourceGroupPager_listAttestationsAtResourceGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAttestationsClient().NewListForResourceGroupPager("myRg", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AttestationListResult = armpolicyinsights.AttestationListResult{
		// 	Value: []*armpolicyinsights.Attestation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
		// 				Comments: to.Ptr("This subscription has passed a security audit."),
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				Evidence: []*armpolicyinsights.AttestationEvidence{
		// 					{
		// 						Description: to.Ptr("The results of the security audit."),
		// 						SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
		// 				}},
		// 				ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				Metadata: map[string]any{
		// 					"departmentId": "NYC-MARKETING-1",
		// 				},
		// 				Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("689bfc0c-a012-49fc-af40-3ebea35ff3ed"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.policyinsights/attestations/689bfc0c-a012-49fc-af40-3ebea35ff3ed"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/090a47f8-13e9-441e-ad90-dc666cc5d487"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("34709f31-f267-4eee-8479-0da11925f2f2"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("34709f31-f267-4eee-8479-0da11925f2f2"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_ListResourceGroupScope_WithQuery.json
func ExampleAttestationsClient_NewListForResourceGroupPager_listAttestationsAtResourceGroupScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAttestationsClient().NewListForResourceGroupPager("myRg", &armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5' AND PolicyDefinitionReferenceId eq '0b158b46-ff42-4799-8e39-08a5c23b4551'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AttestationListResult = armpolicyinsights.AttestationListResult{
		// 	Value: []*armpolicyinsights.Attestation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
		// 				Comments: to.Ptr("This subscription has passed a security audit."),
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				Evidence: []*armpolicyinsights.AttestationEvidence{
		// 					{
		// 						Description: to.Ptr("The results of the security audit."),
		// 						SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
		// 				}},
		// 				ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				Metadata: map[string]any{
		// 					"departmentId": "NYC-MARKETING-1",
		// 				},
		// 				Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_CreateResourceGroupScope.json
func ExampleAttestationsClient_BeginCreateOrUpdateAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAttestationsClient().BeginCreateOrUpdateAtResourceGroup(ctx, "myRg", "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", armpolicyinsights.Attestation{
		Properties: &armpolicyinsights.AttestationProperties{
			AssessmentDate:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t }()),
			Comments:        to.Ptr("This subscription has passed a security audit."),
			ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
			Evidence: []*armpolicyinsights.AttestationEvidence{
				{
					Description: to.Ptr("The results of the security audit."),
					SourceURI:   to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
				}},
			ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t }()),
			Metadata: map[string]any{
				"departmentId": "NYC-MARKETING-1",
			},
			Owner:                       to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
			PolicyAssignmentID:          to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
			PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
	// 		Comments: to.Ptr("This subscription has passed a security audit."),
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		Evidence: []*armpolicyinsights.AttestationEvidence{
	// 			{
	// 				Description: to.Ptr("The results of the security audit."),
	// 				SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
	// 		}},
	// 		ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		Metadata: map[string]any{
	// 			"departmentId": "NYC-MARKETING-1",
	// 		},
	// 		Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_GetResourceGroupScope.json
func ExampleAttestationsClient_GetAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAttestationsClient().GetAtResourceGroup(ctx, "myRg", "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
	// 		Comments: to.Ptr("This subscription has passed a security audit."),
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		Evidence: []*armpolicyinsights.AttestationEvidence{
	// 			{
	// 				Description: to.Ptr("The results of the security audit."),
	// 				SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
	// 		}},
	// 		ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		Metadata: map[string]any{
	// 			"departmentId": "NYC-MARKETING-1",
	// 		},
	// 		Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_DeleteResourceGroupScope.json
func ExampleAttestationsClient_DeleteAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAttestationsClient().DeleteAtResourceGroup(ctx, "myRg", "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_ListResourceScope.json
func ExampleAttestationsClient_NewListForResourcePager_listAttestationsAtIndividualResourceScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAttestationsClient().NewListForResourcePager("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AttestationListResult = armpolicyinsights.AttestationListResult{
		// 	Value: []*armpolicyinsights.Attestation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
		// 				Comments: to.Ptr("This subscription has passed a security audit."),
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				Evidence: []*armpolicyinsights.AttestationEvidence{
		// 					{
		// 						Description: to.Ptr("The results of the security audit."),
		// 						SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
		// 				}},
		// 				ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				Metadata: map[string]any{
		// 					"departmentId": "NYC-MARKETING-1",
		// 				},
		// 				Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("689bfc0c-a012-49fc-af40-3ebea35ff3ed"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM/providers/microsoft.policyinsights/attestations/689bfc0c-a012-49fc-af40-3ebea35ff3ed"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/090a47f8-13e9-441e-ad90-dc666cc5d487"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("34709f31-f267-4eee-8479-0da11925f2f2"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("34709f31-f267-4eee-8479-0da11925f2f2"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_ListResourceScope_WithQuery.json
func ExampleAttestationsClient_NewListForResourcePager_listAttestationsAtIndividualResourceScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAttestationsClient().NewListForResourcePager("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM", &armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5' AND PolicyDefinitionReferenceId eq '0b158b46-ff42-4799-8e39-08a5c23b4551'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AttestationListResult = armpolicyinsights.AttestationListResult{
		// 	Value: []*armpolicyinsights.Attestation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.AttestationProperties{
		// 				AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
		// 				Comments: to.Ptr("This subscription has passed a security audit."),
		// 				ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
		// 				Evidence: []*armpolicyinsights.AttestationEvidence{
		// 					{
		// 						Description: to.Ptr("The results of the security audit."),
		// 						SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
		// 				}},
		// 				ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
		// 				LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				Metadata: map[string]any{
		// 					"departmentId": "NYC-MARKETING-1",
		// 				},
		// 				Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_CreateResourceScope.json
func ExampleAttestationsClient_BeginCreateOrUpdateAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAttestationsClient().BeginCreateOrUpdateAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM", "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", armpolicyinsights.Attestation{
		Properties: &armpolicyinsights.AttestationProperties{
			AssessmentDate:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t }()),
			Comments:        to.Ptr("This subscription has passed a security audit."),
			ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
			Evidence: []*armpolicyinsights.AttestationEvidence{
				{
					Description: to.Ptr("The results of the security audit."),
					SourceURI:   to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
				}},
			ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t }()),
			Metadata: map[string]any{
				"departmentId": "NYC-MARKETING-1",
			},
			Owner:                       to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
			PolicyAssignmentID:          to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
			PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
	// 		Comments: to.Ptr("This subscription has passed a security audit."),
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		Evidence: []*armpolicyinsights.AttestationEvidence{
	// 			{
	// 				Description: to.Ptr("The results of the security audit."),
	// 				SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
	// 		}},
	// 		ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		Metadata: map[string]any{
	// 			"departmentId": "NYC-MARKETING-1",
	// 		},
	// 		Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_GetResourceScope.json
func ExampleAttestationsClient_GetAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAttestationsClient().GetAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM", "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Attestation = armpolicyinsights.Attestation{
	// 	Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/attestations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM/providers/microsoft.policyinsights/attestations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
	// 	Properties: &armpolicyinsights.AttestationProperties{
	// 		AssessmentDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T00:00:00.000Z"); return t}()),
	// 		Comments: to.Ptr("This subscription has passed a security audit."),
	// 		ComplianceState: to.Ptr(armpolicyinsights.ComplianceStateCompliant),
	// 		Evidence: []*armpolicyinsights.AttestationEvidence{
	// 			{
	// 				Description: to.Ptr("The results of the security audit."),
	// 				SourceURI: to.Ptr("https://gist.github.com/contoso/9573e238762c60166c090ae16b814011"),
	// 		}},
	// 		ExpiresOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-15T00:00:00.000Z"); return t}()),
	// 		LastComplianceStateChangeAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		Metadata: map[string]any{
	// 			"departmentId": "NYC-MARKETING-1",
	// 		},
	// 		Owner: to.Ptr("55a32e28-3aa5-4eea-9b5a-4cd85153b966"),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("0b158b46-ff42-4799-8e39-08a5c23b4551"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2022-09-01/examples/Attestations_DeleteResourceScope.json
func ExampleAttestationsClient_DeleteAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAttestationsClient().DeleteAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myrg/providers/microsoft.compute/virtualMachines/devVM", "790996e6-9871-4b1f-9cd9-ec42cd6ced1e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
