//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_Get.json
func ExampleSQLVulnerabilityAssessmentScansClient_Get_getScanDetailsOfAScanRecord() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScansClient().Get(ctx, "Scheduled-20200623", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Scan = armsecurity.Scan{
	// 	Name: to.Ptr("Scheduled-20200623"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623"),
	// 	Properties: &armsecurity.ScanProperties{
	// 		Database: to.Ptr("master"),
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.723Z"); return t}()),
	// 		HighSeverityFailedRulesCount: to.Ptr[int32](3),
	// 		IsBaselineApplied: to.Ptr(false),
	// 		LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 		LowSeverityFailedRulesCount: to.Ptr[int32](1),
	// 		MediumSeverityFailedRulesCount: to.Ptr[int32](2),
	// 		Server: to.Ptr("server1"),
	// 		SQLVersion: to.Ptr("15.0.2000"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 		State: to.Ptr(armsecurity.ScanStateFailed),
	// 		TotalFailedRulesCount: to.Ptr[int32](6),
	// 		TotalPassedRulesCount: to.Ptr[int32](20),
	// 		TotalRulesCount: to.Ptr[int32](26),
	// 		TriggerType: to.Ptr(armsecurity.ScanTriggerTypeRecurring),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_GetLatest.json
func ExampleSQLVulnerabilityAssessmentScansClient_Get_getScanDetailsOfTheLatestScanRecord() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScansClient().Get(ctx, "latest", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Scan = armsecurity.Scan{
	// 	Name: to.Ptr("Scheduled-20200623"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623"),
	// 	Properties: &armsecurity.ScanProperties{
	// 		Database: to.Ptr("master"),
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.723Z"); return t}()),
	// 		HighSeverityFailedRulesCount: to.Ptr[int32](3),
	// 		IsBaselineApplied: to.Ptr(false),
	// 		LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 		LowSeverityFailedRulesCount: to.Ptr[int32](1),
	// 		MediumSeverityFailedRulesCount: to.Ptr[int32](2),
	// 		Server: to.Ptr("server1"),
	// 		SQLVersion: to.Ptr("15.0.2000"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 		State: to.Ptr(armsecurity.ScanStateFailed),
	// 		TotalFailedRulesCount: to.Ptr[int32](6),
	// 		TotalPassedRulesCount: to.Ptr[int32](20),
	// 		TotalRulesCount: to.Ptr[int32](26),
	// 		TriggerType: to.Ptr(armsecurity.ScanTriggerTypeRecurring),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_List.json
func ExampleSQLVulnerabilityAssessmentScansClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScansClient().List(ctx, "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Scans = armsecurity.Scans{
	// 	Value: []*armsecurity.Scan{
	// 		{
	// 			Name: to.Ptr("Scheduled-20200225"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200225"),
	// 			Properties: &armsecurity.ScanProperties{
	// 				Database: to.Ptr("master"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-25T11:38:07.860Z"); return t}()),
	// 				HighSeverityFailedRulesCount: to.Ptr[int32](3),
	// 				IsBaselineApplied: to.Ptr(false),
	// 				LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 				LowSeverityFailedRulesCount: to.Ptr[int32](1),
	// 				MediumSeverityFailedRulesCount: to.Ptr[int32](2),
	// 				Server: to.Ptr("server1"),
	// 				SQLVersion: to.Ptr("15.0.2000"),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-25T11:34:29.139Z"); return t}()),
	// 				State: to.Ptr(armsecurity.ScanStateFailed),
	// 				TotalFailedRulesCount: to.Ptr[int32](6),
	// 				TotalPassedRulesCount: to.Ptr[int32](20),
	// 				TotalRulesCount: to.Ptr[int32](26),
	// 				TriggerType: to.Ptr(armsecurity.ScanTriggerTypeRecurring),
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("scan_20200226_113429"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/scan_20200226_113429"),
	// 			Properties: &armsecurity.ScanProperties{
	// 				Database: to.Ptr("master"),
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-26T11:38:07.860Z"); return t}()),
	// 				HighSeverityFailedRulesCount: to.Ptr[int32](0),
	// 				IsBaselineApplied: to.Ptr(true),
	// 				LastScanTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-23T06:49:00.645Z"); return t}()),
	// 				LowSeverityFailedRulesCount: to.Ptr[int32](0),
	// 				MediumSeverityFailedRulesCount: to.Ptr[int32](0),
	// 				Server: to.Ptr("server1"),
	// 				SQLVersion: to.Ptr("15.0.2000"),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-26T11:34:29.139Z"); return t}()),
	// 				State: to.Ptr(armsecurity.ScanStatePassed),
	// 				TotalFailedRulesCount: to.Ptr[int32](0),
	// 				TotalPassedRulesCount: to.Ptr[int32](26),
	// 				TotalRulesCount: to.Ptr[int32](26),
	// 				TriggerType: to.Ptr(armsecurity.ScanTriggerTypeOnDemand),
	// 			},
	// 	}},
	// }
}
