//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// AvailableProviderOperationsClient contains the methods for the AvailableProviderOperations group.
// Don't use this type directly, use NewAvailableProviderOperationsClient() instead.
type AvailableProviderOperationsClient struct {
	internal *arm.Client
}

// NewAvailableProviderOperationsClient creates a new instance of AvailableProviderOperationsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAvailableProviderOperationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AvailableProviderOperationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AvailableProviderOperationsClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - List of AvailableProviderOperations
//
// Generated from API version 2016-10-01
//   - options - AvailableProviderOperationsClientListOptions contains the optional parameters for the AvailableProviderOperationsClient.NewListPager
//     method.
func (client *AvailableProviderOperationsClient) NewListPager(options *AvailableProviderOperationsClientListOptions) *runtime.Pager[AvailableProviderOperationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AvailableProviderOperationsClientListResponse]{
		More: func(page AvailableProviderOperationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AvailableProviderOperationsClientListResponse) (AvailableProviderOperationsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AvailableProviderOperationsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return AvailableProviderOperationsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *AvailableProviderOperationsClient) listCreateRequest(ctx context.Context, options *AvailableProviderOperationsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.StorSimple/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AvailableProviderOperationsClient) listHandleResponse(resp *http.Response) (AvailableProviderOperationsClientListResponse, error) {
	result := AvailableProviderOperationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AvailableProviderOperations); err != nil {
		return AvailableProviderOperationsClientListResponse{}, err
	}
	return result, nil
}
