// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -O0 -cl-std=CL1.2 -triple amdgcn-amd-amdhsa -emit-llvm %s -o - | FileCheck -check-prefixes=CL12 %s
// RUN: %clang_cc1 -O0 -cl-std=CL2.0 -triple amdgcn-amd-amdhsa -emit-llvm %s -o - | FileCheck -check-prefixes=CL20 %s

// CL12-LABEL: define dso_local void @func1(
// CL12-SAME: ptr addrspace(5) noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// CL12-NEXT:  [[ENTRY:.*:]]
// CL12-NEXT:    [[X_ADDR:%.*]] = alloca ptr addrspace(5), align 4, addrspace(5)
// CL12-NEXT:    store ptr addrspace(5) [[X]], ptr addrspace(5) [[X_ADDR]], align 4
// CL12-NEXT:    [[TMP0:%.*]] = load ptr addrspace(5), ptr addrspace(5) [[X_ADDR]], align 4
// CL12-NEXT:    store i32 1, ptr addrspace(5) [[TMP0]], align 4
// CL12-NEXT:    ret void
//
// CL20-LABEL: define dso_local void @func1(
// CL20-SAME: ptr noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// CL20-NEXT:  [[ENTRY:.*:]]
// CL20-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CL20-NEXT:    [[X_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[X_ADDR]] to ptr
// CL20-NEXT:    store ptr [[X]], ptr [[X_ADDR_ASCAST]], align 8
// CL20-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR_ASCAST]], align 8
// CL20-NEXT:    store i32 1, ptr [[TMP0]], align 4
// CL20-NEXT:    ret void
//
void func1(int *x) {
  *x = 1;
}

// CL12-LABEL: define dso_local void @func2(
// CL12-SAME: ) #[[ATTR0]] {
// CL12-NEXT:  [[ENTRY:.*:]]
// CL12-NEXT:    [[LV1:%.*]] = alloca i32, align 4, addrspace(5)
// CL12-NEXT:    [[LV2:%.*]] = alloca i32, align 4, addrspace(5)
// CL12-NEXT:    [[LA:%.*]] = alloca [100 x i32], align 4, addrspace(5)
// CL12-NEXT:    [[LP1:%.*]] = alloca ptr addrspace(5), align 4, addrspace(5)
// CL12-NEXT:    [[LP2:%.*]] = alloca ptr addrspace(5), align 4, addrspace(5)
// CL12-NEXT:    [[LVC:%.*]] = alloca i32, align 4, addrspace(5)
// CL12-NEXT:    store i32 1, ptr addrspace(5) [[LV1]], align 4
// CL12-NEXT:    store i32 2, ptr addrspace(5) [[LV2]], align 4
// CL12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], ptr addrspace(5) [[LA]], i64 0, i64 0
// CL12-NEXT:    store i32 3, ptr addrspace(5) [[ARRAYIDX]], align 4
// CL12-NEXT:    store ptr addrspace(5) [[LV1]], ptr addrspace(5) [[LP1]], align 4
// CL12-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], ptr addrspace(5) [[LA]], i64 0, i64 0
// CL12-NEXT:    store ptr addrspace(5) [[ARRAYDECAY]], ptr addrspace(5) [[LP2]], align 4
// CL12-NEXT:    call void @func1(ptr addrspace(5) noundef [[LV1]]) #[[ATTR2:[0-9]+]]
// CL12-NEXT:    store i32 4, ptr addrspace(5) [[LVC]], align 4
// CL12-NEXT:    store i32 4, ptr addrspace(5) [[LV1]], align 4
// CL12-NEXT:    ret void
//
// CL20-LABEL: define dso_local void @func2(
// CL20-SAME: ) #[[ATTR0]] {
// CL20-NEXT:  [[ENTRY:.*:]]
// CL20-NEXT:    [[LV1:%.*]] = alloca i32, align 4, addrspace(5)
// CL20-NEXT:    [[LV2:%.*]] = alloca i32, align 4, addrspace(5)
// CL20-NEXT:    [[LA:%.*]] = alloca [100 x i32], align 4, addrspace(5)
// CL20-NEXT:    [[LP1:%.*]] = alloca ptr, align 8, addrspace(5)
// CL20-NEXT:    [[LP2:%.*]] = alloca ptr, align 8, addrspace(5)
// CL20-NEXT:    [[LVC:%.*]] = alloca i32, align 4, addrspace(5)
// CL20-NEXT:    store i32 1, ptr addrspace(5) [[LV1]], align 4
// CL20-NEXT:    store i32 2, ptr addrspace(5) [[LV2]], align 4
// CL20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], ptr addrspace(5) [[LA]], i64 0, i64 0
// CL20-NEXT:    store i32 3, ptr addrspace(5) [[ARRAYIDX]], align 4
// CL20-NEXT:    [[LV1_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[LV1]] to ptr
// CL20-NEXT:    store ptr [[LV1_ASCAST]], ptr addrspace(5) [[LP1]], align 8
// CL20-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], ptr addrspace(5) [[LA]], i64 0, i64 0
// CL20-NEXT:    [[ARRAYDECAY_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[ARRAYDECAY]] to ptr
// CL20-NEXT:    store ptr [[ARRAYDECAY_ASCAST]], ptr addrspace(5) [[LP2]], align 8
// CL20-NEXT:    [[LV1_ASCAST1:%.*]] = addrspacecast ptr addrspace(5) [[LV1]] to ptr
// CL20-NEXT:    call void @func1(ptr noundef [[LV1_ASCAST1]]) #[[ATTR2:[0-9]+]]
// CL20-NEXT:    store i32 4, ptr addrspace(5) [[LVC]], align 4
// CL20-NEXT:    store i32 4, ptr addrspace(5) [[LV1]], align 4
// CL20-NEXT:    ret void
//
void func2(void) {
  int lv1;
  lv1 = 1;
  int lv2 = 2;

  int la[100];
  la[0] = 3;

  int *lp1 = &lv1;

  int *lp2 = la;

  func1(&lv1);

  const int lvc = 4;
  lv1 = lvc;
}

// CL12-LABEL: define dso_local void @func3(
// CL12-SAME: ) #[[ATTR0]] {
// CL12-NEXT:  [[ENTRY:.*:]]
// CL12-NEXT:    [[A:%.*]] = alloca [16 x [1 x float]], align 4, addrspace(5)
// CL12-NEXT:    call void @llvm.memset.p5.i64(ptr addrspace(5) align 4 [[A]], i8 0, i64 64, i1 false)
// CL12-NEXT:    ret void
//
// CL20-LABEL: define dso_local void @func3(
// CL20-SAME: ) #[[ATTR0]] {
// CL20-NEXT:  [[ENTRY:.*:]]
// CL20-NEXT:    [[A:%.*]] = alloca [16 x [1 x float]], align 4, addrspace(5)
// CL20-NEXT:    call void @llvm.memset.p5.i64(ptr addrspace(5) align 4 [[A]], i8 0, i64 64, i1 false)
// CL20-NEXT:    ret void
//
void func3(void) {
  float a[16][1] = {{0.}};
}

// CL12-LABEL: define dso_local void @wrong_store_type_private_pointer_alloca(
// CL12-SAME: ) #[[ATTR0]] {
// CL12-NEXT:  [[ENTRY:.*:]]
// CL12-NEXT:    [[VAR:%.*]] = alloca i64, align 8, addrspace(5)
// CL12-NEXT:    [[ALLOCA_ADDR:%.*]] = alloca ptr addrspace(5), align 4, addrspace(5)
// CL12-NEXT:    store i64 5, ptr addrspace(5) [[VAR]], align 8
// CL12-NEXT:    store ptr addrspace(5) [[VAR]], ptr addrspace(5) [[ALLOCA_ADDR]], align 4
// CL12-NEXT:    [[TMP0:%.*]] = load ptr addrspace(5), ptr addrspace(5) [[ALLOCA_ADDR]], align 4
// CL12-NEXT:    store i64 8, ptr addrspace(5) [[TMP0]], align 8
// CL12-NEXT:    ret void
//
// CL20-LABEL: define dso_local void @wrong_store_type_private_pointer_alloca(
// CL20-SAME: ) #[[ATTR0]] {
// CL20-NEXT:  [[ENTRY:.*:]]
// CL20-NEXT:    [[VAR:%.*]] = alloca i64, align 8, addrspace(5)
// CL20-NEXT:    [[ALLOCA_ADDR:%.*]] = alloca ptr addrspace(5), align 4, addrspace(5)
// CL20-NEXT:    store i64 5, ptr addrspace(5) [[VAR]], align 8
// CL20-NEXT:    store ptr addrspace(5) [[VAR]], ptr addrspace(5) [[ALLOCA_ADDR]], align 4
// CL20-NEXT:    [[TMP0:%.*]] = load ptr addrspace(5), ptr addrspace(5) [[ALLOCA_ADDR]], align 4
// CL20-NEXT:    store i64 8, ptr addrspace(5) [[TMP0]], align 8
// CL20-NEXT:    ret void
//
void wrong_store_type_private_pointer_alloca() {
  long var = 5;

  // This needs to write an addrspace(5) pointer to the temporary alloca,
  // which should be allocated with the correct size.
  __private long *alloca_addr = &var;
  *alloca_addr = 8;
}

// CL12-LABEL: define dso_local void @wrong_store_type_private_pointer_as_generic_alloca(
// CL12-SAME: ) #[[ATTR0]] {
// CL12-NEXT:  [[ENTRY:.*:]]
// CL12-NEXT:    [[VAR:%.*]] = alloca i64, align 8, addrspace(5)
// CL12-NEXT:    [[ALLOCA_ADDR_AS_GENERIC:%.*]] = alloca ptr addrspace(5), align 4, addrspace(5)
// CL12-NEXT:    store i64 5, ptr addrspace(5) [[VAR]], align 8
// CL12-NEXT:    store ptr addrspace(5) [[VAR]], ptr addrspace(5) [[ALLOCA_ADDR_AS_GENERIC]], align 4
// CL12-NEXT:    [[TMP0:%.*]] = load ptr addrspace(5), ptr addrspace(5) [[ALLOCA_ADDR_AS_GENERIC]], align 4
// CL12-NEXT:    store i64 9, ptr addrspace(5) [[TMP0]], align 8
// CL12-NEXT:    ret void
//
// CL20-LABEL: define dso_local void @wrong_store_type_private_pointer_as_generic_alloca(
// CL20-SAME: ) #[[ATTR0]] {
// CL20-NEXT:  [[ENTRY:.*:]]
// CL20-NEXT:    [[VAR:%.*]] = alloca i64, align 8, addrspace(5)
// CL20-NEXT:    [[ALLOCA_ADDR_AS_GENERIC:%.*]] = alloca ptr, align 8, addrspace(5)
// CL20-NEXT:    store i64 5, ptr addrspace(5) [[VAR]], align 8
// CL20-NEXT:    [[VAR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VAR]] to ptr
// CL20-NEXT:    store ptr [[VAR_ASCAST]], ptr addrspace(5) [[ALLOCA_ADDR_AS_GENERIC]], align 8
// CL20-NEXT:    [[TMP0:%.*]] = load ptr, ptr addrspace(5) [[ALLOCA_ADDR_AS_GENERIC]], align 8
// CL20-NEXT:    store i64 9, ptr [[TMP0]], align 8
// CL20-NEXT:    ret void
//
void wrong_store_type_private_pointer_as_generic_alloca() {
  long var = 5;

  // This needs to write an addrspace(0) pointer to the temporary alloca in
  // CL2.0, which should be allocated with the correct size.
  long *alloca_addr_as_generic = &var;
  *alloca_addr_as_generic = 9;
}
