.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbKeycodeToKeysym __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeycodeToKeysym \- Finds the keysym bound to a particular key at a specified
group and shift level
.SH SYNOPSIS
.HP
.B KeySym XkbKeycodeToKeysym
.BI "(\^Display *" "dpy" "\^,"
.BI "KeyCode " "kc" "\^,"
.BI "unsigned int " "group" "\^,"
.BI "unsigned int " "level" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I dpy
connection to X server
.TP
.I kc
key of interest
.TP
.I group
group of interest
.TP
.I level
shift level of interest
.SH DESCRIPTION
.LP
.I XkbKeycodeToKeysym
returns the keysym bound to a particular group and shift level for a particular
key on the core keyboard. If
.I kc
is not a legal keycode for the core keyboard, or if
.I group
or
.I level
are out of range for the specified key,
.I XkbKeycodeToKeysym
returns NoSymbol.
