% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_options.R
\name{compareOptions}
\alias{compareOptions}
\title{Options for comparison mode}
\usage{
compareOptions(ncharts = NULL, nrow = NULL, ncol = NULL, allowCompare = TRUE)
}
\arguments{
\item{ncharts}{Number of charts to generate.}

\item{nrow}{Number of rows. If \code{NULL}, the function tries to pick the
best number of rows given the number of charts and columns.}

\item{ncol}{Number of columns. If \code{NULL}, the function tries to pick the
best number of columns given the number of charts and rows.}

\item{allowCompare}{If \code{TRUE} (the default), then the user can use the
UI to add or remove charts and choose which variables to compare}
}
\value{
List of options
}
\description{
This function generates a list of options that are used by
\code{\link{manipulateWidget}} to compare multiple charts.
}
\examples{
if (require(dygraphs)) {

  mydata <- data.frame(
    year = 2000+1:100,
    series1 = rnorm(100),
    series2 = rnorm(100),
    series3 = rnorm(100)
  )
  manipulateWidget(
    dygraph(mydata[range[1]:range[2] - 2000, c("year", series)], main = title),
    range = mwSlider(2001, 2100, c(2001, 2100)),
    series = mwSelect(c("series1", "series2", "series3")),
    title = mwText("Fictive time series"),
    .compare = list(title = NULL, series = NULL),
    .compareOpts = compareOptions(ncharts = 4)
  )

  manipulateWidget(
    dygraph(mydata[range[1]:range[2] - 2000, c("year", series)], main = title),
    range = mwSlider(2001, 2100, c(2001, 2100)),
    series = mwSelect(c("series1", "series2", "series3")),
    title = mwText("Fictive time series"),
    .compare = list(title = NULL, series = NULL),
    .compareOpts = compareOptions(ncharts = 3, nrow = 3)
  )
}

}
