% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_reorder.R
\name{cor_reorder}
\alias{cor_reorder}
\title{Reorder Correlation Matrix}
\usage{
cor_reorder(x)
}
\arguments{
\item{x}{a correlation matrix. Particularly, an object of class \code{cor_mat}.}
}
\value{
a data frame
}
\description{
reorder correlation matrix, according to the coefficients,
  using the hierarchical clustering method.
}
\examples{
# Compute correlation matrix
#::::::::::::::::::::::::::::::::::::::::::
cor.mat <- mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec) \%>\%
  cor_mat()

# Reorder by correlation and get p-values
#::::::::::::::::::::::::::::::::::::::::::
# Reorder
cor.mat \%>\%
  cor_reorder()
# Get p-values of the reordered cor_mat
cor.mat \%>\%
  cor_reorder() \%>\%
  cor_get_pval()

}
\seealso{
\code{\link{cor_mat}()}, \code{\link{cor_gather}()}, \code{\link{cor_spread}()}
}
