# 2024-04-01 Triage Log

A pretty quiet week, with most changes (dropped from the report below) being
due to continuing bimodality in the performance data. No particularly notable
changes landed.

Triage done by **@simulacrum**.
Revision range: [73476d49904751f8d90ce904e16dfbc278083d2c..3d5528c287860b918e178a34f04ff903325571b3](https://perf.rust-lang.org/?start=73476d49904751f8d90ce904e16dfbc278083d2c&end=3d5528c287860b918e178a34f04ff903325571b3&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.1%]   | 15    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 1.8%]   | 30    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.6%, -0.2%] | 29    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.5%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -0.2% | [-1.6%, 1.1%]  | 44    |


1 Regressions, 2 Improvements, 5 Mixed; 0 of them in rollups
61 artifact comparisons made in total

#### Regressions

Use FxIndexMap instead FxHashMap to stabilize iteration order in EffectiveVisibilities [#121851](https://github.com/rust-lang/rust/pull/121851) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a8cfc83801301c2b4f0fd030192e268eeb15d473&end=bf71daedc29e7a240261acd1516378047e311a6f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 13    |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.4%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 13    |

Justified by avoiding bugs in incremental compilation. See [comment](https://github.com/rust-lang/rust/pull/121851#issuecomment-1976192758) for details.

#### Improvements

Avoid some unnecessary query invocations. [#121387](https://github.com/rust-lang/rust/pull/121387) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b13a71a2e77f4625d1a2b8a5b9488414686ebca9&end=519d892f9523fe40cc11ec07323ffc2792614742&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.7%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.0% | [-1.7%, -0.3%] | 2     |


Simplify proc macro bridge state [#122939](https://github.com/rust-lang/rust/pull/122939) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=519d892f9523fe40cc11ec07323ffc2792614742&end=536606bc5df7e6045c6dbedc2f852ba3d38581f1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.9%, -0.4%] | 6     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 2     |

#### Mixed

Less generic code for Vec allocations [#122396](https://github.com/rust-lang/rust/pull/122396) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0157da41ee9a1f6fb1a20e00ea62ab4122e2feaa&end=c9f8f3438a8134a413aa5d4903e0196e44e37bbc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.3%, 0.8%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.4%, -0.1%] | 12    |
| Improvements ✅ <br /> (secondary) | -4.4% | [-4.4%, -4.4%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-1.4%, 0.8%]  | 14    |

Improvements mostly outweigh regressions, including the improvements in binary size.

Rollup of 8 pull requests [#123147](https://github.com/rust-lang/rust/pull/123147) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9d709549481f77a8ab3111e7da2156d8d8181cdb&end=d779a7a25f67fced5f8fea232ef407c5b228a22f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.8%, 1.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.7%, 1.2%]  | 5     |

Regressions appear to be potentially genuine, but also not particularly material, limited to just one benchmark.

Codegen const panic messages as function calls [#122671](https://github.com/rust-lang/rust/pull/122671) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d74804636fa57e80d1e213fa9d2d65b27216b515&end=db2f9759f43167755d4eebb0a1358df9766a505e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.9%, 0.4%]  | 5     |

This is primarily a win in binary sizes, particularly for code built with
overflow checks which add many more callsites that are made cheaper with this
optimization.

Eliminate `UbChecks` for non-standard libraries [#122975](https://github.com/rust-lang/rust/pull/122975) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=db2f9759f43167755d4eebb0a1358df9766a505e&end=760e567af5398a0d8c512f904e551e1f38e00d79&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.3%, 1.7%]   | 7     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.3%  | [-0.8%, 1.7%]  | 12    |

Mixed results look fairly real. This change affects codegen of downstream
libraries (i.e., most of the perf suite) so it's expected to lead to mostly
improvements. It's not clear precisely where the regressions are coming from
(maybe LLVM is able to optimize more?). The largest regression seems to resolve
itself in #122976 (see next mixed PR in this report) but it's not clear that
there is any direct relationship between the two.

Remove len argument from RawVec::reserve_for_push [#122976](https://github.com/rust-lang/rust/pull/122976) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a3cfa031fa7726a957d73e6cad5744eb9706f56d&end=877d36b1928b5a4f7d193517b48290ecbe404d71&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.8%  | [2.8%, 2.8%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-1.7%, -1.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -1.7% | [-1.7%, -1.7%] | 1     |

Appears to primarily resolve regressions introduced by #122975 (previous mixed
PR in this report). Potentially just noise as such.
