# This script is called at install time
function(findLibsAndModules SEARCH_PATH SUFFIX LIBS_DIRECTORIES EXCLUDE_PATTERN)
    file(GLOB_RECURSE LIBS ${SEARCH_PATH}/*${SUFFIX}*)
    if(${FW_BUILD_EXTERNAL})
        file(GLOB_RECURSE LIBS ${Sight_LIBRARY_DIR}/*${SUFFIX}*)
    endif()

    if(${EXCLUDE_PATTERN})
        list(FILTER LIBS EXCLUDE REGEX ${EXCLUDE_PATTERN})
    endif()
    list(REMOVE_DUPLICATES LIBS)
    set(FOLDERS)
    foreach(LIB ${LIBS})
        get_filename_component(LIB_DIR "${LIB}" DIRECTORY)
        list(APPEND FOLDERS ${LIB_DIR})
    endforeach()
    if(FOLDERS)
        list(REMOVE_DUPLICATES FOLDERS)
    endif()
    set(${LIBS_DIRECTORIES} ${FOLDERS} PARENT_SCOPE)
endfunction()
