/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Christopher Moore <moore@free.fr>
 *   2020      Evan Nemerson <evan@nemerson.com>
 *   2023      Michael R. Crusoe <crusoe@debian.org>
 */

#define SIMDE_TESTS_CURRENT_ISAX gfni
#include "../test.h"
#include "avx512/test-avx512.h"
#include <simde/x86/gfni.h>

static int
test_simde_mm_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i x;
    simde__m128i A;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C(  92), INT8_C(-112), INT8_C(  58), INT8_C(-121),
                        INT8_C( -84), INT8_C( 106), INT8_C( -83), INT8_C( -57),
                        INT8_C( -16), INT8_C(  29), INT8_C( -68), INT8_C( -73),
                        INT8_C( 115), INT8_C( -71), INT8_C( 124), INT8_C(-123)),
      simde_mm_set_epi8(INT8_C(-125), INT8_C(  82), INT8_C( -93), INT8_C(-115),
                        INT8_C(  48), INT8_C(  63), INT8_C(  -3), INT8_C(  71),
                        INT8_C(  31), INT8_C( -71), INT8_C(-118), INT8_C(  42),
                        INT8_C(-101), INT8_C(  45), INT8_C(  94), INT8_C(  25)),
      simde_mm_set_epi8(INT8_C(  65), INT8_C(  78), INT8_C( -72), INT8_C( -98),
                        INT8_C( -56), INT8_C(   8), INT8_C(  37), INT8_C(  92),
                        INT8_C( -34), INT8_C(-113), INT8_C(   0), INT8_C(  17),
                        INT8_C(  38), INT8_C( -46), INT8_C(  86), INT8_C( -75)) },
    { simde_mm_set_epi8(INT8_C( -51), INT8_C(  87), INT8_C( -81), INT8_C( -31),
                        INT8_C( -33), INT8_C( -54), INT8_C(   4), INT8_C( -53),
                        INT8_C(  74), INT8_C( -65), INT8_C( -58), INT8_C( -69),
                        INT8_C(  85), INT8_C( 106), INT8_C( -20), INT8_C( -61)),
      simde_mm_set_epi8(INT8_C(  91), INT8_C(-104), INT8_C(  75), INT8_C(  27),
                        INT8_C(  22), INT8_C(  10), INT8_C(   2), INT8_C( -59),
                        INT8_C(  -6), INT8_C( -24), INT8_C(  10), INT8_C(  64),
                        INT8_C(  -9), INT8_C( -53), INT8_C( -12), INT8_C(  73)),
      simde_mm_set_epi8(INT8_C(  68), INT8_C(-113), INT8_C( -68), INT8_C(  -5),
                        INT8_C(  34), INT8_C(  36), INT8_C( -31), INT8_C( -87),
                        INT8_C(  24), INT8_C( 114), INT8_C(-100), INT8_C(  34),
                        INT8_C(  59), INT8_C(  75), INT8_C(  93), INT8_C( 124)) },
    { simde_mm_set_epi8(INT8_C(  53), INT8_C( -39), INT8_C( 123), INT8_C( -73),
                        INT8_C(-128), INT8_C( 112), INT8_C( -47), INT8_C( 125),
                        INT8_C( -38), INT8_C(-114), INT8_C(  26), INT8_C(  58),
                        INT8_C(  61), INT8_C( -20), INT8_C( -15), INT8_C( 106)),
      simde_mm_set_epi8(INT8_C( 118), INT8_C(  69), INT8_C( 100), INT8_C(  56),
                        INT8_C(  50), INT8_C(  20), INT8_C(-109), INT8_C( 106),
                        INT8_C( 101), INT8_C(  21), INT8_C(   4), INT8_C( -48),
                        INT8_C( 106), INT8_C(  -7), INT8_C( -14), INT8_C( -89)),
      simde_mm_set_epi8(INT8_C( -16), INT8_C(   5), INT8_C(   9), INT8_C(  97),
                        INT8_C(  49), INT8_C(  18), INT8_C(-115), INT8_C(  -1),
                        INT8_C( 106), INT8_C(  -2), INT8_C(  -5), INT8_C(  10),
                        INT8_C(  -2), INT8_C( -90), INT8_C( -40), INT8_C(  25)) },
    { simde_mm_set_epi8(INT8_C(  -7), INT8_C( 100), INT8_C( 118), INT8_C(  67),
                        INT8_C( 122), INT8_C( 119), INT8_C(  90), INT8_C( -55),
                        INT8_C( -23), INT8_C( 110), INT8_C(  28), INT8_C( -91),
                        INT8_C(  51), INT8_C(  59), INT8_C( -59), INT8_C(  53)),
      simde_mm_set_epi8(INT8_C(-101), INT8_C(  15), INT8_C( -63), INT8_C(  65),
                        INT8_C(   7), INT8_C( -86), INT8_C( -61), INT8_C( -99),
                        INT8_C(  72), INT8_C(  45), INT8_C(  23), INT8_C( 121),
                        INT8_C(-107), INT8_C( 110), INT8_C( -55), INT8_C( -65)),
      simde_mm_set_epi8(INT8_C(   5), INT8_C(-113), INT8_C( 125), INT8_C(-111),
                        INT8_C(  76), INT8_C( -94), INT8_C( 108), INT8_C( -92),
                        INT8_C(  87), INT8_C(  75), INT8_C( -80), INT8_C(  99),
                        INT8_C(  61), INT8_C( -42), INT8_C( -96), INT8_C(  47)) },
    { simde_mm_set_epi8(INT8_C(  23), INT8_C(  51), INT8_C( -97), INT8_C(-120),
                        INT8_C(  74), INT8_C( -72), INT8_C(  10), INT8_C(  -6),
                        INT8_C(   4), INT8_C(  92), INT8_C( 126), INT8_C( -75),
                        INT8_C(  -6), INT8_C(  29), INT8_C( 112), INT8_C(-128)),
      simde_mm_set_epi8(INT8_C( -67), INT8_C( -37), INT8_C(-104), INT8_C(  -9),
                        INT8_C(-118), INT8_C( 101), INT8_C(  85), INT8_C( -70),
                        INT8_C( -55), INT8_C(  77), INT8_C(-100), INT8_C(  82),
                        INT8_C( -87), INT8_C(  63), INT8_C( -31), INT8_C(  99)),
      simde_mm_set_epi8(INT8_C(  38), INT8_C( -26), INT8_C(  46), INT8_C( 121),
                        INT8_C(  22), INT8_C(  31), INT8_C( 124), INT8_C( -17),
                        INT8_C(  87), INT8_C(-121), INT8_C( -33), INT8_C(  45),
                        INT8_C( -84), INT8_C( -65), INT8_C( 102), INT8_C(  36)) },
    { simde_mm_set_epi8(INT8_C( -93), INT8_C( -32), INT8_C(  26), INT8_C( -58),
                        INT8_C(  54), INT8_C(  13), INT8_C(  -9), INT8_C( 107),
                        INT8_C(  45), INT8_C( -14), INT8_C( -76), INT8_C( -47),
                        INT8_C( -81), INT8_C( 125), INT8_C(  36), INT8_C(-128)),
      simde_mm_set_epi8(INT8_C( -18), INT8_C(  50), INT8_C(-118), INT8_C(  32),
                        INT8_C(  64), INT8_C(-128), INT8_C(  45), INT8_C(  -2),
                        INT8_C( -74), INT8_C( 107), INT8_C( -62), INT8_C(  23),
                        INT8_C(  71), INT8_C( -89), INT8_C(-114), INT8_C(  59)),
      simde_mm_set_epi8(INT8_C( -40), INT8_C(-114), INT8_C( -79), INT8_C(   3),
                        INT8_C( 126), INT8_C(  53), INT8_C(  10), INT8_C(  41),
                        INT8_C( -45), INT8_C( -41), INT8_C(  71), INT8_C(  49),
                        INT8_C(  73), INT8_C(  76), INT8_C( -85), INT8_C(  20)) },
    { simde_mm_set_epi8(INT8_C( -67), INT8_C( -83), INT8_C(  49), INT8_C(-106),
                        INT8_C( -17), INT8_C(-100), INT8_C(  12), INT8_C(  -4),
                        INT8_C( 115), INT8_C(  51), INT8_C( -39), INT8_C(  71),
                        INT8_C(  77), INT8_C( -21), INT8_C( -53), INT8_C( -85)),
      simde_mm_set_epi8(INT8_C( -61), INT8_C( 108), INT8_C(  88), INT8_C( -96),
                        INT8_C(  69), INT8_C( -99), INT8_C( -76), INT8_C(  17),
                        INT8_C(  11), INT8_C( -75), INT8_C( -45), INT8_C( 118),
                        INT8_C(  33), INT8_C( -59), INT8_C(  86), INT8_C(  64)),
      simde_mm_set_epi8(INT8_C(  83), INT8_C( -73), INT8_C( 110), INT8_C(-113),
                        INT8_C( -95), INT8_C( -88), INT8_C(  37), INT8_C( -11),
                        INT8_C( -77), INT8_C(  95), INT8_C( -61), INT8_C(-115),
                        INT8_C( -63), INT8_C( -38), INT8_C( -64), INT8_C(  54)) },
    { simde_mm_set_epi8(INT8_C( 122), INT8_C( 121), INT8_C(  24), INT8_C(  62),
                        INT8_C(  21), INT8_C( -43), INT8_C(  93), INT8_C( -47),
                        INT8_C(  58), INT8_C(-128), INT8_C( 124), INT8_C(  87),
                        INT8_C(  28), INT8_C(  96), INT8_C( -90), INT8_C( -42)),
      simde_mm_set_epi8(INT8_C( -56), INT8_C(  37), INT8_C(-105), INT8_C( -59),
                        INT8_C(  68), INT8_C(  78), INT8_C(-104), INT8_C( -97),
                        INT8_C(-118), INT8_C(  78), INT8_C(  55), INT8_C(  96),
                        INT8_C( -17), INT8_C( -60), INT8_C(  41), INT8_C( -68)),
      simde_mm_set_epi8(INT8_C( -53), INT8_C( -31), INT8_C(  84), INT8_C(  76),
                        INT8_C(-123), INT8_C( 113), INT8_C(  93), INT8_C( -49),
                        INT8_C( -19), INT8_C( -64), INT8_C( 118), INT8_C(  58),
                        INT8_C(-112), INT8_C(-105), INT8_C( -67), INT8_C( -33)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_gf2p8affine_epi64_epi8(test_vec[i].x, test_vec[i].A, INT8_C( 113));
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m256i x;
    simde__m256i A;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(-125), INT8_C(  82), INT8_C( -93), INT8_C(-115),
                           INT8_C(  48), INT8_C(  63), INT8_C(  -3), INT8_C(  71),
                           INT8_C(  31), INT8_C( -71), INT8_C(-118), INT8_C(  42),
                           INT8_C(-101), INT8_C(  45), INT8_C(  94), INT8_C(  25),
                           INT8_C(  92), INT8_C(-112), INT8_C(  58), INT8_C(-121),
                           INT8_C( -84), INT8_C( 106), INT8_C( -83), INT8_C( -57),
                           INT8_C( -16), INT8_C(  29), INT8_C( -68), INT8_C( -73),
                           INT8_C( 115), INT8_C( -71), INT8_C( 124), INT8_C(-123)),
      simde_mm256_set_epi8(INT8_C(  91), INT8_C(-104), INT8_C(  75), INT8_C(  27),
                           INT8_C(  22), INT8_C(  10), INT8_C(   2), INT8_C( -59),
                           INT8_C(  -6), INT8_C( -24), INT8_C(  10), INT8_C(  64),
                           INT8_C(  -9), INT8_C( -53), INT8_C( -12), INT8_C(  73),
                           INT8_C( -51), INT8_C(  87), INT8_C( -81), INT8_C( -31),
                           INT8_C( -33), INT8_C( -54), INT8_C(   4), INT8_C( -53),
                           INT8_C(  74), INT8_C( -65), INT8_C( -58), INT8_C( -69),
                           INT8_C(  85), INT8_C( 106), INT8_C( -20), INT8_C( -61)),
      simde_mm256_set_epi8(INT8_C( -74), INT8_C(  39), INT8_C( -74), INT8_C( 116),
                           INT8_C( -33), INT8_C(-112), INT8_C( -22), INT8_C(  33),
                           INT8_C( -25), INT8_C( -94), INT8_C(  37), INT8_C(   5),
                           INT8_C( -60), INT8_C( -48), INT8_C( -84), INT8_C(-126),
                           INT8_C(-113), INT8_C( 107), INT8_C( -39), INT8_C(   7),
                           INT8_C(-105), INT8_C( 112), INT8_C(   8), INT8_C( -68),
                           INT8_C(-113), INT8_C( 121), INT8_C(  71), INT8_C(  25),
                           INT8_C( 116), INT8_C(-117), INT8_C( 124), INT8_C( -58)) },
    { simde_mm256_set_epi8(INT8_C( 118), INT8_C(  69), INT8_C( 100), INT8_C(  56),
                           INT8_C(  50), INT8_C(  20), INT8_C(-109), INT8_C( 106),
                           INT8_C( 101), INT8_C(  21), INT8_C(   4), INT8_C( -48),
                           INT8_C( 106), INT8_C(  -7), INT8_C( -14), INT8_C( -89),
                           INT8_C(  53), INT8_C( -39), INT8_C( 123), INT8_C( -73),
                           INT8_C(-128), INT8_C( 112), INT8_C( -47), INT8_C( 125),
                           INT8_C( -38), INT8_C(-114), INT8_C(  26), INT8_C(  58),
                           INT8_C(  61), INT8_C( -20), INT8_C( -15), INT8_C( 106)),
      simde_mm256_set_epi8(INT8_C(-101), INT8_C(  15), INT8_C( -63), INT8_C(  65),
                           INT8_C(   7), INT8_C( -86), INT8_C( -61), INT8_C( -99),
                           INT8_C(  72), INT8_C(  45), INT8_C(  23), INT8_C( 121),
                           INT8_C(-107), INT8_C( 110), INT8_C( -55), INT8_C( -65),
                           INT8_C(  -7), INT8_C( 100), INT8_C( 118), INT8_C(  67),
                           INT8_C( 122), INT8_C( 119), INT8_C(  90), INT8_C( -55),
                           INT8_C( -23), INT8_C( 110), INT8_C(  28), INT8_C( -91),
                           INT8_C(  51), INT8_C(  59), INT8_C( -59), INT8_C(  53)),
      simde_mm256_set_epi8(INT8_C( -56), INT8_C( -59), INT8_C(  58), INT8_C( -58),
                           INT8_C(  22), INT8_C( -41), INT8_C(  12), INT8_C( 120),
                           INT8_C( 111), INT8_C(  48), INT8_C( 114), INT8_C( -31),
                           INT8_C(  72), INT8_C( 126), INT8_C( -17), INT8_C( 114),
                           INT8_C(   9), INT8_C( -73), INT8_C( 125), INT8_C( -12),
                           INT8_C(  69), INT8_C( 121), INT8_C( 102), INT8_C(  39),
                           INT8_C( 111), INT8_C(  86), INT8_C( 101), INT8_C( -34),
                           INT8_C( -37), INT8_C(-100), INT8_C(  56), INT8_C(  41)) },
    { simde_mm256_set_epi8(INT8_C( -67), INT8_C( -37), INT8_C(-104), INT8_C(  -9),
                           INT8_C(-118), INT8_C( 101), INT8_C(  85), INT8_C( -70),
                           INT8_C( -55), INT8_C(  77), INT8_C(-100), INT8_C(  82),
                           INT8_C( -87), INT8_C(  63), INT8_C( -31), INT8_C(  99),
                           INT8_C(  23), INT8_C(  51), INT8_C( -97), INT8_C(-120),
                           INT8_C(  74), INT8_C( -72), INT8_C(  10), INT8_C(  -6),
                           INT8_C(   4), INT8_C(  92), INT8_C( 126), INT8_C( -75),
                           INT8_C(  -6), INT8_C(  29), INT8_C( 112), INT8_C(-128)),
      simde_mm256_set_epi8(INT8_C( -18), INT8_C(  50), INT8_C(-118), INT8_C(  32),
                           INT8_C(  64), INT8_C(-128), INT8_C(  45), INT8_C(  -2),
                           INT8_C( -74), INT8_C( 107), INT8_C( -62), INT8_C(  23),
                           INT8_C(  71), INT8_C( -89), INT8_C(-114), INT8_C(  59),
                           INT8_C( -93), INT8_C( -32), INT8_C(  26), INT8_C( -58),
                           INT8_C(  54), INT8_C(  13), INT8_C(  -9), INT8_C( 107),
                           INT8_C(  45), INT8_C( -14), INT8_C( -76), INT8_C( -47),
                           INT8_C( -81), INT8_C( 125), INT8_C(  36), INT8_C(-128)),
      simde_mm256_set_epi8(INT8_C( 108), INT8_C( 112), INT8_C(  38), INT8_C( -65),
                           INT8_C(  35), INT8_C(  31), INT8_C(  86), INT8_C( 106),
                           INT8_C( -49), INT8_C( -45), INT8_C(-109), INT8_C( -92),
                           INT8_C( 122), INT8_C(  16), INT8_C( -82), INT8_C(  52),
                           INT8_C( -44), INT8_C( 127), INT8_C(  59), INT8_C(  43),
                           INT8_C( 119), INT8_C( -84), INT8_C( -67), INT8_C( -69),
                           INT8_C( -79), INT8_C(-124), INT8_C( -31), INT8_C(  79),
                           INT8_C(  10), INT8_C(-105), INT8_C( -73), INT8_C(  90)) },
    { simde_mm256_set_epi8(INT8_C( -61), INT8_C( 108), INT8_C(  88), INT8_C( -96),
                           INT8_C(  69), INT8_C( -99), INT8_C( -76), INT8_C(  17),
                           INT8_C(  11), INT8_C( -75), INT8_C( -45), INT8_C( 118),
                           INT8_C(  33), INT8_C( -59), INT8_C(  86), INT8_C(  64),
                           INT8_C( -67), INT8_C( -83), INT8_C(  49), INT8_C(-106),
                           INT8_C( -17), INT8_C(-100), INT8_C(  12), INT8_C(  -4),
                           INT8_C( 115), INT8_C(  51), INT8_C( -39), INT8_C(  71),
                           INT8_C(  77), INT8_C( -21), INT8_C( -53), INT8_C( -85)),
      simde_mm256_set_epi8(INT8_C( -56), INT8_C(  37), INT8_C(-105), INT8_C( -59),
                           INT8_C(  68), INT8_C(  78), INT8_C(-104), INT8_C( -97),
                           INT8_C(-118), INT8_C(  78), INT8_C(  55), INT8_C(  96),
                           INT8_C( -17), INT8_C( -60), INT8_C(  41), INT8_C( -68),
                           INT8_C( 122), INT8_C( 121), INT8_C(  24), INT8_C(  62),
                           INT8_C(  21), INT8_C( -43), INT8_C(  93), INT8_C( -47),
                           INT8_C(  58), INT8_C(-128), INT8_C( 124), INT8_C(  87),
                           INT8_C(  28), INT8_C(  96), INT8_C( -90), INT8_C( -42)),
      simde_mm256_set_epi8(INT8_C(  26), INT8_C( -96), INT8_C( -40), INT8_C(  11),
                           INT8_C( -51), INT8_C(  28), INT8_C( 113), INT8_C(-114),
                           INT8_C(  84), INT8_C( -49), INT8_C(-120), INT8_C(   7),
                           INT8_C(  76), INT8_C( -83), INT8_C( -37), INT8_C(  -2),
                           INT8_C(  85), INT8_C( -86), INT8_C( -62), INT8_C( -22),
                           INT8_C(  64), INT8_C( -84), INT8_C( -13), INT8_C(  68),
                           INT8_C(  81), INT8_C(  -3), INT8_C(  42), INT8_C( 117),
                           INT8_C( -87), INT8_C(  27), INT8_C( 126), INT8_C( -73)) },
    { simde_mm256_set_epi8(INT8_C( -54), INT8_C( -58), INT8_C(-101), INT8_C( 125),
                           INT8_C( -73), INT8_C( -39), INT8_C(-121), INT8_C(  30),
                           INT8_C( -17), INT8_C(  12), INT8_C( -86), INT8_C( -34),
                           INT8_C(  61), INT8_C(  53), INT8_C(  73), INT8_C(  85),
                           INT8_C(  87), INT8_C( -21), INT8_C( -86), INT8_C( 121),
                           INT8_C(  27), INT8_C( 115), INT8_C(-124), INT8_C( -40),
                           INT8_C( -59), INT8_C(  52), INT8_C(  99), INT8_C( -34),
                           INT8_C(  76), INT8_C(  41), INT8_C( -93), INT8_C(-112)),
      simde_mm256_set_epi8(INT8_C(  31), INT8_C( -32), INT8_C( -69), INT8_C(-120),
                           INT8_C(  29), INT8_C(  35), INT8_C( -67), INT8_C(  30),
                           INT8_C( -13), INT8_C( -62), INT8_C( 104), INT8_C(  56),
                           INT8_C( -20), INT8_C(  50), INT8_C(  79), INT8_C( 105),
                           INT8_C( -40), INT8_C(-109), INT8_C(-116), INT8_C(  88),
                           INT8_C(  42), INT8_C( 110), INT8_C(-119), INT8_C( -31),
                           INT8_C( -21), INT8_C( 111), INT8_C(-125), INT8_C(-103),
                           INT8_C( -29), INT8_C(  95), INT8_C(-104), INT8_C(  45)),
      simde_mm256_set_epi8(INT8_C( -16), INT8_C(  -4), INT8_C(  82), INT8_C(  12),
                           INT8_C(  56), INT8_C( -11), INT8_C(-117), INT8_C( -72),
                           INT8_C(-109), INT8_C(  72), INT8_C( -43), INT8_C( -58),
                           INT8_C(  29), INT8_C( -63), INT8_C(  14), INT8_C( -85),
                           INT8_C( -78), INT8_C(-105), INT8_C(  -4), INT8_C( 105),
                           INT8_C(  66), INT8_C(  38), INT8_C(  39), INT8_C( -36),
                           INT8_C( -73), INT8_C( -99), INT8_C( -20), INT8_C( -68),
                           INT8_C( -66), INT8_C(   3), INT8_C(-126), INT8_C( -15)) },
    { simde_mm256_set_epi8(INT8_C( 112), INT8_C(   2), INT8_C( -69), INT8_C(-108),
                           INT8_C( -48), INT8_C(  49), INT8_C( -97), INT8_C(  65),
                           INT8_C(  82), INT8_C(-120), INT8_C(  44), INT8_C( -16),
                           INT8_C(  69), INT8_C( 113), INT8_C(  37), INT8_C(  -3),
                           INT8_C(-126), INT8_C(  14), INT8_C( 120), INT8_C(  66),
                           INT8_C( -26), INT8_C( 114), INT8_C( -17), INT8_C(  54),
                           INT8_C(-115), INT8_C( -70), INT8_C(  81), INT8_C( -70),
                           INT8_C(-100), INT8_C(  69), INT8_C( -73), INT8_C(  75)),
      simde_mm256_set_epi8(INT8_C(  13), INT8_C( 114), INT8_C( -55), INT8_C( -70),
                           INT8_C( -86), INT8_C( -74), INT8_C( -53), INT8_C(  93),
                           INT8_C(-107), INT8_C(  88), INT8_C(-116), INT8_C(-100),
                           INT8_C( -14), INT8_C( -86), INT8_C(  18), INT8_C(-108),
                           INT8_C(  24), INT8_C( -37), INT8_C(  81), INT8_C(  91),
                           INT8_C( 122), INT8_C(  76), INT8_C( -21), INT8_C( -97),
                           INT8_C(  13), INT8_C( -19), INT8_C(  87), INT8_C(-108),
                           INT8_C(  39), INT8_C(  66), INT8_C(  79), INT8_C( -12)),
      simde_mm256_set_epi8(INT8_C(-110), INT8_C( -66), INT8_C(  74), INT8_C( -77),
                           INT8_C( -44), INT8_C(-111), INT8_C( -47), INT8_C( -57),
                           INT8_C( 125), INT8_C(  87), INT8_C(  87), INT8_C(-128),
                           INT8_C(  90), INT8_C(  60), INT8_C( 120), INT8_C(  34),
                           INT8_C( -36), INT8_C(  69), INT8_C(-114), INT8_C(  96),
                           INT8_C(  82), INT8_C( -81), INT8_C( 103), INT8_C( 113),
                           INT8_C(-123), INT8_C( 103), INT8_C(  -7), INT8_C( 103),
                           INT8_C(  94), INT8_C( -86), INT8_C( -84), INT8_C(  66)) },
    { simde_mm256_set_epi8(INT8_C( -86), INT8_C(  40), INT8_C(   4), INT8_C(-124),
                           INT8_C(  35), INT8_C( 115), INT8_C(  21), INT8_C(  14),
                           INT8_C( -63), INT8_C(-123), INT8_C( -55), INT8_C(  82),
                           INT8_C(-104), INT8_C( -96), INT8_C( -98), INT8_C(-116),
                           INT8_C( 118), INT8_C( 105), INT8_C( -99), INT8_C(  73),
                           INT8_C( -46), INT8_C(  60), INT8_C(  67), INT8_C(  75),
                           INT8_C(-111), INT8_C( 102), INT8_C( -17), INT8_C( -13),
                           INT8_C(  71), INT8_C(  80), INT8_C( 109), INT8_C( -40)),
      simde_mm256_set_epi8(INT8_C(   6), INT8_C( 112), INT8_C( -23), INT8_C( -13),
                           INT8_C(  68), INT8_C(  65), INT8_C(  87), INT8_C( -31),
                           INT8_C(-110), INT8_C(  -3), INT8_C(  46), INT8_C( -24),
                           INT8_C(  26), INT8_C(-108), INT8_C( -39), INT8_C(  72),
                           INT8_C(  66), INT8_C( -83), INT8_C( -22), INT8_C( -71),
                           INT8_C(  -5), INT8_C( -66), INT8_C(  36), INT8_C(  92),
                           INT8_C(-115), INT8_C(  63), INT8_C( -65), INT8_C(  54),
                           INT8_C( -13), INT8_C( -99), INT8_C(  49), INT8_C(  36)),
      simde_mm256_set_epi8(INT8_C(-117), INT8_C(  78), INT8_C(-107), INT8_C(  25),
                           INT8_C( -17), INT8_C(  91), INT8_C(  51), INT8_C( -40),
                           INT8_C(  39), INT8_C( -53), INT8_C(  -7), INT8_C( 104),
                           INT8_C(   2), INT8_C( -95), INT8_C(  49), INT8_C(  87),
                           INT8_C(  64), INT8_C(-117), INT8_C(   4), INT8_C( -11),
                           INT8_C( -30), INT8_C(  94), INT8_C( 126), INT8_C( -64),
                           INT8_C(  -8), INT8_C( -69), INT8_C( -34), INT8_C(  40),
                           INT8_C(  18), INT8_C( -86), INT8_C( -11), INT8_C( -72)) },
    { simde_mm256_set_epi8(INT8_C(  96), INT8_C( -97), INT8_C( -92), INT8_C(  96),
                           INT8_C(  90), INT8_C( -49), INT8_C(-117), INT8_C(  30),
                           INT8_C(-114), INT8_C(-106), INT8_C(  10), INT8_C(-120),
                           INT8_C(  27), INT8_C(  -2), INT8_C(  89), INT8_C(  41),
                           INT8_C( -25), INT8_C(-109), INT8_C( 120), INT8_C( -70),
                           INT8_C(  60), INT8_C( -33), INT8_C( 121), INT8_C(  49),
                           INT8_C( -80), INT8_C( 118), INT8_C( -64), INT8_C(  38),
                           INT8_C(  20), INT8_C( -60), INT8_C( -96), INT8_C(  -5)),
      simde_mm256_set_epi8(INT8_C( -77), INT8_C( 102), INT8_C(  95), INT8_C( -28),
                           INT8_C(  18), INT8_C( -12), INT8_C(  60), INT8_C( -53),
                           INT8_C(  29), INT8_C(  49), INT8_C(  11), INT8_C( -44),
                           INT8_C( 116), INT8_C(  50), INT8_C(-112), INT8_C(   1),
                           INT8_C(   6), INT8_C(  22), INT8_C( -56), INT8_C( -34),
                           INT8_C(-113), INT8_C( -15), INT8_C( -61), INT8_C(  70),
                           INT8_C( -23), INT8_C(  15), INT8_C( -49), INT8_C( -19),
                           INT8_C( -17), INT8_C(-127), INT8_C( -34), INT8_C(  64)),
      simde_mm256_set_epi8(INT8_C(   1), INT8_C( -96), INT8_C( 104), INT8_C(   1),
                           INT8_C(  76), INT8_C( 123), INT8_C( -69), INT8_C(-116),
                           INT8_C( -76), INT8_C( -54), INT8_C( -27), INT8_C(-119),
                           INT8_C(  25), INT8_C( -27), INT8_C(  37), INT8_C( 116),
                           INT8_C(  68), INT8_C(  57), INT8_C(  62), INT8_C( 117),
                           INT8_C(  73), INT8_C(  82), INT8_C(  78), INT8_C( -66),
                           INT8_C( -32), INT8_C(  72), INT8_C( 100), INT8_C( -43),
                           INT8_C( -38), INT8_C(  58), INT8_C( -96), INT8_C(  11)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_gf2p8affine_epi64_epi8(test_vec[i].x, test_vec[i].A, 196);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i x;
    simde__m512i A;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  91), INT8_C(-104), INT8_C(  75), INT8_C(  27),
                           INT8_C(  22), INT8_C(  10), INT8_C(   2), INT8_C( -59),
                           INT8_C(  -6), INT8_C( -24), INT8_C(  10), INT8_C(  64),
                           INT8_C(  -9), INT8_C( -53), INT8_C( -12), INT8_C(  73),
                           INT8_C( -51), INT8_C(  87), INT8_C( -81), INT8_C( -31),
                           INT8_C( -33), INT8_C( -54), INT8_C(   4), INT8_C( -53),
                           INT8_C(  74), INT8_C( -65), INT8_C( -58), INT8_C( -69),
                           INT8_C(  85), INT8_C( 106), INT8_C( -20), INT8_C( -61),
                           INT8_C(-125), INT8_C(  82), INT8_C( -93), INT8_C(-115),
                           INT8_C(  48), INT8_C(  63), INT8_C(  -3), INT8_C(  71),
                           INT8_C(  31), INT8_C( -71), INT8_C(-118), INT8_C(  42),
                           INT8_C(-101), INT8_C(  45), INT8_C(  94), INT8_C(  25),
                           INT8_C(  92), INT8_C(-112), INT8_C(  58), INT8_C(-121),
                           INT8_C( -84), INT8_C( 106), INT8_C( -83), INT8_C( -57),
                           INT8_C( -16), INT8_C(  29), INT8_C( -68), INT8_C( -73),
                           INT8_C( 115), INT8_C( -71), INT8_C( 124), INT8_C(-123)),
      simde_mm512_set_epi8(INT8_C(-101), INT8_C(  15), INT8_C( -63), INT8_C(  65),
                           INT8_C(   7), INT8_C( -86), INT8_C( -61), INT8_C( -99),
                           INT8_C(  72), INT8_C(  45), INT8_C(  23), INT8_C( 121),
                           INT8_C(-107), INT8_C( 110), INT8_C( -55), INT8_C( -65),
                           INT8_C(  -7), INT8_C( 100), INT8_C( 118), INT8_C(  67),
                           INT8_C( 122), INT8_C( 119), INT8_C(  90), INT8_C( -55),
                           INT8_C( -23), INT8_C( 110), INT8_C(  28), INT8_C( -91),
                           INT8_C(  51), INT8_C(  59), INT8_C( -59), INT8_C(  53),
                           INT8_C( 118), INT8_C(  69), INT8_C( 100), INT8_C(  56),
                           INT8_C(  50), INT8_C(  20), INT8_C(-109), INT8_C( 106),
                           INT8_C( 101), INT8_C(  21), INT8_C(   4), INT8_C( -48),
                           INT8_C( 106), INT8_C(  -7), INT8_C( -14), INT8_C( -89),
                           INT8_C(  53), INT8_C( -39), INT8_C( 123), INT8_C( -73),
                           INT8_C(-128), INT8_C( 112), INT8_C( -47), INT8_C( 125),
                           INT8_C( -38), INT8_C(-114), INT8_C(  26), INT8_C(  58),
                           INT8_C(  61), INT8_C( -20), INT8_C( -15), INT8_C( 106)),
      simde_mm512_set_epi8(INT8_C( -61), INT8_C( -58), INT8_C(  66), INT8_C(-113),
                           INT8_C(  97), INT8_C( -47), INT8_C( 114), INT8_C( -27),
                           INT8_C( -63), INT8_C(  -7), INT8_C(  78), INT8_C( 104),
                           INT8_C(  66), INT8_C(  41), INT8_C(  56), INT8_C(  93),
                           INT8_C(  33), INT8_C( 120), INT8_C(-107), INT8_C( -31),
                           INT8_C(  40), INT8_C( -46), INT8_C(  39), INT8_C( 123),
                           INT8_C(  87), INT8_C( 101), INT8_C(  -9), INT8_C( -85),
                           INT8_C( -63), INT8_C( -20), INT8_C(  89), INT8_C( -64),
                           INT8_C( -46), INT8_C(  46), INT8_C(  79), INT8_C( -84),
                           INT8_C( -27), INT8_C( -39), INT8_C( -49), INT8_C(  50),
                           INT8_C( -81), INT8_C( -31), INT8_C(   9), INT8_C(  16),
                           INT8_C( -64), INT8_C( -28), INT8_C( 117), INT8_C(  -8),
                           INT8_C(   7), INT8_C( -76), INT8_C( -55), INT8_C(  17),
                           INT8_C(  -7), INT8_C( -64), INT8_C(  54), INT8_C(  -9),
                           INT8_C(  38), INT8_C(-127), INT8_C(  74), INT8_C(  42),
                           INT8_C(-102), INT8_C(  40), INT8_C( -56), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C( -18), INT8_C(  50), INT8_C(-118), INT8_C(  32),
                           INT8_C(  64), INT8_C(-128), INT8_C(  45), INT8_C(  -2),
                           INT8_C( -74), INT8_C( 107), INT8_C( -62), INT8_C(  23),
                           INT8_C(  71), INT8_C( -89), INT8_C(-114), INT8_C(  59),
                           INT8_C( -93), INT8_C( -32), INT8_C(  26), INT8_C( -58),
                           INT8_C(  54), INT8_C(  13), INT8_C(  -9), INT8_C( 107),
                           INT8_C(  45), INT8_C( -14), INT8_C( -76), INT8_C( -47),
                           INT8_C( -81), INT8_C( 125), INT8_C(  36), INT8_C(-128),
                           INT8_C( -67), INT8_C( -37), INT8_C(-104), INT8_C(  -9),
                           INT8_C(-118), INT8_C( 101), INT8_C(  85), INT8_C( -70),
                           INT8_C( -55), INT8_C(  77), INT8_C(-100), INT8_C(  82),
                           INT8_C( -87), INT8_C(  63), INT8_C( -31), INT8_C(  99),
                           INT8_C(  23), INT8_C(  51), INT8_C( -97), INT8_C(-120),
                           INT8_C(  74), INT8_C( -72), INT8_C(  10), INT8_C(  -6),
                           INT8_C(   4), INT8_C(  92), INT8_C( 126), INT8_C( -75),
                           INT8_C(  -6), INT8_C(  29), INT8_C( 112), INT8_C(-128)),
      simde_mm512_set_epi8(INT8_C( -56), INT8_C(  37), INT8_C(-105), INT8_C( -59),
                           INT8_C(  68), INT8_C(  78), INT8_C(-104), INT8_C( -97),
                           INT8_C(-118), INT8_C(  78), INT8_C(  55), INT8_C(  96),
                           INT8_C( -17), INT8_C( -60), INT8_C(  41), INT8_C( -68),
                           INT8_C( 122), INT8_C( 121), INT8_C(  24), INT8_C(  62),
                           INT8_C(  21), INT8_C( -43), INT8_C(  93), INT8_C( -47),
                           INT8_C(  58), INT8_C(-128), INT8_C( 124), INT8_C(  87),
                           INT8_C(  28), INT8_C(  96), INT8_C( -90), INT8_C( -42),
                           INT8_C( -61), INT8_C( 108), INT8_C(  88), INT8_C( -96),
                           INT8_C(  69), INT8_C( -99), INT8_C( -76), INT8_C(  17),
                           INT8_C(  11), INT8_C( -75), INT8_C( -45), INT8_C( 118),
                           INT8_C(  33), INT8_C( -59), INT8_C(  86), INT8_C(  64),
                           INT8_C( -67), INT8_C( -83), INT8_C(  49), INT8_C(-106),
                           INT8_C( -17), INT8_C(-100), INT8_C(  12), INT8_C(  -4),
                           INT8_C( 115), INT8_C(  51), INT8_C( -39), INT8_C(  71),
                           INT8_C(  77), INT8_C( -21), INT8_C( -53), INT8_C( -85)),
      simde_mm512_set_epi8(INT8_C(  12), INT8_C(  99), INT8_C(-119), INT8_C(   3),
                           INT8_C(  56), INT8_C( -52), INT8_C( -46), INT8_C( -56),
                           INT8_C(  73), INT8_C( 119), INT8_C( -99), INT8_C( 112),
                           INT8_C( -50), INT8_C(-103), INT8_C( -62), INT8_C( -55),
                           INT8_C(  81), INT8_C(  73), INT8_C( -72), INT8_C(  51),
                           INT8_C(-124), INT8_C( -60), INT8_C(  53), INT8_C(  93),
                           INT8_C( -91), INT8_C(  94), INT8_C( -25), INT8_C(  -6),
                           INT8_C( -82), INT8_C(-108), INT8_C( -72), INT8_C( -61),
                           INT8_C(  35), INT8_C(  13), INT8_C( -86), INT8_C(  19),
                           INT8_C(  79), INT8_C( -97), INT8_C(  49), INT8_C( -31),
                           INT8_C(  -3), INT8_C( -79), INT8_C(   2), INT8_C( -18),
                           INT8_C(  11), INT8_C(  68), INT8_C( -26), INT8_C(-115),
                           INT8_C(  88), INT8_C(  52), INT8_C(  16), INT8_C(  73),
                           INT8_C( 122), INT8_C( 115), INT8_C( -22), INT8_C(  -5),
                           INT8_C(  25), INT8_C(-105), INT8_C( -33), INT8_C( -90),
                           INT8_C(  35), INT8_C(  21), INT8_C( -40), INT8_C( -27)) },
    { simde_mm512_set_epi8(INT8_C(  31), INT8_C( -32), INT8_C( -69), INT8_C(-120),
                           INT8_C(  29), INT8_C(  35), INT8_C( -67), INT8_C(  30),
                           INT8_C( -13), INT8_C( -62), INT8_C( 104), INT8_C(  56),
                           INT8_C( -20), INT8_C(  50), INT8_C(  79), INT8_C( 105),
                           INT8_C( -40), INT8_C(-109), INT8_C(-116), INT8_C(  88),
                           INT8_C(  42), INT8_C( 110), INT8_C(-119), INT8_C( -31),
                           INT8_C( -21), INT8_C( 111), INT8_C(-125), INT8_C(-103),
                           INT8_C( -29), INT8_C(  95), INT8_C(-104), INT8_C(  45),
                           INT8_C( -54), INT8_C( -58), INT8_C(-101), INT8_C( 125),
                           INT8_C( -73), INT8_C( -39), INT8_C(-121), INT8_C(  30),
                           INT8_C( -17), INT8_C(  12), INT8_C( -86), INT8_C( -34),
                           INT8_C(  61), INT8_C(  53), INT8_C(  73), INT8_C(  85),
                           INT8_C(  87), INT8_C( -21), INT8_C( -86), INT8_C( 121),
                           INT8_C(  27), INT8_C( 115), INT8_C(-124), INT8_C( -40),
                           INT8_C( -59), INT8_C(  52), INT8_C(  99), INT8_C( -34),
                           INT8_C(  76), INT8_C(  41), INT8_C( -93), INT8_C(-112)),
      simde_mm512_set_epi8(INT8_C(  13), INT8_C( 114), INT8_C( -55), INT8_C( -70),
                           INT8_C( -86), INT8_C( -74), INT8_C( -53), INT8_C(  93),
                           INT8_C(-107), INT8_C(  88), INT8_C(-116), INT8_C(-100),
                           INT8_C( -14), INT8_C( -86), INT8_C(  18), INT8_C(-108),
                           INT8_C(  24), INT8_C( -37), INT8_C(  81), INT8_C(  91),
                           INT8_C( 122), INT8_C(  76), INT8_C( -21), INT8_C( -97),
                           INT8_C(  13), INT8_C( -19), INT8_C(  87), INT8_C(-108),
                           INT8_C(  39), INT8_C(  66), INT8_C(  79), INT8_C( -12),
                           INT8_C( 112), INT8_C(   2), INT8_C( -69), INT8_C(-108),
                           INT8_C( -48), INT8_C(  49), INT8_C( -97), INT8_C(  65),
                           INT8_C(  82), INT8_C(-120), INT8_C(  44), INT8_C( -16),
                           INT8_C(  69), INT8_C( 113), INT8_C(  37), INT8_C(  -3),
                           INT8_C(-126), INT8_C(  14), INT8_C( 120), INT8_C(  66),
                           INT8_C( -26), INT8_C( 114), INT8_C( -17), INT8_C(  54),
                           INT8_C(-115), INT8_C( -70), INT8_C(  81), INT8_C( -70),
                           INT8_C(-100), INT8_C(  69), INT8_C( -73), INT8_C(  75)),
      simde_mm512_set_epi8(INT8_C( 104), INT8_C(-127), INT8_C(-113), INT8_C( -96),
                           INT8_C(  18), INT8_C(-124), INT8_C(  84), INT8_C( -83),
                           INT8_C(  52), INT8_C( -34), INT8_C(  13), INT8_C( -60),
                           INT8_C(  61), INT8_C(-102), INT8_C( -63), INT8_C(  12),
                           INT8_C( -39), INT8_C(  72), INT8_C(-104), INT8_C(  27),
                           INT8_C( 112), INT8_C( -82), INT8_C( -10), INT8_C(  35),
                           INT8_C( -97), INT8_C( -54), INT8_C( -88), INT8_C(  19),
                           INT8_C( -36), INT8_C( -44), INT8_C(  68), INT8_C(  88),
                           INT8_C( -50), INT8_C( -62), INT8_C( -58), INT8_C(  32),
                           INT8_C( -17), INT8_C(  17), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  83), INT8_C( -32), INT8_C( -56),
                           INT8_C( -26), INT8_C(  96), INT8_C( -50), INT8_C(  53),
                           INT8_C( -80), INT8_C(  37), INT8_C(  25), INT8_C(  43),
                           INT8_C(  88), INT8_C(-106), INT8_C(-126), INT8_C( -50),
                           INT8_C( 106), INT8_C( 100), INT8_C( -64), INT8_C(-128),
                           INT8_C(  79), INT8_C(  53), INT8_C(  63), INT8_C(   4)) },
    { simde_mm512_set_epi8(INT8_C(   6), INT8_C( 112), INT8_C( -23), INT8_C( -13),
                           INT8_C(  68), INT8_C(  65), INT8_C(  87), INT8_C( -31),
                           INT8_C(-110), INT8_C(  -3), INT8_C(  46), INT8_C( -24),
                           INT8_C(  26), INT8_C(-108), INT8_C( -39), INT8_C(  72),
                           INT8_C(  66), INT8_C( -83), INT8_C( -22), INT8_C( -71),
                           INT8_C(  -5), INT8_C( -66), INT8_C(  36), INT8_C(  92),
                           INT8_C(-115), INT8_C(  63), INT8_C( -65), INT8_C(  54),
                           INT8_C( -13), INT8_C( -99), INT8_C(  49), INT8_C(  36),
                           INT8_C( -86), INT8_C(  40), INT8_C(   4), INT8_C(-124),
                           INT8_C(  35), INT8_C( 115), INT8_C(  21), INT8_C(  14),
                           INT8_C( -63), INT8_C(-123), INT8_C( -55), INT8_C(  82),
                           INT8_C(-104), INT8_C( -96), INT8_C( -98), INT8_C(-116),
                           INT8_C( 118), INT8_C( 105), INT8_C( -99), INT8_C(  73),
                           INT8_C( -46), INT8_C(  60), INT8_C(  67), INT8_C(  75),
                           INT8_C(-111), INT8_C( 102), INT8_C( -17), INT8_C( -13),
                           INT8_C(  71), INT8_C(  80), INT8_C( 109), INT8_C( -40)),
      simde_mm512_set_epi8(INT8_C( -77), INT8_C( 102), INT8_C(  95), INT8_C( -28),
                           INT8_C(  18), INT8_C( -12), INT8_C(  60), INT8_C( -53),
                           INT8_C(  29), INT8_C(  49), INT8_C(  11), INT8_C( -44),
                           INT8_C( 116), INT8_C(  50), INT8_C(-112), INT8_C(   1),
                           INT8_C(   6), INT8_C(  22), INT8_C( -56), INT8_C( -34),
                           INT8_C(-113), INT8_C( -15), INT8_C( -61), INT8_C(  70),
                           INT8_C( -23), INT8_C(  15), INT8_C( -49), INT8_C( -19),
                           INT8_C( -17), INT8_C(-127), INT8_C( -34), INT8_C(  64),
                           INT8_C(  96), INT8_C( -97), INT8_C( -92), INT8_C(  96),
                           INT8_C(  90), INT8_C( -49), INT8_C(-117), INT8_C(  30),
                           INT8_C(-114), INT8_C(-106), INT8_C(  10), INT8_C(-120),
                           INT8_C(  27), INT8_C(  -2), INT8_C(  89), INT8_C(  41),
                           INT8_C( -25), INT8_C(-109), INT8_C( 120), INT8_C( -70),
                           INT8_C(  60), INT8_C( -33), INT8_C( 121), INT8_C(  49),
                           INT8_C( -80), INT8_C( 118), INT8_C( -64), INT8_C(  38),
                           INT8_C(  20), INT8_C( -60), INT8_C( -96), INT8_C(  -5)),
      simde_mm512_set_epi8(INT8_C(  -8), INT8_C( -79), INT8_C(  44), INT8_C(  10),
                           INT8_C( -63), INT8_C(  42), INT8_C( -90), INT8_C( -24),
                           INT8_C(  22), INT8_C(-125), INT8_C(  11), INT8_C( 102),
                           INT8_C(  91), INT8_C(  43), INT8_C( -88), INT8_C(  28),
                           INT8_C(  54), INT8_C( -86), INT8_C( 118), INT8_C(  27),
                           INT8_C(  44), INT8_C(  43), INT8_C( -70), INT8_C(  64),
                           INT8_C(  66), INT8_C(  48), INT8_C(  77), INT8_C(  80),
                           INT8_C(-111), INT8_C(   2), INT8_C( 103), INT8_C(  70),
                           INT8_C( 106), INT8_C(  -2), INT8_C( -89), INT8_C( -63),
                           INT8_C(-100), INT8_C(  55), INT8_C(  87), INT8_C( -89),
                           INT8_C(-102), INT8_C( -39), INT8_C( 103), INT8_C(  36),
                           INT8_C( -91), INT8_C(-118), INT8_C( -79), INT8_C( -12),
                           INT8_C(  93), INT8_C(  38), INT8_C( 122), INT8_C(  -5),
                           INT8_C(-102), INT8_C( 111), INT8_C( -84), INT8_C( -48),
                           INT8_C(  -9), INT8_C( -36), INT8_C(  57), INT8_C(  16),
                           INT8_C(-105), INT8_C(  52), INT8_C(  86), INT8_C(  81)) },
    { simde_mm512_set_epi8(INT8_C(  35), INT8_C(  81), INT8_C(  98), INT8_C(  19),
                           INT8_C( 101), INT8_C(  68), INT8_C( -12), INT8_C(  76),
                           INT8_C( 124), INT8_C(-120), INT8_C( -47), INT8_C( -64),
                           INT8_C( 123), INT8_C( -63), INT8_C(-104), INT8_C( 112),
                           INT8_C( 121), INT8_C(   5), INT8_C(-114), INT8_C( -67),
                           INT8_C( -30), INT8_C(  49), INT8_C( -62), INT8_C( -64),
                           INT8_C(  23), INT8_C(  30), INT8_C(  77), INT8_C( -34),
                           INT8_C( -79), INT8_C(  41), INT8_C(  56), INT8_C(  80),
                           INT8_C( 101), INT8_C( 101), INT8_C(  86), INT8_C( -92),
                           INT8_C(  67), INT8_C(  78), INT8_C(  66), INT8_C( -34),
                           INT8_C( -60), INT8_C( 101), INT8_C( -49), INT8_C(  58),
                           INT8_C(  85), INT8_C(  98), INT8_C( -83), INT8_C( 120),
                           INT8_C( -94), INT8_C( -69), INT8_C( 114), INT8_C(  51),
                           INT8_C(  -6), INT8_C(  41), INT8_C(   1), INT8_C( -18),
                           INT8_C(  83), INT8_C( -45), INT8_C(  15), INT8_C(  29),
                           INT8_C(  33), INT8_C( -73), INT8_C(  69), INT8_C( 101)),
      simde_mm512_set_epi8(INT8_C( -32), INT8_C(-108), INT8_C(-123), INT8_C( -29),
                           INT8_C(   2), INT8_C( -87), INT8_C( -27), INT8_C(  55),
                           INT8_C(-108), INT8_C( 107), INT8_C(  45), INT8_C( -42),
                           INT8_C( -86), INT8_C(-117), INT8_C(  52), INT8_C(-105),
                           INT8_C( -99), INT8_C(-127), INT8_C(  96), INT8_C( -45),
                           INT8_C( -78), INT8_C(  74), INT8_C( -81), INT8_C(-117),
                           INT8_C(  -7), INT8_C( -62), INT8_C( -97), INT8_C( -59),
                           INT8_C( -31), INT8_C(-122), INT8_C(  86), INT8_C( -86),
                           INT8_C( -59), INT8_C(  56), INT8_C( -37), INT8_C( 107),
                           INT8_C( -21), INT8_C( 121), INT8_C( 126), INT8_C( -35),
                           INT8_C(-108), INT8_C( 116), INT8_C(  37), INT8_C(  25),
                           INT8_C( 118), INT8_C(-106), INT8_C(  26), INT8_C(  84),
                           INT8_C(-100), INT8_C(  47), INT8_C(  87), INT8_C(  88),
                           INT8_C(  91), INT8_C(  11), INT8_C(   5), INT8_C(-103),
                           INT8_C(  16), INT8_C(  32), INT8_C( 111), INT8_C(   4),
                           INT8_C(-119), INT8_C(  25), INT8_C(  22), INT8_C( -98)),
      simde_mm512_set_epi8(INT8_C(-100), INT8_C(  38), INT8_C(  57), INT8_C(  -9),
                           INT8_C(-117), INT8_C(-114), INT8_C(-118), INT8_C( -82),
                           INT8_C( 111), INT8_C(-114), INT8_C( -35), INT8_C( -78),
                           INT8_C( -66), INT8_C(  20), INT8_C(  71), INT8_C(-108),
                           INT8_C(  74), INT8_C(-117), INT8_C(-126), INT8_C(  -4),
                           INT8_C(  90), INT8_C(-121), INT8_C(  14), INT8_C( -10),
                           INT8_C( -45), INT8_C(  75), INT8_C( -82), INT8_C( -81),
                           INT8_C( 119), INT8_C(   8), INT8_C(  80), INT8_C(  31),
                           INT8_C(  -6), INT8_C(  -6), INT8_C(-121), INT8_C(  47),
                           INT8_C(  29), INT8_C( -97), INT8_C( -96), INT8_C( -20),
                           INT8_C(   5), INT8_C(  62), INT8_C(  49), INT8_C( -44),
                           INT8_C( -45), INT8_C( -11), INT8_C( -59), INT8_C(  54),
                           INT8_C( -76), INT8_C( 100), INT8_C( -76), INT8_C(  94),
                           INT8_C(-114), INT8_C(  78), INT8_C(  -9), INT8_C(  84),
                           INT8_C(  20), INT8_C(-124), INT8_C(-119), INT8_C( -84),
                           INT8_C(  51), INT8_C(  74), INT8_C(  -3), INT8_C(  -5)) },
    { simde_mm512_set_epi8(INT8_C(  66), INT8_C( -80), INT8_C( -63), INT8_C(  61),
                           INT8_C( -93), INT8_C( -68), INT8_C(  -6), INT8_C(  29),
                           INT8_C(  23), INT8_C( -68), INT8_C( -72), INT8_C( -60),
                           INT8_C(  43), INT8_C( -79), INT8_C( 121), INT8_C( -29),
                           INT8_C(  97), INT8_C(-101), INT8_C( -12), INT8_C( -68),
                           INT8_C(  -5), INT8_C( 120), INT8_C(  60), INT8_C( 117),
                           INT8_C(-113), INT8_C(  37), INT8_C(  65), INT8_C(  75),
                           INT8_C( 114), INT8_C(-102), INT8_C(  95), INT8_C( -11),
                           INT8_C(  60), INT8_C(-109), INT8_C( 126), INT8_C( -65),
                           INT8_C( -87), INT8_C(  29), INT8_C( 126), INT8_C(  71),
                           INT8_C( -89), INT8_C( 115), INT8_C( -78), INT8_C(  20),
                           INT8_C( 106), INT8_C(  12), INT8_C( -71), INT8_C( -99),
                           INT8_C(  22), INT8_C( -59), INT8_C( -40), INT8_C(  71),
                           INT8_C( -27), INT8_C( -58), INT8_C(  93), INT8_C(  56),
                           INT8_C( -74), INT8_C(-107), INT8_C( -37), INT8_C( -36),
                           INT8_C( -90), INT8_C(  79), INT8_C( 105), INT8_C(-115)),
      simde_mm512_set_epi8(INT8_C(  97), INT8_C( -34), INT8_C(  16), INT8_C(  27),
                           INT8_C( -61), INT8_C(  47), INT8_C( -46), INT8_C( -28),
                           INT8_C(  -1), INT8_C(  48), INT8_C(  49), INT8_C( -97),
                           INT8_C( -82), INT8_C(  -5), INT8_C(-101), INT8_C(  74),
                           INT8_C( -12), INT8_C(-117), INT8_C(   2), INT8_C( 111),
                           INT8_C( 103), INT8_C( 106), INT8_C(  49), INT8_C(  41),
                           INT8_C( -15), INT8_C( -75), INT8_C(  18), INT8_C(  70),
                           INT8_C(   6), INT8_C( -21), INT8_C( -83), INT8_C(  -3),
                           INT8_C( -80), INT8_C(  -7), INT8_C(  18), INT8_C(  44),
                           INT8_C( -49), INT8_C( -88), INT8_C(  47), INT8_C( -96),
                           INT8_C( -84), INT8_C( -86), INT8_C(  82), INT8_C( -89),
                           INT8_C( 103), INT8_C(  19), INT8_C( -12), INT8_C(  24),
                           INT8_C(  26), INT8_C(  98), INT8_C( -35), INT8_C( -11),
                           INT8_C(  90), INT8_C( -96), INT8_C(  20), INT8_C( 127),
                           INT8_C(-100), INT8_C( 125), INT8_C( 105), INT8_C( -43),
                           INT8_C( 115), INT8_C(-111), INT8_C( 110), INT8_C(  23)),
      simde_mm512_set_epi8(INT8_C( -88), INT8_C(  60), INT8_C(  57), INT8_C(  95),
                           INT8_C(  49), INT8_C( -76), INT8_C( -65), INT8_C(  -2),
                           INT8_C( -29), INT8_C( -64), INT8_C( -39), INT8_C( -64),
                           INT8_C(  91), INT8_C(  77), INT8_C( 108), INT8_C( 122),
                           INT8_C(  27), INT8_C(  13), INT8_C(-102), INT8_C(   9),
                           INT8_C( -51), INT8_C(  42), INT8_C(  10), INT8_C(  67),
                           INT8_C(   7), INT8_C( -37), INT8_C(  75), INT8_C(-105),
                           INT8_C( -16), INT8_C( -71), INT8_C( -54), INT8_C(  22),
                           INT8_C( -49), INT8_C( -77), INT8_C(-119), INT8_C( 122),
                           INT8_C( 113), INT8_C( 118), INT8_C(-119), INT8_C(  77),
                           INT8_C(  78), INT8_C( -20), INT8_C( -53), INT8_C( -68),
                           INT8_C( -77), INT8_C( -37), INT8_C(  78), INT8_C(  76),
                           INT8_C(-125), INT8_C( -13), INT8_C(  -5), INT8_C(  76),
                           INT8_C(  89), INT8_C( -20), INT8_C(-105), INT8_C( -29),
                           INT8_C( -34), INT8_C( -26), INT8_C( -28), INT8_C(  65),
                           INT8_C( 101), INT8_C( -67), INT8_C( -16), INT8_C(  26)) },
    { simde_mm512_set_epi8(INT8_C(   8), INT8_C( 123), INT8_C(  10), INT8_C(   2),
                           INT8_C( 101), INT8_C(  99), INT8_C( 109), INT8_C(  10),
                           INT8_C( -81), INT8_C(-128), INT8_C( -42), INT8_C(  28),
                           INT8_C( -14), INT8_C( -60), INT8_C(  95), INT8_C(  76),
                           INT8_C(  34), INT8_C( -72), INT8_C( -83), INT8_C(-103),
                           INT8_C( 124), INT8_C( -24), INT8_C( -55), INT8_C(  22),
                           INT8_C(-115), INT8_C(  43), INT8_C(  53), INT8_C(-100),
                           INT8_C( 126), INT8_C( 123), INT8_C(  70), INT8_C(  79),
                           INT8_C(  47), INT8_C( 116), INT8_C(  38), INT8_C(  25),
                           INT8_C( -54), INT8_C(  18), INT8_C( -58), INT8_C(-123),
                           INT8_C(  40), INT8_C( -54), INT8_C(-122), INT8_C( -64),
                           INT8_C( 111), INT8_C(  66), INT8_C(  57), INT8_C( -34),
                           INT8_C(  67), INT8_C( -68), INT8_C( -84), INT8_C(  -7),
                           INT8_C( -99), INT8_C(  12), INT8_C(-115), INT8_C( 121),
                           INT8_C(  67), INT8_C(  39), INT8_C(-116), INT8_C( -98),
                           INT8_C(  21), INT8_C(-107), INT8_C(  14), INT8_C(  51)),
      simde_mm512_set_epi8(INT8_C( -90), INT8_C( -61), INT8_C( 119), INT8_C( -75),
                           INT8_C( -77), INT8_C( -66), INT8_C(  -5), INT8_C(-119),
                           INT8_C( -73), INT8_C(  56), INT8_C(  64), INT8_C(  21),
                           INT8_C(  66), INT8_C(  53), INT8_C( 117), INT8_C( -41),
                           INT8_C( 120), INT8_C(-102), INT8_C( -22), INT8_C(  29),
                           INT8_C(  18), INT8_C( -50), INT8_C(-111), INT8_C(  88),
                           INT8_C( -27), INT8_C(  98), INT8_C(  39), INT8_C(  14),
                           INT8_C( -13), INT8_C( -52), INT8_C( -33), INT8_C( 115),
                           INT8_C(  79), INT8_C(   6), INT8_C( -29), INT8_C(  19),
                           INT8_C( -11), INT8_C( -57), INT8_C( -61), INT8_C(  26),
                           INT8_C(  90), INT8_C( 106), INT8_C(  71), INT8_C(  -8),
                           INT8_C(-111), INT8_C(  50), INT8_C(   2), INT8_C( 100),
                           INT8_C( -12), INT8_C(   6), INT8_C(  19), INT8_C( 121),
                           INT8_C(  91), INT8_C( -20), INT8_C( -24), INT8_C(  37),
                           INT8_C(   9), INT8_C(  18), INT8_C(   3), INT8_C(  25),
                           INT8_C(  -7), INT8_C(  60), INT8_C(  12), INT8_C( 112)),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C(  15), INT8_C(-106), INT8_C( 118),
                           INT8_C( -55), INT8_C(-109), INT8_C(  41), INT8_C(-106),
                           INT8_C( 112), INT8_C(-128), INT8_C( -57), INT8_C(   1),
                           INT8_C(  77), INT8_C( -67), INT8_C( -83), INT8_C(  62),
                           INT8_C(  50), INT8_C(  22), INT8_C( -83), INT8_C(  91),
                           INT8_C(  -3), INT8_C( 104), INT8_C(  37), INT8_C( -60),
                           INT8_C( -96), INT8_C( -11), INT8_C(  -2), INT8_C( -91),
                           INT8_C( 110), INT8_C( -42), INT8_C(  65), INT8_C(  -4),
                           INT8_C(  53), INT8_C( -53), INT8_C( -55), INT8_C( 101),
                           INT8_C( 110), INT8_C( 118), INT8_C( -36), INT8_C(  59),
                           INT8_C( -96), INT8_C(  -6), INT8_C(  -6), INT8_C(-106),
                           INT8_C( -40), INT8_C( -23), INT8_C(-115), INT8_C(  71),
                           INT8_C( -14), INT8_C(  79), INT8_C(  82), INT8_C(   9),
                           INT8_C(  58), INT8_C( -38), INT8_C(  39), INT8_C( 104),
                           INT8_C(-118), INT8_C( -54), INT8_C(   8), INT8_C( -76),
                           INT8_C( -58), INT8_C( -42), INT8_C(  30), INT8_C(  16)) },
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C( 120), INT8_C( -74), INT8_C(  62),
                           INT8_C(  90), INT8_C( -96), INT8_C(  75), INT8_C( -78),
                           INT8_C(  -6), INT8_C( -71), INT8_C( -63), INT8_C(  18),
                           INT8_C(  60), INT8_C(  34), INT8_C(  -5), INT8_C( -95),
                           INT8_C(  20), INT8_C( -75), INT8_C(-106), INT8_C( -37),
                           INT8_C(  52), INT8_C( 127), INT8_C(-121), INT8_C(  89),
                           INT8_C(  64), INT8_C(  32), INT8_C(-117), INT8_C( -70),
                           INT8_C( 112), INT8_C( -57), INT8_C(  67), INT8_C( 101),
                           INT8_C( -17), INT8_C(  32), INT8_C( 117), INT8_C(  37),
                           INT8_C( -21), INT8_C(  53), INT8_C(  33), INT8_C(-118),
                           INT8_C( -95), INT8_C( 107), INT8_C(   7), INT8_C(  73),
                           INT8_C(  99), INT8_C( 101), INT8_C(  84), INT8_C( -74),
                           INT8_C(  -8), INT8_C(  64), INT8_C( 124), INT8_C( -76),
                           INT8_C(  79), INT8_C(   2), INT8_C(  35), INT8_C( -37),
                           INT8_C( -29), INT8_C( -61), INT8_C( -22), INT8_C(  -1),
                           INT8_C( -84), INT8_C(  62), INT8_C(-103), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -96), INT8_C(  30), INT8_C(  11), INT8_C( -55),
                           INT8_C( -14), INT8_C(-106), INT8_C(  14), INT8_C( -64),
                           INT8_C( 108), INT8_C( -88), INT8_C(-108), INT8_C(  18),
                           INT8_C(  38), INT8_C(  83), INT8_C(   5), INT8_C(  37),
                           INT8_C( -18), INT8_C(  57), INT8_C( -44), INT8_C( -90),
                           INT8_C(  25), INT8_C(-119), INT8_C(  27), INT8_C(  -2),
                           INT8_C( -43), INT8_C( 122), INT8_C(  24), INT8_C(  50),
                           INT8_C(  13), INT8_C(  -1), INT8_C(  74), INT8_C( -40),
                           INT8_C(  45), INT8_C(-118), INT8_C( -70), INT8_C( 117),
                           INT8_C( -65), INT8_C(  72), INT8_C(-106), INT8_C(  16),
                           INT8_C( -24), INT8_C( -94), INT8_C(  77), INT8_C( -48),
                           INT8_C( -36), INT8_C(  38), INT8_C( -91), INT8_C( -47),
                           INT8_C(  42), INT8_C(-103), INT8_C( -94), INT8_C( 107),
                           INT8_C( -44), INT8_C(  48), INT8_C( -99), INT8_C( 117),
                           INT8_C( 113), INT8_C(  88), INT8_C(-102), INT8_C(  23),
                           INT8_C(  -5), INT8_C(  85), INT8_C( -40), INT8_C( -45)),
      simde_mm512_set_epi8(INT8_C( -36), INT8_C( -12), INT8_C(-113), INT8_C( 120),
                           INT8_C(-109), INT8_C( -87), INT8_C( -83), INT8_C( -19),
                           INT8_C( -94), INT8_C(  91), INT8_C( -58), INT8_C(  21),
                           INT8_C( 104), INT8_C( -86), INT8_C(  66), INT8_C( 116),
                           INT8_C(  90), INT8_C(  14), INT8_C(  62), INT8_C( -73),
                           INT8_C( -47), INT8_C(  28), INT8_C(-102), INT8_C( -45),
                           INT8_C( -30), INT8_C(  43), INT8_C(  13), INT8_C( -71),
                           INT8_C( 103), INT8_C(  41), INT8_C( -71), INT8_C( -56),
                           INT8_C(  67), INT8_C(  28), INT8_C( -88), INT8_C(  92),
                           INT8_C(  26), INT8_C(-128), INT8_C(   5), INT8_C(  54),
                           INT8_C( 125), INT8_C(  12), INT8_C(-109), INT8_C(  77),
                           INT8_C(  25), INT8_C(  79), INT8_C( 112), INT8_C( 119),
                           INT8_C( -37), INT8_C(-103), INT8_C(  93), INT8_C( -40),
                           INT8_C( -59), INT8_C(  12), INT8_C( 107), INT8_C( -79),
                           INT8_C(  18), INT8_C(   3), INT8_C(  -3), INT8_C(-109),
                           INT8_C( -70), INT8_C(  13), INT8_C( -59), INT8_C( -14)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_gf2p8affine_epi64_epi8(test_vec[i].x, test_vec[i].A, INT8_C(   1));
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_mask_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i src;
    simde__mmask16 k;
    simde__m128i x;
    simde__m128i A;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -53), INT8_C( 109), INT8_C( -72), INT8_C(  -6),
                        INT8_C( 112), INT8_C(  75), INT8_C( -92), INT8_C(  12),
                        INT8_C(  98), INT8_C( -63), INT8_C(  64), INT8_C( -41),
                        INT8_C(  43), INT8_C( -55), INT8_C( -46), INT8_C(  88)),
      UINT16_C( 5407),
      simde_mm_set_epi8(INT8_C(   3), INT8_C( -64), INT8_C(  77), INT8_C( -56),
                        INT8_C(-127), INT8_C( -33), INT8_C(  83), INT8_C(  46),
                        INT8_C( -91), INT8_C( 125), INT8_C( -59), INT8_C( -28),
                        INT8_C(-110), INT8_C(  94), INT8_C(  67), INT8_C(  64)),
      simde_mm_set_epi8(INT8_C( -18), INT8_C(  56), INT8_C( -33), INT8_C(   5),
                        INT8_C( -31), INT8_C(  37), INT8_C(  43), INT8_C( -26),
                        INT8_C( -84), INT8_C(  85), INT8_C(  28), INT8_C( -96),
                        INT8_C( -54), INT8_C(  79), INT8_C(  16), INT8_C( 119)),
      simde_mm_set_epi8(INT8_C( -53), INT8_C( 109), INT8_C( -72), INT8_C( 103),
                        INT8_C( 112), INT8_C( 117), INT8_C( -92), INT8_C(  -4),
                        INT8_C(  98), INT8_C( -63), INT8_C(  64), INT8_C( -91),
                        INT8_C(  79), INT8_C( 118), INT8_C(-128), INT8_C(-110)) },
    { simde_mm_set_epi8(INT8_C( 117), INT8_C( -64), INT8_C(  56), INT8_C( -56),
                        INT8_C(  44), INT8_C( -78), INT8_C(  20), INT8_C( -85),
                        INT8_C( -38), INT8_C( -31), INT8_C( -26), INT8_C(-115),
                        INT8_C(-118), INT8_C(   4), INT8_C( -21), INT8_C(  76)),
      UINT16_C(23105),
      simde_mm_set_epi8(INT8_C( 122), INT8_C( -86), INT8_C( 110), INT8_C( -49),
                        INT8_C( -67), INT8_C(  44), INT8_C( -99), INT8_C(-105),
                        INT8_C(  48), INT8_C( 110), INT8_C( -78), INT8_C(  59),
                        INT8_C(-113), INT8_C(-109), INT8_C(  95), INT8_C( -41)),
      simde_mm_set_epi8(INT8_C(  96), INT8_C(   1), INT8_C( 107), INT8_C(   0),
                        INT8_C(  79), INT8_C( -78), INT8_C(  84), INT8_C( 107),
                        INT8_C(  99), INT8_C(  90), INT8_C( 101), INT8_C( -53),
                        INT8_C(  26), INT8_C( 105), INT8_C( -25), INT8_C(  22)),
      simde_mm_set_epi8(INT8_C( 117), INT8_C(-123), INT8_C(  56), INT8_C(  51),
                        INT8_C(-105), INT8_C( -78), INT8_C(  50), INT8_C( -85),
                        INT8_C( -38), INT8_C(  15), INT8_C( -26), INT8_C(-115),
                        INT8_C(-118), INT8_C(   4), INT8_C( -21), INT8_C( -25)) },
    { simde_mm_set_epi8(INT8_C( 117), INT8_C(  -4), INT8_C(  -7), INT8_C(  29),
                        INT8_C(-111), INT8_C( 111), INT8_C( -38), INT8_C( -85),
                        INT8_C( -27), INT8_C( 107), INT8_C( -26), INT8_C( -23),
                        INT8_C( -57), INT8_C( 127), INT8_C( -37), INT8_C( 116)),
      UINT16_C(46922),
      simde_mm_set_epi8(INT8_C(  35), INT8_C(  35), INT8_C( -52), INT8_C(  65),
                        INT8_C( -57), INT8_C(  52), INT8_C(-105), INT8_C( -52),
                        INT8_C(  -3), INT8_C( -72), INT8_C(  12), INT8_C( -81),
                        INT8_C( 102), INT8_C(   5), INT8_C(  69), INT8_C( -78)),
      simde_mm_set_epi8(INT8_C(  36), INT8_C( -42), INT8_C( 126), INT8_C(  34),
                        INT8_C( 123), INT8_C(  57), INT8_C(  98), INT8_C(  50),
                        INT8_C(  11), INT8_C(  55), INT8_C(  39), INT8_C( -87),
                        INT8_C( 121), INT8_C( -10), INT8_C(  48), INT8_C( -27)),
      simde_mm_set_epi8(INT8_C(  51), INT8_C(  -4), INT8_C(  71), INT8_C(  70),
                        INT8_C(-111), INT8_C( 108), INT8_C( 125), INT8_C(  71),
                        INT8_C( -27), INT8_C(  29), INT8_C( -26), INT8_C( -23),
                        INT8_C( -17), INT8_C( 127), INT8_C( -87), INT8_C( 116)) },
    { simde_mm_set_epi8(INT8_C(  49), INT8_C( -42), INT8_C(  99), INT8_C( -33),
                        INT8_C( 102), INT8_C( -69), INT8_C(  80), INT8_C(  28),
                        INT8_C( -57), INT8_C(-105), INT8_C( -54), INT8_C(  29),
                        INT8_C( 127), INT8_C(-103), INT8_C( -56), INT8_C(  -9)),
      UINT16_C(13222),
      simde_mm_set_epi8(INT8_C(  63), INT8_C(  76), INT8_C( -21), INT8_C( 103),
                        INT8_C( -99), INT8_C(  -8), INT8_C( -71), INT8_C(   6),
                        INT8_C( -27), INT8_C( 107), INT8_C(  23), INT8_C(  20),
                        INT8_C( -71), INT8_C(  77), INT8_C( 119), INT8_C(-117)),
      simde_mm_set_epi8(INT8_C(   7), INT8_C(  81), INT8_C( -54), INT8_C(-116),
                        INT8_C( 110), INT8_C(-127), INT8_C(  83), INT8_C(  47),
                        INT8_C( -56), INT8_C(-107), INT8_C(  -7), INT8_C(  36),
                        INT8_C(  -9), INT8_C(   1), INT8_C(  85), INT8_C( -61)),
      simde_mm_set_epi8(INT8_C(  49), INT8_C( -42), INT8_C(  96), INT8_C(  73),
                        INT8_C( 102), INT8_C( -69), INT8_C( -95), INT8_C( 108),
                        INT8_C( -46), INT8_C(-105), INT8_C(  74), INT8_C(  29),
                        INT8_C( 127), INT8_C(  92), INT8_C(-125), INT8_C(  -9)) },
    { simde_mm_set_epi8(INT8_C( -28), INT8_C(  17), INT8_C( 126), INT8_C(  55),
                        INT8_C( -19), INT8_C(  71), INT8_C(  38), INT8_C(-110),
                        INT8_C( -94), INT8_C(  23), INT8_C( -88), INT8_C(  -8),
                        INT8_C(  30), INT8_C( -59), INT8_C(  51), INT8_C( -12)),
      UINT16_C(30769),
      simde_mm_set_epi8(INT8_C( -20), INT8_C(  56), INT8_C(  74), INT8_C(  73),
                        INT8_C(  35), INT8_C(   7), INT8_C(  57), INT8_C( -59),
                        INT8_C( -71), INT8_C( -43), INT8_C(-119), INT8_C(  46),
                        INT8_C( -19), INT8_C(  31), INT8_C(  36), INT8_C( -80)),
      simde_mm_set_epi8(INT8_C(-105), INT8_C(  21), INT8_C( -18), INT8_C( 101),
                        INT8_C(-105), INT8_C( -48), INT8_C(  19), INT8_C(-120),
                        INT8_C(  94), INT8_C(-111), INT8_C(  11), INT8_C( -31),
                        INT8_C(-128), INT8_C(   1), INT8_C(-123), INT8_C(  66)),
      simde_mm_set_epi8(INT8_C( -28), INT8_C( -37), INT8_C( -35), INT8_C( -45),
                        INT8_C(  34), INT8_C(  71), INT8_C(  38), INT8_C(-110),
                        INT8_C( -94), INT8_C(  23), INT8_C(  17), INT8_C( -23),
                        INT8_C(  30), INT8_C( -59), INT8_C(  51), INT8_C( 113)) },
    { simde_mm_set_epi8(INT8_C( -95), INT8_C( -71), INT8_C(  70), INT8_C( -61),
                        INT8_C( -28), INT8_C(  74), INT8_C(  70), INT8_C(  59),
                        INT8_C(  -6), INT8_C( -54), INT8_C(  90), INT8_C( 108),
                        INT8_C( -12), INT8_C(  40), INT8_C(  67), INT8_C( -19)),
      UINT16_C(59146),
      simde_mm_set_epi8(INT8_C(  38), INT8_C( 113), INT8_C( -51), INT8_C(  35),
                        INT8_C( -49), INT8_C(  20), INT8_C(  32), INT8_C(  74),
                        INT8_C( -76), INT8_C(-126), INT8_C( -53), INT8_C( -83),
                        INT8_C( -23), INT8_C( 109), INT8_C(   7), INT8_C(  82)),
      simde_mm_set_epi8(INT8_C( -75), INT8_C( -32), INT8_C(-100), INT8_C( 104),
                        INT8_C( -83), INT8_C(   7), INT8_C(  51), INT8_C( -62),
                        INT8_C(-102), INT8_C( 127), INT8_C( 113), INT8_C( 115),
                        INT8_C(  31), INT8_C(  20), INT8_C(  95), INT8_C(  34)),
      simde_mm_set_epi8(INT8_C( -82), INT8_C( -59), INT8_C( 101), INT8_C( -61),
                        INT8_C( -28), INT8_C(  80), INT8_C( 123), INT8_C(  86),
                        INT8_C(  -6), INT8_C( -54), INT8_C(  90), INT8_C( 108),
                        INT8_C( -20), INT8_C(  40), INT8_C( -41), INT8_C( -19)) },
    { simde_mm_set_epi8(INT8_C(  17), INT8_C( 122), INT8_C(  -7), INT8_C( -75),
                        INT8_C(  76), INT8_C(  29), INT8_C( -90), INT8_C( 121),
                        INT8_C( 121), INT8_C(  21), INT8_C(  69), INT8_C(  30),
                        INT8_C(  36), INT8_C( -84), INT8_C(  26), INT8_C( 107)),
      UINT16_C(23704),
      simde_mm_set_epi8(INT8_C( -95), INT8_C( -68), INT8_C( -65), INT8_C(  63),
                        INT8_C( -44), INT8_C( -41), INT8_C( -55), INT8_C(  46),
                        INT8_C(  -5), INT8_C(  -8), INT8_C(  32), INT8_C( 101),
                        INT8_C(-121), INT8_C(  60), INT8_C(  -4), INT8_C(  40)),
      simde_mm_set_epi8(INT8_C(  -4), INT8_C( -76), INT8_C(  74), INT8_C( -56),
                        INT8_C( -36), INT8_C( 121), INT8_C(-105), INT8_C( 109),
                        INT8_C(  83), INT8_C(  99), INT8_C( -62), INT8_C( -33),
                        INT8_C(  15), INT8_C(  27), INT8_C(-106), INT8_C(  56)),
      simde_mm_set_epi8(INT8_C(  17), INT8_C( -59), INT8_C(  -7), INT8_C(  58),
                        INT8_C( 102), INT8_C( -62), INT8_C( -90), INT8_C( 121),
                        INT8_C( -12), INT8_C(  21), INT8_C(  69), INT8_C( -50),
                        INT8_C( 112), INT8_C( -84), INT8_C(  26), INT8_C( 107)) },
    { simde_mm_set_epi8(INT8_C( -94), INT8_C( -39), INT8_C(  28), INT8_C(  17),
                        INT8_C(  32), INT8_C( -23), INT8_C( -32), INT8_C( 102),
                        INT8_C(  60), INT8_C(  10), INT8_C(-120), INT8_C( -82),
                        INT8_C( -91), INT8_C( -44), INT8_C(   8), INT8_C( -86)),
      UINT16_C(18462),
      simde_mm_set_epi8(INT8_C( 121), INT8_C( -31), INT8_C(-109), INT8_C( -76),
                        INT8_C(  27), INT8_C( -91), INT8_C( -72), INT8_C(-121),
                        INT8_C( 100), INT8_C(  45), INT8_C( -84), INT8_C(  24),
                        INT8_C(  66), INT8_C( 120), INT8_C(  55), INT8_C(  85)),
      simde_mm_set_epi8(INT8_C(-124), INT8_C( 103), INT8_C( -54), INT8_C( -95),
                        INT8_C( -17), INT8_C( -76), INT8_C(  88), INT8_C(-114),
                        INT8_C(   2), INT8_C( -31), INT8_C(-107), INT8_C(  94),
                        INT8_C( 104), INT8_C(  -6), INT8_C(  21), INT8_C(  36)),
      simde_mm_set_epi8(INT8_C( -94), INT8_C( -21), INT8_C(  28), INT8_C(  17),
                        INT8_C(  24), INT8_C( -23), INT8_C( -32), INT8_C( 102),
                        INT8_C(  60), INT8_C(  10), INT8_C(-120), INT8_C( 116),
                        INT8_C(  51), INT8_C(  -4), INT8_C(  93), INT8_C( -86)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_mask_gf2p8affine_epi64_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C(  32));
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_mask_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m256i src;
    simde__mmask32 k;
    simde__m256i x;
    simde__m256i A;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( -91), INT8_C( 125), INT8_C( -59), INT8_C( -28),
                           INT8_C(-110), INT8_C(  94), INT8_C(  67), INT8_C(  64),
                           INT8_C( -85), INT8_C( 127), INT8_C( -76), INT8_C(-117),
                           INT8_C(  37), INT8_C(-123), INT8_C(  21), INT8_C(  31),
                           INT8_C( -53), INT8_C( 109), INT8_C( -72), INT8_C(  -6),
                           INT8_C( 112), INT8_C(  75), INT8_C( -92), INT8_C(  12),
                           INT8_C(  98), INT8_C( -63), INT8_C(  64), INT8_C( -41),
                           INT8_C(  43), INT8_C( -55), INT8_C( -46), INT8_C(  88)),
      UINT32_C(2178896686),
      simde_mm256_set_epi8(INT8_C( 117), INT8_C( -64), INT8_C(  56), INT8_C( -56),
                           INT8_C(  44), INT8_C( -78), INT8_C(  20), INT8_C( -85),
                           INT8_C( -38), INT8_C( -31), INT8_C( -26), INT8_C(-115),
                           INT8_C(-118), INT8_C(   4), INT8_C( -21), INT8_C(  76),
                           INT8_C( -18), INT8_C(  56), INT8_C( -33), INT8_C(   5),
                           INT8_C( -31), INT8_C(  37), INT8_C(  43), INT8_C( -26),
                           INT8_C( -84), INT8_C(  85), INT8_C(  28), INT8_C( -96),
                           INT8_C( -54), INT8_C(  79), INT8_C(  16), INT8_C( 119)),
      simde_mm256_set_epi8(INT8_C(  99), INT8_C(  90), INT8_C( 101), INT8_C( -53),
                           INT8_C(  26), INT8_C( 105), INT8_C( -25), INT8_C(  22),
                           INT8_C( 122), INT8_C( -86), INT8_C( 110), INT8_C( -49),
                           INT8_C( -67), INT8_C(  44), INT8_C( -99), INT8_C(-105),
                           INT8_C(  48), INT8_C( 110), INT8_C( -78), INT8_C(  59),
                           INT8_C(-113), INT8_C(-109), INT8_C(  95), INT8_C( -41),
                           INT8_C( -26), INT8_C(  72), INT8_C(  78), INT8_C(  30),
                           INT8_C(  13), INT8_C(   4), INT8_C(  90), INT8_C(  65)),
      simde_mm256_set_epi8(INT8_C(  24), INT8_C( 125), INT8_C( -59), INT8_C( -28),
                           INT8_C(-110), INT8_C(  94), INT8_C(  67), INT8_C(-120),
                           INT8_C( -33), INT8_C(  17), INT8_C( -76), INT8_C( -88),
                           INT8_C(   3), INT8_C( -43), INT8_C( -31), INT8_C( -89),
                           INT8_C( -53), INT8_C(-111), INT8_C( -72), INT8_C(   3),
                           INT8_C( 112), INT8_C(  75), INT8_C( 122), INT8_C( 124),
                           INT8_C(  98), INT8_C( -63), INT8_C(   2), INT8_C( -41),
                           INT8_C(  -4), INT8_C(  80), INT8_C(  97), INT8_C(  88)) },
    { simde_mm256_set_epi8(INT8_C( -14), INT8_C(  79), INT8_C(  79), INT8_C( -73),
                           INT8_C(  50), INT8_C( -99), INT8_C( -73), INT8_C(  74),
                           INT8_C( 117), INT8_C(  -4), INT8_C(  -7), INT8_C(  29),
                           INT8_C(-111), INT8_C( 111), INT8_C( -38), INT8_C( -85),
                           INT8_C( -27), INT8_C( 107), INT8_C( -26), INT8_C( -23),
                           INT8_C( -57), INT8_C( 127), INT8_C( -37), INT8_C( 116),
                           INT8_C(  96), INT8_C(   1), INT8_C( 107), INT8_C(   0),
                           INT8_C(  79), INT8_C( -78), INT8_C(  84), INT8_C( 107)),
      UINT32_C(1711621554),
      simde_mm256_set_epi8(INT8_C( -57), INT8_C(-105), INT8_C( -54), INT8_C(  29),
                           INT8_C( 127), INT8_C(-103), INT8_C( -56), INT8_C(  -9),
                           INT8_C(  36), INT8_C( -42), INT8_C( 126), INT8_C(  34),
                           INT8_C( 123), INT8_C(  57), INT8_C(  98), INT8_C(  50),
                           INT8_C(  11), INT8_C(  55), INT8_C(  39), INT8_C( -87),
                           INT8_C( 121), INT8_C( -10), INT8_C(  48), INT8_C( -27),
                           INT8_C(  35), INT8_C(  35), INT8_C( -52), INT8_C(  65),
                           INT8_C( -57), INT8_C(  52), INT8_C(-105), INT8_C( -52)),
      simde_mm256_set_epi8(INT8_C(  63), INT8_C(  76), INT8_C( -21), INT8_C( 103),
                           INT8_C( -99), INT8_C(  -8), INT8_C( -71), INT8_C(   6),
                           INT8_C( -27), INT8_C( 107), INT8_C(  23), INT8_C(  20),
                           INT8_C( -71), INT8_C(  77), INT8_C( 119), INT8_C(-117),
                           INT8_C( -71), INT8_C( 102), INT8_C( -10), INT8_C( -14),
                           INT8_C(  15), INT8_C( 106), INT8_C(  51), INT8_C( -90),
                           INT8_C(  49), INT8_C( -42), INT8_C(  99), INT8_C( -33),
                           INT8_C( 102), INT8_C( -69), INT8_C(  80), INT8_C(  28)),
      simde_mm256_set_epi8(INT8_C( -14), INT8_C( 103), INT8_C(-119), INT8_C( -73),
                           INT8_C(  50), INT8_C(   6), INT8_C(   4), INT8_C(  74),
                           INT8_C( 117), INT8_C(  -4), INT8_C(  -7), INT8_C(  29),
                           INT8_C(-111), INT8_C(  99), INT8_C( -38), INT8_C( -32),
                           INT8_C( -27), INT8_C( -78), INT8_C( -26), INT8_C( -23),
                           INT8_C( -57), INT8_C(  64), INT8_C( -37), INT8_C( -94),
                           INT8_C(  15), INT8_C(   1), INT8_C( 111), INT8_C(  90),
                           INT8_C(  79), INT8_C( -78), INT8_C(  97), INT8_C( 107)) },
    { simde_mm256_set_epi8(INT8_C( -28), INT8_C(  17), INT8_C( 126), INT8_C(  55),
                           INT8_C( -19), INT8_C(  71), INT8_C(  38), INT8_C(-110),
                           INT8_C( -94), INT8_C(  23), INT8_C( -88), INT8_C(  -8),
                           INT8_C(  30), INT8_C( -59), INT8_C(  51), INT8_C( -12),
                           INT8_C(   7), INT8_C(  81), INT8_C( -54), INT8_C(-116),
                           INT8_C( 110), INT8_C(-127), INT8_C(  83), INT8_C(  47),
                           INT8_C( -56), INT8_C(-107), INT8_C(  -7), INT8_C(  36),
                           INT8_C(  -9), INT8_C(   1), INT8_C(  85), INT8_C( -61)),
      UINT32_C(2266658865),
      simde_mm256_set_epi8(INT8_C(-105), INT8_C(  21), INT8_C( -18), INT8_C( 101),
                           INT8_C(-105), INT8_C( -48), INT8_C(  19), INT8_C(-120),
                           INT8_C(  94), INT8_C(-111), INT8_C(  11), INT8_C( -31),
                           INT8_C(-128), INT8_C(   1), INT8_C(-123), INT8_C(  66),
                           INT8_C( -20), INT8_C(  56), INT8_C(  74), INT8_C(  73),
                           INT8_C(  35), INT8_C(   7), INT8_C(  57), INT8_C( -59),
                           INT8_C( -71), INT8_C( -43), INT8_C(-119), INT8_C(  46),
                           INT8_C( -19), INT8_C(  31), INT8_C(  36), INT8_C( -80)),
      simde_mm256_set_epi8(INT8_C( -76), INT8_C(-126), INT8_C( -53), INT8_C( -83),
                           INT8_C( -23), INT8_C( 109), INT8_C(   7), INT8_C(  82),
                           INT8_C(  96), INT8_C(-118), INT8_C( -29), INT8_C(  25),
                           INT8_C( -59), INT8_C(  -4), INT8_C( -25), INT8_C(  10),
                           INT8_C( -95), INT8_C( -71), INT8_C(  70), INT8_C( -61),
                           INT8_C( -28), INT8_C(  74), INT8_C(  70), INT8_C(  59),
                           INT8_C(  -6), INT8_C( -54), INT8_C(  90), INT8_C( 108),
                           INT8_C( -12), INT8_C(  40), INT8_C(  67), INT8_C( -19)),
      simde_mm256_set_epi8(INT8_C( 100), INT8_C(  17), INT8_C( 126), INT8_C(  55),
                           INT8_C( -19), INT8_C(   3), INT8_C(  18), INT8_C(  10),
                           INT8_C( -94), INT8_C(  23), INT8_C( -88), INT8_C(  19),
                           INT8_C(  95), INT8_C( -59), INT8_C( 115), INT8_C( -12),
                           INT8_C(   7), INT8_C(-102), INT8_C(  27), INT8_C( 124),
                           INT8_C( -35), INT8_C(-127), INT8_C(  83), INT8_C(  47),
                           INT8_C( -56), INT8_C(-107), INT8_C( -43), INT8_C( -32),
                           INT8_C(  -9), INT8_C(   1), INT8_C(  85), INT8_C(  22)) },
    { simde_mm256_set_epi8(INT8_C( 121), INT8_C(  21), INT8_C(  69), INT8_C(  30),
                           INT8_C(  36), INT8_C( -84), INT8_C(  26), INT8_C( 107),
                           INT8_C( -75), INT8_C( -32), INT8_C(-100), INT8_C( 104),
                           INT8_C( -83), INT8_C(   7), INT8_C(  51), INT8_C( -62),
                           INT8_C(-102), INT8_C( 127), INT8_C( 113), INT8_C( 115),
                           INT8_C(  31), INT8_C(  20), INT8_C(  95), INT8_C(  34),
                           INT8_C(  38), INT8_C( 113), INT8_C( -51), INT8_C(  35),
                           INT8_C( -49), INT8_C(  20), INT8_C(  32), INT8_C(  74)),
      UINT32_C(1277011577),
      simde_mm256_set_epi8(INT8_C(  83), INT8_C(  99), INT8_C( -62), INT8_C( -33),
                           INT8_C(  15), INT8_C(  27), INT8_C(-106), INT8_C(  56),
                           INT8_C( -95), INT8_C( -68), INT8_C( -65), INT8_C(  63),
                           INT8_C( -44), INT8_C( -41), INT8_C( -55), INT8_C(  46),
                           INT8_C(  -5), INT8_C(  -8), INT8_C(  32), INT8_C( 101),
                           INT8_C(-121), INT8_C(  60), INT8_C(  -4), INT8_C(  40),
                           INT8_C(  49), INT8_C(-121), INT8_C( -33), INT8_C( -15),
                           INT8_C( 124), INT8_C( 101), INT8_C(  92), INT8_C(-104)),
      simde_mm256_set_epi8(INT8_C(  84), INT8_C( -52), INT8_C(  27), INT8_C( -95),
                           INT8_C( -59), INT8_C( -38), INT8_C(  72), INT8_C(  30),
                           INT8_C( -94), INT8_C( -39), INT8_C(  28), INT8_C(  17),
                           INT8_C(  32), INT8_C( -23), INT8_C( -32), INT8_C( 102),
                           INT8_C(  60), INT8_C(  10), INT8_C(-120), INT8_C( -82),
                           INT8_C( -91), INT8_C( -44), INT8_C(   8), INT8_C( -86),
                           INT8_C(  -4), INT8_C( -76), INT8_C(  74), INT8_C( -56),
                           INT8_C( -36), INT8_C( 121), INT8_C(-105), INT8_C( 109)),
      simde_mm256_set_epi8(INT8_C( 121), INT8_C( -22), INT8_C(  69), INT8_C(  30),
                           INT8_C( -28), INT8_C( -46), INT8_C(  26), INT8_C( 107),
                           INT8_C( -75), INT8_C( -32), INT8_C(-100), INT8_C( -33),
                           INT8_C(  34), INT8_C(-119), INT8_C(  51), INT8_C(  -5),
                           INT8_C(  88), INT8_C( 127), INT8_C( -80), INT8_C( 115),
                           INT8_C(  31), INT8_C( 103), INT8_C(  -5), INT8_C(  34),
                           INT8_C(  38), INT8_C(   5), INT8_C( 118), INT8_C(  -1),
                           INT8_C(  42), INT8_C(  20), INT8_C(  32), INT8_C( -68)) },
    { simde_mm256_set_epi8(INT8_C(-124), INT8_C( 103), INT8_C( -54), INT8_C( -95),
                           INT8_C( -17), INT8_C( -76), INT8_C(  88), INT8_C(-114),
                           INT8_C(   2), INT8_C( -31), INT8_C(-107), INT8_C(  94),
                           INT8_C( 104), INT8_C(  -6), INT8_C(  21), INT8_C(  36),
                           INT8_C( 121), INT8_C( -31), INT8_C(-109), INT8_C( -76),
                           INT8_C(  27), INT8_C( -91), INT8_C( -72), INT8_C(-121),
                           INT8_C( 100), INT8_C(  45), INT8_C( -84), INT8_C(  24),
                           INT8_C(  66), INT8_C( 120), INT8_C(  55), INT8_C(  85)),
      UINT32_C(3331867243),
      simde_mm256_set_epi8(INT8_C( -14), INT8_C(-126), INT8_C( -83), INT8_C(  96),
                           INT8_C( -66), INT8_C(  90), INT8_C( -90), INT8_C( -89),
                           INT8_C( -40), INT8_C( -65), INT8_C( 123), INT8_C( -41),
                           INT8_C( -49), INT8_C(  85), INT8_C(  43), INT8_C( -95),
                           INT8_C(   5), INT8_C( -81), INT8_C( 110), INT8_C( -86),
                           INT8_C(  44), INT8_C( -55), INT8_C( -28), INT8_C( -56),
                           INT8_C(  76), INT8_C( -15), INT8_C(-120), INT8_C( -25),
                           INT8_C(  79), INT8_C(  84), INT8_C(  15), INT8_C(  29)),
      simde_mm256_set_epi8(INT8_C( -17), INT8_C(  62), INT8_C(  30), INT8_C(  74),
                           INT8_C(  10), INT8_C(  78), INT8_C(  -4), INT8_C(  -8),
                           INT8_C(  -3), INT8_C(-107), INT8_C(   8), INT8_C(  87),
                           INT8_C(-103), INT8_C(  34), INT8_C(  54), INT8_C(  10),
                           INT8_C(  84), INT8_C(-128), INT8_C(-105), INT8_C( 112),
                           INT8_C( -50), INT8_C( -23), INT8_C( -84), INT8_C( -97),
                           INT8_C( -21), INT8_C( -52), INT8_C(  24), INT8_C( -62),
                           INT8_C( 125), INT8_C(-108), INT8_C( -58), INT8_C(  91)),
      simde_mm256_set_epi8(INT8_C(  59), INT8_C( -41), INT8_C( -54), INT8_C( -95),
                           INT8_C( -17), INT8_C( -58), INT8_C( 115), INT8_C(-114),
                           INT8_C(  -3), INT8_C( -31), INT8_C(-107), INT8_C( -48),
                           INT8_C(  30), INT8_C(  -6), INT8_C(  21), INT8_C(  36),
                           INT8_C( 121), INT8_C( -94), INT8_C(-109), INT8_C( -76),
                           INT8_C(  27), INT8_C( -91), INT8_C(  91), INT8_C(-121),
                           INT8_C( 100), INT8_C( -83), INT8_C( -43), INT8_C(  24),
                           INT8_C(  79), INT8_C( 120), INT8_C(-108), INT8_C( -23)) },
    { simde_mm256_set_epi8(INT8_C( -75), INT8_C(  81), INT8_C(  40), INT8_C( -29),
                           INT8_C(  -6), INT8_C( -70), INT8_C( -30), INT8_C( -15),
                           INT8_C(  74), INT8_C( -68), INT8_C( -59), INT8_C( -94),
                           INT8_C( 110), INT8_C( 112), INT8_C( -76), INT8_C( -57),
                           INT8_C(-115), INT8_C( -95), INT8_C( 123), INT8_C( -26),
                           INT8_C( -67), INT8_C( -55), INT8_C( 111), INT8_C(  39),
                           INT8_C(  74), INT8_C(  65), INT8_C(  50), INT8_C( -20),
                           INT8_C( -17), INT8_C(  24), INT8_C(  43), INT8_C(  11)),
      UINT32_C(2569613341),
      simde_mm256_set_epi8(INT8_C(  17), INT8_C( -34), INT8_C(  64), INT8_C(  47),
                           INT8_C(  37), INT8_C( -59), INT8_C(  63), INT8_C( -84),
                           INT8_C(  92), INT8_C(-115), INT8_C(-116), INT8_C( -81),
                           INT8_C(  37), INT8_C(-120), INT8_C( -30), INT8_C(   9),
                           INT8_C(  94), INT8_C(  16), INT8_C(   4), INT8_C(-128),
                           INT8_C(-108), INT8_C(-101), INT8_C(  -9), INT8_C(  51),
                           INT8_C(  65), INT8_C(  86), INT8_C( -18), INT8_C( -72),
                           INT8_C(  59), INT8_C(-108), INT8_C(-124), INT8_C( -72)),
      simde_mm256_set_epi8(INT8_C( -62), INT8_C( 100), INT8_C(  93), INT8_C( -47),
                           INT8_C( 119), INT8_C( -97), INT8_C(  60), INT8_C( -11),
                           INT8_C( -73), INT8_C(  49), INT8_C(-118), INT8_C(  27),
                           INT8_C( -43), INT8_C( -52), INT8_C(   6), INT8_C( 113),
                           INT8_C(  97), INT8_C( 119), INT8_C( -54), INT8_C( -41),
                           INT8_C(  46), INT8_C( -26), INT8_C(  13), INT8_C(-110),
                           INT8_C(  -4), INT8_C(  30), INT8_C(   9), INT8_C( 116),
                           INT8_C( -89), INT8_C(   7), INT8_C(  11), INT8_C(  83)),
      simde_mm256_set_epi8(INT8_C( 105), INT8_C(  81), INT8_C(  40), INT8_C( -28),
                           INT8_C( -79), INT8_C( -70), INT8_C( -30), INT8_C( -64),
                           INT8_C(  74), INT8_C( -68), INT8_C(  65), INT8_C( -94),
                           INT8_C(  64), INT8_C( 112), INT8_C( -76), INT8_C( -98),
                           INT8_C(-115), INT8_C( -95), INT8_C(  83), INT8_C(-123),
                           INT8_C( -67), INT8_C( -55), INT8_C( 111), INT8_C(  39),
                           INT8_C(  74), INT8_C(  65), INT8_C(  50), INT8_C( -19),
                           INT8_C(  -6), INT8_C(-120), INT8_C(  43), INT8_C( -19)) },
    { simde_mm256_set_epi8(INT8_C( -10), INT8_C(  41), INT8_C( -97), INT8_C(-113),
                           INT8_C(  11), INT8_C(-128), INT8_C( -95), INT8_C(-126),
                           INT8_C(  71), INT8_C(  54), INT8_C(  41), INT8_C(  29),
                           INT8_C(  68), INT8_C( -53), INT8_C( -78), INT8_C( 122),
                           INT8_C(-110), INT8_C(-109), INT8_C( -52), INT8_C( -84),
                           INT8_C(  98), INT8_C( -88), INT8_C(-117), INT8_C(   7),
                           INT8_C(-106), INT8_C( -20), INT8_C(  29), INT8_C(  -5),
                           INT8_C( -21), INT8_C( 109), INT8_C( -97), INT8_C( -60)),
      UINT32_C(3674607040),
      simde_mm256_set_epi8(INT8_C(  51), INT8_C(  98), INT8_C(-100), INT8_C(   4),
                           INT8_C( -58), INT8_C( 111), INT8_C( 124), INT8_C( -27),
                           INT8_C( -60), INT8_C( -35), INT8_C(  13), INT8_C( -18),
                           INT8_C(  -5), INT8_C(   9), INT8_C(  15), INT8_C(  46),
                           INT8_C(-105), INT8_C( -55), INT8_C( 100), INT8_C(   4),
                           INT8_C(  11), INT8_C(-115), INT8_C(  82), INT8_C(  -5),
                           INT8_C(  51), INT8_C( 124), INT8_C( -80), INT8_C(  29),
                           INT8_C( -61), INT8_C( 111), INT8_C(-115), INT8_C(-123)),
      simde_mm256_set_epi8(INT8_C( -91), INT8_C( -60), INT8_C(  62), INT8_C(  -1),
                           INT8_C(  19), INT8_C(  32), INT8_C( 116), INT8_C(  35),
                           INT8_C(-124), INT8_C(  15), INT8_C(-113), INT8_C(-125),
                           INT8_C( -98), INT8_C( 113), INT8_C(  93), INT8_C(  23),
                           INT8_C( 127), INT8_C(-118), INT8_C(  21), INT8_C(  52),
                           INT8_C(-111), INT8_C( 102), INT8_C(  71), INT8_C( -75),
                           INT8_C( 102), INT8_C(  66), INT8_C( -33), INT8_C( -93),
                           INT8_C( -36), INT8_C(  -6), INT8_C(  49), INT8_C(   6)),
      simde_mm256_set_epi8(INT8_C( -99), INT8_C(  18), INT8_C( -97), INT8_C( 102),
                           INT8_C( -69), INT8_C(-128), INT8_C(-111), INT8_C(  83),
                           INT8_C(  71), INT8_C(  54), INT8_C(  41), INT8_C(  29),
                           INT8_C(  68), INT8_C(-111), INT8_C( -40), INT8_C( 122),
                           INT8_C(-110), INT8_C(-109), INT8_C( -52), INT8_C( -84),
                           INT8_C(-100), INT8_C(-128), INT8_C(-117), INT8_C(  91),
                           INT8_C( -41), INT8_C( -94), INT8_C(  29), INT8_C(  -5),
                           INT8_C( -21), INT8_C( 109), INT8_C( -97), INT8_C( -60)) },
    { simde_mm256_set_epi8(INT8_C( -90), INT8_C( -71), INT8_C(  70), INT8_C(-109),
                           INT8_C( -13), INT8_C(  98), INT8_C( 125), INT8_C( 124),
                           INT8_C( -61), INT8_C( -67), INT8_C(   5), INT8_C( -92),
                           INT8_C(  29), INT8_C(  -5), INT8_C(  71), INT8_C(  99),
                           INT8_C(  21), INT8_C( -93), INT8_C(  49), INT8_C( -93),
                           INT8_C(  15), INT8_C(  16), INT8_C(  34), INT8_C( -44),
                           INT8_C( -31), INT8_C(  58), INT8_C(  81), INT8_C( -54),
                           INT8_C( -62), INT8_C( -59), INT8_C(  87), INT8_C( -96)),
      UINT32_C(2409021262),
      simde_mm256_set_epi8(INT8_C( -63), INT8_C(  90), INT8_C( 104), INT8_C( -31),
                           INT8_C(  15), INT8_C(  24), INT8_C( -61), INT8_C(  -4),
                           INT8_C( -78), INT8_C(  93), INT8_C(-127), INT8_C( 105),
                           INT8_C(  32), INT8_C(  40), INT8_C( 120), INT8_C( -39),
                           INT8_C( 125), INT8_C( -19), INT8_C( -33), INT8_C(  93),
                           INT8_C(  67), INT8_C(  66), INT8_C( -76), INT8_C( -84),
                           INT8_C(  35), INT8_C( 117), INT8_C( -99), INT8_C(  91),
                           INT8_C(  -5), INT8_C(  18), INT8_C( -73), INT8_C(  54)),
      simde_mm256_set_epi8(INT8_C(  79), INT8_C( -59), INT8_C( -96), INT8_C(  42),
                           INT8_C( -10), INT8_C(  69), INT8_C( -63), INT8_C(  86),
                           INT8_C(  88), INT8_C(  57), INT8_C( -72), INT8_C( 125),
                           INT8_C(  32), INT8_C( -66), INT8_C( -47), INT8_C( -11),
                           INT8_C(  63), INT8_C(  94), INT8_C(-107), INT8_C(  -5),
                           INT8_C(  -1), INT8_C(  -3), INT8_C( -12), INT8_C( 101),
                           INT8_C(  -3), INT8_C(-119), INT8_C( -62), INT8_C(  38),
                           INT8_C(  42), INT8_C(-111), INT8_C( -85), INT8_C(  30)),
      simde_mm256_set_epi8(INT8_C( -17), INT8_C( -71), INT8_C(  70), INT8_C(-109),
                           INT8_C( 105), INT8_C( -80), INT8_C( 118), INT8_C( -70),
                           INT8_C( -68), INT8_C( -67), INT8_C(   5), INT8_C( -69),
                           INT8_C(  29), INT8_C( -72), INT8_C( -98), INT8_C(  99),
                           INT8_C(  36), INT8_C( -93), INT8_C( -70), INT8_C( -35),
                           INT8_C( 117), INT8_C( -56), INT8_C(  36), INT8_C(  96),
                           INT8_C( -31), INT8_C(  62), INT8_C(  81), INT8_C( -54),
                           INT8_C( -33), INT8_C(  84), INT8_C(-128), INT8_C( -96)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_mask_gf2p8affine_epi64_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C(  41));
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i x;
    simde__m512i A;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -38), INT8_C( -31), INT8_C( -26), INT8_C(-115),
                           INT8_C(-118), INT8_C(   4), INT8_C( -21), INT8_C(  76),
                           INT8_C( -18), INT8_C(  56), INT8_C( -33), INT8_C(   5),
                           INT8_C( -31), INT8_C(  37), INT8_C(  43), INT8_C( -26),
                           INT8_C( -84), INT8_C(  85), INT8_C(  28), INT8_C( -96),
                           INT8_C( -54), INT8_C(  79), INT8_C(  16), INT8_C( 119),
                           INT8_C(   3), INT8_C( -64), INT8_C(  77), INT8_C( -56),
                           INT8_C(-127), INT8_C( -33), INT8_C(  83), INT8_C(  46),
                           INT8_C( -91), INT8_C( 125), INT8_C( -59), INT8_C( -28),
                           INT8_C(-110), INT8_C(  94), INT8_C(  67), INT8_C(  64),
                           INT8_C( -85), INT8_C( 127), INT8_C( -76), INT8_C(-117),
                           INT8_C(  37), INT8_C(-123), INT8_C(  21), INT8_C(  31),
                           INT8_C( -53), INT8_C( 109), INT8_C( -72), INT8_C(  -6),
                           INT8_C( 112), INT8_C(  75), INT8_C( -92), INT8_C(  12),
                           INT8_C(  98), INT8_C( -63), INT8_C(  64), INT8_C( -41),
                           INT8_C(  43), INT8_C( -55), INT8_C( -46), INT8_C(  88)),
      UINT64_C( 8484844130360497323),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C(  79), INT8_C(  79), INT8_C( -73),
                           INT8_C(  50), INT8_C( -99), INT8_C( -73), INT8_C(  74),
                           INT8_C( 117), INT8_C(  -4), INT8_C(  -7), INT8_C(  29),
                           INT8_C(-111), INT8_C( 111), INT8_C( -38), INT8_C( -85),
                           INT8_C( -27), INT8_C( 107), INT8_C( -26), INT8_C( -23),
                           INT8_C( -57), INT8_C( 127), INT8_C( -37), INT8_C( 116),
                           INT8_C(  96), INT8_C(   1), INT8_C( 107), INT8_C(   0),
                           INT8_C(  79), INT8_C( -78), INT8_C(  84), INT8_C( 107),
                           INT8_C(  99), INT8_C(  90), INT8_C( 101), INT8_C( -53),
                           INT8_C(  26), INT8_C( 105), INT8_C( -25), INT8_C(  22),
                           INT8_C( 122), INT8_C( -86), INT8_C( 110), INT8_C( -49),
                           INT8_C( -67), INT8_C(  44), INT8_C( -99), INT8_C(-105),
                           INT8_C(  48), INT8_C( 110), INT8_C( -78), INT8_C(  59),
                           INT8_C(-113), INT8_C(-109), INT8_C(  95), INT8_C( -41),
                           INT8_C( -26), INT8_C(  72), INT8_C(  78), INT8_C(  30),
                           INT8_C(  13), INT8_C(   4), INT8_C(  90), INT8_C(  65)),
      simde_mm512_set_epi8(INT8_C( -27), INT8_C( 107), INT8_C(  23), INT8_C(  20),
                           INT8_C( -71), INT8_C(  77), INT8_C( 119), INT8_C(-117),
                           INT8_C( -71), INT8_C( 102), INT8_C( -10), INT8_C( -14),
                           INT8_C(  15), INT8_C( 106), INT8_C(  51), INT8_C( -90),
                           INT8_C(  49), INT8_C( -42), INT8_C(  99), INT8_C( -33),
                           INT8_C( 102), INT8_C( -69), INT8_C(  80), INT8_C(  28),
                           INT8_C( -57), INT8_C(-105), INT8_C( -54), INT8_C(  29),
                           INT8_C( 127), INT8_C(-103), INT8_C( -56), INT8_C(  -9),
                           INT8_C(  36), INT8_C( -42), INT8_C( 126), INT8_C(  34),
                           INT8_C( 123), INT8_C(  57), INT8_C(  98), INT8_C(  50),
                           INT8_C(  11), INT8_C(  55), INT8_C(  39), INT8_C( -87),
                           INT8_C( 121), INT8_C( -10), INT8_C(  48), INT8_C( -27),
                           INT8_C(  35), INT8_C(  35), INT8_C( -52), INT8_C(  65),
                           INT8_C( -57), INT8_C(  52), INT8_C(-105), INT8_C( -52),
                           INT8_C(  -3), INT8_C( -72), INT8_C(  12), INT8_C( -81),
                           INT8_C( 102), INT8_C(   5), INT8_C(  69), INT8_C( -78)),
      simde_mm512_set_epi8(INT8_C( -38), INT8_C( -91), INT8_C( -91), INT8_C( -22),
                           INT8_C(-118), INT8_C( -51), INT8_C( -21), INT8_C(  63),
                           INT8_C(  99), INT8_C(-114), INT8_C( -33), INT8_C(   5),
                           INT8_C( -31), INT8_C(  37), INT8_C(  43), INT8_C( -26),
                           INT8_C( -84), INT8_C(  85), INT8_C( -51), INT8_C( -20),
                           INT8_C( -43), INT8_C(  79), INT8_C(  16), INT8_C( 119),
                           INT8_C( 109), INT8_C(-109), INT8_C(  77), INT8_C( -56),
                           INT8_C(  54), INT8_C( -33), INT8_C(  83), INT8_C(  46),
                           INT8_C( -91), INT8_C( 125), INT8_C( -76), INT8_C( -28),
                           INT8_C( 116), INT8_C(-121), INT8_C(  67), INT8_C(  64),
                           INT8_C(  42), INT8_C( 127), INT8_C(  -2), INT8_C(  55),
                           INT8_C(  37), INT8_C(-123), INT8_C( -46), INT8_C(  31),
                           INT8_C( -53), INT8_C( 109), INT8_C( -72), INT8_C( -25),
                           INT8_C( 112), INT8_C(-108), INT8_C( -92), INT8_C(  12),
                           INT8_C(-116), INT8_C( -63), INT8_C(-109), INT8_C( -41),
                           INT8_C(  51), INT8_C( -55), INT8_C( 109), INT8_C(  16)) },
    { simde_mm512_set_epi8(INT8_C( -20), INT8_C(  56), INT8_C(  74), INT8_C(  73),
                           INT8_C(  35), INT8_C(   7), INT8_C(  57), INT8_C( -59),
                           INT8_C( -71), INT8_C( -43), INT8_C(-119), INT8_C(  46),
                           INT8_C( -19), INT8_C(  31), INT8_C(  36), INT8_C( -80),
                           INT8_C( -97), INT8_C(  23), INT8_C(  98), INT8_C(  40),
                           INT8_C(-121), INT8_C(  26), INT8_C( 120), INT8_C(  49),
                           INT8_C( -28), INT8_C(  17), INT8_C( 126), INT8_C(  55),
                           INT8_C( -19), INT8_C(  71), INT8_C(  38), INT8_C(-110),
                           INT8_C( -94), INT8_C(  23), INT8_C( -88), INT8_C(  -8),
                           INT8_C(  30), INT8_C( -59), INT8_C(  51), INT8_C( -12),
                           INT8_C(   7), INT8_C(  81), INT8_C( -54), INT8_C(-116),
                           INT8_C( 110), INT8_C(-127), INT8_C(  83), INT8_C(  47),
                           INT8_C( -56), INT8_C(-107), INT8_C(  -7), INT8_C(  36),
                           INT8_C(  -9), INT8_C(   1), INT8_C(  85), INT8_C( -61),
                           INT8_C(  63), INT8_C(  76), INT8_C( -21), INT8_C( 103),
                           INT8_C( -99), INT8_C(  -8), INT8_C( -71), INT8_C(   6)),
      UINT64_C( 6814240774331401538),
      simde_mm512_set_epi8(INT8_C( -75), INT8_C( -32), INT8_C(-100), INT8_C( 104),
                           INT8_C( -83), INT8_C(   7), INT8_C(  51), INT8_C( -62),
                           INT8_C(-102), INT8_C( 127), INT8_C( 113), INT8_C( 115),
                           INT8_C(  31), INT8_C(  20), INT8_C(  95), INT8_C(  34),
                           INT8_C(  38), INT8_C( 113), INT8_C( -51), INT8_C(  35),
                           INT8_C( -49), INT8_C(  20), INT8_C(  32), INT8_C(  74),
                           INT8_C( -76), INT8_C(-126), INT8_C( -53), INT8_C( -83),
                           INT8_C( -23), INT8_C( 109), INT8_C(   7), INT8_C(  82),
                           INT8_C(  96), INT8_C(-118), INT8_C( -29), INT8_C(  25),
                           INT8_C( -59), INT8_C(  -4), INT8_C( -25), INT8_C(  10),
                           INT8_C( -95), INT8_C( -71), INT8_C(  70), INT8_C( -61),
                           INT8_C( -28), INT8_C(  74), INT8_C(  70), INT8_C(  59),
                           INT8_C(  -6), INT8_C( -54), INT8_C(  90), INT8_C( 108),
                           INT8_C( -12), INT8_C(  40), INT8_C(  67), INT8_C( -19),
                           INT8_C(-105), INT8_C(  21), INT8_C( -18), INT8_C( 101),
                           INT8_C(-105), INT8_C( -48), INT8_C(  19), INT8_C(-120)),
      simde_mm512_set_epi8(INT8_C(  60), INT8_C(  10), INT8_C(-120), INT8_C( -82),
                           INT8_C( -91), INT8_C( -44), INT8_C(   8), INT8_C( -86),
                           INT8_C(  -4), INT8_C( -76), INT8_C(  74), INT8_C( -56),
                           INT8_C( -36), INT8_C( 121), INT8_C(-105), INT8_C( 109),
                           INT8_C(  83), INT8_C(  99), INT8_C( -62), INT8_C( -33),
                           INT8_C(  15), INT8_C(  27), INT8_C(-106), INT8_C(  56),
                           INT8_C( -95), INT8_C( -68), INT8_C( -65), INT8_C(  63),
                           INT8_C( -44), INT8_C( -41), INT8_C( -55), INT8_C(  46),
                           INT8_C(  -5), INT8_C(  -8), INT8_C(  32), INT8_C( 101),
                           INT8_C(-121), INT8_C(  60), INT8_C(  -4), INT8_C(  40),
                           INT8_C(  49), INT8_C(-121), INT8_C( -33), INT8_C( -15),
                           INT8_C( 124), INT8_C( 101), INT8_C(  92), INT8_C(-104),
                           INT8_C(  17), INT8_C( 122), INT8_C(  -7), INT8_C( -75),
                           INT8_C(  76), INT8_C(  29), INT8_C( -90), INT8_C( 121),
                           INT8_C( 121), INT8_C(  21), INT8_C(  69), INT8_C(  30),
                           INT8_C(  36), INT8_C( -84), INT8_C(  26), INT8_C( 107)),
      simde_mm512_set_epi8(INT8_C( -20), INT8_C(  45), INT8_C(  74), INT8_C(  94),
                           INT8_C( -21), INT8_C(-117), INT8_C(  10), INT8_C( -59),
                           INT8_C(  -7), INT8_C( -43), INT8_C(-119), INT8_C( -31),
                           INT8_C( -19), INT8_C(  31), INT8_C(  36), INT8_C( -49),
                           INT8_C( -97), INT8_C(  23), INT8_C(  98), INT8_C(  40),
                           INT8_C( -49), INT8_C(  26), INT8_C( -86), INT8_C( -32),
                           INT8_C(  80), INT8_C( -13), INT8_C(  32), INT8_C(  55),
                           INT8_C( -19), INT8_C(  71), INT8_C(  38), INT8_C( -54),
                           INT8_C(-116), INT8_C(  23), INT8_C( -88), INT8_C(  -8),
                           INT8_C(  30), INT8_C( -59), INT8_C(  51), INT8_C( -12),
                           INT8_C(   7), INT8_C(  81), INT8_C( -54), INT8_C(-116),
                           INT8_C( 110), INT8_C(-127), INT8_C(  83), INT8_C(  49),
                           INT8_C( 103), INT8_C(-107), INT8_C(  -7), INT8_C(  36),
                           INT8_C(  -9), INT8_C(  80), INT8_C(  85), INT8_C(  95),
                           INT8_C(  63), INT8_C( -38), INT8_C( -21), INT8_C( 103),
                           INT8_C( -99), INT8_C(  -8), INT8_C(  44), INT8_C(   6)) },
    { simde_mm512_set_epi8(INT8_C(  76), INT8_C( -15), INT8_C(-120), INT8_C( -25),
                           INT8_C(  79), INT8_C(  84), INT8_C(  15), INT8_C(  29),
                           INT8_C( 123), INT8_C(  56), INT8_C(  84), INT8_C(   4),
                           INT8_C( -58), INT8_C(-104), INT8_C(  66), INT8_C( 107),
                           INT8_C(-124), INT8_C( 103), INT8_C( -54), INT8_C( -95),
                           INT8_C( -17), INT8_C( -76), INT8_C(  88), INT8_C(-114),
                           INT8_C(   2), INT8_C( -31), INT8_C(-107), INT8_C(  94),
                           INT8_C( 104), INT8_C(  -6), INT8_C(  21), INT8_C(  36),
                           INT8_C( 121), INT8_C( -31), INT8_C(-109), INT8_C( -76),
                           INT8_C(  27), INT8_C( -91), INT8_C( -72), INT8_C(-121),
                           INT8_C( 100), INT8_C(  45), INT8_C( -84), INT8_C(  24),
                           INT8_C(  66), INT8_C( 120), INT8_C(  55), INT8_C(  85),
                           INT8_C(  84), INT8_C( -52), INT8_C(  27), INT8_C( -95),
                           INT8_C( -59), INT8_C( -38), INT8_C(  72), INT8_C(  30),
                           INT8_C( -94), INT8_C( -39), INT8_C(  28), INT8_C(  17),
                           INT8_C(  32), INT8_C( -23), INT8_C( -32), INT8_C( 102)),
      UINT64_C(  409667768288928968),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C( -95), INT8_C( 123), INT8_C( -26),
                           INT8_C( -67), INT8_C( -55), INT8_C( 111), INT8_C(  39),
                           INT8_C(  74), INT8_C(  65), INT8_C(  50), INT8_C( -20),
                           INT8_C( -17), INT8_C(  24), INT8_C(  43), INT8_C(  11),
                           INT8_C( -17), INT8_C(  62), INT8_C(  30), INT8_C(  74),
                           INT8_C(  10), INT8_C(  78), INT8_C(  -4), INT8_C(  -8),
                           INT8_C(  -3), INT8_C(-107), INT8_C(   8), INT8_C(  87),
                           INT8_C(-103), INT8_C(  34), INT8_C(  54), INT8_C(  10),
                           INT8_C(  84), INT8_C(-128), INT8_C(-105), INT8_C( 112),
                           INT8_C( -50), INT8_C( -23), INT8_C( -84), INT8_C( -97),
                           INT8_C( -21), INT8_C( -52), INT8_C(  24), INT8_C( -62),
                           INT8_C( 125), INT8_C(-108), INT8_C( -58), INT8_C(  91),
                           INT8_C( -14), INT8_C(-126), INT8_C( -83), INT8_C(  96),
                           INT8_C( -66), INT8_C(  90), INT8_C( -90), INT8_C( -89),
                           INT8_C( -40), INT8_C( -65), INT8_C( 123), INT8_C( -41),
                           INT8_C( -49), INT8_C(  85), INT8_C(  43), INT8_C( -95)),
      simde_mm512_set_epi8(INT8_C(  -4), INT8_C(  30), INT8_C(   9), INT8_C( 116),
                           INT8_C( -89), INT8_C(   7), INT8_C(  11), INT8_C(  83),
                           INT8_C(  17), INT8_C( -34), INT8_C(  64), INT8_C(  47),
                           INT8_C(  37), INT8_C( -59), INT8_C(  63), INT8_C( -84),
                           INT8_C(  92), INT8_C(-115), INT8_C(-116), INT8_C( -81),
                           INT8_C(  37), INT8_C(-120), INT8_C( -30), INT8_C(   9),
                           INT8_C(  94), INT8_C(  16), INT8_C(   4), INT8_C(-128),
                           INT8_C(-108), INT8_C(-101), INT8_C(  -9), INT8_C(  51),
                           INT8_C(  65), INT8_C(  86), INT8_C( -18), INT8_C( -72),
                           INT8_C(  59), INT8_C(-108), INT8_C(-124), INT8_C( -72),
                           INT8_C( -39), INT8_C( -73), INT8_C(  42), INT8_C(   8),
                           INT8_C(-103), INT8_C(  41), INT8_C(  48), INT8_C(  29),
                           INT8_C( -75), INT8_C(  81), INT8_C(  40), INT8_C( -29),
                           INT8_C(  -6), INT8_C( -70), INT8_C( -30), INT8_C( -15),
                           INT8_C(  74), INT8_C( -68), INT8_C( -59), INT8_C( -94),
                           INT8_C( 110), INT8_C( 112), INT8_C( -76), INT8_C( -57)),
      simde_mm512_set_epi8(INT8_C(  76), INT8_C( -15), INT8_C(-120), INT8_C( -25),
                           INT8_C(  79), INT8_C(   3), INT8_C(  15), INT8_C(  12),
                           INT8_C(-114), INT8_C(  56), INT8_C(  -7), INT8_C(   4),
                           INT8_C( 119), INT8_C( -95), INT8_C(   9), INT8_C( -47),
                           INT8_C(-124), INT8_C(-119), INT8_C( -47), INT8_C( -95),
                           INT8_C( -49), INT8_C(-111), INT8_C( -18), INT8_C(-114),
                           INT8_C( -74), INT8_C( -31), INT8_C(   9), INT8_C(  94),
                           INT8_C(  98), INT8_C(  -6), INT8_C( -81), INT8_C(  36),
                           INT8_C( 121), INT8_C( -31), INT8_C(  31), INT8_C( -76),
                           INT8_C(  47), INT8_C( -46), INT8_C( -72), INT8_C(-121),
                           INT8_C(  84), INT8_C(   5), INT8_C( -84), INT8_C(  24),
                           INT8_C(  16), INT8_C( 120), INT8_C(  55), INT8_C( -14),
                           INT8_C(  61), INT8_C( -87), INT8_C(-110), INT8_C( -95),
                           INT8_C( -59), INT8_C(  13), INT8_C(  72), INT8_C(  30),
                           INT8_C(  34), INT8_C(  38), INT8_C(  28), INT8_C(  17),
                           INT8_C(-117), INT8_C( -23), INT8_C( -32), INT8_C( 102)) },
    { simde_mm512_set_epi8(INT8_C( -11), INT8_C(  39), INT8_C(  -6), INT8_C(  77),
                           INT8_C( -37), INT8_C(   6), INT8_C(  13), INT8_C( -64),
                           INT8_C( -10), INT8_C(  41), INT8_C( -97), INT8_C(-113),
                           INT8_C(  11), INT8_C(-128), INT8_C( -95), INT8_C(-126),
                           INT8_C(  71), INT8_C(  54), INT8_C(  41), INT8_C(  29),
                           INT8_C(  68), INT8_C( -53), INT8_C( -78), INT8_C( 122),
                           INT8_C(-110), INT8_C(-109), INT8_C( -52), INT8_C( -84),
                           INT8_C(  98), INT8_C( -88), INT8_C(-117), INT8_C(   7),
                           INT8_C(-106), INT8_C( -20), INT8_C(  29), INT8_C(  -5),
                           INT8_C( -21), INT8_C( 109), INT8_C( -97), INT8_C( -60),
                           INT8_C( -62), INT8_C( 100), INT8_C(  93), INT8_C( -47),
                           INT8_C( 119), INT8_C( -97), INT8_C(  60), INT8_C( -11),
                           INT8_C( -73), INT8_C(  49), INT8_C(-118), INT8_C(  27),
                           INT8_C( -43), INT8_C( -52), INT8_C(   6), INT8_C( 113),
                           INT8_C(  97), INT8_C( 119), INT8_C( -54), INT8_C( -41),
                           INT8_C(  46), INT8_C( -26), INT8_C(  13), INT8_C(-110)),
      UINT64_C( 3710033834925854085),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C(  58), INT8_C(  81), INT8_C( -54),
                           INT8_C( -62), INT8_C( -59), INT8_C(  87), INT8_C( -96),
                           INT8_C( -91), INT8_C( -60), INT8_C(  62), INT8_C(  -1),
                           INT8_C(  19), INT8_C(  32), INT8_C( 116), INT8_C(  35),
                           INT8_C(-124), INT8_C(  15), INT8_C(-113), INT8_C(-125),
                           INT8_C( -98), INT8_C( 113), INT8_C(  93), INT8_C(  23),
                           INT8_C( 127), INT8_C(-118), INT8_C(  21), INT8_C(  52),
                           INT8_C(-111), INT8_C( 102), INT8_C(  71), INT8_C( -75),
                           INT8_C( 102), INT8_C(  66), INT8_C( -33), INT8_C( -93),
                           INT8_C( -36), INT8_C(  -6), INT8_C(  49), INT8_C(   6),
                           INT8_C(  51), INT8_C(  98), INT8_C(-100), INT8_C(   4),
                           INT8_C( -58), INT8_C( 111), INT8_C( 124), INT8_C( -27),
                           INT8_C( -60), INT8_C( -35), INT8_C(  13), INT8_C( -18),
                           INT8_C(  -5), INT8_C(   9), INT8_C(  15), INT8_C(  46),
                           INT8_C(-105), INT8_C( -55), INT8_C( 100), INT8_C(   4),
                           INT8_C(  11), INT8_C(-115), INT8_C(  82), INT8_C(  -5)),
      simde_mm512_set_epi8(INT8_C( -63), INT8_C(  90), INT8_C( 104), INT8_C( -31),
                           INT8_C(  15), INT8_C(  24), INT8_C( -61), INT8_C(  -4),
                           INT8_C( -78), INT8_C(  93), INT8_C(-127), INT8_C( 105),
                           INT8_C(  32), INT8_C(  40), INT8_C( 120), INT8_C( -39),
                           INT8_C( 125), INT8_C( -19), INT8_C( -33), INT8_C(  93),
                           INT8_C(  67), INT8_C(  66), INT8_C( -76), INT8_C( -84),
                           INT8_C(  35), INT8_C( 117), INT8_C( -99), INT8_C(  91),
                           INT8_C(  -5), INT8_C(  18), INT8_C( -73), INT8_C(  54),
                           INT8_C( -20), INT8_C(  57), INT8_C( -83), INT8_C( -25),
                           INT8_C(-113), INT8_C(-106), INT8_C( -65), INT8_C(  78),
                           INT8_C( -90), INT8_C( -71), INT8_C(  70), INT8_C(-109),
                           INT8_C( -13), INT8_C(  98), INT8_C( 125), INT8_C( 124),
                           INT8_C( -61), INT8_C( -67), INT8_C(   5), INT8_C( -92),
                           INT8_C(  29), INT8_C(  -5), INT8_C(  71), INT8_C(  99),
                           INT8_C(  21), INT8_C( -93), INT8_C(  49), INT8_C( -93),
                           INT8_C(  15), INT8_C(  16), INT8_C(  34), INT8_C( -44)),
      simde_mm512_set_epi8(INT8_C( -11), INT8_C(  39), INT8_C(  28), INT8_C( -54),
                           INT8_C( -37), INT8_C(   6), INT8_C( -34), INT8_C( 109),
                           INT8_C( -10), INT8_C( 101), INT8_C( 123), INT8_C( -70),
                           INT8_C( 100), INT8_C(  81), INT8_C( -95), INT8_C(-126),
                           INT8_C(  33), INT8_C(  54), INT8_C(-123), INT8_C( -59),
                           INT8_C(  68), INT8_C( -53), INT8_C( -78), INT8_C( 122),
                           INT8_C(-110), INT8_C(-109), INT8_C( -52), INT8_C( -61),
                           INT8_C( -35), INT8_C( -34), INT8_C(-117), INT8_C( -56),
                           INT8_C( -21), INT8_C(  89), INT8_C(  29), INT8_C(  -5),
                           INT8_C( -21), INT8_C( 109), INT8_C(  91), INT8_C(  45),
                           INT8_C( -62), INT8_C(  18), INT8_C( -18), INT8_C( -47),
                           INT8_C(  63), INT8_C(  79), INT8_C( -14), INT8_C( -85),
                           INT8_C( -68), INT8_C(  49), INT8_C(-118), INT8_C(  27),
                           INT8_C(  94), INT8_C( -19), INT8_C(   6), INT8_C(  15),
                           INT8_C( -45), INT8_C( 119), INT8_C( -54), INT8_C( -41),
                           INT8_C(  46), INT8_C(  60), INT8_C(  13), INT8_C(-100)) },
    { simde_mm512_set_epi8(INT8_C( -69), INT8_C( -81), INT8_C(-105), INT8_C( -85),
                           INT8_C( -82), INT8_C( 108), INT8_C(-118), INT8_C( 109),
                           INT8_C( 112), INT8_C(-112), INT8_C( -34), INT8_C(  -5),
                           INT8_C( -77), INT8_C(-118), INT8_C( -13), INT8_C(  64),
                           INT8_C( 122), INT8_C(-122), INT8_C(  12), INT8_C(-116),
                           INT8_C(-107), INT8_C( -96), INT8_C(  15), INT8_C( -28),
                           INT8_C( -78), INT8_C( 119), INT8_C(   1), INT8_C(  -6),
                           INT8_C(-124), INT8_C( 118), INT8_C(  59), INT8_C( -58),
                           INT8_C(  79), INT8_C( -59), INT8_C( -96), INT8_C(  42),
                           INT8_C( -10), INT8_C(  69), INT8_C( -63), INT8_C(  86),
                           INT8_C(  88), INT8_C(  57), INT8_C( -72), INT8_C( 125),
                           INT8_C(  32), INT8_C( -66), INT8_C( -47), INT8_C( -11),
                           INT8_C(  63), INT8_C(  94), INT8_C(-107), INT8_C(  -5),
                           INT8_C(  -1), INT8_C(  -3), INT8_C( -12), INT8_C( 101),
                           INT8_C(  -3), INT8_C(-119), INT8_C( -62), INT8_C(  38),
                           INT8_C(  42), INT8_C(-111), INT8_C( -85), INT8_C(  30)),
      UINT64_C(13505615964757104331),
      simde_mm512_set_epi8(INT8_C( 119), INT8_C( -26), INT8_C( -34), INT8_C( -29),
                           INT8_C(  61), INT8_C( -97), INT8_C( 121), INT8_C( -50),
                           INT8_C( 115), INT8_C(  70), INT8_C(-126), INT8_C(  82),
                           INT8_C(  49), INT8_C( -85), INT8_C( -85), INT8_C(  63),
                           INT8_C( -92), INT8_C(  55), INT8_C(  97), INT8_C(  48),
                           INT8_C(  61), INT8_C(  17), INT8_C(  44), INT8_C(  43),
                           INT8_C(  34), INT8_C(  28), INT8_C( -52), INT8_C( 105),
                           INT8_C(   4), INT8_C(  65), INT8_C( -75), INT8_C(  34),
                           INT8_C(  39), INT8_C( 110), INT8_C(  14), INT8_C(  27),
                           INT8_C( -36), INT8_C( -59), INT8_C( -76), INT8_C(  54),
                           INT8_C(  38), INT8_C( -22), INT8_C( -75), INT8_C( -86),
                           INT8_C( -68), INT8_C(  73), INT8_C( -18), INT8_C( -72),
                           INT8_C( -76), INT8_C( -29), INT8_C(-118), INT8_C(  60),
                           INT8_C(  27), INT8_C( 123), INT8_C(  54), INT8_C(-106),
                           INT8_C( -24), INT8_C(-112), INT8_C( -63), INT8_C(   6),
                           INT8_C(  30), INT8_C( -40), INT8_C(  40), INT8_C(-118)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C(  59), INT8_C(  -7), INT8_C( -57),
                           INT8_C( -54), INT8_C( -24), INT8_C(-127), INT8_C(  28),
                           INT8_C(  72), INT8_C(  65), INT8_C( -12), INT8_C( -17),
                           INT8_C(-122), INT8_C(  99), INT8_C( -39), INT8_C( -66),
                           INT8_C(-112), INT8_C( 104), INT8_C(  -8), INT8_C(-107),
                           INT8_C( 107), INT8_C( -79), INT8_C( -16), INT8_C(   2),
                           INT8_C(  85), INT8_C( -99), INT8_C( -15), INT8_C(  35),
                           INT8_C(-123), INT8_C( -63), INT8_C( -50), INT8_C(  41),
                           INT8_C(  40), INT8_C( -15), INT8_C( -56), INT8_C(  80),
                           INT8_C( -27), INT8_C( -56), INT8_C(  15), INT8_C(  83),
                           INT8_C( -33), INT8_C(  -5), INT8_C(  78), INT8_C(  31),
                           INT8_C( -93), INT8_C(-105), INT8_C(  63), INT8_C(   3),
                           INT8_C( -15), INT8_C(  48), INT8_C(-120), INT8_C( -78),
                           INT8_C(  93), INT8_C(  78), INT8_C(-110), INT8_C(   1),
                           INT8_C( -12), INT8_C(  47), INT8_C(  72), INT8_C(  51),
                           INT8_C(  89), INT8_C(  59), INT8_C( -98), INT8_C(  89)),
      simde_mm512_set_epi8(INT8_C( 104), INT8_C( -81), INT8_C( -54), INT8_C(  27),
                           INT8_C(  -7), INT8_C( 108), INT8_C(  77), INT8_C(  76),
                           INT8_C( 112), INT8_C(  99), INT8_C(  76), INT8_C(  -5),
                           INT8_C(  42), INT8_C(  67), INT8_C( -13), INT8_C( -57),
                           INT8_C(  59), INT8_C(-122), INT8_C(  12), INT8_C(  51),
                           INT8_C(-107), INT8_C( 125), INT8_C(  64), INT8_C( -28),
                           INT8_C( -78), INT8_C( 119), INT8_C( -86), INT8_C(  -6),
                           INT8_C( 123), INT8_C( 118), INT8_C(  57), INT8_C( -58),
                           INT8_C(  79), INT8_C( -59), INT8_C( -96), INT8_C(  42),
                           INT8_C( -10), INT8_C(  34), INT8_C( -63), INT8_C(  86),
                           INT8_C(  88), INT8_C(  57), INT8_C( -76), INT8_C(  -7),
                           INT8_C(  32), INT8_C( -66), INT8_C( -47), INT8_C( 109),
                           INT8_C(  63), INT8_C(  94), INT8_C(-107), INT8_C( 124),
                           INT8_C(  -1), INT8_C(-124), INT8_C(  32), INT8_C( 101),
                           INT8_C(  33), INT8_C(-112), INT8_C( -62), INT8_C(  38),
                           INT8_C(  14), INT8_C(-111), INT8_C( -11), INT8_C( -11)) },
    { simde_mm512_set_epi8(INT8_C( -91), INT8_C(  33), INT8_C(  -8), INT8_C(  37),
                           INT8_C(  32), INT8_C(  45), INT8_C(-122), INT8_C(  70),
                           INT8_C( 117), INT8_C( -19), INT8_C( -75), INT8_C(  13),
                           INT8_C( -99), INT8_C(  93), INT8_C( -75), INT8_C(  20),
                           INT8_C(  19), INT8_C(   8), INT8_C(-110), INT8_C( -98),
                           INT8_C(   3), INT8_C(  62), INT8_C(  35), INT8_C(   2),
                           INT8_C( 100), INT8_C(  93), INT8_C(  79), INT8_C(  89),
                           INT8_C( -78), INT8_C(  31), INT8_C(  94), INT8_C( 113),
                           INT8_C(-119), INT8_C(  14), INT8_C(-123), INT8_C( -25),
                           INT8_C(  58), INT8_C( -66), INT8_C( -71), INT8_C(  92),
                           INT8_C( 108), INT8_C( 124), INT8_C( -29), INT8_C( -77),
                           INT8_C( -24), INT8_C(-128), INT8_C(-121), INT8_C(  28),
                           INT8_C(-127), INT8_C(  21), INT8_C(  32), INT8_C( -79),
                           INT8_C( -97), INT8_C( -30), INT8_C(-115), INT8_C(  53),
                           INT8_C(  70), INT8_C(  75), INT8_C( -26), INT8_C(  77),
                           INT8_C( -45), INT8_C(-100), INT8_C(  30), INT8_C(  32)),
      UINT64_C(15325554837812698489),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C( 103), INT8_C( -34), INT8_C(  26),
                           INT8_C( -92), INT8_C(-106), INT8_C(  83), INT8_C( -36),
                           INT8_C(  61), INT8_C( -16), INT8_C(-112), INT8_C( -39),
                           INT8_C(  99), INT8_C( 110), INT8_C(   8), INT8_C( -91),
                           INT8_C(  19), INT8_C(  65), INT8_C(  30), INT8_C(  69),
                           INT8_C( -83), INT8_C(  78), INT8_C(  47), INT8_C( -80),
                           INT8_C(  55), INT8_C(  16), INT8_C(  42), INT8_C(-127),
                           INT8_C(   9), INT8_C(-125), INT8_C(  29), INT8_C(-101),
                           INT8_C(  97), INT8_C( -40), INT8_C(  70), INT8_C( -20),
                           INT8_C(-125), INT8_C(-105), INT8_C( -47), INT8_C(  87),
                           INT8_C(-126), INT8_C(  27), INT8_C(  91), INT8_C( -52),
                           INT8_C( -69), INT8_C(  76), INT8_C(-116), INT8_C(  24),
                           INT8_C( -37), INT8_C( -95), INT8_C( -14), INT8_C( -88),
                           INT8_C(  -7), INT8_C(  96), INT8_C( 114), INT8_C(  40),
                           INT8_C( -93), INT8_C( -16), INT8_C( -29), INT8_C( 102),
                           INT8_C( -36), INT8_C( 111), INT8_C( -60), INT8_C(  50)),
      simde_mm512_set_epi8(INT8_C(   4), INT8_C(   6), INT8_C(  63), INT8_C( -47),
                           INT8_C(  -7), INT8_C( -11), INT8_C( -31), INT8_C( -27),
                           INT8_C(-102), INT8_C( -51), INT8_C( -75), INT8_C( -30),
                           INT8_C(-125), INT8_C(-103), INT8_C(  96), INT8_C(  41),
                           INT8_C( -33), INT8_C( -83), INT8_C(  79), INT8_C( -21),
                           INT8_C( -93), INT8_C( -15), INT8_C( 127), INT8_C( 107),
                           INT8_C(-114), INT8_C(  54), INT8_C( -68), INT8_C(-124),
                           INT8_C( -75), INT8_C(  94), INT8_C(  96), INT8_C( -35),
                           INT8_C( -99), INT8_C( -46), INT8_C( -57), INT8_C(  42),
                           INT8_C( 102), INT8_C( -83), INT8_C( -30), INT8_C( 107),
                           INT8_C(  39), INT8_C( -54), INT8_C( -46), INT8_C(  23),
                           INT8_C(  43), INT8_C(  67), INT8_C(  68), INT8_C( -29),
                           INT8_C(  71), INT8_C(  38), INT8_C( -71), INT8_C(  -2),
                           INT8_C( -12), INT8_C( -12), INT8_C( 127), INT8_C(  43),
                           INT8_C(  65), INT8_C( 114), INT8_C(-111), INT8_C( -99),
                           INT8_C(  48), INT8_C( -90), INT8_C( -33), INT8_C(  -6)),
      simde_mm512_set_epi8(INT8_C(  10), INT8_C( 121), INT8_C(  -8), INT8_C(   6),
                           INT8_C(  32), INT8_C(  77), INT8_C(-122), INT8_C(  70),
                           INT8_C( -46), INT8_C( -19), INT8_C(  50), INT8_C(  13),
                           INT8_C(   1), INT8_C(  18), INT8_C(-117), INT8_C( 107),
                           INT8_C(  19), INT8_C(  58), INT8_C(-110), INT8_C( -98),
                           INT8_C( -98), INT8_C(-112), INT8_C( 120), INT8_C(   2),
                           INT8_C( -60), INT8_C( -98), INT8_C(  -8), INT8_C(  89),
                           INT8_C(  29), INT8_C(   6), INT8_C(  94), INT8_C(  21),
                           INT8_C(-119), INT8_C(  14), INT8_C(  21), INT8_C(  -3),
                           INT8_C(  52), INT8_C(   2), INT8_C( -71), INT8_C( -77),
                           INT8_C(  17), INT8_C( 124), INT8_C( -29), INT8_C(  19),
                           INT8_C(  39), INT8_C(-128), INT8_C(-121), INT8_C(  28),
                           INT8_C(-127), INT8_C(  47), INT8_C(  32), INT8_C(  38),
                           INT8_C( -26), INT8_C( -81), INT8_C(-115), INT8_C(  26),
                           INT8_C(  70), INT8_C( 107), INT8_C(  26), INT8_C( -45),
                           INT8_C( 121), INT8_C(-100), INT8_C(  30), INT8_C( -90)) },
    { simde_mm512_set_epi8(INT8_C( -62), INT8_C( -73), INT8_C(   0), INT8_C(-101),
                           INT8_C( 116), INT8_C(  69), INT8_C(  92), INT8_C( 108),
                           INT8_C(  36), INT8_C( -46), INT8_C( -54), INT8_C( -54),
                           INT8_C( -20), INT8_C(  67), INT8_C( -51), INT8_C( -85),
                           INT8_C( -23), INT8_C(  69), INT8_C(-114), INT8_C(  64),
                           INT8_C(  81), INT8_C(  77), INT8_C( -92), INT8_C(  40),
                           INT8_C( -30), INT8_C( -93), INT8_C( -92), INT8_C( 118),
                           INT8_C( -39), INT8_C( -80), INT8_C( -72), INT8_C( -77),
                           INT8_C(  65), INT8_C( 123), INT8_C( -53), INT8_C(  39),
                           INT8_C( -96), INT8_C(  45), INT8_C(  84), INT8_C( -69),
                           INT8_C(   0), INT8_C( -17), INT8_C( -85), INT8_C(  75),
                           INT8_C(  94), INT8_C(-101), INT8_C(-110), INT8_C(  18),
                           INT8_C(  15), INT8_C(   3), INT8_C(  69), INT8_C( -46),
                           INT8_C( -17), INT8_C( -89), INT8_C(-105), INT8_C(  25),
                           INT8_C(  75), INT8_C( -48), INT8_C( -24), INT8_C( 121),
                           INT8_C(  24), INT8_C( -37), INT8_C( -70), INT8_C( 117)),
      UINT64_C( 8321631579246341407),
      simde_mm512_set_epi8(INT8_C(-108), INT8_C( -86), INT8_C( -86), INT8_C(  72),
                           INT8_C(  33), INT8_C(  33), INT8_C( -55), INT8_C(  78),
                           INT8_C(  32), INT8_C(  80), INT8_C(  63), INT8_C( -95),
                           INT8_C( -12), INT8_C( 117), INT8_C(   6), INT8_C( -80),
                           INT8_C( 125), INT8_C( -75), INT8_C( 125), INT8_C( -17),
                           INT8_C(  20), INT8_C(-128), INT8_C( -32), INT8_C(  -1),
                           INT8_C(  85), INT8_C( -34), INT8_C(  19), INT8_C(  84),
                           INT8_C(  40), INT8_C(  92), INT8_C( -28), INT8_C( -58),
                           INT8_C( -25), INT8_C( 122), INT8_C(  47), INT8_C(-100),
                           INT8_C(-128), INT8_C(  -1), INT8_C( 114), INT8_C(  -5),
                           INT8_C( 125), INT8_C( 104), INT8_C( -10), INT8_C( -76),
                           INT8_C( 115), INT8_C(  98), INT8_C(  54), INT8_C( 111),
                           INT8_C(-112), INT8_C(  15), INT8_C( -43), INT8_C( -23),
                           INT8_C(-121), INT8_C(  73), INT8_C( -23), INT8_C(-123),
                           INT8_C( -93), INT8_C( -81), INT8_C( -81), INT8_C(-110),
                           INT8_C( -89), INT8_C( -34), INT8_C(   8), INT8_C( 108)),
      simde_mm512_set_epi8(INT8_C( -28), INT8_C(  40), INT8_C( 110), INT8_C( -17),
                           INT8_C(  44), INT8_C( 103), INT8_C(  -7), INT8_C(   8),
                           INT8_C(  70), INT8_C( 121), INT8_C(  -7), INT8_C( -36),
                           INT8_C( -32), INT8_C( 126), INT8_C(  91), INT8_C(  92),
                           INT8_C(  -4), INT8_C(  58), INT8_C(   0), INT8_C( -32),
                           INT8_C(-125), INT8_C( -97), INT8_C( -73), INT8_C( -36),
                           INT8_C( 101), INT8_C( -91), INT8_C(  92), INT8_C(-100),
                           INT8_C(  92), INT8_C( -53), INT8_C(   4), INT8_C(   1),
                           INT8_C(  13), INT8_C(  64), INT8_C( -32), INT8_C( -67),
                           INT8_C( 106), INT8_C( 112), INT8_C( -54), INT8_C(  55),
                           INT8_C(  64), INT8_C( -37), INT8_C(  81), INT8_C(  53),
                           INT8_C(  79), INT8_C(  81), INT8_C( -60), INT8_C( -46),
                           INT8_C( -11), INT8_C(  90), INT8_C(  97), INT8_C(  68),
                           INT8_C(-127), INT8_C(  86), INT8_C(  32), INT8_C(-118),
                           INT8_C(  76), INT8_C( -43), INT8_C(  41), INT8_C(-111),
                           INT8_C(  -3), INT8_C( -53), INT8_C( 102), INT8_C(-116)),
      simde_mm512_set_epi8(INT8_C( -62), INT8_C( -20), INT8_C( -20), INT8_C(-101),
                           INT8_C( 116), INT8_C(  69), INT8_C( -70), INT8_C(-118),
                           INT8_C(  36), INT8_C(  57), INT8_C(-112), INT8_C(  68),
                           INT8_C( -70), INT8_C( -32), INT8_C( -51), INT8_C( -85),
                           INT8_C( -23), INT8_C( -24), INT8_C(-114), INT8_C(  83),
                           INT8_C(  42), INT8_C( -47), INT8_C(  19), INT8_C( -80),
                           INT8_C(  -3), INT8_C( 104), INT8_C( -92), INT8_C(  94),
                           INT8_C( -39), INT8_C(  98), INT8_C( -72), INT8_C( -77),
                           INT8_C( 126), INT8_C( -61), INT8_C( -53), INT8_C(  28),
                           INT8_C( 100), INT8_C(  45), INT8_C(  84), INT8_C( -69),
                           INT8_C(  13), INT8_C( -17), INT8_C( 113), INT8_C(  75),
                           INT8_C(  94), INT8_C(  69), INT8_C(  68), INT8_C(  18),
                           INT8_C(-102), INT8_C(   3), INT8_C(-119), INT8_C( -46),
                           INT8_C(  39), INT8_C(-112), INT8_C(-105), INT8_C(-123),
                           INT8_C(  75), INT8_C( -48), INT8_C( -24), INT8_C( -24),
                           INT8_C(  75), INT8_C(  -3), INT8_C( -99), INT8_C( 105)) },
    { simde_mm512_set_epi8(INT8_C( -17), INT8_C( -70), INT8_C(  -8), INT8_C(  -6),
                           INT8_C( -25), INT8_C(  67), INT8_C(-120), INT8_C(  82),
                           INT8_C(  90), INT8_C(  -2), INT8_C(  90), INT8_C( 114),
                           INT8_C( -38), INT8_C( -75), INT8_C(  88), INT8_C(-108),
                           INT8_C( -25), INT8_C(-124), INT8_C( -83), INT8_C( -55),
                           INT8_C( -40), INT8_C(  90), INT8_C( 105), INT8_C(  22),
                           INT8_C( 103), INT8_C(  26), INT8_C( -91), INT8_C( 114),
                           INT8_C(  98), INT8_C( 100), INT8_C(  66), INT8_C(  64),
                           INT8_C( -59), INT8_C( -34), INT8_C(  81), INT8_C( -52),
                           INT8_C( -90), INT8_C(  63), INT8_C(-114), INT8_C(  90),
                           INT8_C(  11), INT8_C(  25), INT8_C(  93), INT8_C( -33),
                           INT8_C(  76), INT8_C(  -7), INT8_C( -19), INT8_C(  23),
                           INT8_C( -78), INT8_C(  66), INT8_C(  45), INT8_C(  -6),
                           INT8_C( -98), INT8_C( -55), INT8_C(  30), INT8_C( -34),
                           INT8_C(  89), INT8_C( -71), INT8_C( -37), INT8_C( -43),
                           INT8_C( -19), INT8_C( -25), INT8_C( -17), INT8_C(  -4)),
      UINT64_C( 2599823307644986375),
      simde_mm512_set_epi8(INT8_C( -99), INT8_C(  38), INT8_C(  18), INT8_C(-109),
                           INT8_C(  29), INT8_C( -64), INT8_C(  95), INT8_C( 126),
                           INT8_C(  95), INT8_C(  35), INT8_C(  71), INT8_C(  92),
                           INT8_C(  50), INT8_C(  -1), INT8_C( -76), INT8_C(  25),
                           INT8_C(  42), INT8_C(  60), INT8_C( -11), INT8_C( -16),
                           INT8_C(-122), INT8_C(  72), INT8_C( 102), INT8_C(  38),
                           INT8_C(  86), INT8_C(  14), INT8_C(  82), INT8_C( -45),
                           INT8_C(-108), INT8_C(-114), INT8_C( 112), INT8_C(-118),
                           INT8_C(   4), INT8_C( -43), INT8_C(  38), INT8_C(  -4),
                           INT8_C(  78), INT8_C( 122), INT8_C(  16), INT8_C( -58),
                           INT8_C( -65), INT8_C(-101), INT8_C( -18), INT8_C(  14),
                           INT8_C(  29), INT8_C(  -4), INT8_C(  93), INT8_C( 106),
                           INT8_C(-112), INT8_C(  63), INT8_C(  -1), INT8_C( 100),
                           INT8_C(  79), INT8_C(  72), INT8_C( -17), INT8_C(  88),
                           INT8_C(  -3), INT8_C( -83), INT8_C( -17), INT8_C( 122),
                           INT8_C( 121), INT8_C( -91), INT8_C(   5), INT8_C(  38)),
      simde_mm512_set_epi8(INT8_C( -22), INT8_C(-124), INT8_C( -17), INT8_C( -97),
                           INT8_C(  33), INT8_C( 121), INT8_C(-115), INT8_C(  31),
                           INT8_C(  21), INT8_C(  -5), INT8_C(  49), INT8_C(  61),
                           INT8_C( -59), INT8_C( -39), INT8_C(  80), INT8_C( 122),
                           INT8_C( -84), INT8_C( -34), INT8_C(-110), INT8_C(-125),
                           INT8_C(  33), INT8_C(  -5), INT8_C(-115), INT8_C(  79),
                           INT8_C(  18), INT8_C(  37), INT8_C( 104), INT8_C( -81),
                           INT8_C(  38), INT8_C( -46), INT8_C(  97), INT8_C(  -2),
                           INT8_C(  71), INT8_C(  69), INT8_C( -82), INT8_C( 125),
                           INT8_C(-121), INT8_C(  79), INT8_C(  33), INT8_C(-125),
                           INT8_C(-101), INT8_C(  49), INT8_C(  13), INT8_C( -58),
                           INT8_C( -47), INT8_C( -76), INT8_C( -78), INT8_C(  97),
                           INT8_C( 116), INT8_C(  -3), INT8_C(  89), INT8_C( -19),
                           INT8_C(  76), INT8_C(  18), INT8_C( -76), INT8_C( -28),
                           INT8_C(  61), INT8_C(-124), INT8_C( 120), INT8_C(-125),
                           INT8_C(  58), INT8_C(   0), INT8_C(  85), INT8_C(   8)),
      simde_mm512_set_epi8(INT8_C( -17), INT8_C( -70), INT8_C(  13), INT8_C(  -6),
                           INT8_C( -25), INT8_C(  66), INT8_C(-120), INT8_C(  82),
                           INT8_C(  90), INT8_C(  -2), INT8_C(  90), INT8_C(-122),
                           INT8_C( -38), INT8_C(-121), INT8_C(  88), INT8_C(-108),
                           INT8_C( -25), INT8_C(  31), INT8_C( -55), INT8_C( -55),
                           INT8_C(  42), INT8_C( 105), INT8_C( 105), INT8_C( 116),
                           INT8_C(  78), INT8_C(  26), INT8_C( -91), INT8_C( 114),
                           INT8_C(  98), INT8_C(  47), INT8_C( -77), INT8_C(  64),
                           INT8_C( -59), INT8_C( -34), INT8_C(  81), INT8_C( -64),
                           INT8_C( -91), INT8_C(  63), INT8_C(  32), INT8_C(  90),
                           INT8_C(  55), INT8_C(  -7), INT8_C(  75), INT8_C(  72),
                           INT8_C(  76), INT8_C( 113), INT8_C( -19), INT8_C(  30),
                           INT8_C(-123), INT8_C( 111), INT8_C(  58), INT8_C(  -6),
                           INT8_C( -98), INT8_C( -87), INT8_C(  30), INT8_C( -34),
                           INT8_C(  89), INT8_C( -71), INT8_C( -37), INT8_C( -43),
                           INT8_C( -19), INT8_C(  61), INT8_C(  34), INT8_C( 102)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_gf2p8affine_epi64_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C(  40));
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_maskz_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask16 k;
    simde__m128i x;
    simde__m128i A;
    simde__m128i r;
  } test_vec[8] = {
    { UINT16_C(28514),
      simde_mm_set_epi8(INT8_C(  -8), INT8_C(  96), INT8_C(  18), INT8_C(  58),
                        INT8_C( 122), INT8_C(   7), INT8_C(  79), INT8_C(-100),
                        INT8_C( -48), INT8_C(  91), INT8_C(  -3), INT8_C(-127),
                        INT8_C(  14), INT8_C(-111), INT8_C(  27), INT8_C( -76)),
      simde_mm_set_epi8(INT8_C(-117), INT8_C(  -3), INT8_C( 125), INT8_C(-126),
                        INT8_C(  35), INT8_C( 127), INT8_C(  14), INT8_C( 124),
                        INT8_C( -32), INT8_C(  64), INT8_C(  -6), INT8_C(   5),
                        INT8_C( -90), INT8_C(  20), INT8_C( -31), INT8_C(  65)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(  96), INT8_C( -81), INT8_C(   0),
                        INT8_C(  88), INT8_C( -40), INT8_C(-103), INT8_C( -36),
                        INT8_C(   0), INT8_C(  75), INT8_C( 103), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(-116), INT8_C(   0)) },
    { UINT16_C( 6767),
      simde_mm_set_epi8(INT8_C( 126), INT8_C(  73), INT8_C( -25), INT8_C(  25),
                        INT8_C( -85), INT8_C(  30), INT8_C(  88), INT8_C( 126),
                        INT8_C( -49), INT8_C(  27), INT8_C( -87), INT8_C( -78),
                        INT8_C( 121), INT8_C( -77), INT8_C(  64), INT8_C(-105)),
      simde_mm_set_epi8(INT8_C( 117), INT8_C(  88), INT8_C( -38), INT8_C( -50),
                        INT8_C( -20), INT8_C( -14), INT8_C(  13), INT8_C(-126),
                        INT8_C(  54), INT8_C(  27), INT8_C( -19), INT8_C(   2),
                        INT8_C( -62), INT8_C( -13), INT8_C( -21), INT8_C( 121)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  72),
                        INT8_C(  78), INT8_C(   0), INT8_C(  54), INT8_C(   0),
                        INT8_C(   0), INT8_C(-120), INT8_C( -63), INT8_C(   0),
                        INT8_C( -30), INT8_C( -33), INT8_C(-124), INT8_C(  63)) },
    { UINT16_C(22163),
      simde_mm_set_epi8(INT8_C(   7), INT8_C(-121), INT8_C(  35), INT8_C( -53),
                        INT8_C(  31), INT8_C( -93), INT8_C(  71), INT8_C( -88),
                        INT8_C( 118), INT8_C(  62), INT8_C(  61), INT8_C(  63),
                        INT8_C(  14), INT8_C(  14), INT8_C(  31), INT8_C( 112)),
      simde_mm_set_epi8(INT8_C(  95), INT8_C(  63), INT8_C(-121), INT8_C(  59),
                        INT8_C( -53), INT8_C( -35), INT8_C(  37), INT8_C( -31),
                        INT8_C( -96), INT8_C(  81), INT8_C(  92), INT8_C( -51),
                        INT8_C(  48), INT8_C( -43), INT8_C(   1), INT8_C( -58)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(  67), INT8_C(   0), INT8_C( -82),
                        INT8_C(   0), INT8_C( -18), INT8_C(  70), INT8_C(   0),
                        INT8_C( -43), INT8_C(   0), INT8_C(   0), INT8_C(  29),
                        INT8_C(   0), INT8_C(   0), INT8_C(  12), INT8_C(  -7)) },
    { UINT16_C(17293),
      simde_mm_set_epi8(INT8_C(  43), INT8_C( -29), INT8_C( -33), INT8_C(-101),
                        INT8_C( -92), INT8_C( -95), INT8_C(  82), INT8_C(  35),
                        INT8_C(   3), INT8_C( -99), INT8_C(   5), INT8_C(  91),
                        INT8_C(  76), INT8_C( -65), INT8_C( -10), INT8_C( -12)),
      simde_mm_set_epi8(INT8_C(  56), INT8_C( 110), INT8_C(  34), INT8_C(  85),
                        INT8_C(  25), INT8_C( -71), INT8_C(-127), INT8_C(   0),
                        INT8_C(  99), INT8_C(  28), INT8_C(   1), INT8_C( -35),
                        INT8_C( -39), INT8_C( -86), INT8_C( -44), INT8_C( -63)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(  67), INT8_C(   0), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(  69), INT8_C(  41),
                        INT8_C( -52), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C( -39), INT8_C(  63), INT8_C(   0), INT8_C(  96)) },
    { UINT16_C(60810),
      simde_mm_set_epi8(INT8_C(-115), INT8_C( 123), INT8_C( -93), INT8_C(  59),
                        INT8_C(  66), INT8_C(  53), INT8_C( -76), INT8_C(  34),
                        INT8_C(  80), INT8_C( 112), INT8_C( -24), INT8_C( -52),
                        INT8_C(  68), INT8_C(  70), INT8_C(   6), INT8_C(  61)),
      simde_mm_set_epi8(INT8_C( -92), INT8_C(-121), INT8_C(  78), INT8_C(  54),
                        INT8_C( -41), INT8_C( 118), INT8_C( -81), INT8_C(  86),
                        INT8_C(-103), INT8_C( 105), INT8_C(-114), INT8_C(-114),
                        INT8_C( -29), INT8_C(-127), INT8_C( 122), INT8_C(  87)),
      simde_mm_set_epi8(INT8_C( -54), INT8_C(  -3), INT8_C( -26), INT8_C(   0),
                        INT8_C(  58), INT8_C(  12), INT8_C(   0), INT8_C( -25),
                        INT8_C(  99), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C(  46), INT8_C(   0), INT8_C(  32), INT8_C(   0)) },
    { UINT16_C(11150),
      simde_mm_set_epi8(INT8_C(  29), INT8_C( -45), INT8_C( -10), INT8_C(  88),
                        INT8_C(-127), INT8_C(  63), INT8_C( -37), INT8_C(  20),
                        INT8_C( -46), INT8_C(  91), INT8_C(  -7), INT8_C(  17),
                        INT8_C(-101), INT8_C( -78), INT8_C(-112), INT8_C( -57)),
      simde_mm_set_epi8(INT8_C(  -1), INT8_C( 108), INT8_C(   6), INT8_C( 104),
                        INT8_C( -14), INT8_C(  32), INT8_C(  24), INT8_C(  11),
                        INT8_C(  24), INT8_C(  56), INT8_C(-122), INT8_C(   6),
                        INT8_C( 113), INT8_C( -67), INT8_C(-122), INT8_C( -34)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(-126), INT8_C(   0),
                        INT8_C( -32), INT8_C(   0), INT8_C( -12), INT8_C(  38),
                        INT8_C( 123), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C( 120), INT8_C( -39), INT8_C(  39), INT8_C(   0)) },
    { UINT16_C(19041),
      simde_mm_set_epi8(INT8_C( 121), INT8_C( -69), INT8_C( -17), INT8_C(   9),
                        INT8_C( -15), INT8_C( -58), INT8_C(-102), INT8_C( -34),
                        INT8_C(  -5), INT8_C(  28), INT8_C(  80), INT8_C( -95),
                        INT8_C( -19), INT8_C(  42), INT8_C(  52), INT8_C( -49)),
      simde_mm_set_epi8(INT8_C( -28), INT8_C( -43), INT8_C( -70), INT8_C( -76),
                        INT8_C( -94), INT8_C(-108), INT8_C( -89), INT8_C( -53),
                        INT8_C(  93), INT8_C( 113), INT8_C( -28), INT8_C( 100),
                        INT8_C( -99), INT8_C(-106), INT8_C(-107), INT8_C( -54)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C( 110), INT8_C(   0), INT8_C(   0),
                        INT8_C( -67), INT8_C(   0), INT8_C( -15), INT8_C(   0),
                        INT8_C(   0), INT8_C( -17), INT8_C(-116), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  20)) },
    { UINT16_C(64646),
      simde_mm_set_epi8(INT8_C( -52), INT8_C(-101), INT8_C( 102), INT8_C(-127),
                        INT8_C( -21), INT8_C( 125), INT8_C(  50), INT8_C( -75),
                        INT8_C(  86), INT8_C(  40), INT8_C( -12), INT8_C(  70),
                        INT8_C( -13), INT8_C( -31), INT8_C(-109), INT8_C(  62)),
      simde_mm_set_epi8(INT8_C( 114), INT8_C(  64), INT8_C( -41), INT8_C(-112),
                        INT8_C( -98), INT8_C( -51), INT8_C(  83), INT8_C(  93),
                        INT8_C(  63), INT8_C( -30), INT8_C( -83), INT8_C(  98),
                        INT8_C( 110), INT8_C(  -3), INT8_C( 105), INT8_C( -23)),
      simde_mm_set_epi8(INT8_C( -81), INT8_C(-112), INT8_C( 119), INT8_C( -88),
                        INT8_C( -85), INT8_C( -85), INT8_C(   0), INT8_C(   0),
                        INT8_C(-123), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C(   0), INT8_C(  54), INT8_C(   9), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_maskz_gf2p8affine_epi64_epi8(test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C( 112));
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_maskz_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask32 k;
    simde__m256i x;
    simde__m256i A;
    simde__m256i r;
  } test_vec[8] = {
    { UINT32_C(2667081570),
      simde_mm256_set_epi8(INT8_C(-117), INT8_C(  -3), INT8_C( 125), INT8_C(-126),
                           INT8_C(  35), INT8_C( 127), INT8_C(  14), INT8_C( 124),
                           INT8_C( -32), INT8_C(  64), INT8_C(  -6), INT8_C(   5),
                           INT8_C( -90), INT8_C(  20), INT8_C( -31), INT8_C(  65),
                           INT8_C(  -8), INT8_C(  96), INT8_C(  18), INT8_C(  58),
                           INT8_C( 122), INT8_C(   7), INT8_C(  79), INT8_C(-100),
                           INT8_C( -48), INT8_C(  91), INT8_C(  -3), INT8_C(-127),
                           INT8_C(  14), INT8_C(-111), INT8_C(  27), INT8_C( -76)),
      simde_mm256_set_epi8(INT8_C(  54), INT8_C(  27), INT8_C( -19), INT8_C(   2),
                           INT8_C( -62), INT8_C( -13), INT8_C( -21), INT8_C( 121),
                           INT8_C( 126), INT8_C(  73), INT8_C( -25), INT8_C(  25),
                           INT8_C( -85), INT8_C(  30), INT8_C(  88), INT8_C( 126),
                           INT8_C( -49), INT8_C(  27), INT8_C( -87), INT8_C( -78),
                           INT8_C( 121), INT8_C( -77), INT8_C(  64), INT8_C(-105),
                           INT8_C( -59), INT8_C(  68), INT8_C(  37), INT8_C( 123),
                           INT8_C( -35), INT8_C(-104), INT8_C(  26), INT8_C( 111)),
      simde_mm256_set_epi8(INT8_C( -10), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C( -95), INT8_C(  53), INT8_C(  97), INT8_C(   0),
                           INT8_C( -97), INT8_C(  30), INT8_C(  56), INT8_C(  98),
                           INT8_C(  72), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -76), INT8_C( -56), INT8_C(   0),
                           INT8_C( -78), INT8_C(  68), INT8_C(   2), INT8_C(  88),
                           INT8_C(   0), INT8_C(-105), INT8_C( 117), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  12), INT8_C(   0)) },
    { UINT32_C(3975286146),
      simde_mm256_set_epi8(INT8_C( -96), INT8_C(  81), INT8_C(  92), INT8_C( -51),
                           INT8_C(  48), INT8_C( -43), INT8_C(   1), INT8_C( -58),
                           INT8_C(   7), INT8_C(-121), INT8_C(  35), INT8_C( -53),
                           INT8_C(  31), INT8_C( -93), INT8_C(  71), INT8_C( -88),
                           INT8_C( 118), INT8_C(  62), INT8_C(  61), INT8_C(  63),
                           INT8_C(  14), INT8_C(  14), INT8_C(  31), INT8_C( 112),
                           INT8_C(-116), INT8_C( -66), INT8_C( 120), INT8_C( 120),
                           INT8_C(  41), INT8_C(  92), INT8_C(  86), INT8_C(-109)),
      simde_mm256_set_epi8(INT8_C(  43), INT8_C( -29), INT8_C( -33), INT8_C(-101),
                           INT8_C( -92), INT8_C( -95), INT8_C(  82), INT8_C(  35),
                           INT8_C(   3), INT8_C( -99), INT8_C(   5), INT8_C(  91),
                           INT8_C(  76), INT8_C( -65), INT8_C( -10), INT8_C( -12),
                           INT8_C( -73), INT8_C( 117), INT8_C(-114), INT8_C( -69),
                           INT8_C(-117), INT8_C( -76), INT8_C(  67), INT8_C(-115),
                           INT8_C(  95), INT8_C(  63), INT8_C(-121), INT8_C(  59),
                           INT8_C( -53), INT8_C( -35), INT8_C(  37), INT8_C( -31)),
      simde_mm256_set_epi8(INT8_C(  84), INT8_C( 124), INT8_C( -54), INT8_C(   0),
                           INT8_C(  38), INT8_C(  86), INT8_C(   0), INT8_C(   0),
                           INT8_C( 105), INT8_C(-117), INT8_C( 127), INT8_C( -97),
                           INT8_C(   0), INT8_C(   0), INT8_C( -79), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -65), INT8_C( -65), INT8_C(   0), INT8_C(-101),
                           INT8_C(  49), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  59), INT8_C(   0)) },
    { UINT32_C(3651851457),
      simde_mm256_set_epi8(INT8_C(-115), INT8_C( 123), INT8_C( -93), INT8_C(  59),
                           INT8_C(  66), INT8_C(  53), INT8_C( -76), INT8_C(  34),
                           INT8_C(  80), INT8_C( 112), INT8_C( -24), INT8_C( -52),
                           INT8_C(  68), INT8_C(  70), INT8_C(   6), INT8_C(  61),
                           INT8_C(-102), INT8_C( -31), INT8_C( -61), INT8_C(  -1),
                           INT8_C(  87), INT8_C(  86), INT8_C( -19), INT8_C(-118),
                           INT8_C(  56), INT8_C( 110), INT8_C(  34), INT8_C(  85),
                           INT8_C(  25), INT8_C( -71), INT8_C(-127), INT8_C(   0)),
      simde_mm256_set_epi8(INT8_C( -46), INT8_C(  91), INT8_C(  -7), INT8_C(  17),
                           INT8_C(-101), INT8_C( -78), INT8_C(-112), INT8_C( -57),
                           INT8_C( -66), INT8_C( -70), INT8_C(-120), INT8_C(  26),
                           INT8_C( -56), INT8_C(-100), INT8_C(  43), INT8_C(-114),
                           INT8_C( -92), INT8_C(-121), INT8_C(  78), INT8_C(  54),
                           INT8_C( -41), INT8_C( 118), INT8_C( -81), INT8_C(  86),
                           INT8_C(-103), INT8_C( 105), INT8_C(-114), INT8_C(-114),
                           INT8_C( -29), INT8_C(-127), INT8_C( 122), INT8_C(  87)),
      simde_mm256_set_epi8(INT8_C(  36), INT8_C(  62), INT8_C(   0), INT8_C( -71),
                           INT8_C( -19), INT8_C(   0), INT8_C(   0), INT8_C(  78),
                           INT8_C( -30), INT8_C(   0), INT8_C( -62), INT8_C(   0),
                           INT8_C( 104), INT8_C(   0), INT8_C( -77), INT8_C(   0),
                           INT8_C(-120), INT8_C(   5), INT8_C(   0), INT8_C(  -8),
                           INT8_C(   0), INT8_C( -44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   5), INT8_C(  70), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -39)) },
    { UINT32_C(2168445716),
      simde_mm256_set_epi8(INT8_C(  -5), INT8_C(  28), INT8_C(  80), INT8_C( -95),
                           INT8_C( -19), INT8_C(  42), INT8_C(  52), INT8_C( -49),
                           INT8_C( -78), INT8_C( 121), INT8_C( 126), INT8_C( 119),
                           INT8_C(  15), INT8_C(  89), INT8_C(  74), INT8_C(  97),
                           INT8_C(  -1), INT8_C( 108), INT8_C(   6), INT8_C( 104),
                           INT8_C( -14), INT8_C(  32), INT8_C(  24), INT8_C(  11),
                           INT8_C(  24), INT8_C(  56), INT8_C(-122), INT8_C(   6),
                           INT8_C( 113), INT8_C( -67), INT8_C(-122), INT8_C( -34)),
      simde_mm256_set_epi8(INT8_C( -49), INT8_C(  54), INT8_C(-125), INT8_C( 111),
                           INT8_C(  64), INT8_C( -66), INT8_C(  -4), INT8_C(-122),
                           INT8_C( -28), INT8_C( -43), INT8_C( -70), INT8_C( -76),
                           INT8_C( -94), INT8_C(-108), INT8_C( -89), INT8_C( -53),
                           INT8_C(  93), INT8_C( 113), INT8_C( -28), INT8_C( 100),
                           INT8_C( -99), INT8_C(-106), INT8_C(-107), INT8_C( -54),
                           INT8_C( 121), INT8_C( -69), INT8_C( -17), INT8_C(   9),
                           INT8_C( -15), INT8_C( -58), INT8_C(-102), INT8_C( -34)),
      simde_mm256_set_epi8(INT8_C( -90), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  69),
                           INT8_C(   0), INT8_C(   0), INT8_C(  18), INT8_C(  84),
                           INT8_C(  32), INT8_C(  50), INT8_C(  10), INT8_C( -59),
                           INT8_C( -64), INT8_C( -76), INT8_C(   0), INT8_C( -55),
                           INT8_C( 127), INT8_C(   0), INT8_C(  59), INT8_C( -69),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-101),
                           INT8_C(   0), INT8_C( -97), INT8_C(   0), INT8_C(   0)) },
    { UINT32_C(4091646782),
      simde_mm256_set_epi8(INT8_C( 107), INT8_C( 124), INT8_C( -95), INT8_C( 119),
                           INT8_C( -70), INT8_C(  31), INT8_C(-107), INT8_C(  56),
                           INT8_C( 114), INT8_C(  64), INT8_C( -41), INT8_C(-112),
                           INT8_C( -98), INT8_C( -51), INT8_C(  83), INT8_C(  93),
                           INT8_C(  63), INT8_C( -30), INT8_C( -83), INT8_C(  98),
                           INT8_C( 110), INT8_C(  -3), INT8_C( 105), INT8_C( -23),
                           INT8_C( -52), INT8_C(-101), INT8_C( 102), INT8_C(-127),
                           INT8_C( -21), INT8_C( 125), INT8_C(  50), INT8_C( -75)),
      simde_mm256_set_epi8(INT8_C( -33), INT8_C(-115), INT8_C( -46), INT8_C(  86),
                           INT8_C( -86), INT8_C( -28), INT8_C( -72), INT8_C(   4),
                           INT8_C( -56), INT8_C( -54), INT8_C( -60), INT8_C(  85),
                           INT8_C(  73), INT8_C(   2), INT8_C( -40), INT8_C( -46),
                           INT8_C( -45), INT8_C(  89), INT8_C( -24), INT8_C(  92),
                           INT8_C(   7), INT8_C(  49), INT8_C( 106), INT8_C( -69),
                           INT8_C( -61), INT8_C( -44), INT8_C(  92), INT8_C(  28),
                           INT8_C(  21), INT8_C( -36), INT8_C( -96), INT8_C(  50)),
      simde_mm256_set_epi8(INT8_C( -55), INT8_C(  49), INT8_C( -35), INT8_C( 124),
                           INT8_C(   0), INT8_C(   0), INT8_C(  75), INT8_C( -73),
                           INT8_C( 108), INT8_C(   6), INT8_C( -65), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-119),
                           INT8_C(  34), INT8_C(   0), INT8_C(   0), INT8_C( -93),
                           INT8_C(   0), INT8_C(   0), INT8_C(  15), INT8_C(-118),
                           INT8_C(   0), INT8_C(   0), INT8_C(-127), INT8_C( -85),
                           INT8_C( -31), INT8_C(-125), INT8_C(  38), INT8_C(   0)) },
    { UINT32_C( 484348831),
      simde_mm256_set_epi8(INT8_C( 103), INT8_C(-123), INT8_C( -94), INT8_C( -49),
                           INT8_C(-110), INT8_C(-117), INT8_C( -20), INT8_C( -24),
                           INT8_C(-118), INT8_C(-114), INT8_C(  58), INT8_C(  97),
                           INT8_C(-121), INT8_C(-105), INT8_C(  15), INT8_C(  90),
                           INT8_C(  56), INT8_C( -93), INT8_C(  -6), INT8_C( -16),
                           INT8_C( 110), INT8_C(   3), INT8_C(  -8), INT8_C( -93),
                           INT8_C(  96), INT8_C(-124), INT8_C( -43), INT8_C( 119),
                           INT8_C( -95), INT8_C( 114), INT8_C(-109), INT8_C( -39)),
      simde_mm256_set_epi8(INT8_C(  95), INT8_C( -75), INT8_C( -52), INT8_C(  24),
                           INT8_C( -86), INT8_C(  91), INT8_C( -23), INT8_C( -49),
                           INT8_C( 111), INT8_C( -77), INT8_C(   6), INT8_C(  42),
                           INT8_C( 120), INT8_C( -42), INT8_C(  70), INT8_C(  14),
                           INT8_C(  84), INT8_C( 113), INT8_C( -38), INT8_C( 102),
                           INT8_C( -38), INT8_C(-125), INT8_C(  39), INT8_C(  72),
                           INT8_C( -14), INT8_C( 109), INT8_C( 110), INT8_C(  60),
                           INT8_C( -93), INT8_C(   6), INT8_C( 127), INT8_C(  94)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -62),
                           INT8_C(-107), INT8_C( -96), INT8_C(   0), INT8_C(   0),
                           INT8_C(-115), INT8_C( 104), INT8_C(   0), INT8_C( -80),
                           INT8_C( -14), INT8_C( -64), INT8_C(  73), INT8_C(   0),
                           INT8_C(  16), INT8_C(   0), INT8_C(   0), INT8_C(  47),
                           INT8_C(   0), INT8_C(   0), INT8_C( -69), INT8_C( -71),
                           INT8_C(  65), INT8_C(   0), INT8_C(   0), INT8_C( -63),
                           INT8_C( -59), INT8_C( 125), INT8_C( -90), INT8_C(  90)) },
    { UINT32_C(1399212686),
      simde_mm256_set_epi8(INT8_C(  41), INT8_C( -37), INT8_C(-117), INT8_C(  95),
                           INT8_C( -14), INT8_C(-122), INT8_C( -91), INT8_C( -89),
                           INT8_C( -40), INT8_C(  17), INT8_C( -71), INT8_C(  29),
                           INT8_C(-114), INT8_C(  39), INT8_C( -61), INT8_C(-105),
                           INT8_C(  -8), INT8_C( -35), INT8_C(  35), INT8_C(  20),
                           INT8_C(  59), INT8_C( -64), INT8_C(  20), INT8_C( -16),
                           INT8_C(-106), INT8_C( -49), INT8_C(  -6), INT8_C( 106),
                           INT8_C( -37), INT8_C(  21), INT8_C(  -6), INT8_C( -23)),
      simde_mm256_set_epi8(INT8_C(  63), INT8_C( -90), INT8_C(  32), INT8_C( -78),
                           INT8_C( -95), INT8_C(  -2), INT8_C(-119), INT8_C(  67),
                           INT8_C(-107), INT8_C( -81), INT8_C(  37), INT8_C( 116),
                           INT8_C( -57), INT8_C(  58), INT8_C(-116), INT8_C( 117),
                           INT8_C(  93), INT8_C( 117), INT8_C(-121), INT8_C( -82),
                           INT8_C( -77), INT8_C(-126), INT8_C( -76), INT8_C( -31),
                           INT8_C(-112), INT8_C(-125), INT8_C( -27), INT8_C( -87),
                           INT8_C(  -3), INT8_C( -45), INT8_C( 106), INT8_C(  28)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  49), INT8_C(   0), INT8_C( 104),
                           INT8_C(   0), INT8_C(   0), INT8_C( 110), INT8_C( -59),
                           INT8_C(   0), INT8_C( -25), INT8_C( 120), INT8_C(   0),
                           INT8_C(   0), INT8_C(  13), INT8_C( -73), INT8_C(   0),
                           INT8_C(   0), INT8_C(  36), INT8_C(   0), INT8_C(   0),
                           INT8_C( -14), INT8_C(   0), INT8_C( -59), INT8_C(   0),
                           INT8_C( -95), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -89), INT8_C( -62), INT8_C( -59), INT8_C(   0)) },
    { UINT32_C(2838825552),
      simde_mm256_set_epi8(INT8_C(  16), INT8_C( -91), INT8_C(  46), INT8_C( -50),
                           INT8_C( 114), INT8_C( -52), INT8_C(  74), INT8_C( -49),
                           INT8_C(  12), INT8_C(  87), INT8_C( 122), INT8_C(  68),
                           INT8_C(  75), INT8_C(  81), INT8_C( -37), INT8_C(  -8),
                           INT8_C( -53), INT8_C( 104), INT8_C(  84), INT8_C(-122),
                           INT8_C( -31), INT8_C( -86), INT8_C( -25), INT8_C( 110),
                           INT8_C(  -6), INT8_C(  33), INT8_C( -77), INT8_C( -84),
                           INT8_C(   8), INT8_C(  51), INT8_C(-125), INT8_C( -60)),
      simde_mm256_set_epi8(INT8_C( 104), INT8_C( -53), INT8_C( 118), INT8_C(  34),
                           INT8_C(  19), INT8_C(  -6), INT8_C(-103), INT8_C(  93),
                           INT8_C( 101), INT8_C( 100), INT8_C( -55), INT8_C( 108),
                           INT8_C(   6), INT8_C( -85), INT8_C(   4), INT8_C( -17),
                           INT8_C(-116), INT8_C( 108), INT8_C(  39), INT8_C(  48),
                           INT8_C( -56), INT8_C( -50), INT8_C( -30), INT8_C( -76),
                           INT8_C( -28), INT8_C(-125), INT8_C( 119), INT8_C(-118),
                           INT8_C(  52), INT8_C(  56), INT8_C( -74), INT8_C(  39)),
      simde_mm256_set_epi8(INT8_C(  45), INT8_C(   0), INT8_C( -83), INT8_C(   0),
                           INT8_C(-103), INT8_C(   0), INT8_C(   0), INT8_C(-105),
                           INT8_C(   0), INT8_C(   0), INT8_C( -31), INT8_C(-115),
                           INT8_C(   0), INT8_C( -13), INT8_C(   0), INT8_C( -11),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-112), INT8_C(   0), INT8_C(  83), INT8_C(   0),
                           INT8_C(   0), INT8_C( -86), INT8_C(   0), INT8_C(-102),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_maskz_gf2p8affine_epi64_epi8(test_vec[i].k, test_vec[i].x, test_vec[i].A, 217);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_gf2p8affine_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i x;
    simde__m512i A;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C( 2216089611417448290),
      simde_mm512_set_epi8(INT8_C(  54), INT8_C(  27), INT8_C( -19), INT8_C(   2),
                           INT8_C( -62), INT8_C( -13), INT8_C( -21), INT8_C( 121),
                           INT8_C( 126), INT8_C(  73), INT8_C( -25), INT8_C(  25),
                           INT8_C( -85), INT8_C(  30), INT8_C(  88), INT8_C( 126),
                           INT8_C( -49), INT8_C(  27), INT8_C( -87), INT8_C( -78),
                           INT8_C( 121), INT8_C( -77), INT8_C(  64), INT8_C(-105),
                           INT8_C( -59), INT8_C(  68), INT8_C(  37), INT8_C( 123),
                           INT8_C( -35), INT8_C(-104), INT8_C(  26), INT8_C( 111),
                           INT8_C(-117), INT8_C(  -3), INT8_C( 125), INT8_C(-126),
                           INT8_C(  35), INT8_C( 127), INT8_C(  14), INT8_C( 124),
                           INT8_C( -32), INT8_C(  64), INT8_C(  -6), INT8_C(   5),
                           INT8_C( -90), INT8_C(  20), INT8_C( -31), INT8_C(  65),
                           INT8_C(  -8), INT8_C(  96), INT8_C(  18), INT8_C(  58),
                           INT8_C( 122), INT8_C(   7), INT8_C(  79), INT8_C(-100),
                           INT8_C( -48), INT8_C(  91), INT8_C(  -3), INT8_C(-127),
                           INT8_C(  14), INT8_C(-111), INT8_C(  27), INT8_C( -76)),
      simde_mm512_set_epi8(INT8_C(   3), INT8_C( -99), INT8_C(   5), INT8_C(  91),
                           INT8_C(  76), INT8_C( -65), INT8_C( -10), INT8_C( -12),
                           INT8_C( -73), INT8_C( 117), INT8_C(-114), INT8_C( -69),
                           INT8_C(-117), INT8_C( -76), INT8_C(  67), INT8_C(-115),
                           INT8_C(  95), INT8_C(  63), INT8_C(-121), INT8_C(  59),
                           INT8_C( -53), INT8_C( -35), INT8_C(  37), INT8_C( -31),
                           INT8_C( -96), INT8_C(  81), INT8_C(  92), INT8_C( -51),
                           INT8_C(  48), INT8_C( -43), INT8_C(   1), INT8_C( -58),
                           INT8_C(   7), INT8_C(-121), INT8_C(  35), INT8_C( -53),
                           INT8_C(  31), INT8_C( -93), INT8_C(  71), INT8_C( -88),
                           INT8_C( 118), INT8_C(  62), INT8_C(  61), INT8_C(  63),
                           INT8_C(  14), INT8_C(  14), INT8_C(  31), INT8_C( 112),
                           INT8_C(-116), INT8_C( -66), INT8_C( 120), INT8_C( 120),
                           INT8_C(  41), INT8_C(  92), INT8_C(  86), INT8_C(-109),
                           INT8_C( 117), INT8_C(  88), INT8_C( -38), INT8_C( -50),
                           INT8_C( -20), INT8_C( -14), INT8_C(  13), INT8_C(-126)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C( -20), INT8_C( -55), INT8_C(  25), INT8_C(   0),
                           INT8_C(-101), INT8_C( -70), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-101),
                           INT8_C(   0), INT8_C(   0), INT8_C(   5), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -89),
                           INT8_C( 126), INT8_C( -67), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   5), INT8_C(   0),
                           INT8_C(-115), INT8_C(   0), INT8_C(   0), INT8_C( 106),
                           INT8_C(  27), INT8_C(-120), INT8_C(  11), INT8_C(   0),
                           INT8_C( -79), INT8_C(  62), INT8_C( 123), INT8_C(-116),
                           INT8_C(  52), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -51), INT8_C(-109), INT8_C(   0),
                           INT8_C( -34), INT8_C(-114), INT8_C( -35), INT8_C(-114),
                           INT8_C(   0), INT8_C(  20), INT8_C( 108), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  43), INT8_C(   0)) },
    { UINT64_C( 3162617222919180835),
      simde_mm512_set_epi8(INT8_C( -66), INT8_C( -70), INT8_C(-120), INT8_C(  26),
                           INT8_C( -56), INT8_C(-100), INT8_C(  43), INT8_C(-114),
                           INT8_C( -92), INT8_C(-121), INT8_C(  78), INT8_C(  54),
                           INT8_C( -41), INT8_C( 118), INT8_C( -81), INT8_C(  86),
                           INT8_C(-103), INT8_C( 105), INT8_C(-114), INT8_C(-114),
                           INT8_C( -29), INT8_C(-127), INT8_C( 122), INT8_C(  87),
                           INT8_C(-115), INT8_C( 123), INT8_C( -93), INT8_C(  59),
                           INT8_C(  66), INT8_C(  53), INT8_C( -76), INT8_C(  34),
                           INT8_C(  80), INT8_C( 112), INT8_C( -24), INT8_C( -52),
                           INT8_C(  68), INT8_C(  70), INT8_C(   6), INT8_C(  61),
                           INT8_C(-102), INT8_C( -31), INT8_C( -61), INT8_C(  -1),
                           INT8_C(  87), INT8_C(  86), INT8_C( -19), INT8_C(-118),
                           INT8_C(  56), INT8_C( 110), INT8_C(  34), INT8_C(  85),
                           INT8_C(  25), INT8_C( -71), INT8_C(-127), INT8_C(   0),
                           INT8_C(  99), INT8_C(  28), INT8_C(   1), INT8_C( -35),
                           INT8_C( -39), INT8_C( -86), INT8_C( -44), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C(  93), INT8_C( 113), INT8_C( -28), INT8_C( 100),
                           INT8_C( -99), INT8_C(-106), INT8_C(-107), INT8_C( -54),
                           INT8_C( 121), INT8_C( -69), INT8_C( -17), INT8_C(   9),
                           INT8_C( -15), INT8_C( -58), INT8_C(-102), INT8_C( -34),
                           INT8_C(  -5), INT8_C(  28), INT8_C(  80), INT8_C( -95),
                           INT8_C( -19), INT8_C(  42), INT8_C(  52), INT8_C( -49),
                           INT8_C( -78), INT8_C( 121), INT8_C( 126), INT8_C( 119),
                           INT8_C(  15), INT8_C(  89), INT8_C(  74), INT8_C(  97),
                           INT8_C(  -1), INT8_C( 108), INT8_C(   6), INT8_C( 104),
                           INT8_C( -14), INT8_C(  32), INT8_C(  24), INT8_C(  11),
                           INT8_C(  24), INT8_C(  56), INT8_C(-122), INT8_C(   6),
                           INT8_C( 113), INT8_C( -67), INT8_C(-122), INT8_C( -34),
                           INT8_C(  29), INT8_C( -45), INT8_C( -10), INT8_C(  88),
                           INT8_C(-127), INT8_C(  63), INT8_C( -37), INT8_C(  20),
                           INT8_C( -46), INT8_C(  91), INT8_C(  -7), INT8_C(  17),
                           INT8_C(-101), INT8_C( -78), INT8_C(-112), INT8_C( -57)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( -38), INT8_C(   0),
                           INT8_C(  85), INT8_C(   0), INT8_C( -45), INT8_C(   7),
                           INT8_C(  -6), INT8_C(  20), INT8_C(-121), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -52), INT8_C(-101),
                           INT8_C(  75), INT8_C( 121), INT8_C(   0), INT8_C( -26),
                           INT8_C( -14), INT8_C( -65), INT8_C(   6), INT8_C(-121),
                           INT8_C( 110), INT8_C(   0), INT8_C(   0), INT8_C(-114),
                           INT8_C(  12), INT8_C(   0), INT8_C(   2), INT8_C( 109),
                           INT8_C( -11), INT8_C(   0), INT8_C(  69), INT8_C(   0),
                           INT8_C(   0), INT8_C(  54), INT8_C(   0), INT8_C(   0),
                           INT8_C(-121), INT8_C(   0), INT8_C(  55), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  52),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C( -56),
                           INT8_C(   0), INT8_C(   0), INT8_C(-102), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  33), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  50), INT8_C(  83)) },
    { UINT64_C(16489290895671470027),
      simde_mm512_set_epi8(INT8_C( -45), INT8_C(  89), INT8_C( -24), INT8_C(  92),
                           INT8_C(   7), INT8_C(  49), INT8_C( 106), INT8_C( -69),
                           INT8_C( -61), INT8_C( -44), INT8_C(  92), INT8_C(  28),
                           INT8_C(  21), INT8_C( -36), INT8_C( -96), INT8_C(  50),
                           INT8_C( 107), INT8_C( 124), INT8_C( -95), INT8_C( 119),
                           INT8_C( -70), INT8_C(  31), INT8_C(-107), INT8_C(  56),
                           INT8_C( 114), INT8_C(  64), INT8_C( -41), INT8_C(-112),
                           INT8_C( -98), INT8_C( -51), INT8_C(  83), INT8_C(  93),
                           INT8_C(  63), INT8_C( -30), INT8_C( -83), INT8_C(  98),
                           INT8_C( 110), INT8_C(  -3), INT8_C( 105), INT8_C( -23),
                           INT8_C( -52), INT8_C(-101), INT8_C( 102), INT8_C(-127),
                           INT8_C( -21), INT8_C( 125), INT8_C(  50), INT8_C( -75),
                           INT8_C(  86), INT8_C(  40), INT8_C( -12), INT8_C(  70),
                           INT8_C( -13), INT8_C( -31), INT8_C(-109), INT8_C(  62),
                           INT8_C( -49), INT8_C(  54), INT8_C(-125), INT8_C( 111),
                           INT8_C(  64), INT8_C( -66), INT8_C(  -4), INT8_C(-122)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C( 109), INT8_C( 110), INT8_C(  60),
                           INT8_C( -93), INT8_C(   6), INT8_C( 127), INT8_C(  94),
                           INT8_C( 103), INT8_C(-123), INT8_C( -94), INT8_C( -49),
                           INT8_C(-110), INT8_C(-117), INT8_C( -20), INT8_C( -24),
                           INT8_C(-118), INT8_C(-114), INT8_C(  58), INT8_C(  97),
                           INT8_C(-121), INT8_C(-105), INT8_C(  15), INT8_C(  90),
                           INT8_C(  56), INT8_C( -93), INT8_C(  -6), INT8_C( -16),
                           INT8_C( 110), INT8_C(   3), INT8_C(  -8), INT8_C( -93),
                           INT8_C(  96), INT8_C(-124), INT8_C( -43), INT8_C( 119),
                           INT8_C( -95), INT8_C( 114), INT8_C(-109), INT8_C( -39),
                           INT8_C(  -1), INT8_C( 101), INT8_C( 115), INT8_C(  83),
                           INT8_C(  28), INT8_C( -34), INT8_C(-109), INT8_C( -97),
                           INT8_C( -33), INT8_C(-115), INT8_C( -46), INT8_C(  86),
                           INT8_C( -86), INT8_C( -28), INT8_C( -72), INT8_C(   4),
                           INT8_C( -56), INT8_C( -54), INT8_C( -60), INT8_C(  85),
                           INT8_C(  73), INT8_C(   2), INT8_C( -40), INT8_C( -46)),
      simde_mm512_set_epi8(INT8_C(   7), INT8_C(  45), INT8_C(  -8), INT8_C(   0),
                           INT8_C(   0), INT8_C( 123), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -45), INT8_C(   0), INT8_C(  12),
                           INT8_C(   0), INT8_C(  59), INT8_C(   0), INT8_C(  87),
                           INT8_C( 115), INT8_C(   0), INT8_C(  -8), INT8_C(  98),
                           INT8_C(  20), INT8_C(   0), INT8_C(  34), INT8_C(   0),
                           INT8_C( -57), INT8_C(   0), INT8_C( 100), INT8_C(  60),
                           INT8_C(   0), INT8_C( -54), INT8_C(   0), INT8_C(   0),
                           INT8_C(  80), INT8_C(   0), INT8_C(   2), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( 119), INT8_C(   0),
                           INT8_C( 115), INT8_C(   0), INT8_C(   0), INT8_C(-111),
                           INT8_C(   0), INT8_C( -89), INT8_C(   0), INT8_C(   0),
                           INT8_C( 105), INT8_C(   0), INT8_C( 115), INT8_C(   0),
                           INT8_C(   0), INT8_C(-106), INT8_C(-101), INT8_C( 103),
                           INT8_C(  66), INT8_C( -39), INT8_C(   0), INT8_C(   0),
                           INT8_C(  96), INT8_C(   0), INT8_C(  48), INT8_C( -42)) },
    { UINT64_C( 6084884706841798472),
      simde_mm512_set_epi8(INT8_C(-112), INT8_C(-125), INT8_C( -27), INT8_C( -87),
                           INT8_C(  -3), INT8_C( -45), INT8_C( 106), INT8_C(  28),
                           INT8_C(  41), INT8_C( -37), INT8_C(-117), INT8_C(  95),
                           INT8_C( -14), INT8_C(-122), INT8_C( -91), INT8_C( -89),
                           INT8_C( -40), INT8_C(  17), INT8_C( -71), INT8_C(  29),
                           INT8_C(-114), INT8_C(  39), INT8_C( -61), INT8_C(-105),
                           INT8_C(  -8), INT8_C( -35), INT8_C(  35), INT8_C(  20),
                           INT8_C(  59), INT8_C( -64), INT8_C(  20), INT8_C( -16),
                           INT8_C(-106), INT8_C( -49), INT8_C(  -6), INT8_C( 106),
                           INT8_C( -37), INT8_C(  21), INT8_C(  -6), INT8_C( -23),
                           INT8_C( 118), INT8_C( -97), INT8_C(-119), INT8_C( -44),
                           INT8_C(  83), INT8_C( 102), INT8_C(  74), INT8_C(-114),
                           INT8_C(  95), INT8_C( -75), INT8_C( -52), INT8_C(  24),
                           INT8_C( -86), INT8_C(  91), INT8_C( -23), INT8_C( -49),
                           INT8_C( 111), INT8_C( -77), INT8_C(   6), INT8_C(  42),
                           INT8_C( 120), INT8_C( -42), INT8_C(  70), INT8_C(  14)),
      simde_mm512_set_epi8(INT8_C(  16), INT8_C( -91), INT8_C(  46), INT8_C( -50),
                           INT8_C( 114), INT8_C( -52), INT8_C(  74), INT8_C( -49),
                           INT8_C(  12), INT8_C(  87), INT8_C( 122), INT8_C(  68),
                           INT8_C(  75), INT8_C(  81), INT8_C( -37), INT8_C(  -8),
                           INT8_C( -53), INT8_C( 104), INT8_C(  84), INT8_C(-122),
                           INT8_C( -31), INT8_C( -86), INT8_C( -25), INT8_C( 110),
                           INT8_C(  -6), INT8_C(  33), INT8_C( -77), INT8_C( -84),
                           INT8_C(   8), INT8_C(  51), INT8_C(-125), INT8_C( -60),
                           INT8_C( -65), INT8_C(  89), INT8_C( -90), INT8_C(-126),
                           INT8_C( -87), INT8_C(  53), INT8_C(  10), INT8_C(  80),
                           INT8_C(  63), INT8_C( -90), INT8_C(  32), INT8_C( -78),
                           INT8_C( -95), INT8_C(  -2), INT8_C(-119), INT8_C(  67),
                           INT8_C(-107), INT8_C( -81), INT8_C(  37), INT8_C( 116),
                           INT8_C( -57), INT8_C(  58), INT8_C(-116), INT8_C( 117),
                           INT8_C(  93), INT8_C( 117), INT8_C(-121), INT8_C( -82),
                           INT8_C( -77), INT8_C(-126), INT8_C( -76), INT8_C( -31)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  75), INT8_C(   0), INT8_C( 109),
                           INT8_C(   0), INT8_C( -94), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-106), INT8_C(-114), INT8_C(  93),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -44),
                           INT8_C( -74), INT8_C( -22), INT8_C(   0), INT8_C(-123),
                           INT8_C(  64), INT8_C(   0), INT8_C( -87), INT8_C(   0),
                           INT8_C(   0), INT8_C(  33), INT8_C(-109), INT8_C(   0),
                           INT8_C(   0), INT8_C( -13), INT8_C(  18), INT8_C(   0),
                           INT8_C( 105), INT8_C(  40), INT8_C(   0), INT8_C(  22),
                           INT8_C( -82), INT8_C(   0), INT8_C( -88), INT8_C(   0),
                           INT8_C(-127), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -43), INT8_C(  44),
                           INT8_C(   0), INT8_C(   0), INT8_C( -55), INT8_C(   0),
                           INT8_C(   0), INT8_C(  73), INT8_C(  47), INT8_C( 108),
                           INT8_C(   0), INT8_C(  97), INT8_C(   0), INT8_C(   0),
                           INT8_C( -68), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(16466136098061989415),
      simde_mm512_set_epi8(INT8_C( -81), INT8_C( 119), INT8_C( -63), INT8_C( -22),
                           INT8_C(-118), INT8_C(  -5), INT8_C( -43), INT8_C( -96),
                           INT8_C(-103), INT8_C(  22), INT8_C(  19), INT8_C(  79),
                           INT8_C(  40), INT8_C(  50), INT8_C( -52), INT8_C( -40),
                           INT8_C( -71), INT8_C(  37), INT8_C( -98), INT8_C( 112),
                           INT8_C( 106), INT8_C(  49), INT8_C( -36), INT8_C( -93),
                           INT8_C(  66), INT8_C( -50), INT8_C(-100), INT8_C( -11),
                           INT8_C( 123), INT8_C(  32), INT8_C( -64), INT8_C( -56),
                           INT8_C(  95), INT8_C( -27), INT8_C( -37), INT8_C(  82),
                           INT8_C( -65), INT8_C(  74), INT8_C( 101), INT8_C( -10),
                           INT8_C( 104), INT8_C( -53), INT8_C( 118), INT8_C(  34),
                           INT8_C(  19), INT8_C(  -6), INT8_C(-103), INT8_C(  93),
                           INT8_C( 101), INT8_C( 100), INT8_C( -55), INT8_C( 108),
                           INT8_C(   6), INT8_C( -85), INT8_C(   4), INT8_C( -17),
                           INT8_C(-116), INT8_C( 108), INT8_C(  39), INT8_C(  48),
                           INT8_C( -56), INT8_C( -50), INT8_C( -30), INT8_C( -76)),
      simde_mm512_set_epi8(INT8_C(  39), INT8_C(  12), INT8_C( -93), INT8_C( -40),
                           INT8_C(  15), INT8_C( 114), INT8_C(  37), INT8_C( -75),
                           INT8_C( -90), INT8_C(  35), INT8_C( 103), INT8_C( -54),
                           INT8_C(  73), INT8_C( -37), INT8_C(   9), INT8_C(  80),
                           INT8_C(  26), INT8_C( -85), INT8_C(  -3), INT8_C(  57),
                           INT8_C( -52), INT8_C( -30), INT8_C( -59), INT8_C(   8),
                           INT8_C( -56), INT8_C(  70), INT8_C(  58), INT8_C(  -6),
                           INT8_C( -31), INT8_C(  86), INT8_C( -56), INT8_C( -31),
                           INT8_C( -79), INT8_C(  14), INT8_C(  39), INT8_C(-116),
                           INT8_C( -35), INT8_C(  92), INT8_C(  -7), INT8_C(-122),
                           INT8_C( -44), INT8_C(-112), INT8_C( 127), INT8_C(  54),
                           INT8_C(  84), INT8_C( 113), INT8_C(  62), INT8_C( -16),
                           INT8_C(  -9), INT8_C( -30), INT8_C(-125), INT8_C(  52),
                           INT8_C(  95), INT8_C( 118), INT8_C(  32), INT8_C( -80),
                           INT8_C( -77), INT8_C( -73), INT8_C( 106), INT8_C(-116),
                           INT8_C( -44), INT8_C( 115), INT8_C( 124), INT8_C(  50)),
      simde_mm512_set_epi8(INT8_C(  -1), INT8_C( -23), INT8_C( -50), INT8_C(   0),
                           INT8_C(   0), INT8_C( -84), INT8_C(   0), INT8_C(   0),
                           INT8_C(  56), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  87), INT8_C( -14),
                           INT8_C(   0), INT8_C(-117), INT8_C(  44), INT8_C( -24),
                           INT8_C(   0), INT8_C( -46), INT8_C( 123), INT8_C(-118),
                           INT8_C( 106), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   7), INT8_C(   0), INT8_C( -99), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -50), INT8_C(  56),
                           INT8_C(   0), INT8_C(  51), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   8), INT8_C(  31),
                           INT8_C(  40), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  75), INT8_C(   0), INT8_C(  14), INT8_C(  78),
                           INT8_C(   0), INT8_C( -31), INT8_C(-122), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-122), INT8_C(   0),
                           INT8_C(   0), INT8_C(  97), INT8_C(-112), INT8_C( -22)) },
    { UINT64_C(10141573627661406757),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C(  28), INT8_C( -98), INT8_C(  53),
                           INT8_C(  38), INT8_C( -97), INT8_C(  41), INT8_C(  23),
                           INT8_C( -69), INT8_C(  29), INT8_C(-117), INT8_C(  81),
                           INT8_C(  91), INT8_C( -84), INT8_C(  67), INT8_C( -26),
                           INT8_C(-106), INT8_C(  41), INT8_C( -18), INT8_C(  77),
                           INT8_C(  80), INT8_C( 122), INT8_C(  27), INT8_C(   7),
                           INT8_C( -44), INT8_C( 117), INT8_C(  58), INT8_C( -92),
                           INT8_C(  91), INT8_C(-116), INT8_C( -45), INT8_C( -65),
                           INT8_C( 110), INT8_C( -99), INT8_C(  26), INT8_C(  95),
                           INT8_C( -85), INT8_C(-102), INT8_C( 106), INT8_C(  71),
                           INT8_C(  -2), INT8_C(  90), INT8_C(  49), INT8_C(-107),
                           INT8_C(  41), INT8_C( -92), INT8_C(-110), INT8_C(  38),
                           INT8_C(  38), INT8_C(  15), INT8_C( -94), INT8_C( -90),
                           INT8_C( 107), INT8_C( -97), INT8_C(  21), INT8_C(  27),
                           INT8_C( -10), INT8_C(-108), INT8_C( -20), INT8_C( -86),
                           INT8_C(  23), INT8_C(  68), INT8_C( -52), INT8_C(-120)),
      simde_mm512_set_epi8(INT8_C(  61), INT8_C( -61), INT8_C(  13), INT8_C(   2),
                           INT8_C( -62), INT8_C(-117), INT8_C( 105), INT8_C( -23),
                           INT8_C(  79), INT8_C(  54), INT8_C( -95), INT8_C( -18),
                           INT8_C(  97), INT8_C(  38), INT8_C( -79), INT8_C( -93),
                           INT8_C(  75), INT8_C(  -4), INT8_C( -52), INT8_C( -36),
                           INT8_C(  23), INT8_C(  21), INT8_C( -48), INT8_C( -79),
                           INT8_C(  10), INT8_C( -23), INT8_C(  -6), INT8_C(  57),
                           INT8_C( 126), INT8_C(  10), INT8_C( -59), INT8_C(  45),
                           INT8_C(  35), INT8_C(  45), INT8_C(  17), INT8_C(  32),
                           INT8_C(  74), INT8_C( -19), INT8_C( -96), INT8_C( 111),
                           INT8_C(   9), INT8_C(   3), INT8_C(-116), INT8_C( 122),
                           INT8_C(-109), INT8_C(  90), INT8_C( -38), INT8_C( -19),
                           INT8_C(  89), INT8_C( -28), INT8_C(  79), INT8_C( -48),
                           INT8_C( 127), INT8_C(  39), INT8_C( -62), INT8_C(  57),
                           INT8_C( -98), INT8_C( 124), INT8_C( -59), INT8_C(-117),
                           INT8_C(-125), INT8_C( 101), INT8_C(  26), INT8_C( 113)),
      simde_mm512_set_epi8(INT8_C(  66), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  65), INT8_C(  49), INT8_C(   0), INT8_C(   0),
                           INT8_C( -72), INT8_C(   0), INT8_C(   4), INT8_C(  49),
                           INT8_C(-109), INT8_C( -81), INT8_C( -40), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 112),
                           INT8_C(  10), INT8_C(   0), INT8_C( -22), INT8_C(  33),
                           INT8_C(   0), INT8_C( 113), INT8_C( -73), INT8_C( -73),
                           INT8_C( -75), INT8_C(   0), INT8_C(  76), INT8_C( -21),
                           INT8_C(   0), INT8_C( 108), INT8_C(-104), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -36), INT8_C(   4),
                           INT8_C(  73), INT8_C(   0), INT8_C( 105), INT8_C(   0),
                           INT8_C(   0), INT8_C( -35), INT8_C(   0), INT8_C(   5),
                           INT8_C(   0), INT8_C(   0), INT8_C( -91), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -54), INT8_C(   0),
                           INT8_C(   0), INT8_C(  62), INT8_C(   0), INT8_C( -23)) },
    { UINT64_C( 9475610514207139221),
      simde_mm512_set_epi8(INT8_C(-118), INT8_C( 118), INT8_C(  91), INT8_C(  46),
                           INT8_C(-114), INT8_C( -42), INT8_C(  89), INT8_C(  67),
                           INT8_C( 116), INT8_C( 126), INT8_C(   1), INT8_C( -41),
                           INT8_C(  65), INT8_C(-125), INT8_C(  78), INT8_C( 101),
                           INT8_C(-117), INT8_C( -31), INT8_C(  78), INT8_C( 100),
                           INT8_C(  23), INT8_C(  20), INT8_C(  26), INT8_C(  22),
                           INT8_C( 127), INT8_C( -64), INT8_C(-101), INT8_C( 121),
                           INT8_C(   1), INT8_C( 115), INT8_C(  26), INT8_C(  10),
                           INT8_C(-106), INT8_C(   7), INT8_C( -61), INT8_C(-100),
                           INT8_C(  98), INT8_C(  89), INT8_C( -63), INT8_C( -47),
                           INT8_C( -25), INT8_C( -25), INT8_C( -72), INT8_C(-114),
                           INT8_C(  10), INT8_C(  82), INT8_C( -92), INT8_C( -12),
                           INT8_C( -47), INT8_C( -28), INT8_C( -48), INT8_C(  53),
                           INT8_C( -55), INT8_C(  77), INT8_C( -44), INT8_C(  56),
                           INT8_C( 116), INT8_C(-126), INT8_C(   6), INT8_C(  75),
                           INT8_C( 121), INT8_C( -27), INT8_C(  70), INT8_C( -31)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C( 122), INT8_C( -84), INT8_C( -42),
                           INT8_C(  39), INT8_C(  29), INT8_C(-115), INT8_C( -86),
                           INT8_C( -59), INT8_C( -20), INT8_C( -12), INT8_C(-109),
                           INT8_C( 101), INT8_C( -88), INT8_C( -86), INT8_C(  53),
                           INT8_C(  71), INT8_C(  13), INT8_C( -92), INT8_C( -64),
                           INT8_C(  27), INT8_C(  27), INT8_C(-118), INT8_C(  46),
                           INT8_C(  77), INT8_C( -63), INT8_C(  15), INT8_C( 115),
                           INT8_C(-127), INT8_C( 113), INT8_C(-122), INT8_C(-128),
                           INT8_C( -15), INT8_C(  46), INT8_C(   1), INT8_C( -61),
                           INT8_C( -47), INT8_C( -78), INT8_C( -25), INT8_C( -43),
                           INT8_C(  27), INT8_C( -59), INT8_C( -58), INT8_C(  14),
                           INT8_C( -30), INT8_C(  21), INT8_C( -79), INT8_C(  73),
                           INT8_C( -11), INT8_C(  23), INT8_C(   2), INT8_C(  25),
                           INT8_C( -11), INT8_C(  76), INT8_C(-126), INT8_C( -38),
                           INT8_C(   7), INT8_C( -48), INT8_C(-125), INT8_C( -67),
                           INT8_C(  74), INT8_C( -92), INT8_C( -44), INT8_C(  92)),
      simde_mm512_set_epi8(INT8_C(  15), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   9), INT8_C(  95),
                           INT8_C(  69), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  50), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -7),
                           INT8_C( -89), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-128), INT8_C( -25), INT8_C( -34), INT8_C( -10),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 111), INT8_C(   0), INT8_C(   0), INT8_C( -13),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  85), INT8_C(   0), INT8_C(  96),
                           INT8_C(  95), INT8_C(  -3), INT8_C(  68), INT8_C(   0),
                           INT8_C(   0), INT8_C(-114), INT8_C(   0), INT8_C( -99),
                           INT8_C( 102), INT8_C(   0), INT8_C(   0), INT8_C( -19),
                           INT8_C(   0), INT8_C( -49), INT8_C(   0), INT8_C(  38)) },
    { UINT64_C( 3401470949633102944),
      simde_mm512_set_epi8(INT8_C(-104), INT8_C(-104), INT8_C(-124), INT8_C( -27),
                           INT8_C(  -3), INT8_C(  93), INT8_C( 108), INT8_C(   0),
                           INT8_C( -69), INT8_C( -66), INT8_C(  77), INT8_C(  58),
                           INT8_C( -19), INT8_C( 100), INT8_C(-128), INT8_C( -58),
                           INT8_C(   7), INT8_C(  -9), INT8_C( -26), INT8_C(-108),
                           INT8_C(  35), INT8_C(  86), INT8_C( -43), INT8_C( -27),
                           INT8_C(  28), INT8_C(-101), INT8_C(  36), INT8_C( -57),
                           INT8_C( -58), INT8_C( -71), INT8_C( -70), INT8_C( -23),
                           INT8_C( -36), INT8_C( -65), INT8_C( -77), INT8_C( 109),
                           INT8_C( -18), INT8_C( 121), INT8_C(  64), INT8_C(  98),
                           INT8_C( 123), INT8_C( -41), INT8_C(-125), INT8_C( -77),
                           INT8_C( -97), INT8_C( -69), INT8_C( -26), INT8_C( -51),
                           INT8_C( -68), INT8_C( -76), INT8_C( -28), INT8_C( -68),
                           INT8_C( 123), INT8_C(-118), INT8_C( 117), INT8_C( -62),
                           INT8_C( 121), INT8_C(   3), INT8_C(  62), INT8_C(  -4),
                           INT8_C(-118), INT8_C( -53), INT8_C(-107), INT8_C(  26)),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C(-120), INT8_C(  -7), INT8_C( -23),
                           INT8_C(  43), INT8_C( 101), INT8_C( -13), INT8_C( -38),
                           INT8_C(  26), INT8_C( -88), INT8_C( -66), INT8_C(  89),
                           INT8_C( -49), INT8_C( -11), INT8_C(  84), INT8_C(  63),
                           INT8_C(  60), INT8_C(-112), INT8_C(  94), INT8_C(  33),
                           INT8_C(  90), INT8_C(  39), INT8_C( -66), INT8_C(-115),
                           INT8_C( -83), INT8_C(-100), INT8_C(  33), INT8_C( 122),
                           INT8_C(  63), INT8_C( -80), INT8_C(  28), INT8_C( -93),
                           INT8_C( -72), INT8_C(   6), INT8_C(  39), INT8_C( -53),
                           INT8_C(  31), INT8_C( -90), INT8_C(-102), INT8_C( -51),
                           INT8_C( -61), INT8_C( -92), INT8_C(  73), INT8_C(  54),
                           INT8_C( 120), INT8_C(  92), INT8_C(  79), INT8_C(  73),
                           INT8_C(  26), INT8_C(  -5), INT8_C(-126), INT8_C( 101),
                           INT8_C(  59), INT8_C(  51), INT8_C( -54), INT8_C( -55),
                           INT8_C(   1), INT8_C(  26), INT8_C( -69), INT8_C( 103),
                           INT8_C(  37), INT8_C(   8), INT8_C(  21), INT8_C( -87)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(  80), INT8_C(   0),
                           INT8_C( -25), INT8_C(  84), INT8_C(-111), INT8_C( -65),
                           INT8_C(   0), INT8_C(   0), INT8_C(  20), INT8_C(  -2),
                           INT8_C(   0), INT8_C(-107), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 110), INT8_C(-111), INT8_C( -49),
                           INT8_C(   0), INT8_C(   0), INT8_C( 115), INT8_C(  77),
                           INT8_C( -51), INT8_C(  48), INT8_C(   0), INT8_C(   0),
                           INT8_C( -33), INT8_C(  21), INT8_C(  24), INT8_C(   0),
                           INT8_C( -32), INT8_C(   0), INT8_C(   0), INT8_C( -31),
                           INT8_C(   0), INT8_C(   0), INT8_C(  55), INT8_C(   0),
                           INT8_C(  16), INT8_C(   0), INT8_C(  48), INT8_C(  18),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  18),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -85),
                           INT8_C(   0), INT8_C( -35), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 108), INT8_C(-107), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_gf2p8affine_epi64_epi8(test_vec[i].k, test_vec[i].x, test_vec[i].A, 191);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i x;
    simde__m128i A;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C(  58), INT8_C( -43), INT8_C(  69), INT8_C(  40),
                        INT8_C( -27), INT8_C(-105), INT8_C(  74), INT8_C(-119),
                        INT8_C(  24), INT8_C( -36), INT8_C(  85), INT8_C(  31),
                        INT8_C(  10), INT8_C( -63), INT8_C(   1), INT8_C( 111)),
      simde_mm_set_epi8(INT8_C( -23), INT8_C(  64), INT8_C(  17), INT8_C(-118),
                        INT8_C(-108), INT8_C(-111), INT8_C(   0), INT8_C(  45),
                        INT8_C(  94), INT8_C(  64), INT8_C(  99), INT8_C( -32),
                        INT8_C(  92), INT8_C( -94), INT8_C( 121), INT8_C( 115)),
      simde_mm_set_epi8(INT8_C( -73), INT8_C(  28), INT8_C(  38), INT8_C( -87),
                        INT8_C(  39), INT8_C(-120), INT8_C( -86), INT8_C(  42),
                        INT8_C( 105), INT8_C(  75), INT8_C( -53), INT8_C(-122),
                        INT8_C(  79), INT8_C(-117), INT8_C( -14), INT8_C(  59)) },
    { simde_mm_set_epi8(INT8_C( 125), INT8_C(  92), INT8_C( -40), INT8_C(  78),
                        INT8_C( -48), INT8_C(-102), INT8_C( -48), INT8_C( -60),
                        INT8_C(-104), INT8_C(  50), INT8_C( 111), INT8_C( -80),
                        INT8_C(  75), INT8_C(  75), INT8_C( -50), INT8_C(  85)),
      simde_mm_set_epi8(INT8_C( -33), INT8_C(  19), INT8_C( -14), INT8_C(  38),
                        INT8_C( -80), INT8_C( -72), INT8_C(   4), INT8_C( -22),
                        INT8_C(  57), INT8_C( -46), INT8_C(  98), INT8_C( -35),
                        INT8_C(  77), INT8_C(-102), INT8_C(  53), INT8_C(  14)),
      simde_mm_set_epi8(INT8_C( -93), INT8_C(-121), INT8_C(  -3), INT8_C(  24),
                        INT8_C(  22), INT8_C( -48), INT8_C(  22), INT8_C(  31),
                        INT8_C( 108), INT8_C( -47), INT8_C(  94), INT8_C(  87),
                        INT8_C( -94), INT8_C( -94), INT8_C(  56), INT8_C( -85)) },
    { simde_mm_set_epi8(INT8_C( -18), INT8_C( -67), INT8_C( -39), INT8_C( -64),
                        INT8_C( -69), INT8_C( -25), INT8_C(  53), INT8_C(  -3),
                        INT8_C(  35), INT8_C( -75), INT8_C(-109), INT8_C(  14),
                        INT8_C( -96), INT8_C(-128), INT8_C(  82), INT8_C(  64)),
      simde_mm_set_epi8(INT8_C( 125), INT8_C( -15), INT8_C( -11), INT8_C(   2),
                        INT8_C(  36), INT8_C(  95), INT8_C(-105), INT8_C(-112),
                        INT8_C(  -4), INT8_C(  76), INT8_C(  54), INT8_C( -65),
                        INT8_C(  65), INT8_C(  18), INT8_C( -19), INT8_C( -94)),
      simde_mm_set_epi8(INT8_C( -19), INT8_C(  84), INT8_C( -34), INT8_C(  24),
                        INT8_C( -11), INT8_C( -44), INT8_C(-128), INT8_C(-104),
                        INT8_C(  20), INT8_C(-110), INT8_C( -12), INT8_C( 118),
                        INT8_C( -13), INT8_C(  11), INT8_C(  33), INT8_C(  71)) },
    { simde_mm_set_epi8(INT8_C(  -1), INT8_C(  76), INT8_C(-126), INT8_C(  62),
                        INT8_C(  70), INT8_C( -18), INT8_C(-123), INT8_C(-104),
                        INT8_C( -12), INT8_C( -12), INT8_C( 120), INT8_C(  -6),
                        INT8_C( -20), INT8_C(  70), INT8_C(  51), INT8_C( -27)),
      simde_mm_set_epi8(INT8_C( -65), INT8_C( -81), INT8_C(  -8), INT8_C( -60),
                        INT8_C( 123), INT8_C(  65), INT8_C( -54), INT8_C( -19),
                        INT8_C(  17), INT8_C( -96), INT8_C(  47), INT8_C(  16),
                        INT8_C(  48), INT8_C( 113), INT8_C(  -7), INT8_C( -55)),
      simde_mm_set_epi8(INT8_C( 127), INT8_C(  84), INT8_C( -12), INT8_C( -69),
                        INT8_C( -65), INT8_C(  44), INT8_C( -88), INT8_C(  37),
                        INT8_C( 100), INT8_C( 100), INT8_C(  -5), INT8_C(  -4),
                        INT8_C(-118), INT8_C(  -6), INT8_C(  96), INT8_C( -14)) },
    { simde_mm_set_epi8(INT8_C(  -4), INT8_C(  47), INT8_C( 110), INT8_C( -54),
                        INT8_C( -29), INT8_C( 114), INT8_C( -26), INT8_C( -27),
                        INT8_C(  82), INT8_C( -32), INT8_C( -46), INT8_C(  81),
                        INT8_C( 113), INT8_C( -64), INT8_C( -33), INT8_C(  40)),
      simde_mm_set_epi8(INT8_C(  25), INT8_C( -38), INT8_C( 109), INT8_C(  24),
                        INT8_C( -65), INT8_C( -78), INT8_C(-113), INT8_C( -16),
                        INT8_C(  14), INT8_C(  38), INT8_C( 121), INT8_C(  52),
                        INT8_C(-126), INT8_C(  39), INT8_C(  80), INT8_C( -84)),
      simde_mm_set_epi8(INT8_C(  28), INT8_C(  48), INT8_C( -41), INT8_C(  44),
                        INT8_C(-114), INT8_C(  12), INT8_C( 110), INT8_C(  79),
                        INT8_C( -71), INT8_C(  96), INT8_C(  21), INT8_C(  16),
                        INT8_C(  -8), INT8_C( -92), INT8_C(  78), INT8_C( -58)) },
    { simde_mm_set_epi8(INT8_C(  83), INT8_C(   5), INT8_C( 114), INT8_C(  83),
                        INT8_C(  22), INT8_C(  94), INT8_C( -39), INT8_C( -38),
                        INT8_C(  30), INT8_C(-105), INT8_C( 103), INT8_C( -18),
                        INT8_C(  92), INT8_C(  29), INT8_C( -79), INT8_C( -94)),
      simde_mm_set_epi8(INT8_C(  74), INT8_C( 100), INT8_C(-114), INT8_C(  59),
                        INT8_C(  73), INT8_C( -61), INT8_C(  30), INT8_C(-124),
                        INT8_C(  41), INT8_C( 101), INT8_C( -53), INT8_C( -66),
                        INT8_C(  55), INT8_C(  15), INT8_C(   6), INT8_C( 114)),
      simde_mm_set_epi8(INT8_C(-111), INT8_C(  32), INT8_C(  73), INT8_C(-111),
                        INT8_C(  15), INT8_C(  55), INT8_C(-102), INT8_C( 103),
                        INT8_C(-116), INT8_C(  79), INT8_C( 123), INT8_C(   5),
                        INT8_C(  31), INT8_C( -80), INT8_C(  39), INT8_C(   6)) },
    { simde_mm_set_epi8(INT8_C(  37), INT8_C(  18), INT8_C( 127), INT8_C(  -7),
                        INT8_C( -59), INT8_C( -34), INT8_C(   4), INT8_C(-122),
                        INT8_C(  76), INT8_C( -20), INT8_C(-120), INT8_C(  61),
                        INT8_C( 105), INT8_C(-116), INT8_C(  95), INT8_C(  77)),
      simde_mm_set_epi8(INT8_C( -26), INT8_C(  45), INT8_C( 112), INT8_C(  97),
                        INT8_C(  60), INT8_C(   9), INT8_C(  86), INT8_C( -33),
                        INT8_C(  14), INT8_C(  28), INT8_C(-121), INT8_C( -41),
                        INT8_C(-101), INT8_C(  24), INT8_C(   0), INT8_C(   2)),
      simde_mm_set_epi8(INT8_C(  48), INT8_C( -37), INT8_C( 118), INT8_C(   2),
                        INT8_C( 125), INT8_C(  99), INT8_C( -93), INT8_C( -36),
                        INT8_C(  11), INT8_C(  36), INT8_C( -94), INT8_C( -94),
                        INT8_C( -80), INT8_C(-106), INT8_C(-126), INT8_C(  37)) },
    { simde_mm_set_epi8(INT8_C(  59), INT8_C( -71), INT8_C( 127), INT8_C(  88),
                        INT8_C(  -2), INT8_C( -99), INT8_C(  37), INT8_C(-101),
                        INT8_C(  66), INT8_C( 123), INT8_C( -27), INT8_C(  88),
                        INT8_C( -48), INT8_C(  84), INT8_C( -82), INT8_C( -53)),
      simde_mm_set_epi8(INT8_C( 112), INT8_C(-103), INT8_C( -33), INT8_C( -60),
                        INT8_C( -26), INT8_C(  65), INT8_C( -62), INT8_C(  59),
                        INT8_C( -87), INT8_C(  60), INT8_C(-118), INT8_C(-122),
                        INT8_C( -40), INT8_C( 117), INT8_C( -94), INT8_C( -63)),
      simde_mm_set_epi8(INT8_C(  50), INT8_C(  38), INT8_C( -68), INT8_C(  55),
                        INT8_C( -19), INT8_C(   8), INT8_C( 119), INT8_C( -18),
                        INT8_C( -96), INT8_C(  80), INT8_C(  71), INT8_C(  19),
                        INT8_C(-116), INT8_C( -69), INT8_C(  37), INT8_C(  28)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_gf2p8affineinv_epi64_epi8(test_vec[i].x, test_vec[i].A, INT8_C(  54));
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m256i x;
    simde__m256i A;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( -23), INT8_C(  64), INT8_C(  17), INT8_C(-118),
                           INT8_C(-108), INT8_C(-111), INT8_C(   0), INT8_C(  45),
                           INT8_C(  94), INT8_C(  64), INT8_C(  99), INT8_C( -32),
                           INT8_C(  92), INT8_C( -94), INT8_C( 121), INT8_C( 115),
                           INT8_C(  58), INT8_C( -43), INT8_C(  69), INT8_C(  40),
                           INT8_C( -27), INT8_C(-105), INT8_C(  74), INT8_C(-119),
                           INT8_C(  24), INT8_C( -36), INT8_C(  85), INT8_C(  31),
                           INT8_C(  10), INT8_C( -63), INT8_C(   1), INT8_C( 111)),
      simde_mm256_set_epi8(INT8_C( -33), INT8_C(  19), INT8_C( -14), INT8_C(  38),
                           INT8_C( -80), INT8_C( -72), INT8_C(   4), INT8_C( -22),
                           INT8_C(  57), INT8_C( -46), INT8_C(  98), INT8_C( -35),
                           INT8_C(  77), INT8_C(-102), INT8_C(  53), INT8_C(  14),
                           INT8_C( 125), INT8_C(  92), INT8_C( -40), INT8_C(  78),
                           INT8_C( -48), INT8_C(-102), INT8_C( -48), INT8_C( -60),
                           INT8_C(-104), INT8_C(  50), INT8_C( 111), INT8_C( -80),
                           INT8_C(  75), INT8_C(  75), INT8_C( -50), INT8_C(  85)),
      simde_mm256_set_epi8(INT8_C( 110), INT8_C(  80), INT8_C(  -5), INT8_C(  68),
                           INT8_C(  42), INT8_C(-101), INT8_C(-116), INT8_C(  64),
                           INT8_C(-114), INT8_C( -33), INT8_C(  44), INT8_C( -47),
                           INT8_C( -96), INT8_C(  14), INT8_C( -68), INT8_C(  39),
                           INT8_C(-115), INT8_C( -42), INT8_C(  -5), INT8_C( -90),
                           INT8_C(   0), INT8_C(  13), INT8_C( 127), INT8_C(-125),
                           INT8_C(-122), INT8_C(  75), INT8_C(  70), INT8_C(  54),
                           INT8_C(  67), INT8_C(  -9), INT8_C(  56), INT8_C( -66)) },
    { simde_mm256_set_epi8(INT8_C( 125), INT8_C( -15), INT8_C( -11), INT8_C(   2),
                           INT8_C(  36), INT8_C(  95), INT8_C(-105), INT8_C(-112),
                           INT8_C(  -4), INT8_C(  76), INT8_C(  54), INT8_C( -65),
                           INT8_C(  65), INT8_C(  18), INT8_C( -19), INT8_C( -94),
                           INT8_C( -18), INT8_C( -67), INT8_C( -39), INT8_C( -64),
                           INT8_C( -69), INT8_C( -25), INT8_C(  53), INT8_C(  -3),
                           INT8_C(  35), INT8_C( -75), INT8_C(-109), INT8_C(  14),
                           INT8_C( -96), INT8_C(-128), INT8_C(  82), INT8_C(  64)),
      simde_mm256_set_epi8(INT8_C( -65), INT8_C( -81), INT8_C(  -8), INT8_C( -60),
                           INT8_C( 123), INT8_C(  65), INT8_C( -54), INT8_C( -19),
                           INT8_C(  17), INT8_C( -96), INT8_C(  47), INT8_C(  16),
                           INT8_C(  48), INT8_C( 113), INT8_C(  -7), INT8_C( -55),
                           INT8_C(  -1), INT8_C(  76), INT8_C(-126), INT8_C(  62),
                           INT8_C(  70), INT8_C( -18), INT8_C(-123), INT8_C(-104),
                           INT8_C( -12), INT8_C( -12), INT8_C( 120), INT8_C(  -6),
                           INT8_C( -20), INT8_C(  70), INT8_C(  51), INT8_C( -27)),
      simde_mm256_set_epi8(INT8_C( -71), INT8_C(  -5), INT8_C( -88), INT8_C( -84),
                           INT8_C(  93), INT8_C( -14), INT8_C( -95), INT8_C( -91),
                           INT8_C(-117), INT8_C(  17), INT8_C(  26), INT8_C( -16),
                           INT8_C( 101), INT8_C(  -8), INT8_C(  21), INT8_C(  62),
                           INT8_C( -24), INT8_C(  25), INT8_C( -66), INT8_C(  91),
                           INT8_C( -67), INT8_C( -47), INT8_C( -58), INT8_C(-109),
                           INT8_C(  -8), INT8_C( -48), INT8_C(-125), INT8_C(   4),
                           INT8_C(-116), INT8_C( -65), INT8_C(  -1), INT8_C( -84)) },
    { simde_mm256_set_epi8(INT8_C(  25), INT8_C( -38), INT8_C( 109), INT8_C(  24),
                           INT8_C( -65), INT8_C( -78), INT8_C(-113), INT8_C( -16),
                           INT8_C(  14), INT8_C(  38), INT8_C( 121), INT8_C(  52),
                           INT8_C(-126), INT8_C(  39), INT8_C(  80), INT8_C( -84),
                           INT8_C(  -4), INT8_C(  47), INT8_C( 110), INT8_C( -54),
                           INT8_C( -29), INT8_C( 114), INT8_C( -26), INT8_C( -27),
                           INT8_C(  82), INT8_C( -32), INT8_C( -46), INT8_C(  81),
                           INT8_C( 113), INT8_C( -64), INT8_C( -33), INT8_C(  40)),
      simde_mm256_set_epi8(INT8_C(  74), INT8_C( 100), INT8_C(-114), INT8_C(  59),
                           INT8_C(  73), INT8_C( -61), INT8_C(  30), INT8_C(-124),
                           INT8_C(  41), INT8_C( 101), INT8_C( -53), INT8_C( -66),
                           INT8_C(  55), INT8_C(  15), INT8_C(   6), INT8_C( 114),
                           INT8_C(  83), INT8_C(   5), INT8_C( 114), INT8_C(  83),
                           INT8_C(  22), INT8_C(  94), INT8_C( -39), INT8_C( -38),
                           INT8_C(  30), INT8_C(-105), INT8_C( 103), INT8_C( -18),
                           INT8_C(  92), INT8_C(  29), INT8_C( -79), INT8_C( -94)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( -35), INT8_C(  53), INT8_C( -86),
                           INT8_C( 100), INT8_C(  10), INT8_C( -28), INT8_C(  -1),
                           INT8_C( -48), INT8_C(  54), INT8_C(   9), INT8_C( -50),
                           INT8_C(-107), INT8_C(  28), INT8_C(  -3), INT8_C( -83),
                           INT8_C(  56), INT8_C(  28), INT8_C( -61), INT8_C( 106),
                           INT8_C( -77), INT8_C( 117), INT8_C(-123), INT8_C( -29),
                           INT8_C( -43), INT8_C( -97), INT8_C(   3), INT8_C( -27),
                           INT8_C(  47), INT8_C(  92), INT8_C(-116), INT8_C(  60)) },
    { simde_mm256_set_epi8(INT8_C( -26), INT8_C(  45), INT8_C( 112), INT8_C(  97),
                           INT8_C(  60), INT8_C(   9), INT8_C(  86), INT8_C( -33),
                           INT8_C(  14), INT8_C(  28), INT8_C(-121), INT8_C( -41),
                           INT8_C(-101), INT8_C(  24), INT8_C(   0), INT8_C(   2),
                           INT8_C(  37), INT8_C(  18), INT8_C( 127), INT8_C(  -7),
                           INT8_C( -59), INT8_C( -34), INT8_C(   4), INT8_C(-122),
                           INT8_C(  76), INT8_C( -20), INT8_C(-120), INT8_C(  61),
                           INT8_C( 105), INT8_C(-116), INT8_C(  95), INT8_C(  77)),
      simde_mm256_set_epi8(INT8_C( 112), INT8_C(-103), INT8_C( -33), INT8_C( -60),
                           INT8_C( -26), INT8_C(  65), INT8_C( -62), INT8_C(  59),
                           INT8_C( -87), INT8_C(  60), INT8_C(-118), INT8_C(-122),
                           INT8_C( -40), INT8_C( 117), INT8_C( -94), INT8_C( -63),
                           INT8_C(  59), INT8_C( -71), INT8_C( 127), INT8_C(  88),
                           INT8_C(  -2), INT8_C( -99), INT8_C(  37), INT8_C(-101),
                           INT8_C(  66), INT8_C( 123), INT8_C( -27), INT8_C(  88),
                           INT8_C( -48), INT8_C(  84), INT8_C( -82), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C(  71), INT8_C( -19), INT8_C( -57), INT8_C(  56),
                           INT8_C(-119), INT8_C(  25), INT8_C( -68), INT8_C(-108),
                           INT8_C(   9), INT8_C(  96), INT8_C( 104), INT8_C( -39),
                           INT8_C(  70), INT8_C(  25), INT8_C(-116), INT8_C( -51),
                           INT8_C( -68), INT8_C(  67), INT8_C( -85), INT8_C(  74),
                           INT8_C( -23), INT8_C(-127), INT8_C( -17), INT8_C(-120),
                           INT8_C( 109), INT8_C(  33), INT8_C( -19), INT8_C( -85),
                           INT8_C(  18), INT8_C( -70), INT8_C(-105), INT8_C(  40)) },
    { simde_mm256_set_epi8(INT8_C( -97), INT8_C(  10), INT8_C(  84), INT8_C(  49),
                           INT8_C(  94), INT8_C( -59), INT8_C( -83), INT8_C(  28),
                           INT8_C( -40), INT8_C( 110), INT8_C(  -8), INT8_C(  28),
                           INT8_C( -35), INT8_C(  -5), INT8_C(-119), INT8_C( -82),
                           INT8_C(  99), INT8_C(  84), INT8_C( 122), INT8_C(  69),
                           INT8_C( 115), INT8_C(   3), INT8_C(-108), INT8_C( -90),
                           INT8_C( -26), INT8_C( -78), INT8_C( -27), INT8_C( -66),
                           INT8_C( -90), INT8_C( -23), INT8_C(-125), INT8_C( -64)),
      simde_mm256_set_epi8(INT8_C( -20), INT8_C(-128), INT8_C(  30), INT8_C( -62),
                           INT8_C(-115), INT8_C(  37), INT8_C(  44), INT8_C(   9),
                           INT8_C(  62), INT8_C( 115), INT8_C( -32), INT8_C(  96),
                           INT8_C(  97), INT8_C(-125), INT8_C( 100), INT8_C( -75),
                           INT8_C( 118), INT8_C(-122), INT8_C( 110), INT8_C(  15),
                           INT8_C(  92), INT8_C( -45), INT8_C( -12), INT8_C(  60),
                           INT8_C(-110), INT8_C(  81), INT8_C(  58), INT8_C( -38),
                           INT8_C( 114), INT8_C( -35), INT8_C( -67), INT8_C(  20)),
      simde_mm256_set_epi8(INT8_C(  74), INT8_C(-120), INT8_C(  37), INT8_C(  64),
                           INT8_C(  84), INT8_C( -17), INT8_C(  54), INT8_C( -25),
                           INT8_C( 106), INT8_C( -31), INT8_C(-121), INT8_C( 123),
                           INT8_C(  43), INT8_C(  -9), INT8_C(  72), INT8_C( -42),
                           INT8_C( 109), INT8_C( -70), INT8_C( 106), INT8_C(-112),
                           INT8_C(  25), INT8_C(  95), INT8_C( -10), INT8_C( -53),
                           INT8_C(  44), INT8_C(-128), INT8_C(  29), INT8_C(  24),
                           INT8_C(  96), INT8_C(  39), INT8_C( -27), INT8_C( -97)) },
    { simde_mm256_set_epi8(INT8_C(-122), INT8_C(-125), INT8_C( 103), INT8_C( 110),
                           INT8_C(  98), INT8_C( -78), INT8_C(  -7), INT8_C( -29),
                           INT8_C( -88), INT8_C(  88), INT8_C(  10), INT8_C(  24),
                           INT8_C( 100), INT8_C( -11), INT8_C( -62), INT8_C(  52),
                           INT8_C(  97), INT8_C(  31), INT8_C( -35), INT8_C( 120),
                           INT8_C(   4), INT8_C(  -5), INT8_C(-110), INT8_C(   0),
                           INT8_C( -61), INT8_C(-127), INT8_C( -20), INT8_C(  85),
                           INT8_C( -84), INT8_C(  -4), INT8_C(-113), INT8_C(-106)),
      simde_mm256_set_epi8(INT8_C( 118), INT8_C( -60), INT8_C(  -8), INT8_C( -47),
                           INT8_C( -94), INT8_C(  14), INT8_C(-105), INT8_C( -53),
                           INT8_C( 120), INT8_C( 100), INT8_C(  83), INT8_C(  27),
                           INT8_C( -60), INT8_C(  75), INT8_C(  26), INT8_C( -28),
                           INT8_C(  71), INT8_C(  30), INT8_C(  66), INT8_C( -19),
                           INT8_C( -84), INT8_C( -56), INT8_C(-116), INT8_C( 117),
                           INT8_C(  51), INT8_C( -44), INT8_C(  73), INT8_C(  -1),
                           INT8_C( 111), INT8_C( 113), INT8_C( -22), INT8_C(  64)),
      simde_mm256_set_epi8(INT8_C(  60), INT8_C(  82), INT8_C(  58), INT8_C(  81),
                           INT8_C( -71), INT8_C(  63), INT8_C( -40), INT8_C(  85),
                           INT8_C( -15), INT8_C( -88), INT8_C(  74), INT8_C(  31),
                           INT8_C( 126), INT8_C( -59), INT8_C( -76), INT8_C(  37),
                           INT8_C(   5), INT8_C( -23), INT8_C(  57), INT8_C(  50),
                           INT8_C( -83), INT8_C( 108), INT8_C(-111), INT8_C(-116),
                           INT8_C( -37), INT8_C(  63), INT8_C(  34), INT8_C( -17),
                           INT8_C(  39), INT8_C(  67), INT8_C( -91), INT8_C( -36)) },
    { simde_mm256_set_epi8(INT8_C(  14), INT8_C( -28), INT8_C( 119), INT8_C( -89),
                           INT8_C(  93), INT8_C(  68), INT8_C(  -8), INT8_C( -52),
                           INT8_C(  70), INT8_C( -88), INT8_C( 112), INT8_C(-115),
                           INT8_C(-117), INT8_C( -66), INT8_C(  98), INT8_C( -40),
                           INT8_C(  80), INT8_C(   0), INT8_C( -25), INT8_C( -44),
                           INT8_C( -35), INT8_C(  89), INT8_C(  84), INT8_C(  53),
                           INT8_C(   2), INT8_C( -40), INT8_C(  71), INT8_C(  53),
                           INT8_C(  10), INT8_C( -48), INT8_C( -64), INT8_C( -40)),
      simde_mm256_set_epi8(INT8_C( -12), INT8_C( -97), INT8_C(-116), INT8_C( 114),
                           INT8_C(  34), INT8_C(  77), INT8_C( 118), INT8_C( -26),
                           INT8_C(-124), INT8_C( -29), INT8_C(-117), INT8_C( -60),
                           INT8_C( -21), INT8_C(  89), INT8_C( -92), INT8_C(-120),
                           INT8_C( -47), INT8_C(  45), INT8_C( -68), INT8_C(  28),
                           INT8_C( -35), INT8_C(-100), INT8_C( -85), INT8_C(-104),
                           INT8_C( 112), INT8_C(  16), INT8_C( -41), INT8_C(  56),
                           INT8_C(  84), INT8_C( 104), INT8_C(-121), INT8_C( -39)),
      simde_mm256_set_epi8(INT8_C(  -2), INT8_C( -33), INT8_C( -33), INT8_C(  67),
                           INT8_C(  -6), INT8_C( -74), INT8_C(  74), INT8_C(  25),
                           INT8_C( 100), INT8_C(-127), INT8_C(  70), INT8_C(-102),
                           INT8_C( -53), INT8_C(  12), INT8_C( -36), INT8_C(  58),
                           INT8_C( -67), INT8_C(-116), INT8_C( -84), INT8_C(   5),
                           INT8_C( 109), INT8_C(  -9), INT8_C(  93), INT8_C( -38),
                           INT8_C( 112), INT8_C(-125), INT8_C( 124), INT8_C(  86),
                           INT8_C( -55), INT8_C(  99), INT8_C( -92), INT8_C(-125)) },
    { simde_mm256_set_epi8(INT8_C( 120), INT8_C(  79), INT8_C( -76), INT8_C(  90),
                           INT8_C(   3), INT8_C(-113), INT8_C( 126), INT8_C(  10),
                           INT8_C(  50), INT8_C(-103), INT8_C(  60), INT8_C(-119),
                           INT8_C(-101), INT8_C(  54), INT8_C(  -8), INT8_C(  -9),
                           INT8_C( -13), INT8_C( 119), INT8_C(-104), INT8_C(  81),
                           INT8_C( -64), INT8_C( -40), INT8_C(  34), INT8_C( 104),
                           INT8_C(  75), INT8_C(-123), INT8_C(  -3), INT8_C(  12),
                           INT8_C(  46), INT8_C( -83), INT8_C( 115), INT8_C(  41)),
      simde_mm256_set_epi8(INT8_C( -17), INT8_C(-103), INT8_C(  72), INT8_C(-128),
                           INT8_C( 126), INT8_C(  35), INT8_C( -85), INT8_C( 118),
                           INT8_C(  57), INT8_C( 125), INT8_C(  -6), INT8_C( -57),
                           INT8_C( -20), INT8_C(  11), INT8_C( -19), INT8_C(  80),
                           INT8_C(  -4), INT8_C(  76), INT8_C(  97), INT8_C(   6),
                           INT8_C(  67), INT8_C(-100), INT8_C( 112), INT8_C(  10),
                           INT8_C( -21), INT8_C( -47), INT8_C(  73), INT8_C(  57),
                           INT8_C( -34), INT8_C(  45), INT8_C(  49), INT8_C(  73)),
      simde_mm256_set_epi8(INT8_C( -60), INT8_C( -72), INT8_C( 125), INT8_C(-116),
                           INT8_C(  81), INT8_C( -89), INT8_C( -92), INT8_C(  73),
                           INT8_C( 123), INT8_C(  81), INT8_C( -97), INT8_C(  86),
                           INT8_C( -89), INT8_C( 115), INT8_C( -49), INT8_C(  -3),
                           INT8_C(-125), INT8_C(  32), INT8_C( -14), INT8_C(  50),
                           INT8_C( -93), INT8_C( -25), INT8_C(-127), INT8_C( -11),
                           INT8_C(  40), INT8_C( -42), INT8_C( 122), INT8_C( -84),
                           INT8_C( -25), INT8_C( -81), INT8_C(  64), INT8_C(  32)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_gf2p8affineinv_epi64_epi8(test_vec[i].x, test_vec[i].A, 140);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i x;
    simde__m512i A;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -33), INT8_C(  19), INT8_C( -14), INT8_C(  38),
                           INT8_C( -80), INT8_C( -72), INT8_C(   4), INT8_C( -22),
                           INT8_C(  57), INT8_C( -46), INT8_C(  98), INT8_C( -35),
                           INT8_C(  77), INT8_C(-102), INT8_C(  53), INT8_C(  14),
                           INT8_C( 125), INT8_C(  92), INT8_C( -40), INT8_C(  78),
                           INT8_C( -48), INT8_C(-102), INT8_C( -48), INT8_C( -60),
                           INT8_C(-104), INT8_C(  50), INT8_C( 111), INT8_C( -80),
                           INT8_C(  75), INT8_C(  75), INT8_C( -50), INT8_C(  85),
                           INT8_C( -23), INT8_C(  64), INT8_C(  17), INT8_C(-118),
                           INT8_C(-108), INT8_C(-111), INT8_C(   0), INT8_C(  45),
                           INT8_C(  94), INT8_C(  64), INT8_C(  99), INT8_C( -32),
                           INT8_C(  92), INT8_C( -94), INT8_C( 121), INT8_C( 115),
                           INT8_C(  58), INT8_C( -43), INT8_C(  69), INT8_C(  40),
                           INT8_C( -27), INT8_C(-105), INT8_C(  74), INT8_C(-119),
                           INT8_C(  24), INT8_C( -36), INT8_C(  85), INT8_C(  31),
                           INT8_C(  10), INT8_C( -63), INT8_C(   1), INT8_C( 111)),
      simde_mm512_set_epi8(INT8_C( -65), INT8_C( -81), INT8_C(  -8), INT8_C( -60),
                           INT8_C( 123), INT8_C(  65), INT8_C( -54), INT8_C( -19),
                           INT8_C(  17), INT8_C( -96), INT8_C(  47), INT8_C(  16),
                           INT8_C(  48), INT8_C( 113), INT8_C(  -7), INT8_C( -55),
                           INT8_C(  -1), INT8_C(  76), INT8_C(-126), INT8_C(  62),
                           INT8_C(  70), INT8_C( -18), INT8_C(-123), INT8_C(-104),
                           INT8_C( -12), INT8_C( -12), INT8_C( 120), INT8_C(  -6),
                           INT8_C( -20), INT8_C(  70), INT8_C(  51), INT8_C( -27),
                           INT8_C( 125), INT8_C( -15), INT8_C( -11), INT8_C(   2),
                           INT8_C(  36), INT8_C(  95), INT8_C(-105), INT8_C(-112),
                           INT8_C(  -4), INT8_C(  76), INT8_C(  54), INT8_C( -65),
                           INT8_C(  65), INT8_C(  18), INT8_C( -19), INT8_C( -94),
                           INT8_C( -18), INT8_C( -67), INT8_C( -39), INT8_C( -64),
                           INT8_C( -69), INT8_C( -25), INT8_C(  53), INT8_C(  -3),
                           INT8_C(  35), INT8_C( -75), INT8_C(-109), INT8_C(  14),
                           INT8_C( -96), INT8_C(-128), INT8_C(  82), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -61), INT8_C(  84), INT8_C( -54), INT8_C(  16),
                           INT8_C( -61), INT8_C(  -1), INT8_C(-101), INT8_C( -46),
                           INT8_C( 113), INT8_C( -17), INT8_C(  10), INT8_C( 118),
                           INT8_C(   8), INT8_C(   5), INT8_C( -79), INT8_C(  42),
                           INT8_C( 127), INT8_C( 100), INT8_C(-120), INT8_C(-118),
                           INT8_C(-102), INT8_C(  95), INT8_C(-102), INT8_C(  86),
                           INT8_C(  52), INT8_C(  35), INT8_C( -69), INT8_C(  48),
                           INT8_C( 120), INT8_C( 120), INT8_C( 116), INT8_C( -13),
                           INT8_C(-124), INT8_C(  75), INT8_C( -36), INT8_C( -84),
                           INT8_C( -72), INT8_C( -26), INT8_C( -97), INT8_C( -51),
                           INT8_C(  89), INT8_C( -18), INT8_C( -36), INT8_C( -18),
                           INT8_C( -71), INT8_C(  -6), INT8_C(  44), INT8_C(  65),
                           INT8_C( 108), INT8_C(  11), INT8_C(  76), INT8_C( 123),
                           INT8_C( -38), INT8_C(  38), INT8_C(-125), INT8_C( -77),
                           INT8_C(  17), INT8_C( -22), INT8_C(-122), INT8_C( -79),
                           INT8_C(-125), INT8_C(-124), INT8_C(-104), INT8_C(-120)) },
    { simde_mm512_set_epi8(INT8_C(  74), INT8_C( 100), INT8_C(-114), INT8_C(  59),
                           INT8_C(  73), INT8_C( -61), INT8_C(  30), INT8_C(-124),
                           INT8_C(  41), INT8_C( 101), INT8_C( -53), INT8_C( -66),
                           INT8_C(  55), INT8_C(  15), INT8_C(   6), INT8_C( 114),
                           INT8_C(  83), INT8_C(   5), INT8_C( 114), INT8_C(  83),
                           INT8_C(  22), INT8_C(  94), INT8_C( -39), INT8_C( -38),
                           INT8_C(  30), INT8_C(-105), INT8_C( 103), INT8_C( -18),
                           INT8_C(  92), INT8_C(  29), INT8_C( -79), INT8_C( -94),
                           INT8_C(  25), INT8_C( -38), INT8_C( 109), INT8_C(  24),
                           INT8_C( -65), INT8_C( -78), INT8_C(-113), INT8_C( -16),
                           INT8_C(  14), INT8_C(  38), INT8_C( 121), INT8_C(  52),
                           INT8_C(-126), INT8_C(  39), INT8_C(  80), INT8_C( -84),
                           INT8_C(  -4), INT8_C(  47), INT8_C( 110), INT8_C( -54),
                           INT8_C( -29), INT8_C( 114), INT8_C( -26), INT8_C( -27),
                           INT8_C(  82), INT8_C( -32), INT8_C( -46), INT8_C(  81),
                           INT8_C( 113), INT8_C( -64), INT8_C( -33), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( 112), INT8_C(-103), INT8_C( -33), INT8_C( -60),
                           INT8_C( -26), INT8_C(  65), INT8_C( -62), INT8_C(  59),
                           INT8_C( -87), INT8_C(  60), INT8_C(-118), INT8_C(-122),
                           INT8_C( -40), INT8_C( 117), INT8_C( -94), INT8_C( -63),
                           INT8_C(  59), INT8_C( -71), INT8_C( 127), INT8_C(  88),
                           INT8_C(  -2), INT8_C( -99), INT8_C(  37), INT8_C(-101),
                           INT8_C(  66), INT8_C( 123), INT8_C( -27), INT8_C(  88),
                           INT8_C( -48), INT8_C(  84), INT8_C( -82), INT8_C( -53),
                           INT8_C( -26), INT8_C(  45), INT8_C( 112), INT8_C(  97),
                           INT8_C(  60), INT8_C(   9), INT8_C(  86), INT8_C( -33),
                           INT8_C(  14), INT8_C(  28), INT8_C(-121), INT8_C( -41),
                           INT8_C(-101), INT8_C(  24), INT8_C(   0), INT8_C(   2),
                           INT8_C(  37), INT8_C(  18), INT8_C( 127), INT8_C(  -7),
                           INT8_C( -59), INT8_C( -34), INT8_C(   4), INT8_C(-122),
                           INT8_C(  76), INT8_C( -20), INT8_C(-120), INT8_C(  61),
                           INT8_C( 105), INT8_C(-116), INT8_C(  95), INT8_C(  77)),
      simde_mm512_set_epi8(INT8_C( -92), INT8_C( -62), INT8_C(  -9), INT8_C(-101),
                           INT8_C( 111), INT8_C(  34), INT8_C(  99), INT8_C(-114),
                           INT8_C( -60), INT8_C(  71), INT8_C( -75), INT8_C(  36),
                           INT8_C(  99), INT8_C(  53), INT8_C(-124), INT8_C( -73),
                           INT8_C(  27), INT8_C( -87), INT8_C(-108), INT8_C(  27),
                           INT8_C( -44), INT8_C(  51), INT8_C( -32), INT8_C(  69),
                           INT8_C( -33), INT8_C( -97), INT8_C( 101), INT8_C( -56),
                           INT8_C(-100), INT8_C(  32), INT8_C( -78), INT8_C( -76),
                           INT8_C(  94), INT8_C(   0), INT8_C( -95), INT8_C(  52),
                           INT8_C(  62), INT8_C(  65), INT8_C( -46), INT8_C(  95),
                           INT8_C(-104), INT8_C( -80), INT8_C( -83), INT8_C(  48),
                           INT8_C(  16), INT8_C( -92), INT8_C( -85), INT8_C(  42),
                           INT8_C( -33), INT8_C( -67), INT8_C(-113), INT8_C(  54),
                           INT8_C(-127), INT8_C(  71), INT8_C( 121), INT8_C( -32),
                           INT8_C( -84), INT8_C(  51), INT8_C(  -9), INT8_C(  16),
                           INT8_C(-104), INT8_C(  -8), INT8_C(  49), INT8_C( -78)) },
    { simde_mm512_set_epi8(INT8_C( -20), INT8_C(-128), INT8_C(  30), INT8_C( -62),
                           INT8_C(-115), INT8_C(  37), INT8_C(  44), INT8_C(   9),
                           INT8_C(  62), INT8_C( 115), INT8_C( -32), INT8_C(  96),
                           INT8_C(  97), INT8_C(-125), INT8_C( 100), INT8_C( -75),
                           INT8_C( 118), INT8_C(-122), INT8_C( 110), INT8_C(  15),
                           INT8_C(  92), INT8_C( -45), INT8_C( -12), INT8_C(  60),
                           INT8_C(-110), INT8_C(  81), INT8_C(  58), INT8_C( -38),
                           INT8_C( 114), INT8_C( -35), INT8_C( -67), INT8_C(  20),
                           INT8_C( -97), INT8_C(  10), INT8_C(  84), INT8_C(  49),
                           INT8_C(  94), INT8_C( -59), INT8_C( -83), INT8_C(  28),
                           INT8_C( -40), INT8_C( 110), INT8_C(  -8), INT8_C(  28),
                           INT8_C( -35), INT8_C(  -5), INT8_C(-119), INT8_C( -82),
                           INT8_C(  99), INT8_C(  84), INT8_C( 122), INT8_C(  69),
                           INT8_C( 115), INT8_C(   3), INT8_C(-108), INT8_C( -90),
                           INT8_C( -26), INT8_C( -78), INT8_C( -27), INT8_C( -66),
                           INT8_C( -90), INT8_C( -23), INT8_C(-125), INT8_C( -64)),
      simde_mm512_set_epi8(INT8_C( 118), INT8_C( -60), INT8_C(  -8), INT8_C( -47),
                           INT8_C( -94), INT8_C(  14), INT8_C(-105), INT8_C( -53),
                           INT8_C( 120), INT8_C( 100), INT8_C(  83), INT8_C(  27),
                           INT8_C( -60), INT8_C(  75), INT8_C(  26), INT8_C( -28),
                           INT8_C(  71), INT8_C(  30), INT8_C(  66), INT8_C( -19),
                           INT8_C( -84), INT8_C( -56), INT8_C(-116), INT8_C( 117),
                           INT8_C(  51), INT8_C( -44), INT8_C(  73), INT8_C(  -1),
                           INT8_C( 111), INT8_C( 113), INT8_C( -22), INT8_C(  64),
                           INT8_C(-122), INT8_C(-125), INT8_C( 103), INT8_C( 110),
                           INT8_C(  98), INT8_C( -78), INT8_C(  -7), INT8_C( -29),
                           INT8_C( -88), INT8_C(  88), INT8_C(  10), INT8_C(  24),
                           INT8_C( 100), INT8_C( -11), INT8_C( -62), INT8_C(  52),
                           INT8_C(  97), INT8_C(  31), INT8_C( -35), INT8_C( 120),
                           INT8_C(   4), INT8_C(  -5), INT8_C(-110), INT8_C(   0),
                           INT8_C( -61), INT8_C(-127), INT8_C( -20), INT8_C(  85),
                           INT8_C( -84), INT8_C(  -4), INT8_C(-113), INT8_C(-106)),
      simde_mm512_set_epi8(INT8_C(  82), INT8_C( 120), INT8_C( -19), INT8_C( 116),
                           INT8_C( 110), INT8_C(  31), INT8_C( -57), INT8_C( -18),
                           INT8_C(  32), INT8_C( -79), INT8_C( -19), INT8_C(  44),
                           INT8_C( -14), INT8_C(  15), INT8_C( 109), INT8_C(  88),
                           INT8_C(-128), INT8_C(  91), INT8_C(-114), INT8_C(  31),
                           INT8_C(  57), INT8_C(  36), INT8_C( -48), INT8_C( 125),
                           INT8_C(-108), INT8_C(  12), INT8_C( -26), INT8_C(  49),
                           INT8_C(-128), INT8_C(  37), INT8_C( -63), INT8_C( -97),
                           INT8_C( -21), INT8_C( -19), INT8_C(   6), INT8_C(-120),
                           INT8_C( 121), INT8_C( -51), INT8_C(  40), INT8_C(   0),
                           INT8_C( -28), INT8_C(  14), INT8_C( -71), INT8_C(  76),
                           INT8_C(-104), INT8_C(  79), INT8_C( -81), INT8_C(  98),
                           INT8_C(  -3), INT8_C(-118), INT8_C( -72), INT8_C(  -1),
                           INT8_C( -54), INT8_C( -27), INT8_C(-106), INT8_C( -86),
                           INT8_C(  71), INT8_C(  53), INT8_C( -42), INT8_C(  85),
                           INT8_C(  49), INT8_C(  -5), INT8_C( 104), INT8_C(  97)) },
    { simde_mm512_set_epi8(INT8_C( -12), INT8_C( -97), INT8_C(-116), INT8_C( 114),
                           INT8_C(  34), INT8_C(  77), INT8_C( 118), INT8_C( -26),
                           INT8_C(-124), INT8_C( -29), INT8_C(-117), INT8_C( -60),
                           INT8_C( -21), INT8_C(  89), INT8_C( -92), INT8_C(-120),
                           INT8_C( -47), INT8_C(  45), INT8_C( -68), INT8_C(  28),
                           INT8_C( -35), INT8_C(-100), INT8_C( -85), INT8_C(-104),
                           INT8_C( 112), INT8_C(  16), INT8_C( -41), INT8_C(  56),
                           INT8_C(  84), INT8_C( 104), INT8_C(-121), INT8_C( -39),
                           INT8_C(  14), INT8_C( -28), INT8_C( 119), INT8_C( -89),
                           INT8_C(  93), INT8_C(  68), INT8_C(  -8), INT8_C( -52),
                           INT8_C(  70), INT8_C( -88), INT8_C( 112), INT8_C(-115),
                           INT8_C(-117), INT8_C( -66), INT8_C(  98), INT8_C( -40),
                           INT8_C(  80), INT8_C(   0), INT8_C( -25), INT8_C( -44),
                           INT8_C( -35), INT8_C(  89), INT8_C(  84), INT8_C(  53),
                           INT8_C(   2), INT8_C( -40), INT8_C(  71), INT8_C(  53),
                           INT8_C(  10), INT8_C( -48), INT8_C( -64), INT8_C( -40)),
      simde_mm512_set_epi8(INT8_C( -17), INT8_C(-103), INT8_C(  72), INT8_C(-128),
                           INT8_C( 126), INT8_C(  35), INT8_C( -85), INT8_C( 118),
                           INT8_C(  57), INT8_C( 125), INT8_C(  -6), INT8_C( -57),
                           INT8_C( -20), INT8_C(  11), INT8_C( -19), INT8_C(  80),
                           INT8_C(  -4), INT8_C(  76), INT8_C(  97), INT8_C(   6),
                           INT8_C(  67), INT8_C(-100), INT8_C( 112), INT8_C(  10),
                           INT8_C( -21), INT8_C( -47), INT8_C(  73), INT8_C(  57),
                           INT8_C( -34), INT8_C(  45), INT8_C(  49), INT8_C(  73),
                           INT8_C( 120), INT8_C(  79), INT8_C( -76), INT8_C(  90),
                           INT8_C(   3), INT8_C(-113), INT8_C( 126), INT8_C(  10),
                           INT8_C(  50), INT8_C(-103), INT8_C(  60), INT8_C(-119),
                           INT8_C(-101), INT8_C(  54), INT8_C(  -8), INT8_C(  -9),
                           INT8_C( -13), INT8_C( 119), INT8_C(-104), INT8_C(  81),
                           INT8_C( -64), INT8_C( -40), INT8_C(  34), INT8_C( 104),
                           INT8_C(  75), INT8_C(-123), INT8_C(  -3), INT8_C(  12),
                           INT8_C(  46), INT8_C( -83), INT8_C( 115), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C( -84), INT8_C( -32), INT8_C(  33), INT8_C(  69),
                           INT8_C(  62), INT8_C(-100), INT8_C(  17), INT8_C(  21),
                           INT8_C(  50), INT8_C( 122), INT8_C(-122), INT8_C( -63),
                           INT8_C(  13), INT8_C(  78), INT8_C( -87), INT8_C( 116),
                           INT8_C(  56), INT8_C( -29), INT8_C(   6), INT8_C( -55),
                           INT8_C( 110), INT8_C( 122), INT8_C( -13), INT8_C( -31),
                           INT8_C( 105), INT8_C(  11), INT8_C( -34), INT8_C(  57),
                           INT8_C(-123), INT8_C(  24), INT8_C( 115), INT8_C( -49),
                           INT8_C( -31), INT8_C( 108), INT8_C(  26), INT8_C(  63),
                           INT8_C(  56), INT8_C( 101), INT8_C(   2), INT8_C( -15),
                           INT8_C( -87), INT8_C( 111), INT8_C(-119), INT8_C(  46),
                           INT8_C( -74), INT8_C(  80), INT8_C( 113), INT8_C(  22),
                           INT8_C( 127), INT8_C( -97), INT8_C( -60), INT8_C(  24),
                           INT8_C(  89), INT8_C(-106), INT8_C(-126), INT8_C( -36),
                           INT8_C( -35), INT8_C( -61), INT8_C( 116), INT8_C( 117),
                           INT8_C(  49), INT8_C(-122), INT8_C(-108), INT8_C( -61)) },
    { simde_mm512_set_epi8(INT8_C(  -8), INT8_C( -52), INT8_C(  78), INT8_C( -24),
                           INT8_C( -96), INT8_C( -43), INT8_C(  60), INT8_C( -80),
                           INT8_C( 106), INT8_C( 106), INT8_C( -45), INT8_C(-107),
                           INT8_C( -69), INT8_C( -94), INT8_C(  13), INT8_C( 102),
                           INT8_C( -34), INT8_C(  -8), INT8_C(   0), INT8_C( -97),
                           INT8_C( 121), INT8_C(  10), INT8_C( -78), INT8_C( -54),
                           INT8_C( -36), INT8_C( -63), INT8_C( -81), INT8_C(  10),
                           INT8_C(  65), INT8_C( -80), INT8_C(-116), INT8_C(-125),
                           INT8_C( -11), INT8_C(  15), INT8_C( -74), INT8_C( -56),
                           INT8_C( -11), INT8_C( -46), INT8_C(  40), INT8_C( 101),
                           INT8_C( -18), INT8_C(  80), INT8_C(  29), INT8_C(  31),
                           INT8_C(  12), INT8_C(  -5), INT8_C( -95), INT8_C(  18),
                           INT8_C( 112), INT8_C(-106), INT8_C(  61), INT8_C( -64),
                           INT8_C(  64), INT8_C( -70), INT8_C(-105), INT8_C(  77),
                           INT8_C( -45), INT8_C(  65), INT8_C(  85), INT8_C(  87),
                           INT8_C(  21), INT8_C( -16), INT8_C(  77), INT8_C(  33)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C(  45), INT8_C( -96), INT8_C(  46),
                           INT8_C(  -3), INT8_C(  10), INT8_C( -28), INT8_C(  72),
                           INT8_C(  95), INT8_C(  17), INT8_C( -18), INT8_C(  35),
                           INT8_C( -13), INT8_C(  31), INT8_C( -33), INT8_C(  72),
                           INT8_C( -16), INT8_C( -88), INT8_C(   5), INT8_C( -29),
                           INT8_C( -38), INT8_C(  19), INT8_C( 117), INT8_C(  47),
                           INT8_C(-125), INT8_C( -23), INT8_C(  85), INT8_C(-124),
                           INT8_C(   1), INT8_C(  20), INT8_C( -25), INT8_C(-100),
                           INT8_C(  -3), INT8_C( -75), INT8_C(  69), INT8_C( 119),
                           INT8_C( 113), INT8_C( -53), INT8_C( -61), INT8_C(  67),
                           INT8_C(   0), INT8_C(-115), INT8_C(  11), INT8_C( -86),
                           INT8_C(  51), INT8_C(-124), INT8_C(  33), INT8_C(-127),
                           INT8_C(  15), INT8_C( -42), INT8_C( -15), INT8_C(  69),
                           INT8_C(-105), INT8_C(  93), INT8_C(   9), INT8_C( 127),
                           INT8_C( -40), INT8_C( -93), INT8_C( -66), INT8_C( -79),
                           INT8_C( -24), INT8_C(  26), INT8_C(  16), INT8_C( -79)),
      simde_mm512_set_epi8(INT8_C(  -7), INT8_C(  15), INT8_C( -19), INT8_C(  37),
                           INT8_C( -44), INT8_C(-118), INT8_C(  96), INT8_C( 127),
                           INT8_C( -61), INT8_C( -61), INT8_C(  80), INT8_C(  83),
                           INT8_C(  11), INT8_C( 126), INT8_C( 121), INT8_C( -24),
                           INT8_C( -11), INT8_C(  22), INT8_C( -97), INT8_C( -33),
                           INT8_C( 124), INT8_C(  42), INT8_C( -20), INT8_C( -29),
                           INT8_C( -55), INT8_C(  95), INT8_C( -38), INT8_C(   8),
                           INT8_C( -37), INT8_C( -15), INT8_C(  14), INT8_C(  84),
                           INT8_C(-123), INT8_C(  25), INT8_C(  67), INT8_C(  57),
                           INT8_C(-123), INT8_C(  33), INT8_C(  -2), INT8_C(   0),
                           INT8_C( -65), INT8_C(-105), INT8_C( -97), INT8_C(  97),
                           INT8_C( 125), INT8_C( 109), INT8_C(  -5), INT8_C( 127),
                           INT8_C(  31), INT8_C(  50), INT8_C(  52), INT8_C(  16),
                           INT8_C(-114), INT8_C(  43), INT8_C(-112), INT8_C(  93),
                           INT8_C( -68), INT8_C( 117), INT8_C(   5), INT8_C( -18),
                           INT8_C(-104), INT8_C(  -6), INT8_C(-113), INT8_C(   7)) },
    { simde_mm512_set_epi8(INT8_C(  97), INT8_C( -65), INT8_C(-103), INT8_C( 115),
                           INT8_C(  86), INT8_C(  81), INT8_C(  35), INT8_C( 115),
                           INT8_C(  87), INT8_C(  60), INT8_C( 103), INT8_C(  16),
                           INT8_C( 105), INT8_C(-103), INT8_C(  41), INT8_C( -70),
                           INT8_C( -56), INT8_C( -81), INT8_C(   5), INT8_C( -52),
                           INT8_C(  73), INT8_C(-113), INT8_C(   7), INT8_C( -33),
                           INT8_C(   0), INT8_C( -58), INT8_C( -97), INT8_C(  16),
                           INT8_C( -71), INT8_C( 101), INT8_C(  93), INT8_C(-124),
                           INT8_C(  66), INT8_C( 101), INT8_C( -22), INT8_C(  62),
                           INT8_C(  45), INT8_C( -13), INT8_C(  97), INT8_C(   6),
                           INT8_C( -10), INT8_C(  81), INT8_C( -11), INT8_C(  50),
                           INT8_C(  76), INT8_C(-105), INT8_C( -48), INT8_C( -19),
                           INT8_C(   3), INT8_C(  85), INT8_C(  45), INT8_C( -62),
                           INT8_C(-101), INT8_C( 125), INT8_C( -54), INT8_C(  33),
                           INT8_C( -47), INT8_C(  78), INT8_C(  54), INT8_C(  -7),
                           INT8_C(  46), INT8_C( 104), INT8_C(  81), INT8_C(  -1)),
      simde_mm512_set_epi8(INT8_C(  -4), INT8_C( -11), INT8_C( -65), INT8_C(  94),
                           INT8_C( -93), INT8_C( -39), INT8_C(-128), INT8_C(  35),
                           INT8_C( -73), INT8_C( -74), INT8_C(  30), INT8_C( 126),
                           INT8_C(   3), INT8_C(   4), INT8_C( -68), INT8_C(  86),
                           INT8_C( 115), INT8_C(-119), INT8_C( -25), INT8_C(  -5),
                           INT8_C(  23), INT8_C( -82), INT8_C(  66), INT8_C(  77),
                           INT8_C(  97), INT8_C(   3), INT8_C( -67), INT8_C( -81),
                           INT8_C(  99), INT8_C( -85), INT8_C(  58), INT8_C(  54),
                           INT8_C(  -4), INT8_C(  74), INT8_C(  58), INT8_C(  19),
                           INT8_C( -90), INT8_C(  92), INT8_C(  10), INT8_C( -48),
                           INT8_C(  74), INT8_C(  86), INT8_C( 107), INT8_C( -99),
                           INT8_C(  17), INT8_C(  28), INT8_C(  69), INT8_C(  73),
                           INT8_C(  99), INT8_C( 107), INT8_C( -54), INT8_C(   4),
                           INT8_C( -60), INT8_C(-105), INT8_C(  39), INT8_C( -97),
                           INT8_C( -99), INT8_C( -57), INT8_C( -58), INT8_C( 117),
                           INT8_C(-113), INT8_C(  51), INT8_C(  82), INT8_C( -16)),
      simde_mm512_set_epi8(INT8_C(  37), INT8_C( -66), INT8_C( -65), INT8_C(  81),
                           INT8_C( -51), INT8_C( -71), INT8_C( -51), INT8_C(  81),
                           INT8_C( 117), INT8_C( -14), INT8_C(-103), INT8_C( 124),
                           INT8_C( 118), INT8_C( -65), INT8_C(  76), INT8_C( -29),
                           INT8_C( -87), INT8_C(   2), INT8_C(  54), INT8_C( -50),
                           INT8_C( -53), INT8_C(  40), INT8_C(  -6), INT8_C(  55),
                           INT8_C( -97), INT8_C( -45), INT8_C( -31), INT8_C(  59),
                           INT8_C( -87), INT8_C(  56), INT8_C( -65), INT8_C(   1),
                           INT8_C(  64), INT8_C( 116), INT8_C( 103), INT8_C(  -2),
                           INT8_C(  13), INT8_C(  22), INT8_C(-103), INT8_C( -75),
                           INT8_C(  68), INT8_C( -91), INT8_C(  53), INT8_C( -86),
                           INT8_C(   8), INT8_C(  97), INT8_C( -52), INT8_C(  98),
                           INT8_C( -64), INT8_C(  36), INT8_C( 112), INT8_C( -90),
                           INT8_C( -83), INT8_C( -66), INT8_C(  44), INT8_C(  82),
                           INT8_C( -51), INT8_C(  68), INT8_C(-112), INT8_C( -17),
                           INT8_C( -42), INT8_C(-104), INT8_C( -74), INT8_C( 120)) },
    { simde_mm512_set_epi8(INT8_C(-114), INT8_C(  84), INT8_C( 109), INT8_C(  40),
                           INT8_C( -55), INT8_C(  -5), INT8_C( -28), INT8_C( 111),
                           INT8_C( -61), INT8_C(-126), INT8_C(  -9), INT8_C( 122),
                           INT8_C( 121), INT8_C(  80), INT8_C( 116), INT8_C(  66),
                           INT8_C(  56), INT8_C(  92), INT8_C( -15), INT8_C(  88),
                           INT8_C( -82), INT8_C(  24), INT8_C(  22), INT8_C(  55),
                           INT8_C( -92), INT8_C(  -3), INT8_C( -13), INT8_C(  70),
                           INT8_C( -88), INT8_C( -90), INT8_C( -47), INT8_C( -66),
                           INT8_C( -40), INT8_C(   5), INT8_C( -96), INT8_C(-120),
                           INT8_C( -65), INT8_C( -98), INT8_C( 120), INT8_C(  54),
                           INT8_C( -63), INT8_C(  36), INT8_C(-107), INT8_C(   2),
                           INT8_C(  82), INT8_C( -28), INT8_C(   7), INT8_C( -92),
                           INT8_C(  -8), INT8_C( -92), INT8_C(  58), INT8_C( -89),
                           INT8_C(  15), INT8_C( -88), INT8_C( -89), INT8_C( 119),
                           INT8_C( -67), INT8_C( -95), INT8_C(  25), INT8_C(  99),
                           INT8_C( 100), INT8_C(  30), INT8_C(  28), INT8_C( 104)),
      simde_mm512_set_epi8(INT8_C(  28), INT8_C( -13), INT8_C(-115), INT8_C( -62),
                           INT8_C( 120), INT8_C( -67), INT8_C(-119), INT8_C(  -4),
                           INT8_C(  94), INT8_C(  -5), INT8_C(  64), INT8_C(-117),
                           INT8_C(  28), INT8_C(   9), INT8_C( -53), INT8_C( -49),
                           INT8_C( -43), INT8_C(-111), INT8_C(  22), INT8_C( -21),
                           INT8_C( -86), INT8_C(  -5), INT8_C( -70), INT8_C( -26),
                           INT8_C(  45), INT8_C( 108), INT8_C( -27), INT8_C( 115),
                           INT8_C(  92), INT8_C(-105), INT8_C(-116), INT8_C(  45),
                           INT8_C(-102), INT8_C(  64), INT8_C(  16), INT8_C(-122),
                           INT8_C(  30), INT8_C( -80), INT8_C( -75), INT8_C(   7),
                           INT8_C(  86), INT8_C(-123), INT8_C(  35), INT8_C(-106),
                           INT8_C(  49), INT8_C( -37), INT8_C(-112), INT8_C(  59),
                           INT8_C( 117), INT8_C(  45), INT8_C(  79), INT8_C( -73),
                           INT8_C( 102), INT8_C( 108), INT8_C( -22), INT8_C( -90),
                           INT8_C(-117), INT8_C(  37), INT8_C(  47), INT8_C(  92),
                           INT8_C( -73), INT8_C(  49), INT8_C(  93), INT8_C( -22)),
      simde_mm512_set_epi8(INT8_C( -29), INT8_C(  85), INT8_C( -82), INT8_C(-115),
                           INT8_C( -28), INT8_C( -61), INT8_C(  68), INT8_C(   7),
                           INT8_C( 118), INT8_C(   2), INT8_C(  63), INT8_C(-127),
                           INT8_C(  73), INT8_C(  16), INT8_C(-116), INT8_C(  62),
                           INT8_C( -82), INT8_C( 122), INT8_C( -80), INT8_C(-128),
                           INT8_C(  86), INT8_C(  41), INT8_C( -50), INT8_C( -54),
                           INT8_C(  90), INT8_C(  92), INT8_C( -33), INT8_C(   8),
                           INT8_C( -49), INT8_C(  84), INT8_C( -19), INT8_C(  36),
                           INT8_C(  91), INT8_C( 113), INT8_C( -87), INT8_C( -53),
                           INT8_C( 105), INT8_C(  39), INT8_C( -94), INT8_C( -68),
                           INT8_C( -85), INT8_C(  -6), INT8_C(  -8), INT8_C( -24),
                           INT8_C(  34), INT8_C( 114), INT8_C(-101), INT8_C(  69),
                           INT8_C(  -3), INT8_C(  93), INT8_C( 100), INT8_C(-116),
                           INT8_C(  78), INT8_C(   7), INT8_C(-116), INT8_C( -76),
                           INT8_C(  83), INT8_C(  10), INT8_C(  32), INT8_C(  92),
                           INT8_C( -19), INT8_C( 118), INT8_C( 121), INT8_C(  86)) },
    { simde_mm512_set_epi8(INT8_C( -86), INT8_C(-116), INT8_C( -59), INT8_C(  47),
                           INT8_C(  -4), INT8_C( -72), INT8_C( 122), INT8_C( -93),
                           INT8_C(   3), INT8_C(  -4), INT8_C(  98), INT8_C( -88),
                           INT8_C(  13), INT8_C(  87), INT8_C( -90), INT8_C( -13),
                           INT8_C( -64), INT8_C(  35), INT8_C( -69), INT8_C( -60),
                           INT8_C(-105), INT8_C(-107), INT8_C(  45), INT8_C(-115),
                           INT8_C( -43), INT8_C(  92), INT8_C( 124), INT8_C( -91),
                           INT8_C( -66), INT8_C(  92), INT8_C( -47), INT8_C(  62),
                           INT8_C( -88), INT8_C(  45), INT8_C(  56), INT8_C( -57),
                           INT8_C( 113), INT8_C( -35), INT8_C(  68), INT8_C(  64),
                           INT8_C( -69), INT8_C( -19), INT8_C(   1), INT8_C(   9),
                           INT8_C(  74), INT8_C( -29), INT8_C(  92), INT8_C(  -4),
                           INT8_C(  83), INT8_C(  90), INT8_C(-123), INT8_C( -68),
                           INT8_C( -29), INT8_C( -84), INT8_C(  68), INT8_C(  70),
                           INT8_C( -49), INT8_C(  62), INT8_C(  38), INT8_C( -13),
                           INT8_C(  41), INT8_C( 104), INT8_C( 104), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C( -19), INT8_C(  22), INT8_C(  18), INT8_C(  11),
                           INT8_C(  51), INT8_C( -67), INT8_C( -37), INT8_C( -51),
                           INT8_C( -24), INT8_C( -36), INT8_C( 100), INT8_C(  37),
                           INT8_C(-113), INT8_C(  10), INT8_C( -40), INT8_C( 117),
                           INT8_C( 102), INT8_C(  -9), INT8_C(-115), INT8_C(  91),
                           INT8_C( 102), INT8_C(  70), INT8_C( -21), INT8_C(  80),
                           INT8_C(  31), INT8_C(  56), INT8_C( -30), INT8_C(-124),
                           INT8_C(  52), INT8_C( 118), INT8_C(  89), INT8_C( -37),
                           INT8_C(-109), INT8_C(   4), INT8_C( 120), INT8_C(  53),
                           INT8_C(  13), INT8_C( -50), INT8_C( -58), INT8_C( -53),
                           INT8_C(-113), INT8_C(-126), INT8_C( -64), INT8_C(  -5),
                           INT8_C(-127), INT8_C( -16), INT8_C( -73), INT8_C(  19),
                           INT8_C(-125), INT8_C(  29), INT8_C(-126), INT8_C( -33),
                           INT8_C( 119), INT8_C(  57), INT8_C(  99), INT8_C( -29),
                           INT8_C( -31), INT8_C( -11), INT8_C(-123), INT8_C( 105),
                           INT8_C( -74), INT8_C(-113), INT8_C( -55), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( -73), INT8_C(  -4), INT8_C( 106), INT8_C( -31),
                           INT8_C(  12), INT8_C(  21), INT8_C( -55), INT8_C(  24),
                           INT8_C( -22), INT8_C( 126), INT8_C(   4), INT8_C( -68),
                           INT8_C(  30), INT8_C( -58), INT8_C( -45), INT8_C(  78),
                           INT8_C( -26), INT8_C( -75), INT8_C( 115), INT8_C( -97),
                           INT8_C( -58), INT8_C( -18), INT8_C(  83), INT8_C( -28),
                           INT8_C( -93), INT8_C(  73), INT8_C( -28), INT8_C(  21),
                           INT8_C(-113), INT8_C(  73), INT8_C( -62), INT8_C(-118),
                           INT8_C(   8), INT8_C(   1), INT8_C( 122), INT8_C(  41),
                           INT8_C( 125), INT8_C(  47), INT8_C( -60), INT8_C( -59),
                           INT8_C(-114), INT8_C(  91), INT8_C(  70), INT8_C( -23),
                           INT8_C(-109), INT8_C( -65), INT8_C(-126), INT8_C(  93),
                           INT8_C(  61), INT8_C( -78), INT8_C( -85), INT8_C(  19),
                           INT8_C(  54), INT8_C(  39), INT8_C( -92), INT8_C( -31),
                           INT8_C( -66), INT8_C(  65), INT8_C(  27), INT8_C(  32),
                           INT8_C( -57), INT8_C(  28), INT8_C(  28), INT8_C( -20)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_gf2p8affineinv_epi64_epi8(test_vec[i].x, test_vec[i].A, 159);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_mask_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i src;
    simde__mmask16 k;
    simde__m128i x;
    simde__m128i A;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C(  86), INT8_C(-109), INT8_C(-116), INT8_C(  52),
                        INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  33),
                        INT8_C(  37), INT8_C(  31), INT8_C(  47), INT8_C(  64),
                        INT8_C(  83), INT8_C(  59), INT8_C(  -2), INT8_C(-123)),
      UINT16_C(11144),
      simde_mm_set_epi8(INT8_C( -42), INT8_C(  62), INT8_C(  88), INT8_C(   7),
                        INT8_C(  61), INT8_C( 116), INT8_C( -89), INT8_C( 122),
                        INT8_C( 102), INT8_C( -48), INT8_C( 124), INT8_C(  70),
                        INT8_C(  47), INT8_C(  38), INT8_C( 113), INT8_C( -68)),
      simde_mm_set_epi8(INT8_C(  -6), INT8_C(  43), INT8_C(  55), INT8_C(  12),
                        INT8_C(  60), INT8_C(  72), INT8_C(  58), INT8_C( 119),
                        INT8_C(-125), INT8_C(-116), INT8_C(  -2), INT8_C(  35),
                        INT8_C(  46), INT8_C( -63), INT8_C( -77), INT8_C( -15)),
      simde_mm_set_epi8(INT8_C(  86), INT8_C(-109), INT8_C(  64), INT8_C(  52),
                        INT8_C( -41), INT8_C( -39), INT8_C(  52), INT8_C(-101),
                        INT8_C( -67), INT8_C(  31), INT8_C(  47), INT8_C(  64),
                        INT8_C( -16), INT8_C(  59), INT8_C(  -2), INT8_C(-123)) },
    { simde_mm_set_epi8(INT8_C(  78), INT8_C( -70), INT8_C(   8), INT8_C( -28),
                        INT8_C( -17), INT8_C( 126), INT8_C(-111), INT8_C(-124),
                        INT8_C( -60), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                        INT8_C(  51), INT8_C(  20), INT8_C(  52), INT8_C(-114)),
      UINT16_C(16002),
      simde_mm_set_epi8(INT8_C( 120), INT8_C( -68), INT8_C( -84), INT8_C( -49),
                        INT8_C(  87), INT8_C( -79), INT8_C( -74), INT8_C(  92),
                        INT8_C(  64), INT8_C(-128), INT8_C( -63), INT8_C( -93),
                        INT8_C(  85), INT8_C( -44), INT8_C(  26), INT8_C(-115)),
      simde_mm_set_epi8(INT8_C(  58), INT8_C( -45), INT8_C( 126), INT8_C(  -7),
                        INT8_C(  69), INT8_C(   5), INT8_C( -82), INT8_C(-111),
                        INT8_C( -84), INT8_C(  28), INT8_C( -27), INT8_C(-123),
                        INT8_C(  82), INT8_C(-107), INT8_C( -80), INT8_C(  79)),
      simde_mm_set_epi8(INT8_C(  78), INT8_C( -70), INT8_C(  68), INT8_C(  68),
                        INT8_C(  34), INT8_C( 119), INT8_C( 127), INT8_C(-124),
                        INT8_C(  28), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                        INT8_C(  51), INT8_C(  20), INT8_C( -96), INT8_C(-114)) },
    { simde_mm_set_epi8(INT8_C(-118), INT8_C(  -5), INT8_C( 100), INT8_C(  20),
                        INT8_C(  96), INT8_C(-121), INT8_C(  54), INT8_C( 113),
                        INT8_C( -38), INT8_C(  70), INT8_C( -49), INT8_C(   4),
                        INT8_C( -35), INT8_C(  89), INT8_C(-103), INT8_C(  21)),
      UINT16_C(17590),
      simde_mm_set_epi8(INT8_C(  27), INT8_C(  -2), INT8_C(  62), INT8_C(  34),
                        INT8_C( 118), INT8_C(  94), INT8_C( -81), INT8_C(  50),
                        INT8_C( -73), INT8_C(  61), INT8_C(  67), INT8_C( -62),
                        INT8_C(   2), INT8_C(  50), INT8_C( -54), INT8_C(  -9)),
      simde_mm_set_epi8(INT8_C( 100), INT8_C(  45), INT8_C( -71), INT8_C(-119),
                        INT8_C(  49), INT8_C( -65), INT8_C(  94), INT8_C(  96),
                        INT8_C( -71), INT8_C( 118), INT8_C( -91), INT8_C( -10),
                        INT8_C(  38), INT8_C( -84), INT8_C( -72), INT8_C( -61)),
      simde_mm_set_epi8(INT8_C(-118), INT8_C(  17), INT8_C( 100), INT8_C(  20),
                        INT8_C(  96), INT8_C( -90), INT8_C(  54), INT8_C( 113),
                        INT8_C( -43), INT8_C(  70), INT8_C(  58), INT8_C( -47),
                        INT8_C( -35), INT8_C( -46), INT8_C(  48), INT8_C(  21)) },
    { simde_mm_set_epi8(INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                        INT8_C( -97), INT8_C(  62), INT8_C(  26), INT8_C(  78),
                        INT8_C( -69), INT8_C( -62), INT8_C(-105), INT8_C(  38),
                        INT8_C(  99), INT8_C( -23), INT8_C(  54), INT8_C( -37)),
      UINT16_C( 3274),
      simde_mm_set_epi8(INT8_C(  56), INT8_C( -71), INT8_C(  70), INT8_C(  52),
                        INT8_C( 105), INT8_C(  74), INT8_C( -52), INT8_C( 125),
                        INT8_C(  71), INT8_C(  78), INT8_C( 102), INT8_C( -87),
                        INT8_C( -42), INT8_C(  16), INT8_C( 120), INT8_C(  -7)),
      simde_mm_set_epi8(INT8_C(-115), INT8_C(  83), INT8_C( -51), INT8_C(-117),
                        INT8_C( -24), INT8_C( -79), INT8_C(  55), INT8_C(-125),
                        INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                        INT8_C( -62), INT8_C(  72), INT8_C(  66), INT8_C(-110)),
      simde_mm_set_epi8(INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                        INT8_C(-104), INT8_C(  27), INT8_C(  26), INT8_C(  78),
                        INT8_C( -80), INT8_C(  39), INT8_C(-105), INT8_C(  38),
                        INT8_C( -41), INT8_C( -23), INT8_C(  45), INT8_C( -37)) },
    { simde_mm_set_epi8(INT8_C( -26), INT8_C(  57), INT8_C( -91), INT8_C(  79),
                        INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                        INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                        INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121)),
      UINT16_C(12470),
      simde_mm_set_epi8(INT8_C(  83), INT8_C( -70), INT8_C( -20), INT8_C( -26),
                        INT8_C( 113), INT8_C(  81), INT8_C(-104), INT8_C(  87),
                        INT8_C(  17), INT8_C(  59), INT8_C( -92), INT8_C( -92),
                        INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84)),
      simde_mm_set_epi8(INT8_C( 105), INT8_C(   4), INT8_C(   0), INT8_C( 126),
                        INT8_C(  17), INT8_C( -37), INT8_C( 124), INT8_C(  81),
                        INT8_C( -49), INT8_C( -80), INT8_C(  50), INT8_C( 114),
                        INT8_C( 103), INT8_C( 115), INT8_C(  11), INT8_C( 121)),
      simde_mm_set_epi8(INT8_C( -26), INT8_C(  57), INT8_C( 109), INT8_C( -99),
                        INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                        INT8_C( -20), INT8_C(  93), INT8_C( -79), INT8_C( -79),
                        INT8_C(  88), INT8_C(-121), INT8_C(  60), INT8_C(-121)) },
    { simde_mm_set_epi8(INT8_C( -60), INT8_C( 101), INT8_C(  20), INT8_C( -20),
                        INT8_C( 122), INT8_C( 120), INT8_C(-101), INT8_C( -57),
                        INT8_C(   8), INT8_C( -41), INT8_C(  78), INT8_C( -24),
                        INT8_C( -85), INT8_C( -99), INT8_C( -85), INT8_C( -95)),
      UINT16_C(17946),
      simde_mm_set_epi8(INT8_C(-126), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                        INT8_C(  45), INT8_C(  80), INT8_C(-116), INT8_C(   9),
                        INT8_C(  97), INT8_C(-126), INT8_C( -49), INT8_C(  31),
                        INT8_C(  80), INT8_C( -15), INT8_C(-103), INT8_C( -93)),
      simde_mm_set_epi8(INT8_C( -32), INT8_C(-111), INT8_C( -86), INT8_C(  81),
                        INT8_C( -69), INT8_C( -40), INT8_C(-105), INT8_C(  25),
                        INT8_C(  10), INT8_C( 111), INT8_C(   0), INT8_C( 102),
                        INT8_C( -29), INT8_C( -79), INT8_C( -33), INT8_C( -18)),
      simde_mm_set_epi8(INT8_C( -60), INT8_C( -81), INT8_C(  20), INT8_C( -20),
                        INT8_C( 122), INT8_C(-117), INT8_C(-111), INT8_C( -57),
                        INT8_C(   8), INT8_C( -41), INT8_C(  78), INT8_C(  31),
                        INT8_C(   5), INT8_C( -99), INT8_C(  68), INT8_C( -95)) },
    { simde_mm_set_epi8(INT8_C( -56), INT8_C( -96), INT8_C(-107), INT8_C(  81),
                        INT8_C(  28), INT8_C(  89), INT8_C(-117), INT8_C(-113),
                        INT8_C(  93), INT8_C(  34), INT8_C( -81), INT8_C(  29),
                        INT8_C( -48), INT8_C( -91), INT8_C(-101), INT8_C(  33)),
      UINT16_C(50993),
      simde_mm_set_epi8(INT8_C( -39), INT8_C(  81), INT8_C( -54), INT8_C( 103),
                        INT8_C( -31), INT8_C(  76), INT8_C(  -6), INT8_C(  19),
                        INT8_C(   0), INT8_C( -53), INT8_C( -62), INT8_C(  52),
                        INT8_C( -64), INT8_C(  34), INT8_C( -62), INT8_C(  62)),
      simde_mm_set_epi8(INT8_C( -50), INT8_C(-100), INT8_C(  91), INT8_C( -73),
                        INT8_C(-128), INT8_C( -69), INT8_C(  75), INT8_C(  41),
                        INT8_C(  62), INT8_C( -50), INT8_C(  30), INT8_C(  -6),
                        INT8_C(  85), INT8_C(  -1), INT8_C(  20), INT8_C( -57)),
      simde_mm_set_epi8(INT8_C( -77), INT8_C( 105), INT8_C(-107), INT8_C(  81),
                        INT8_C(  28), INT8_C(-114), INT8_C(  45), INT8_C( -51),
                        INT8_C(  93), INT8_C(  34), INT8_C(   0), INT8_C( -75),
                        INT8_C( -48), INT8_C( -91), INT8_C(-101), INT8_C( -74)) },
    { simde_mm_set_epi8(INT8_C(  27), INT8_C(  42), INT8_C( -96), INT8_C( -57),
                        INT8_C(-122), INT8_C(  20), INT8_C(  54), INT8_C(  94),
                        INT8_C(  37), INT8_C( 113), INT8_C( -54), INT8_C(  15),
                        INT8_C(-119), INT8_C(-119), INT8_C( 102), INT8_C(  12)),
      UINT16_C(59513),
      simde_mm_set_epi8(INT8_C(  20), INT8_C(  -1), INT8_C( 126), INT8_C( -58),
                        INT8_C(-122), INT8_C( -63), INT8_C(   0), INT8_C(  21),
                        INT8_C( 125), INT8_C(-120), INT8_C(  11), INT8_C(  36),
                        INT8_C( -16), INT8_C(  30), INT8_C( -96), INT8_C(  28)),
      simde_mm_set_epi8(INT8_C( -37), INT8_C(   0), INT8_C(  84), INT8_C( 112),
                        INT8_C(  67), INT8_C(-128), INT8_C( -76), INT8_C( -90),
                        INT8_C( -77), INT8_C(  21), INT8_C(  79), INT8_C(  -2),
                        INT8_C(   5), INT8_C(  83), INT8_C(  16), INT8_C( 106)),
      simde_mm_set_epi8(INT8_C(  82), INT8_C( 102), INT8_C(  30), INT8_C( -57),
                        INT8_C( -34), INT8_C(  20), INT8_C(  54), INT8_C(  94),
                        INT8_C(  37), INT8_C(-102), INT8_C(  75), INT8_C(   0),
                        INT8_C(  63), INT8_C(-119), INT8_C( 102), INT8_C( -95)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_mask_gf2p8affineinv_epi64_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].x, test_vec[i].A, 238);
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_mask_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m256i src;
    simde__mmask32 k;
    simde__m256i x;
    simde__m256i A;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( 102), INT8_C( -48), INT8_C( 124), INT8_C(  70),
                           INT8_C(  47), INT8_C(  38), INT8_C( 113), INT8_C( -68),
                           INT8_C( -88), INT8_C(  75), INT8_C(  45), INT8_C( 101),
                           INT8_C( -48), INT8_C(  40), INT8_C(  43), INT8_C(-120),
                           INT8_C(  86), INT8_C(-109), INT8_C(-116), INT8_C(  52),
                           INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  33),
                           INT8_C(  37), INT8_C(  31), INT8_C(  47), INT8_C(  64),
                           INT8_C(  83), INT8_C(  59), INT8_C(  -2), INT8_C(-123)),
      UINT32_C(1031055226),
      simde_mm256_set_epi8(INT8_C(  78), INT8_C( -70), INT8_C(   8), INT8_C( -28),
                           INT8_C( -17), INT8_C( 126), INT8_C(-111), INT8_C(-124),
                           INT8_C( -60), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                           INT8_C(  51), INT8_C(  20), INT8_C(  52), INT8_C(-114),
                           INT8_C(  -6), INT8_C(  43), INT8_C(  55), INT8_C(  12),
                           INT8_C(  60), INT8_C(  72), INT8_C(  58), INT8_C( 119),
                           INT8_C(-125), INT8_C(-116), INT8_C(  -2), INT8_C(  35),
                           INT8_C(  46), INT8_C( -63), INT8_C( -77), INT8_C( -15)),
      simde_mm256_set_epi8(INT8_C( -84), INT8_C(  28), INT8_C( -27), INT8_C(-123),
                           INT8_C(  82), INT8_C(-107), INT8_C( -80), INT8_C(  79),
                           INT8_C( 120), INT8_C( -68), INT8_C( -84), INT8_C( -49),
                           INT8_C(  87), INT8_C( -79), INT8_C( -74), INT8_C(  92),
                           INT8_C(  64), INT8_C(-128), INT8_C( -63), INT8_C( -93),
                           INT8_C(  85), INT8_C( -44), INT8_C(  26), INT8_C(-115),
                           INT8_C(-101), INT8_C(  76), INT8_C(-128), INT8_C( -17),
                           INT8_C(-103), INT8_C(   2), INT8_C(  62), INT8_C(-126)),
      simde_mm256_set_epi8(INT8_C( 102), INT8_C( -48), INT8_C( 113), INT8_C(-120),
                           INT8_C(  40), INT8_C(-113), INT8_C( 113), INT8_C( 110),
                           INT8_C( -88), INT8_C( -59), INT8_C(-120), INT8_C(   0),
                           INT8_C( -48), INT8_C( 100), INT8_C(  43), INT8_C(-120),
                           INT8_C( -17), INT8_C(-109), INT8_C(  51), INT8_C(  52),
                           INT8_C( -80), INT8_C(-116), INT8_C(  70), INT8_C(  70),
                           INT8_C(  37), INT8_C( 122), INT8_C(  93), INT8_C( -39),
                           INT8_C( 114), INT8_C(  59), INT8_C( 112), INT8_C(-123)) },
    { simde_mm256_set_epi8(INT8_C( -22), INT8_C( -88), INT8_C(-110), INT8_C( -48),
                           INT8_C(  76), INT8_C( -59), INT8_C(  68), INT8_C( -74),
                           INT8_C(-118), INT8_C(  -5), INT8_C( 100), INT8_C(  20),
                           INT8_C(  96), INT8_C(-121), INT8_C(  54), INT8_C( 113),
                           INT8_C( -38), INT8_C(  70), INT8_C( -49), INT8_C(   4),
                           INT8_C( -35), INT8_C(  89), INT8_C(-103), INT8_C(  21),
                           INT8_C(  58), INT8_C( -45), INT8_C( 126), INT8_C(  -7),
                           INT8_C(  69), INT8_C(   5), INT8_C( -82), INT8_C(-111)),
      UINT32_C(  36883191),
      simde_mm256_set_epi8(INT8_C( -69), INT8_C( -62), INT8_C(-105), INT8_C(  38),
                           INT8_C(  99), INT8_C( -23), INT8_C(  54), INT8_C( -37),
                           INT8_C( 100), INT8_C(  45), INT8_C( -71), INT8_C(-119),
                           INT8_C(  49), INT8_C( -65), INT8_C(  94), INT8_C(  96),
                           INT8_C( -71), INT8_C( 118), INT8_C( -91), INT8_C( -10),
                           INT8_C(  38), INT8_C( -84), INT8_C( -72), INT8_C( -61),
                           INT8_C(  27), INT8_C(  -2), INT8_C(  62), INT8_C(  34),
                           INT8_C( 118), INT8_C(  94), INT8_C( -81), INT8_C(  50)),
      simde_mm256_set_epi8(INT8_C(  56), INT8_C( -71), INT8_C(  70), INT8_C(  52),
                           INT8_C( 105), INT8_C(  74), INT8_C( -52), INT8_C( 125),
                           INT8_C(  71), INT8_C(  78), INT8_C( 102), INT8_C( -87),
                           INT8_C( -42), INT8_C(  16), INT8_C( 120), INT8_C(  -7),
                           INT8_C(  86), INT8_C( 101), INT8_C(  24), INT8_C( 125),
                           INT8_C( -69), INT8_C(  65), INT8_C(  12), INT8_C( -54),
                           INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                           INT8_C( -97), INT8_C(  62), INT8_C(  26), INT8_C(  78)),
      simde_mm256_set_epi8(INT8_C( -22), INT8_C( -88), INT8_C(-110), INT8_C( -48),
                           INT8_C(  76), INT8_C( -59), INT8_C( -55), INT8_C( -74),
                           INT8_C(-118), INT8_C(  -5), INT8_C(  28), INT8_C( -20),
                           INT8_C(  96), INT8_C(-121), INT8_C( -36), INT8_C( 113),
                           INT8_C( -40), INT8_C(-108), INT8_C( -49), INT8_C(   4),
                           INT8_C(  24), INT8_C(  89), INT8_C( -75), INT8_C(  21),
                           INT8_C(-108), INT8_C( -40), INT8_C(  88), INT8_C( -72),
                           INT8_C(  69), INT8_C(  -9), INT8_C(  23), INT8_C( -33)) },
    { simde_mm256_set_epi8(INT8_C( -26), INT8_C(  57), INT8_C( -91), INT8_C(  79),
                           INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                           INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                           INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121),
                           INT8_C(-115), INT8_C(  83), INT8_C( -51), INT8_C(-117),
                           INT8_C( -24), INT8_C( -79), INT8_C(  55), INT8_C(-125),
                           INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                           INT8_C( -62), INT8_C(  72), INT8_C(  66), INT8_C(-110)),
      UINT32_C(1476407478),
      simde_mm256_set_epi8(INT8_C( 105), INT8_C(   4), INT8_C(   0), INT8_C( 126),
                           INT8_C(  17), INT8_C( -37), INT8_C( 124), INT8_C(  81),
                           INT8_C( -49), INT8_C( -80), INT8_C(  50), INT8_C( 114),
                           INT8_C( 103), INT8_C( 115), INT8_C(  11), INT8_C( 121),
                           INT8_C(  83), INT8_C( -70), INT8_C( -20), INT8_C( -26),
                           INT8_C( 113), INT8_C(  81), INT8_C(-104), INT8_C(  87),
                           INT8_C(  17), INT8_C(  59), INT8_C( -92), INT8_C( -92),
                           INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84)),
      simde_mm256_set_epi8(INT8_C(  97), INT8_C(-126), INT8_C( -49), INT8_C(  31),
                           INT8_C(  80), INT8_C( -15), INT8_C(-103), INT8_C( -93),
                           INT8_C( 122), INT8_C(  28), INT8_C(  31), INT8_C(  41),
                           INT8_C( -69), INT8_C(  33), INT8_C(  70), INT8_C(  26),
                           INT8_C( -60), INT8_C( 101), INT8_C(  20), INT8_C( -20),
                           INT8_C( 122), INT8_C( 120), INT8_C(-101), INT8_C( -57),
                           INT8_C(   8), INT8_C( -41), INT8_C(  78), INT8_C( -24),
                           INT8_C( -85), INT8_C( -99), INT8_C( -85), INT8_C( -95)),
      simde_mm256_set_epi8(INT8_C( -26), INT8_C( -78), INT8_C( -91), INT8_C(  69),
                           INT8_C( 125), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                           INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                           INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121),
                           INT8_C(-115), INT8_C(  83), INT8_C( -76), INT8_C( -39),
                           INT8_C( -24), INT8_C( -79), INT8_C(  55), INT8_C(-125),
                           INT8_C( 104), INT8_C(-109), INT8_C(  75), INT8_C(  75),
                           INT8_C( -62), INT8_C(  27), INT8_C(  51), INT8_C(-110)) },
    { simde_mm256_set_epi8(INT8_C(  93), INT8_C(  34), INT8_C( -81), INT8_C(  29),
                           INT8_C( -48), INT8_C( -91), INT8_C(-101), INT8_C(  33),
                           INT8_C( -32), INT8_C(-111), INT8_C( -86), INT8_C(  81),
                           INT8_C( -69), INT8_C( -40), INT8_C(-105), INT8_C(  25),
                           INT8_C(  10), INT8_C( 111), INT8_C(   0), INT8_C( 102),
                           INT8_C( -29), INT8_C( -79), INT8_C( -33), INT8_C( -18),
                           INT8_C(-126), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                           INT8_C(  45), INT8_C(  80), INT8_C(-116), INT8_C(   9)),
      UINT32_C( 475630479),
      simde_mm256_set_epi8(INT8_C(  62), INT8_C( -50), INT8_C(  30), INT8_C(  -6),
                           INT8_C(  85), INT8_C(  -1), INT8_C(  20), INT8_C( -57),
                           INT8_C( -39), INT8_C(  81), INT8_C( -54), INT8_C( 103),
                           INT8_C( -31), INT8_C(  76), INT8_C(  -6), INT8_C(  19),
                           INT8_C(   0), INT8_C( -53), INT8_C( -62), INT8_C(  52),
                           INT8_C( -64), INT8_C(  34), INT8_C( -62), INT8_C(  62),
                           INT8_C(  85), INT8_C( -50), INT8_C(-124), INT8_C( -51),
                           INT8_C( -15), INT8_C( 123), INT8_C( -57), INT8_C(  49)),
      simde_mm256_set_epi8(INT8_C(  10), INT8_C(  16), INT8_C(  30), INT8_C(-118),
                           INT8_C( -14), INT8_C(  16), INT8_C( -24), INT8_C( 121),
                           INT8_C(  27), INT8_C(  42), INT8_C( -96), INT8_C( -57),
                           INT8_C(-122), INT8_C(  20), INT8_C(  54), INT8_C(  94),
                           INT8_C(  37), INT8_C( 113), INT8_C( -54), INT8_C(  15),
                           INT8_C(-119), INT8_C(-119), INT8_C( 102), INT8_C(  12),
                           INT8_C( -50), INT8_C(-100), INT8_C(  91), INT8_C( -73),
                           INT8_C(-128), INT8_C( -69), INT8_C(  75), INT8_C(  41)),
      simde_mm256_set_epi8(INT8_C(  93), INT8_C(  34), INT8_C( -81), INT8_C( -79),
                           INT8_C(-102), INT8_C(  49), INT8_C(-101), INT8_C(  33),
                           INT8_C( -32), INT8_C(  92), INT8_C( -86), INT8_C(  20),
                           INT8_C(  60), INT8_C( -40), INT8_C(-105), INT8_C(-105),
                           INT8_C(  78), INT8_C( 111), INT8_C(   0), INT8_C( 102),
                           INT8_C(-123), INT8_C( -79), INT8_C(  15), INT8_C(-115),
                           INT8_C( -19), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                           INT8_C( 103), INT8_C(  40), INT8_C(  35), INT8_C( -20)) },
    { simde_mm256_set_epi8(INT8_C( -37), INT8_C(   0), INT8_C(  84), INT8_C( 112),
                           INT8_C(  67), INT8_C(-128), INT8_C( -76), INT8_C( -90),
                           INT8_C( -77), INT8_C(  21), INT8_C(  79), INT8_C(  -2),
                           INT8_C(   5), INT8_C(  83), INT8_C(  16), INT8_C( 106),
                           INT8_C(  20), INT8_C(  -1), INT8_C( 126), INT8_C( -58),
                           INT8_C(-122), INT8_C( -63), INT8_C(   0), INT8_C(  21),
                           INT8_C( 125), INT8_C(-120), INT8_C(  11), INT8_C(  36),
                           INT8_C( -16), INT8_C(  30), INT8_C( -96), INT8_C(  28)),
      UINT32_C(1359096050),
      simde_mm256_set_epi8(INT8_C( -64), INT8_C( 109), INT8_C(   8), INT8_C(  18),
                           INT8_C(  97), INT8_C( -33), INT8_C(  74), INT8_C( 101),
                           INT8_C( 114), INT8_C(  73), INT8_C(  13), INT8_C( -15),
                           INT8_C( -63), INT8_C( -87), INT8_C(  43), INT8_C( -66),
                           INT8_C(  75), INT8_C( -79), INT8_C( 108), INT8_C( -46),
                           INT8_C(-111), INT8_C( 109), INT8_C(  40), INT8_C(  40),
                           INT8_C( -24), INT8_C( -34), INT8_C(  68), INT8_C(  73),
                           INT8_C(  83), INT8_C( -82), INT8_C( 100), INT8_C( 122)),
      simde_mm256_set_epi8(INT8_C(  49), INT8_C(  63), INT8_C( -20), INT8_C(  36),
                           INT8_C(  62), INT8_C(  14), INT8_C( -92), INT8_C(  -1),
                           INT8_C(  45), INT8_C(  43), INT8_C( -36), INT8_C( -24),
                           INT8_C(-118), INT8_C(  66), INT8_C( -23), INT8_C(   1),
                           INT8_C( 115), INT8_C( -91), INT8_C(-114), INT8_C( -33),
                           INT8_C( 119), INT8_C( -27), INT8_C( -46), INT8_C( -37),
                           INT8_C(-114), INT8_C(  33), INT8_C( 101), INT8_C( -50),
                           INT8_C(  17), INT8_C(  -4), INT8_C(  39), INT8_C( -76)),
      simde_mm256_set_epi8(INT8_C( -37), INT8_C(  40), INT8_C(  84), INT8_C(  81),
                           INT8_C(  67), INT8_C(-128), INT8_C( -76), INT8_C(  25),
                           INT8_C( -77), INT8_C(  21), INT8_C(  79), INT8_C(  -2),
                           INT8_C(   5), INT8_C(  83), INT8_C(-116), INT8_C( 106),
                           INT8_C(  20), INT8_C(  -1), INT8_C( -62), INT8_C( -58),
                           INT8_C( -43), INT8_C( -63), INT8_C(   0), INT8_C(  21),
                           INT8_C( 103), INT8_C(  87), INT8_C(  58), INT8_C( 105),
                           INT8_C( -16), INT8_C(  30), INT8_C(  29), INT8_C(  28)) },
    { simde_mm256_set_epi8(INT8_C( -37), INT8_C(  29), INT8_C(  33), INT8_C( -67),
                           INT8_C( -58), INT8_C(  64), INT8_C( -22), INT8_C( 127),
                           INT8_C( 113), INT8_C(  -3), INT8_C( -82), INT8_C(  61),
                           INT8_C( 114), INT8_C(  95), INT8_C(  56), INT8_C(  11),
                           INT8_C(  39), INT8_C( 125), INT8_C(  59), INT8_C(  11),
                           INT8_C(  10), INT8_C(  91), INT8_C(  91), INT8_C(-118),
                           INT8_C(-117), INT8_C( 125), INT8_C( -40), INT8_C(  88),
                           INT8_C(  24), INT8_C( -96), INT8_C(  22), INT8_C(-107)),
      UINT32_C( 847147114),
      simde_mm256_set_epi8(INT8_C( 122), INT8_C( 119), INT8_C(   9), INT8_C(  26),
                           INT8_C( 110), INT8_C( -42), INT8_C( -67), INT8_C(  -7),
                           INT8_C( 125), INT8_C( 120), INT8_C( -78), INT8_C( -83),
                           INT8_C( -76), INT8_C(  43), INT8_C(  -6), INT8_C(  63),
                           INT8_C( -16), INT8_C(  16), INT8_C( -21), INT8_C(-128),
                           INT8_C(  14), INT8_C( -28), INT8_C(  76), INT8_C(-108),
                           INT8_C( -40), INT8_C( -35), INT8_C(  36), INT8_C( -38),
                           INT8_C(   3), INT8_C( -17), INT8_C(  32), INT8_C( 103)),
      simde_mm256_set_epi8(INT8_C( -92), INT8_C( -10), INT8_C( -37), INT8_C( -55),
                           INT8_C(  26), INT8_C(  99), INT8_C( 118), INT8_C( 104),
                           INT8_C(  69), INT8_C( -79), INT8_C(  96), INT8_C(  14),
                           INT8_C(  27), INT8_C( 115), INT8_C(  -2), INT8_C( -45),
                           INT8_C(  88), INT8_C( -52), INT8_C(  70), INT8_C(-120),
                           INT8_C(  78), INT8_C(  99), INT8_C(  69), INT8_C(-111),
                           INT8_C( 113), INT8_C(  76), INT8_C(  28), INT8_C(   7),
                           INT8_C( -98), INT8_C( -99), INT8_C(-123), INT8_C(  88)),
      simde_mm256_set_epi8(INT8_C( -37), INT8_C(  29), INT8_C(  37), INT8_C( -23),
                           INT8_C( -58), INT8_C(  64), INT8_C(  43), INT8_C( 127),
                           INT8_C( 113), INT8_C( -87), INT8_C( -26), INT8_C(  13),
                           INT8_C(  15), INT8_C(  70), INT8_C( -99), INT8_C(  11),
                           INT8_C(  39), INT8_C( -50), INT8_C(  71), INT8_C(  16),
                           INT8_C(  10), INT8_C(  91), INT8_C(  91), INT8_C(-118),
                           INT8_C(-117), INT8_C( -65), INT8_C( 111), INT8_C(  88),
                           INT8_C( 111), INT8_C( -96), INT8_C(  84), INT8_C(-107)) },
    { simde_mm256_set_epi8(INT8_C(  54), INT8_C( -69), INT8_C(  72), INT8_C( 111),
                           INT8_C(  33), INT8_C( -99), INT8_C(  -4), INT8_C(  32),
                           INT8_C(-118), INT8_C( 119), INT8_C( 126), INT8_C( -30),
                           INT8_C( -60), INT8_C( -48), INT8_C( -93), INT8_C( 113),
                           INT8_C(  44), INT8_C(  13), INT8_C(  40), INT8_C(  25),
                           INT8_C( -54), INT8_C( -49), INT8_C(-104), INT8_C(-106),
                           INT8_C(  -8), INT8_C(  71), INT8_C(  97), INT8_C( -37),
                           INT8_C( -97), INT8_C( 104), INT8_C( -72), INT8_C( -12)),
      UINT32_C(3956112043),
      simde_mm256_set_epi8(INT8_C(  51), INT8_C(  38), INT8_C( -90), INT8_C(  14),
                           INT8_C( -23), INT8_C( 121), INT8_C(  31), INT8_C( -78),
                           INT8_C( -80), INT8_C( -80), INT8_C( -11), INT8_C( 101),
                           INT8_C( -38), INT8_C( -92), INT8_C( -62), INT8_C(  21),
                           INT8_C( -98), INT8_C( 125), INT8_C( 126), INT8_C(  47),
                           INT8_C( -61), INT8_C( 119), INT8_C(  16), INT8_C( -89),
                           INT8_C( 113), INT8_C( -56), INT8_C( -82), INT8_C(-119),
                           INT8_C(  18), INT8_C( -58), INT8_C(  99), INT8_C( -43)),
      simde_mm256_set_epi8(INT8_C( 113), INT8_C( -85), INT8_C( -34), INT8_C(  49),
                           INT8_C(  43), INT8_C( -40), INT8_C( -68), INT8_C(  40),
                           INT8_C( 117), INT8_C(  67), INT8_C( -53), INT8_C(   2),
                           INT8_C( -36), INT8_C(  64), INT8_C( -49), INT8_C(  42),
                           INT8_C( -73), INT8_C(  13), INT8_C(  54), INT8_C(-116),
                           INT8_C(-102), INT8_C( -83), INT8_C( -29), INT8_C(  55),
                           INT8_C(  57), INT8_C(  87), INT8_C(  73), INT8_C( -70),
                           INT8_C(-103), INT8_C(-105), INT8_C( -99), INT8_C(   2)),
      simde_mm256_set_epi8(INT8_C(   2), INT8_C(   5), INT8_C( -17), INT8_C( 111),
                           INT8_C( -49), INT8_C( -99), INT8_C(-120), INT8_C(-100),
                           INT8_C( -53), INT8_C( -53), INT8_C( 126), INT8_C( -30),
                           INT8_C(  60), INT8_C(  22), INT8_C( -93), INT8_C(-110),
                           INT8_C(  44), INT8_C( -24), INT8_C( -44), INT8_C( -94),
                           INT8_C( -28), INT8_C( -49), INT8_C( -47), INT8_C(-106),
                           INT8_C(  -5), INT8_C(  71), INT8_C( -31), INT8_C( -37),
                           INT8_C( -56), INT8_C( 104), INT8_C(-106), INT8_C( -53)) },
    { simde_mm256_set_epi8(INT8_C(  14), INT8_C(  10), INT8_C(  41), INT8_C(  17),
                           INT8_C( -27), INT8_C(-110), INT8_C(  84), INT8_C( -17),
                           INT8_C( 100), INT8_C(  28), INT8_C( -98), INT8_C( -75),
                           INT8_C(  86), INT8_C( -13), INT8_C( -71), INT8_C( -97),
                           INT8_C(-109), INT8_C( -82), INT8_C(  68), INT8_C(  69),
                           INT8_C(   3), INT8_C(  91), INT8_C( -46), INT8_C(  55),
                           INT8_C( -27), INT8_C( -27), INT8_C( -39), INT8_C( -77),
                           INT8_C(  21), INT8_C(  50), INT8_C(  79), INT8_C( -83)),
      UINT32_C(2605025778),
      simde_mm256_set_epi8(INT8_C(  38), INT8_C( -41), INT8_C( 112), INT8_C( 117),
                           INT8_C(  58), INT8_C(  17), INT8_C(-102), INT8_C( -45),
                           INT8_C(   5), INT8_C(  37), INT8_C(  20), INT8_C( -10),
                           INT8_C( 125), INT8_C( -30), INT8_C( -78), INT8_C(-119),
                           INT8_C( -34), INT8_C( -69), INT8_C(   5), INT8_C(  -4),
                           INT8_C(  57), INT8_C( -46), INT8_C(  38), INT8_C(-103),
                           INT8_C(  38), INT8_C(  94), INT8_C(   6), INT8_C( 108),
                           INT8_C( 102), INT8_C( 123), INT8_C( 103), INT8_C( 112)),
      simde_mm256_set_epi8(INT8_C(  98), INT8_C(  31), INT8_C( -53), INT8_C( 122),
                           INT8_C( -44), INT8_C( 121), INT8_C( -29), INT8_C( -24),
                           INT8_C(  49), INT8_C(-103), INT8_C(  -9), INT8_C(-119),
                           INT8_C( -99), INT8_C(  40), INT8_C( -76), INT8_C( 102),
                           INT8_C( -62), INT8_C( -47), INT8_C(-114), INT8_C(  87),
                           INT8_C( -23), INT8_C( -34), INT8_C( -44), INT8_C(   6),
                           INT8_C(  21), INT8_C( -94), INT8_C( -31), INT8_C(  89),
                           INT8_C(  -3), INT8_C( 101), INT8_C(  62), INT8_C( -72)),
      simde_mm256_set_epi8(INT8_C( -35), INT8_C(  10), INT8_C(  41), INT8_C(  61),
                           INT8_C( -89), INT8_C(-110), INT8_C(  53), INT8_C( 115),
                           INT8_C( 100), INT8_C(  59), INT8_C( -98), INT8_C( -75),
                           INT8_C(  86), INT8_C(-109), INT8_C( -71), INT8_C(  45),
                           INT8_C(  83), INT8_C( -82), INT8_C(  68), INT8_C(  69),
                           INT8_C( -62), INT8_C(  91), INT8_C( -46), INT8_C( -56),
                           INT8_C( -10), INT8_C( -71), INT8_C(  -6), INT8_C(  30),
                           INT8_C(  21), INT8_C(  50), INT8_C(  13), INT8_C( -83)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_mask_gf2p8affineinv_epi64_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C(  78));
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i x;
    simde__m512i A;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -60), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                           INT8_C(  51), INT8_C(  20), INT8_C(  52), INT8_C(-114),
                           INT8_C(  -6), INT8_C(  43), INT8_C(  55), INT8_C(  12),
                           INT8_C(  60), INT8_C(  72), INT8_C(  58), INT8_C( 119),
                           INT8_C(-125), INT8_C(-116), INT8_C(  -2), INT8_C(  35),
                           INT8_C(  46), INT8_C( -63), INT8_C( -77), INT8_C( -15),
                           INT8_C( -42), INT8_C(  62), INT8_C(  88), INT8_C(   7),
                           INT8_C(  61), INT8_C( 116), INT8_C( -89), INT8_C( 122),
                           INT8_C( 102), INT8_C( -48), INT8_C( 124), INT8_C(  70),
                           INT8_C(  47), INT8_C(  38), INT8_C( 113), INT8_C( -68),
                           INT8_C( -88), INT8_C(  75), INT8_C(  45), INT8_C( 101),
                           INT8_C( -48), INT8_C(  40), INT8_C(  43), INT8_C(-120),
                           INT8_C(  86), INT8_C(-109), INT8_C(-116), INT8_C(  52),
                           INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  33),
                           INT8_C(  37), INT8_C(  31), INT8_C(  47), INT8_C(  64),
                           INT8_C(  83), INT8_C(  59), INT8_C(  -2), INT8_C(-123)),
      UINT64_C( 5672856459990176132),
      simde_mm512_set_epi8(INT8_C( -22), INT8_C( -88), INT8_C(-110), INT8_C( -48),
                           INT8_C(  76), INT8_C( -59), INT8_C(  68), INT8_C( -74),
                           INT8_C(-118), INT8_C(  -5), INT8_C( 100), INT8_C(  20),
                           INT8_C(  96), INT8_C(-121), INT8_C(  54), INT8_C( 113),
                           INT8_C( -38), INT8_C(  70), INT8_C( -49), INT8_C(   4),
                           INT8_C( -35), INT8_C(  89), INT8_C(-103), INT8_C(  21),
                           INT8_C(  58), INT8_C( -45), INT8_C( 126), INT8_C(  -7),
                           INT8_C(  69), INT8_C(   5), INT8_C( -82), INT8_C(-111),
                           INT8_C( -84), INT8_C(  28), INT8_C( -27), INT8_C(-123),
                           INT8_C(  82), INT8_C(-107), INT8_C( -80), INT8_C(  79),
                           INT8_C( 120), INT8_C( -68), INT8_C( -84), INT8_C( -49),
                           INT8_C(  87), INT8_C( -79), INT8_C( -74), INT8_C(  92),
                           INT8_C(  64), INT8_C(-128), INT8_C( -63), INT8_C( -93),
                           INT8_C(  85), INT8_C( -44), INT8_C(  26), INT8_C(-115),
                           INT8_C(-101), INT8_C(  76), INT8_C(-128), INT8_C( -17),
                           INT8_C(-103), INT8_C(   2), INT8_C(  62), INT8_C(-126)),
      simde_mm512_set_epi8(INT8_C(  71), INT8_C(  78), INT8_C( 102), INT8_C( -87),
                           INT8_C( -42), INT8_C(  16), INT8_C( 120), INT8_C(  -7),
                           INT8_C(  86), INT8_C( 101), INT8_C(  24), INT8_C( 125),
                           INT8_C( -69), INT8_C(  65), INT8_C(  12), INT8_C( -54),
                           INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                           INT8_C( -97), INT8_C(  62), INT8_C(  26), INT8_C(  78),
                           INT8_C( -69), INT8_C( -62), INT8_C(-105), INT8_C(  38),
                           INT8_C(  99), INT8_C( -23), INT8_C(  54), INT8_C( -37),
                           INT8_C( 100), INT8_C(  45), INT8_C( -71), INT8_C(-119),
                           INT8_C(  49), INT8_C( -65), INT8_C(  94), INT8_C(  96),
                           INT8_C( -71), INT8_C( 118), INT8_C( -91), INT8_C( -10),
                           INT8_C(  38), INT8_C( -84), INT8_C( -72), INT8_C( -61),
                           INT8_C(  27), INT8_C(  -2), INT8_C(  62), INT8_C(  34),
                           INT8_C( 118), INT8_C(  94), INT8_C( -81), INT8_C(  50),
                           INT8_C( -73), INT8_C(  61), INT8_C(  67), INT8_C( -62),
                           INT8_C(   2), INT8_C(  50), INT8_C( -54), INT8_C(  -9)),
      simde_mm512_set_epi8(INT8_C( -60), INT8_C(  96), INT8_C(  94), INT8_C( -85),
                           INT8_C(-100), INT8_C(   4), INT8_C(  52), INT8_C(-114),
                           INT8_C(  80), INT8_C(  43), INT8_C( -31), INT8_C( -57),
                           INT8_C( 107), INT8_C(  72), INT8_C( -57), INT8_C( 119),
                           INT8_C(-125), INT8_C(-116), INT8_C(  -2), INT8_C(  35),
                           INT8_C(-102), INT8_C( -63), INT8_C( -77), INT8_C( -15),
                           INT8_C( -43), INT8_C(  13), INT8_C( -66), INT8_C(   7),
                           INT8_C(  61), INT8_C(   4), INT8_C( -89), INT8_C( 122),
                           INT8_C(  44), INT8_C( -47), INT8_C( -63), INT8_C(  70),
                           INT8_C( -15), INT8_C(-114), INT8_C( -95), INT8_C(  -4),
                           INT8_C( -88), INT8_C( -81), INT8_C(  14), INT8_C(  16),
                           INT8_C(  53), INT8_C( -76), INT8_C( 115), INT8_C(-120),
                           INT8_C(  75), INT8_C(-109), INT8_C(-116), INT8_C(  98),
                           INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  83),
                           INT8_C(  39), INT8_C(  31), INT8_C(  47), INT8_C(  64),
                           INT8_C(  83), INT8_C(  35), INT8_C(  -2), INT8_C(-123)) },
    { simde_mm512_set_epi8(INT8_C(  83), INT8_C( -70), INT8_C( -20), INT8_C( -26),
                           INT8_C( 113), INT8_C(  81), INT8_C(-104), INT8_C(  87),
                           INT8_C(  17), INT8_C(  59), INT8_C( -92), INT8_C( -92),
                           INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84),
                           INT8_C(  12), INT8_C(  33), INT8_C( -50), INT8_C( -22),
                           INT8_C(  88), INT8_C(   0), INT8_C(  48), INT8_C( -74),
                           INT8_C( -26), INT8_C(  57), INT8_C( -91), INT8_C(  79),
                           INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                           INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                           INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121),
                           INT8_C(-115), INT8_C(  83), INT8_C( -51), INT8_C(-117),
                           INT8_C( -24), INT8_C( -79), INT8_C(  55), INT8_C(-125),
                           INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                           INT8_C( -62), INT8_C(  72), INT8_C(  66), INT8_C(-110),
                           INT8_C(  56), INT8_C( -71), INT8_C(  70), INT8_C(  52),
                           INT8_C( 105), INT8_C(  74), INT8_C( -52), INT8_C( 125)),
      UINT64_C(14965517028695411577),
      simde_mm512_set_epi8(INT8_C( -32), INT8_C(-111), INT8_C( -86), INT8_C(  81),
                           INT8_C( -69), INT8_C( -40), INT8_C(-105), INT8_C(  25),
                           INT8_C(  10), INT8_C( 111), INT8_C(   0), INT8_C( 102),
                           INT8_C( -29), INT8_C( -79), INT8_C( -33), INT8_C( -18),
                           INT8_C(-126), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                           INT8_C(  45), INT8_C(  80), INT8_C(-116), INT8_C(   9),
                           INT8_C(  97), INT8_C(-126), INT8_C( -49), INT8_C(  31),
                           INT8_C(  80), INT8_C( -15), INT8_C(-103), INT8_C( -93),
                           INT8_C( 122), INT8_C(  28), INT8_C(  31), INT8_C(  41),
                           INT8_C( -69), INT8_C(  33), INT8_C(  70), INT8_C(  26),
                           INT8_C( -60), INT8_C( 101), INT8_C(  20), INT8_C( -20),
                           INT8_C( 122), INT8_C( 120), INT8_C(-101), INT8_C( -57),
                           INT8_C(   8), INT8_C( -41), INT8_C(  78), INT8_C( -24),
                           INT8_C( -85), INT8_C( -99), INT8_C( -85), INT8_C( -95),
                           INT8_C( 105), INT8_C(   4), INT8_C(   0), INT8_C( 126),
                           INT8_C(  17), INT8_C( -37), INT8_C( 124), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  37), INT8_C( 113), INT8_C( -54), INT8_C(  15),
                           INT8_C(-119), INT8_C(-119), INT8_C( 102), INT8_C(  12),
                           INT8_C( -50), INT8_C(-100), INT8_C(  91), INT8_C( -73),
                           INT8_C(-128), INT8_C( -69), INT8_C(  75), INT8_C(  41),
                           INT8_C(  62), INT8_C( -50), INT8_C(  30), INT8_C(  -6),
                           INT8_C(  85), INT8_C(  -1), INT8_C(  20), INT8_C( -57),
                           INT8_C( -39), INT8_C(  81), INT8_C( -54), INT8_C( 103),
                           INT8_C( -31), INT8_C(  76), INT8_C(  -6), INT8_C(  19),
                           INT8_C(   0), INT8_C( -53), INT8_C( -62), INT8_C(  52),
                           INT8_C( -64), INT8_C(  34), INT8_C( -62), INT8_C(  62),
                           INT8_C(  85), INT8_C( -50), INT8_C(-124), INT8_C( -51),
                           INT8_C( -15), INT8_C( 123), INT8_C( -57), INT8_C(  49),
                           INT8_C( -56), INT8_C( -96), INT8_C(-107), INT8_C(  81),
                           INT8_C(  28), INT8_C(  89), INT8_C(-117), INT8_C(-113),
                           INT8_C(  93), INT8_C(  34), INT8_C( -81), INT8_C(  29),
                           INT8_C( -48), INT8_C( -91), INT8_C(-101), INT8_C(  33)),
      simde_mm512_set_epi8(INT8_C( -30), INT8_C(  89), INT8_C( -20), INT8_C( -26),
                           INT8_C( -93), INT8_C(  83), INT8_C( -25), INT8_C( -17),
                           INT8_C(  15), INT8_C(  59), INT8_C( -84), INT8_C(  76),
                           INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84),
                           INT8_C(  12), INT8_C(  33), INT8_C( -53), INT8_C(  25),
                           INT8_C(  88), INT8_C(   0), INT8_C(   0), INT8_C( -74),
                           INT8_C( -26), INT8_C(  82), INT8_C(  58), INT8_C( -82),
                           INT8_C(  72), INT8_C( -31), INT8_C(  71), INT8_C(  35),
                           INT8_C( -42), INT8_C(  98), INT8_C(  60), INT8_C(  48),
                           INT8_C(  88), INT8_C( -66), INT8_C(   6), INT8_C(-124),
                           INT8_C(-115), INT8_C( 111), INT8_C(-112), INT8_C(  -6),
                           INT8_C( -24), INT8_C( -79), INT8_C( -40), INT8_C(  82),
                           INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                           INT8_C( -76), INT8_C(  72), INT8_C( -76), INT8_C( -34),
                           INT8_C(  56), INT8_C(  47), INT8_C( -84), INT8_C(  53),
                           INT8_C(  10), INT8_C(  74), INT8_C( -52), INT8_C(-124)) },
    { simde_mm512_set_epi8(INT8_C( -24), INT8_C( -34), INT8_C(  68), INT8_C(  73),
                           INT8_C(  83), INT8_C( -82), INT8_C( 100), INT8_C( 122),
                           INT8_C(-100), INT8_C(-111), INT8_C(  81), INT8_C( -18),
                           INT8_C(  81), INT8_C(   2), INT8_C(  40), INT8_C( -14),
                           INT8_C( -37), INT8_C(   0), INT8_C(  84), INT8_C( 112),
                           INT8_C(  67), INT8_C(-128), INT8_C( -76), INT8_C( -90),
                           INT8_C( -77), INT8_C(  21), INT8_C(  79), INT8_C(  -2),
                           INT8_C(   5), INT8_C(  83), INT8_C(  16), INT8_C( 106),
                           INT8_C(  20), INT8_C(  -1), INT8_C( 126), INT8_C( -58),
                           INT8_C(-122), INT8_C( -63), INT8_C(   0), INT8_C(  21),
                           INT8_C( 125), INT8_C(-120), INT8_C(  11), INT8_C(  36),
                           INT8_C( -16), INT8_C(  30), INT8_C( -96), INT8_C(  28),
                           INT8_C(  10), INT8_C(  16), INT8_C(  30), INT8_C(-118),
                           INT8_C( -14), INT8_C(  16), INT8_C( -24), INT8_C( 121),
                           INT8_C(  27), INT8_C(  42), INT8_C( -96), INT8_C( -57),
                           INT8_C(-122), INT8_C(  20), INT8_C(  54), INT8_C(  94)),
      UINT64_C( 5454260275361163304),
      simde_mm512_set_epi8(INT8_C(  39), INT8_C( 125), INT8_C(  59), INT8_C(  11),
                           INT8_C(  10), INT8_C(  91), INT8_C(  91), INT8_C(-118),
                           INT8_C(-117), INT8_C( 125), INT8_C( -40), INT8_C(  88),
                           INT8_C(  24), INT8_C( -96), INT8_C(  22), INT8_C(-107),
                           INT8_C(  49), INT8_C(  63), INT8_C( -20), INT8_C(  36),
                           INT8_C(  62), INT8_C(  14), INT8_C( -92), INT8_C(  -1),
                           INT8_C(  45), INT8_C(  43), INT8_C( -36), INT8_C( -24),
                           INT8_C(-118), INT8_C(  66), INT8_C( -23), INT8_C(   1),
                           INT8_C( 115), INT8_C( -91), INT8_C(-114), INT8_C( -33),
                           INT8_C( 119), INT8_C( -27), INT8_C( -46), INT8_C( -37),
                           INT8_C(-114), INT8_C(  33), INT8_C( 101), INT8_C( -50),
                           INT8_C(  17), INT8_C(  -4), INT8_C(  39), INT8_C( -76),
                           INT8_C( -64), INT8_C( 109), INT8_C(   8), INT8_C(  18),
                           INT8_C(  97), INT8_C( -33), INT8_C(  74), INT8_C( 101),
                           INT8_C( 114), INT8_C(  73), INT8_C(  13), INT8_C( -15),
                           INT8_C( -63), INT8_C( -87), INT8_C(  43), INT8_C( -66)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  76), INT8_C(  28), INT8_C(   7),
                           INT8_C( -98), INT8_C( -99), INT8_C(-123), INT8_C(  88),
                           INT8_C( 122), INT8_C( 119), INT8_C(   9), INT8_C(  26),
                           INT8_C( 110), INT8_C( -42), INT8_C( -67), INT8_C(  -7),
                           INT8_C( 125), INT8_C( 120), INT8_C( -78), INT8_C( -83),
                           INT8_C( -76), INT8_C(  43), INT8_C(  -6), INT8_C(  63),
                           INT8_C( -16), INT8_C(  16), INT8_C( -21), INT8_C(-128),
                           INT8_C(  14), INT8_C( -28), INT8_C(  76), INT8_C(-108),
                           INT8_C( -40), INT8_C( -35), INT8_C(  36), INT8_C( -38),
                           INT8_C(   3), INT8_C( -17), INT8_C(  32), INT8_C( 103),
                           INT8_C(-115), INT8_C(  83), INT8_C( -28), INT8_C( -74),
                           INT8_C(  50), INT8_C( 126), INT8_C( 112), INT8_C( 106),
                           INT8_C( -37), INT8_C(  29), INT8_C(  33), INT8_C( -67),
                           INT8_C( -58), INT8_C(  64), INT8_C( -22), INT8_C( 127),
                           INT8_C( 113), INT8_C(  -3), INT8_C( -82), INT8_C(  61),
                           INT8_C( 114), INT8_C(  95), INT8_C(  56), INT8_C(  11)),
      simde_mm512_set_epi8(INT8_C( -24), INT8_C(  69), INT8_C(  68), INT8_C(  73),
                           INT8_C( 114), INT8_C( -82), INT8_C( -21), INT8_C( 126),
                           INT8_C(  15), INT8_C(-111), INT8_C( -43), INT8_C(-102),
                           INT8_C(  81), INT8_C(   2), INT8_C(  40), INT8_C( -86),
                           INT8_C( -37), INT8_C(  57), INT8_C( -29), INT8_C( 112),
                           INT8_C( 122), INT8_C( 124), INT8_C( -76), INT8_C( -90),
                           INT8_C(  57), INT8_C( -37), INT8_C(  79), INT8_C(  -8),
                           INT8_C(   5), INT8_C(  83), INT8_C( 121), INT8_C( 106),
                           INT8_C(-109), INT8_C(  -1), INT8_C( 126), INT8_C( -62),
                           INT8_C(-122), INT8_C( -63), INT8_C(   0), INT8_C(  51),
                           INT8_C( 125), INT8_C(-128), INT8_C( -54), INT8_C(  36),
                           INT8_C(  10), INT8_C( -56), INT8_C( -96), INT8_C( -43),
                           INT8_C(  10), INT8_C(  16), INT8_C(   3), INT8_C(-118),
                           INT8_C(  86), INT8_C(  16), INT8_C( -24), INT8_C( 121),
                           INT8_C(  27), INT8_C(  42), INT8_C( 109), INT8_C( -57),
                           INT8_C(  29), INT8_C(  20), INT8_C(  54), INT8_C(  94)) },
    { simde_mm512_set_epi8(INT8_C(  63), INT8_C(  74), INT8_C(  76), INT8_C( -51),
                           INT8_C( -21), INT8_C( -51), INT8_C( 122), INT8_C( -85),
                           INT8_C(  54), INT8_C( -69), INT8_C(  72), INT8_C( 111),
                           INT8_C(  33), INT8_C( -99), INT8_C(  -4), INT8_C(  32),
                           INT8_C(-118), INT8_C( 119), INT8_C( 126), INT8_C( -30),
                           INT8_C( -60), INT8_C( -48), INT8_C( -93), INT8_C( 113),
                           INT8_C(  44), INT8_C(  13), INT8_C(  40), INT8_C(  25),
                           INT8_C( -54), INT8_C( -49), INT8_C(-104), INT8_C(-106),
                           INT8_C(  -8), INT8_C(  71), INT8_C(  97), INT8_C( -37),
                           INT8_C( -97), INT8_C( 104), INT8_C( -72), INT8_C( -12),
                           INT8_C( -92), INT8_C( -10), INT8_C( -37), INT8_C( -55),
                           INT8_C(  26), INT8_C(  99), INT8_C( 118), INT8_C( 104),
                           INT8_C(  69), INT8_C( -79), INT8_C(  96), INT8_C(  14),
                           INT8_C(  27), INT8_C( 115), INT8_C(  -2), INT8_C( -45),
                           INT8_C(  88), INT8_C( -52), INT8_C(  70), INT8_C(-120),
                           INT8_C(  78), INT8_C(  99), INT8_C(  69), INT8_C(-111)),
      UINT64_C( 8198995025376732117),
      simde_mm512_set_epi8(INT8_C( -27), INT8_C( -27), INT8_C( -39), INT8_C( -77),
                           INT8_C(  21), INT8_C(  50), INT8_C(  79), INT8_C( -83),
                           INT8_C( 113), INT8_C( -85), INT8_C( -34), INT8_C(  49),
                           INT8_C(  43), INT8_C( -40), INT8_C( -68), INT8_C(  40),
                           INT8_C( 117), INT8_C(  67), INT8_C( -53), INT8_C(   2),
                           INT8_C( -36), INT8_C(  64), INT8_C( -49), INT8_C(  42),
                           INT8_C( -73), INT8_C(  13), INT8_C(  54), INT8_C(-116),
                           INT8_C(-102), INT8_C( -83), INT8_C( -29), INT8_C(  55),
                           INT8_C(  57), INT8_C(  87), INT8_C(  73), INT8_C( -70),
                           INT8_C(-103), INT8_C(-105), INT8_C( -99), INT8_C(   2),
                           INT8_C(  51), INT8_C(  38), INT8_C( -90), INT8_C(  14),
                           INT8_C( -23), INT8_C( 121), INT8_C(  31), INT8_C( -78),
                           INT8_C( -80), INT8_C( -80), INT8_C( -11), INT8_C( 101),
                           INT8_C( -38), INT8_C( -92), INT8_C( -62), INT8_C(  21),
                           INT8_C( -98), INT8_C( 125), INT8_C( 126), INT8_C(  47),
                           INT8_C( -61), INT8_C( 119), INT8_C(  16), INT8_C( -89)),
      simde_mm512_set_epi8(INT8_C(  38), INT8_C( -41), INT8_C( 112), INT8_C( 117),
                           INT8_C(  58), INT8_C(  17), INT8_C(-102), INT8_C( -45),
                           INT8_C(   5), INT8_C(  37), INT8_C(  20), INT8_C( -10),
                           INT8_C( 125), INT8_C( -30), INT8_C( -78), INT8_C(-119),
                           INT8_C( -34), INT8_C( -69), INT8_C(   5), INT8_C(  -4),
                           INT8_C(  57), INT8_C( -46), INT8_C(  38), INT8_C(-103),
                           INT8_C(  38), INT8_C(  94), INT8_C(   6), INT8_C( 108),
                           INT8_C( 102), INT8_C( 123), INT8_C( 103), INT8_C( 112),
                           INT8_C( -27), INT8_C(-114), INT8_C(-101), INT8_C(-115),
                           INT8_C(-101), INT8_C(  69), INT8_C(-119), INT8_C( -14),
                           INT8_C(  14), INT8_C(  10), INT8_C(  41), INT8_C(  17),
                           INT8_C( -27), INT8_C(-110), INT8_C(  84), INT8_C( -17),
                           INT8_C( 100), INT8_C(  28), INT8_C( -98), INT8_C( -75),
                           INT8_C(  86), INT8_C( -13), INT8_C( -71), INT8_C( -97),
                           INT8_C(-109), INT8_C( -82), INT8_C(  68), INT8_C(  69),
                           INT8_C(   3), INT8_C(  91), INT8_C( -46), INT8_C(  55)),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C(  36), INT8_C(  71), INT8_C( -33),
                           INT8_C( -21), INT8_C( -51), INT8_C( 122), INT8_C(-113),
                           INT8_C(-122), INT8_C( 108), INT8_C(  72), INT8_C( 111),
                           INT8_C( 124), INT8_C( -99), INT8_C(  -4), INT8_C(  32),
                           INT8_C(  61), INT8_C( 119), INT8_C( -31), INT8_C( -30),
                           INT8_C(  -4), INT8_C(  87), INT8_C(  90), INT8_C( 113),
                           INT8_C( 109), INT8_C(  13), INT8_C(  40), INT8_C(  25),
                           INT8_C( 108), INT8_C( -49), INT8_C(-104), INT8_C(  33),
                           INT8_C(  -8), INT8_C(  71), INT8_C(  97), INT8_C( -91),
                           INT8_C( -97), INT8_C( 104), INT8_C(  51), INT8_C( -12),
                           INT8_C( -66), INT8_C(  15), INT8_C( -37), INT8_C( -55),
                           INT8_C(  26), INT8_C(-128), INT8_C(  67), INT8_C( 104),
                           INT8_C(  69), INT8_C( -11), INT8_C( -74), INT8_C(  14),
                           INT8_C(  27), INT8_C( 115), INT8_C( -64), INT8_C(  95),
                           INT8_C( 116), INT8_C(  49), INT8_C(  70), INT8_C( 112),
                           INT8_C(  78), INT8_C(  99), INT8_C(  69), INT8_C( -30)) },
    { simde_mm512_set_epi8(INT8_C( 123), INT8_C(  45), INT8_C(  89), INT8_C( -95),
                           INT8_C(-117), INT8_C( -47), INT8_C(  71), INT8_C( 107),
                           INT8_C( -86), INT8_C( -74), INT8_C(  66), INT8_C( -36),
                           INT8_C(  -2), INT8_C(  91), INT8_C( -51), INT8_C(  23),
                           INT8_C( -45), INT8_C( -60), INT8_C( -99), INT8_C(  65),
                           INT8_C(-113), INT8_C(  -7), INT8_C( -76), INT8_C(  51),
                           INT8_C(  18), INT8_C(  27), INT8_C( -14), INT8_C( 124),
                           INT8_C( -66), INT8_C( -18), INT8_C(  -5), INT8_C(   0),
                           INT8_C(  98), INT8_C(  31), INT8_C( -53), INT8_C( 122),
                           INT8_C( -44), INT8_C( 121), INT8_C( -29), INT8_C( -24),
                           INT8_C(  49), INT8_C(-103), INT8_C(  -9), INT8_C(-119),
                           INT8_C( -99), INT8_C(  40), INT8_C( -76), INT8_C( 102),
                           INT8_C( -62), INT8_C( -47), INT8_C(-114), INT8_C(  87),
                           INT8_C( -23), INT8_C( -34), INT8_C( -44), INT8_C(   6),
                           INT8_C(  21), INT8_C( -94), INT8_C( -31), INT8_C(  89),
                           INT8_C(  -3), INT8_C( 101), INT8_C(  62), INT8_C( -72)),
      UINT64_C(14383600667434858867),
      simde_mm512_set_epi8(INT8_C(   7), INT8_C(  50), INT8_C(-110), INT8_C(  70),
                           INT8_C( -40), INT8_C(  59), INT8_C( 127), INT8_C( -94),
                           INT8_C( -96), INT8_C( -66), INT8_C( -54), INT8_C(-111),
                           INT8_C( -88), INT8_C( -27), INT8_C( -51), INT8_C( -96),
                           INT8_C( 118), INT8_C( -71), INT8_C( 125), INT8_C( 110),
                           INT8_C(-115), INT8_C(-128), INT8_C(  71), INT8_C(-120),
                           INT8_C(-113), INT8_C(  21), INT8_C( -93), INT8_C(-123),
                           INT8_C( -55), INT8_C( -21), INT8_C( -23), INT8_C(  47),
                           INT8_C( 101), INT8_C(-127), INT8_C(  66), INT8_C(  -9),
                           INT8_C( -88), INT8_C( -89), INT8_C(  79), INT8_C( -89),
                           INT8_C(-125), INT8_C(  89), INT8_C(  66), INT8_C(  35),
                           INT8_C( -61), INT8_C(  48), INT8_C( -39), INT8_C( 121),
                           INT8_C(   7), INT8_C( -12), INT8_C( 120), INT8_C(  61),
                           INT8_C( -91), INT8_C( 115), INT8_C(   9), INT8_C(  59),
                           INT8_C( -83), INT8_C(-127), INT8_C(  36), INT8_C( -14),
                           INT8_C( -98), INT8_C(  13), INT8_C( -23), INT8_C( -82)),
      simde_mm512_set_epi8(INT8_C( -30), INT8_C( 110), INT8_C( -97), INT8_C( -76),
                           INT8_C( -96), INT8_C( 126), INT8_C( -48), INT8_C(-117),
                           INT8_C(  20), INT8_C(  23), INT8_C(  95), INT8_C( -52),
                           INT8_C(  15), INT8_C( -26), INT8_C( -88), INT8_C(  -3),
                           INT8_C(  69), INT8_C( -98), INT8_C(-100), INT8_C(  33),
                           INT8_C( -17), INT8_C( -10), INT8_C( -53), INT8_C(  53),
                           INT8_C( -25), INT8_C(  38), INT8_C(  75), INT8_C(  71),
                           INT8_C( 106), INT8_C( -45), INT8_C( -51), INT8_C(  79),
                           INT8_C(  54), INT8_C( -50), INT8_C( -94), INT8_C(  16),
                           INT8_C(   3), INT8_C( -22), INT8_C( -34), INT8_C(  54),
                           INT8_C( 100), INT8_C(-117), INT8_C( 118), INT8_C(  16),
                           INT8_C(  34), INT8_C( -48), INT8_C( -90), INT8_C(  66),
                           INT8_C( -43), INT8_C(-128), INT8_C( 122), INT8_C( -97),
                           INT8_C(  32), INT8_C( -77), INT8_C( -10), INT8_C(  -9),
                           INT8_C(  -5), INT8_C( -84), INT8_C(-115), INT8_C(-106),
                           INT8_C(  40), INT8_C(-127), INT8_C(  47), INT8_C( -89)),
      simde_mm512_set_epi8(INT8_C(  -6), INT8_C( -70), INT8_C(  89), INT8_C( -95),
                           INT8_C(-117), INT8_C(  95), INT8_C( -42), INT8_C( -72),
                           INT8_C( -13), INT8_C( -74), INT8_C(  66), INT8_C(  10),
                           INT8_C( -59), INT8_C(  -7), INT8_C( -51), INT8_C(  23),
                           INT8_C( -32), INT8_C(  73), INT8_C( -99), INT8_C( -51),
                           INT8_C(-113), INT8_C(  -7), INT8_C( -76), INT8_C(  51),
                           INT8_C(  21), INT8_C(  27), INT8_C( -14), INT8_C(  48),
                           INT8_C(  38), INT8_C( -18), INT8_C(  -5), INT8_C(-113),
                           INT8_C(  98), INT8_C( -12), INT8_C( -28), INT8_C( 107),
                           INT8_C( -44), INT8_C( -84), INT8_C( -29), INT8_C( -84),
                           INT8_C( -50), INT8_C(-103), INT8_C(  -9), INT8_C(-119),
                           INT8_C( -99), INT8_C( -66), INT8_C(  24), INT8_C( 102),
                           INT8_C( -58), INT8_C( -47), INT8_C( 123), INT8_C(  23),
                           INT8_C(  82), INT8_C( -34), INT8_C( -44), INT8_C(  29),
                           INT8_C(  21), INT8_C(  39), INT8_C(-113), INT8_C(  33),
                           INT8_C(  -3), INT8_C( 101), INT8_C(  -3), INT8_C( -62)) },
    { simde_mm512_set_epi8(INT8_C(  29), INT8_C(  58), INT8_C(  95), INT8_C(  42),
                           INT8_C(  15), INT8_C(  43), INT8_C( 119), INT8_C(  59),
                           INT8_C(-127), INT8_C( -47), INT8_C( -59), INT8_C(  -3),
                           INT8_C( -51), INT8_C(  41), INT8_C(   7), INT8_C(  -3),
                           INT8_C(  80), INT8_C(  88), INT8_C( 103), INT8_C( -43),
                           INT8_C(-102), INT8_C(  82), INT8_C( -24), INT8_C( -40),
                           INT8_C( -58), INT8_C(  26), INT8_C(  95), INT8_C(  -4),
                           INT8_C(  -1), INT8_C(-103), INT8_C( -99), INT8_C( -29),
                           INT8_C(  -5), INT8_C(   1), INT8_C( -57), INT8_C(  73),
                           INT8_C( -83), INT8_C(  48), INT8_C(  42), INT8_C(-113),
                           INT8_C( 102), INT8_C(  39), INT8_C( -51), INT8_C(   5),
                           INT8_C( -36), INT8_C( -70), INT8_C(  38), INT8_C(-126),
                           INT8_C( -24), INT8_C(-125), INT8_C( -94), INT8_C( -42),
                           INT8_C( 104), INT8_C( -11), INT8_C( -43), INT8_C(  61),
                           INT8_C( -61), INT8_C( -93), INT8_C( 105), INT8_C(  12),
                           INT8_C( -70), INT8_C( 125), INT8_C(  23), INT8_C( -91)),
      UINT64_C( 6749609748297998815),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C( -48), INT8_C(  24), INT8_C( 106),
                           INT8_C( 125), INT8_C(  90), INT8_C( -32), INT8_C( -90),
                           INT8_C(  74), INT8_C(  94), INT8_C( -67), INT8_C(  22),
                           INT8_C(  81), INT8_C( -59), INT8_C(  46), INT8_C(  91),
                           INT8_C(-123), INT8_C(  70), INT8_C( -77), INT8_C( 126),
                           INT8_C(   3), INT8_C(  23), INT8_C( -31), INT8_C( -25),
                           INT8_C( -96), INT8_C(  10), INT8_C(  22), INT8_C(  54),
                           INT8_C(  56), INT8_C( -52), INT8_C(-102), INT8_C(-105),
                           INT8_C( 107), INT8_C(  65), INT8_C( -61), INT8_C( -79),
                           INT8_C( 123), INT8_C( -51), INT8_C(  17), INT8_C( 126),
                           INT8_C( -83), INT8_C(  58), INT8_C( -81), INT8_C(  47),
                           INT8_C(  44), INT8_C(  77), INT8_C( 115), INT8_C( -95),
                           INT8_C( 123), INT8_C( -61), INT8_C( -18), INT8_C(  14),
                           INT8_C(  36), INT8_C(  -5), INT8_C(  29), INT8_C(  95),
                           INT8_C( -38), INT8_C( -24), INT8_C(  52), INT8_C( -93),
                           INT8_C(-118), INT8_C( -53), INT8_C(  97), INT8_C( -62)),
      simde_mm512_set_epi8(INT8_C( -63), INT8_C( -92), INT8_C(  23), INT8_C(-124),
                           INT8_C( -91), INT8_C( -30), INT8_C( -20), INT8_C( -98),
                           INT8_C( -66), INT8_C(  89), INT8_C(  27), INT8_C( -23),
                           INT8_C(-113), INT8_C( -53), INT8_C(  27), INT8_C(  25),
                           INT8_C( -63), INT8_C(  31), INT8_C( -46), INT8_C(  82),
                           INT8_C( 109), INT8_C(  43), INT8_C(   6), INT8_C(  80),
                           INT8_C(  22), INT8_C(  76), INT8_C( -79), INT8_C(-105),
                           INT8_C(  -5), INT8_C(  36), INT8_C(  67), INT8_C( -67),
                           INT8_C(-115), INT8_C(  66), INT8_C(-116), INT8_C( -56),
                           INT8_C( -74), INT8_C( -28), INT8_C(  19), INT8_C(-120),
                           INT8_C(  -8), INT8_C( -85), INT8_C(   1), INT8_C( 105),
                           INT8_C( 112), INT8_C( 102), INT8_C(-119), INT8_C( -90),
                           INT8_C(  31), INT8_C( -89), INT8_C(  26), INT8_C( -72),
                           INT8_C(  -9), INT8_C(-119), INT8_C(  92), INT8_C( 109),
                           INT8_C(  41), INT8_C(  49), INT8_C( -25), INT8_C( 124),
                           INT8_C( 121), INT8_C( -59), INT8_C( -23), INT8_C( -27)),
      simde_mm512_set_epi8(INT8_C(  29), INT8_C(  95), INT8_C(  95), INT8_C( -58),
                           INT8_C( -92), INT8_C( 122), INT8_C( 119), INT8_C( 116),
                           INT8_C( -24), INT8_C( -47), INT8_C( -75), INT8_C(  -3),
                           INT8_C( -81), INT8_C(  41), INT8_C( -23), INT8_C( 113),
                           INT8_C(  80), INT8_C( -21), INT8_C(  57), INT8_C( -43),
                           INT8_C( -74), INT8_C(-126), INT8_C(  -1), INT8_C( -40),
                           INT8_C( -58), INT8_C(  86), INT8_C(  95), INT8_C(  -4),
                           INT8_C(  18), INT8_C(  38), INT8_C(  17), INT8_C( -29),
                           INT8_C(  -5), INT8_C(   1), INT8_C( -57), INT8_C(  11),
                           INT8_C( -53), INT8_C(  48), INT8_C(  68), INT8_C(  80),
                           INT8_C( -95), INT8_C(  23), INT8_C( -51), INT8_C( -12),
                           INT8_C( -36), INT8_C( -70), INT8_C(  38), INT8_C(-126),
                           INT8_C( 104), INT8_C( -88), INT8_C( -40), INT8_C( -42),
                           INT8_C( 104), INT8_C( -11), INT8_C( -43), INT8_C(-122),
                           INT8_C(  24), INT8_C( -11), INT8_C( 105), INT8_C(  71),
                           INT8_C(   9), INT8_C(   0), INT8_C( -69), INT8_C( 117)) },
    { simde_mm512_set_epi8(INT8_C( 123), INT8_C(  59), INT8_C( -91), INT8_C(  35),
                           INT8_C( -96), INT8_C( 111), INT8_C(  38), INT8_C(  53),
                           INT8_C( -15), INT8_C( 111), INT8_C( -21), INT8_C(  77),
                           INT8_C(  -7), INT8_C(  35), INT8_C(-125), INT8_C(-119),
                           INT8_C(  -5), INT8_C( 114), INT8_C(  88), INT8_C( -19),
                           INT8_C( -98), INT8_C(  73), INT8_C(-102), INT8_C( -44),
                           INT8_C(-127), INT8_C(  61), INT8_C( -35), INT8_C( -36),
                           INT8_C(  43), INT8_C(-126), INT8_C( 127), INT8_C(  23),
                           INT8_C(  90), INT8_C(  73), INT8_C( 125), INT8_C(  90),
                           INT8_C(  71), INT8_C(  84), INT8_C(  18), INT8_C( 112),
                           INT8_C( -25), INT8_C( -21), INT8_C(   9), INT8_C(   8),
                           INT8_C( -84), INT8_C( -30), INT8_C(-123), INT8_C(  33),
                           INT8_C(  32), INT8_C(  18), INT8_C(  63), INT8_C(  60),
                           INT8_C(  93), INT8_C(  67), INT8_C(  62), INT8_C( -65),
                           INT8_C(-117), INT8_C( 119), INT8_C( -99), INT8_C( -90),
                           INT8_C( -44), INT8_C(  30), INT8_C(  25), INT8_C(  39)),
      UINT64_C( 9640592840815503565),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( 126), INT8_C(  20), INT8_C(  89),
                           INT8_C(   9), INT8_C(   9), INT8_C(-100), INT8_C( 107),
                           INT8_C( -76), INT8_C( -35), INT8_C(  20), INT8_C( -62),
                           INT8_C(  87), INT8_C( -82), INT8_C( 123), INT8_C(   1),
                           INT8_C(  14), INT8_C(  13), INT8_C(  95), INT8_C( -21),
                           INT8_C(  44), INT8_C( 107), INT8_C( -28), INT8_C(  63),
                           INT8_C( 111), INT8_C(  92), INT8_C(  71), INT8_C( -91),
                           INT8_C( -35), INT8_C(  39), INT8_C(  94), INT8_C( -48),
                           INT8_C( -58), INT8_C( -10), INT8_C( -87), INT8_C( -15),
                           INT8_C( -78), INT8_C( -53), INT8_C( -23), INT8_C(  66),
                           INT8_C(  37), INT8_C(  69), INT8_C( 119), INT8_C( -65),
                           INT8_C(-114), INT8_C(  56), INT8_C(-111), INT8_C(  59),
                           INT8_C( -64), INT8_C( 122), INT8_C(  12), INT8_C(  76),
                           INT8_C( -91), INT8_C(  97), INT8_C(  28), INT8_C( -82),
                           INT8_C(-121), INT8_C(  25), INT8_C(-101), INT8_C( -69),
                           INT8_C(  41), INT8_C( -61), INT8_C(  35), INT8_C(  67)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(  79), INT8_C( -35), INT8_C( -70),
                           INT8_C(  26), INT8_C(  99), INT8_C(-116), INT8_C( -30),
                           INT8_C( 114), INT8_C( 115), INT8_C( -91), INT8_C( -62),
                           INT8_C( -40), INT8_C( 109), INT8_C( 100), INT8_C( -48),
                           INT8_C( -65), INT8_C( -78), INT8_C(-117), INT8_C(-106),
                           INT8_C(  26), INT8_C(-101), INT8_C( -76), INT8_C(   6),
                           INT8_C(  33), INT8_C( -13), INT8_C( -85), INT8_C( 120),
                           INT8_C(  40), INT8_C(  -3), INT8_C(  13), INT8_C(  24),
                           INT8_C(  80), INT8_C(  72), INT8_C(  95), INT8_C(  -4),
                           INT8_C(  23), INT8_C(  83), INT8_C( -88), INT8_C(-123),
                           INT8_C(-118), INT8_C(  82), INT8_C(  40), INT8_C(  10),
                           INT8_C(  44), INT8_C(  43), INT8_C(  53), INT8_C(   7),
                           INT8_C(  60), INT8_C(  40), INT8_C( 118), INT8_C( -43),
                           INT8_C(  16), INT8_C( -92), INT8_C(  82), INT8_C( -97),
                           INT8_C( -23), INT8_C(  21), INT8_C(  23), INT8_C( -52),
                           INT8_C(  79), INT8_C( -51), INT8_C(-125), INT8_C( -68)),
      simde_mm512_set_epi8(INT8_C(  38), INT8_C(  59), INT8_C( -91), INT8_C(  35),
                           INT8_C( -96), INT8_C(-114), INT8_C(  38), INT8_C(  95),
                           INT8_C(  25), INT8_C(  15), INT8_C( -21), INT8_C(  77),
                           INT8_C( -67), INT8_C(  35), INT8_C( -61), INT8_C(-119),
                           INT8_C(  -5), INT8_C( -91), INT8_C(  88), INT8_C( -19),
                           INT8_C( -98), INT8_C( -34), INT8_C(-102), INT8_C( -44),
                           INT8_C(-127), INT8_C(  61), INT8_C( -35), INT8_C( -29),
                           INT8_C( -55), INT8_C(  59), INT8_C( 127), INT8_C(  23),
                           INT8_C(  90), INT8_C(  44), INT8_C( 125), INT8_C( 100),
                           INT8_C(  71), INT8_C(  48), INT8_C(  18), INT8_C( 112),
                           INT8_C( -93), INT8_C( 122), INT8_C( 119), INT8_C( 119),
                           INT8_C(  70), INT8_C( -30), INT8_C(  76), INT8_C( 124),
                           INT8_C(  32), INT8_C(-107), INT8_C(  -2), INT8_C(  60),
                           INT8_C( 125), INT8_C(  67), INT8_C(  62), INT8_C( -65),
                           INT8_C(  -7), INT8_C(-113), INT8_C( -99), INT8_C( -90),
                           INT8_C(  65), INT8_C( -25), INT8_C(  25), INT8_C(-119)) },
    { simde_mm512_set_epi8(INT8_C( -57), INT8_C(  69), INT8_C(  98), INT8_C( -33),
                           INT8_C(  62), INT8_C(  94), INT8_C( -38), INT8_C( -71),
                           INT8_C( -19), INT8_C( 108), INT8_C(  21), INT8_C( -42),
                           INT8_C(  46), INT8_C(  24), INT8_C(-124), INT8_C(  94),
                           INT8_C( -15), INT8_C( 105), INT8_C( 125), INT8_C(  58),
                           INT8_C(  33), INT8_C( -54), INT8_C(  16), INT8_C(-125),
                           INT8_C(  45), INT8_C(  66), INT8_C(-109), INT8_C( -81),
                           INT8_C( -67), INT8_C( 112), INT8_C(   1), INT8_C( -76),
                           INT8_C(  64), INT8_C( -13), INT8_C(  77), INT8_C(-127),
                           INT8_C( -63), INT8_C( -74), INT8_C( -63), INT8_C( -99),
                           INT8_C( -45), INT8_C(  47), INT8_C( 113), INT8_C(  20),
                           INT8_C(-123), INT8_C( 127), INT8_C(  16), INT8_C( -25),
                           INT8_C(  -9), INT8_C(  70), INT8_C(  76), INT8_C( -62),
                           INT8_C(-112), INT8_C(  53), INT8_C( -85), INT8_C(  23),
                           INT8_C(-107), INT8_C( 101), INT8_C( -95), INT8_C(  15),
                           INT8_C( -98), INT8_C(  96), INT8_C( -14), INT8_C( 115)),
      UINT64_C( 7455883527348184901),
      simde_mm512_set_epi8(INT8_C( -76), INT8_C( -37), INT8_C( 101), INT8_C(  42),
                           INT8_C( -10), INT8_C(  29), INT8_C( -32), INT8_C(-104),
                           INT8_C( -52), INT8_C(  91), INT8_C( -27), INT8_C(  64),
                           INT8_C(  61), INT8_C(  70), INT8_C( 125), INT8_C(  77),
                           INT8_C(  50), INT8_C( -84), INT8_C(-108), INT8_C(  43),
                           INT8_C(  26), INT8_C(   9), INT8_C(  13), INT8_C( -36),
                           INT8_C(  39), INT8_C(-122), INT8_C(  26), INT8_C( -88),
                           INT8_C(  96), INT8_C(-114), INT8_C(  52), INT8_C(  21),
                           INT8_C(  98), INT8_C( -75), INT8_C(  31), INT8_C(  27),
                           INT8_C(  37), INT8_C(-110), INT8_C(  11), INT8_C(-105),
                           INT8_C(  12), INT8_C(  -9), INT8_C(  19), INT8_C( -84),
                           INT8_C(-104), INT8_C(-100), INT8_C( -12), INT8_C( -62),
                           INT8_C( -91), INT8_C(  17), INT8_C(   1), INT8_C(  99),
                           INT8_C( -18), INT8_C(  34), INT8_C(  14), INT8_C( 126),
                           INT8_C(  91), INT8_C( -84), INT8_C(-123), INT8_C( -78),
                           INT8_C(  66), INT8_C(  52), INT8_C(  99), INT8_C(  74)),
      simde_mm512_set_epi8(INT8_C( 121), INT8_C( -29), INT8_C(  49), INT8_C(  35),
                           INT8_C(  77), INT8_C(-104), INT8_C(  57), INT8_C(  64),
                           INT8_C( 121), INT8_C(  98), INT8_C(  15), INT8_C( -48),
                           INT8_C(-126), INT8_C(   9), INT8_C(  84), INT8_C(   7),
                           INT8_C( -35), INT8_C(  -9), INT8_C(  12), INT8_C( -76),
                           INT8_C(  70), INT8_C(   4), INT8_C( 117), INT8_C(-104),
                           INT8_C( -90), INT8_C(  57), INT8_C( -33), INT8_C( 119),
                           INT8_C(-114), INT8_C( -15), INT8_C(  50), INT8_C( 107),
                           INT8_C(  64), INT8_C(  46), INT8_C( -20), INT8_C(  32),
                           INT8_C( -25), INT8_C(   9), INT8_C(  82), INT8_C(  67),
                           INT8_C(  95), INT8_C(  56), INT8_C( -84), INT8_C(  66),
                           INT8_C(  -2), INT8_C( -24), INT8_C(  69), INT8_C(  -5),
                           INT8_C( 107), INT8_C(-107), INT8_C( 112), INT8_C(  -8),
                           INT8_C(  -8), INT8_C(  25), INT8_C( 107), INT8_C( -42),
                           INT8_C( -78), INT8_C(  17), INT8_C(-102), INT8_C( -56),
                           INT8_C(  67), INT8_C( -37), INT8_C( -38), INT8_C( -67)),
      simde_mm512_set_epi8(INT8_C( -57), INT8_C(  55), INT8_C( -37), INT8_C( -33),
                           INT8_C(  62), INT8_C(  63), INT8_C(  -5), INT8_C(-104),
                           INT8_C( -19), INT8_C( -75), INT8_C( -37), INT8_C( -95),
                           INT8_C( -24), INT8_C(  24), INT8_C(-124), INT8_C(  94),
                           INT8_C(  -2), INT8_C( 105), INT8_C( 125), INT8_C(  91),
                           INT8_C(  76), INT8_C(  84), INT8_C( 125), INT8_C(-125),
                           INT8_C(  13), INT8_C(  66), INT8_C(-109), INT8_C(-121),
                           INT8_C( -67), INT8_C( 112), INT8_C(   1), INT8_C( -76),
                           INT8_C( -12), INT8_C( -13), INT8_C(  52), INT8_C(-127),
                           INT8_C(  -7), INT8_C(  32), INT8_C( 109), INT8_C( -99),
                           INT8_C( -45), INT8_C(  -6), INT8_C( 113), INT8_C(  20),
                           INT8_C(-123), INT8_C( -78), INT8_C(  84), INT8_C( -25),
                           INT8_C(  -9), INT8_C(  87), INT8_C( -49), INT8_C( -62),
                           INT8_C(-112), INT8_C( 119), INT8_C(  87), INT8_C(  85),
                           INT8_C(-107), INT8_C(  32), INT8_C( -95), INT8_C(  15),
                           INT8_C( -98), INT8_C(-104), INT8_C( -14), INT8_C( -21)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_gf2p8affineinv_epi64_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].x, test_vec[i].A, 172);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_maskz_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask16 k;
    simde__m128i x;
    simde__m128i A;
    simde__m128i r;
  } test_vec[8] = {
    { UINT16_C(65157),
      simde_mm_set_epi8(INT8_C( -88), INT8_C(  75), INT8_C(  45), INT8_C( 101),
                        INT8_C( -48), INT8_C(  40), INT8_C(  43), INT8_C(-120),
                        INT8_C(  86), INT8_C(-109), INT8_C(-116), INT8_C(  52),
                        INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  33)),
      simde_mm_set_epi8(INT8_C( -42), INT8_C(  62), INT8_C(  88), INT8_C(   7),
                        INT8_C(  61), INT8_C( 116), INT8_C( -89), INT8_C( 122),
                        INT8_C( 102), INT8_C( -48), INT8_C( 124), INT8_C(  70),
                        INT8_C(  47), INT8_C(  38), INT8_C( 113), INT8_C( -68)),
      simde_mm_set_epi8(INT8_C(  28), INT8_C( 122), INT8_C(-128), INT8_C(  93),
                        INT8_C( -29), INT8_C( -30), INT8_C( -54), INT8_C(   0),
                        INT8_C(   8), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C(   0), INT8_C(  33), INT8_C(   0), INT8_C( -12)) },
    { UINT16_C(46065),
      simde_mm_set_epi8(INT8_C( -60), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                        INT8_C(  51), INT8_C(  20), INT8_C(  52), INT8_C(-114),
                        INT8_C(  -6), INT8_C(  43), INT8_C(  55), INT8_C(  12),
                        INT8_C(  60), INT8_C(  72), INT8_C(  58), INT8_C( 119)),
      simde_mm_set_epi8(INT8_C(-101), INT8_C(  76), INT8_C(-128), INT8_C( -17),
                        INT8_C(-103), INT8_C(   2), INT8_C(  62), INT8_C(-126),
                        INT8_C(  78), INT8_C( -70), INT8_C(   8), INT8_C( -28),
                        INT8_C( -17), INT8_C( 126), INT8_C(-111), INT8_C(-124)),
      simde_mm_set_epi8(INT8_C(  42), INT8_C(   0), INT8_C(   5), INT8_C( -26),
                        INT8_C(   0), INT8_C(   0), INT8_C(  32), INT8_C(-104),
                        INT8_C( -31), INT8_C( -43), INT8_C(  84), INT8_C( -36),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-120)) },
    { UINT16_C( 6797),
      simde_mm_set_epi8(INT8_C( -84), INT8_C(  28), INT8_C( -27), INT8_C(-123),
                        INT8_C(  82), INT8_C(-107), INT8_C( -80), INT8_C(  79),
                        INT8_C( 120), INT8_C( -68), INT8_C( -84), INT8_C( -49),
                        INT8_C(  87), INT8_C( -79), INT8_C( -74), INT8_C(  92)),
      simde_mm_set_epi8(INT8_C( -38), INT8_C(  70), INT8_C( -49), INT8_C(   4),
                        INT8_C( -35), INT8_C(  89), INT8_C(-103), INT8_C(  21),
                        INT8_C(  58), INT8_C( -45), INT8_C( 126), INT8_C(  -7),
                        INT8_C(  69), INT8_C(   5), INT8_C( -82), INT8_C(-111)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 107),
                        INT8_C(  52), INT8_C(   0), INT8_C( -75), INT8_C(   0),
                        INT8_C( 101), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C(-110), INT8_C( -57), INT8_C(   0), INT8_C( 117)) },
    { UINT16_C(13937),
      simde_mm_set_epi8(INT8_C( -73), INT8_C(  61), INT8_C(  67), INT8_C( -62),
                        INT8_C(   2), INT8_C(  50), INT8_C( -54), INT8_C(  -9),
                        INT8_C( -22), INT8_C( -88), INT8_C(-110), INT8_C( -48),
                        INT8_C(  76), INT8_C( -59), INT8_C(  68), INT8_C( -74)),
      simde_mm_set_epi8(INT8_C( -71), INT8_C( 118), INT8_C( -91), INT8_C( -10),
                        INT8_C(  38), INT8_C( -84), INT8_C( -72), INT8_C( -61),
                        INT8_C(  27), INT8_C(  -2), INT8_C(  62), INT8_C(  34),
                        INT8_C( 118), INT8_C(  94), INT8_C( -81), INT8_C(  50)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(-118), INT8_C(  97),
                        INT8_C(   0), INT8_C(  98), INT8_C(-128), INT8_C(   0),
                        INT8_C(   0), INT8_C(   9), INT8_C( -56), INT8_C( -99),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  98)) },
    { UINT16_C(24160),
      simde_mm_set_epi8(INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                        INT8_C( -97), INT8_C(  62), INT8_C(  26), INT8_C(  78),
                        INT8_C( -69), INT8_C( -62), INT8_C(-105), INT8_C(  38),
                        INT8_C(  99), INT8_C( -23), INT8_C(  54), INT8_C( -37)),
      simde_mm_set_epi8(INT8_C(  71), INT8_C(  78), INT8_C( 102), INT8_C( -87),
                        INT8_C( -42), INT8_C(  16), INT8_C( 120), INT8_C(  -7),
                        INT8_C(  86), INT8_C( 101), INT8_C(  24), INT8_C( 125),
                        INT8_C( -69), INT8_C(  65), INT8_C(  12), INT8_C( -54)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C( -75), INT8_C(   0), INT8_C( -47),
                        INT8_C( -21), INT8_C(  58), INT8_C( 121), INT8_C(   0),
                        INT8_C(   0), INT8_C( 120), INT8_C(  99), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT16_C(52349),
      simde_mm_set_epi8(INT8_C(-115), INT8_C(  83), INT8_C( -51), INT8_C(-117),
                        INT8_C( -24), INT8_C( -79), INT8_C(  55), INT8_C(-125),
                        INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                        INT8_C( -62), INT8_C(  72), INT8_C(  66), INT8_C(-110)),
      simde_mm_set_epi8(INT8_C( -26), INT8_C(  57), INT8_C( -91), INT8_C(  79),
                        INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                        INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                        INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121)),
      simde_mm_set_epi8(INT8_C(-105), INT8_C( -47), INT8_C(   0), INT8_C(   0),
                        INT8_C(  68), INT8_C( -91), INT8_C(   0), INT8_C(   0),
                        INT8_C(   0), INT8_C(  18), INT8_C( -32), INT8_C( -84),
                        INT8_C( -64), INT8_C(  55), INT8_C(   0), INT8_C( -52)) },
    { UINT16_C(12470),
      simde_mm_set_epi8(INT8_C(  83), INT8_C( -70), INT8_C( -20), INT8_C( -26),
                        INT8_C( 113), INT8_C(  81), INT8_C(-104), INT8_C(  87),
                        INT8_C(  17), INT8_C(  59), INT8_C( -92), INT8_C( -92),
                        INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84)),
      simde_mm_set_epi8(INT8_C( 105), INT8_C(   4), INT8_C(   0), INT8_C( 126),
                        INT8_C(  17), INT8_C( -37), INT8_C( 124), INT8_C(  81),
                        INT8_C( -49), INT8_C( -80), INT8_C(  50), INT8_C( 114),
                        INT8_C( 103), INT8_C( 115), INT8_C(  11), INT8_C( 121)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( -35), INT8_C(  45),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C(  92), INT8_C(   0), INT8_C(   1), INT8_C(   1),
                        INT8_C(   0), INT8_C(  55), INT8_C(-116), INT8_C(   0)) },
    { UINT16_C(43937),
      simde_mm_set_epi8(INT8_C( 122), INT8_C(  28), INT8_C(  31), INT8_C(  41),
                        INT8_C( -69), INT8_C(  33), INT8_C(  70), INT8_C(  26),
                        INT8_C( -60), INT8_C( 101), INT8_C(  20), INT8_C( -20),
                        INT8_C( 122), INT8_C( 120), INT8_C(-101), INT8_C( -57)),
      simde_mm_set_epi8(INT8_C(-126), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                        INT8_C(  45), INT8_C(  80), INT8_C(-116), INT8_C(   9),
                        INT8_C(  97), INT8_C(-126), INT8_C( -49), INT8_C(  31),
                        INT8_C(  80), INT8_C( -15), INT8_C(-103), INT8_C( -93)),
      simde_mm_set_epi8(INT8_C(  19), INT8_C(   0), INT8_C(  38), INT8_C(   0),
                        INT8_C( 126), INT8_C(   0), INT8_C( -57), INT8_C(  17),
                        INT8_C(  55), INT8_C(   0), INT8_C(  97), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 125)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_maskz_gf2p8affineinv_epi64_epi8(test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C(  94));
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_maskz_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask32 k;
    simde__m256i x;
    simde__m256i A;
    simde__m256i r;
  } test_vec[8] = {
    { UINT32_C(1396440709),
      simde_mm256_set_epi8(INT8_C( -42), INT8_C(  62), INT8_C(  88), INT8_C(   7),
                           INT8_C(  61), INT8_C( 116), INT8_C( -89), INT8_C( 122),
                           INT8_C( 102), INT8_C( -48), INT8_C( 124), INT8_C(  70),
                           INT8_C(  47), INT8_C(  38), INT8_C( 113), INT8_C( -68),
                           INT8_C( -88), INT8_C(  75), INT8_C(  45), INT8_C( 101),
                           INT8_C( -48), INT8_C(  40), INT8_C(  43), INT8_C(-120),
                           INT8_C(  86), INT8_C(-109), INT8_C(-116), INT8_C(  52),
                           INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  33)),
      simde_mm256_set_epi8(INT8_C(  78), INT8_C( -70), INT8_C(   8), INT8_C( -28),
                           INT8_C( -17), INT8_C( 126), INT8_C(-111), INT8_C(-124),
                           INT8_C( -60), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                           INT8_C(  51), INT8_C(  20), INT8_C(  52), INT8_C(-114),
                           INT8_C(  -6), INT8_C(  43), INT8_C(  55), INT8_C(  12),
                           INT8_C(  60), INT8_C(  72), INT8_C(  58), INT8_C( 119),
                           INT8_C(-125), INT8_C(-116), INT8_C(  -2), INT8_C(  35),
                           INT8_C(  46), INT8_C( -63), INT8_C( -77), INT8_C( -15)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  66), INT8_C(   0), INT8_C( -81),
                           INT8_C(   0), INT8_C(   0), INT8_C( 112), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C( -75), INT8_C(  33),
                           INT8_C( 108), INT8_C(   0), INT8_C( -72), INT8_C( -88),
                           INT8_C( -14), INT8_C( -22), INT8_C(  67), INT8_C( -13),
                           INT8_C(  97), INT8_C(  88), INT8_C( -79), INT8_C(   0),
                           INT8_C(  59), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  59), INT8_C(   0), INT8_C(  91)) },
    { UINT32_C(2567061122),
      simde_mm256_set_epi8(INT8_C(  58), INT8_C( -45), INT8_C( 126), INT8_C(  -7),
                           INT8_C(  69), INT8_C(   5), INT8_C( -82), INT8_C(-111),
                           INT8_C( -84), INT8_C(  28), INT8_C( -27), INT8_C(-123),
                           INT8_C(  82), INT8_C(-107), INT8_C( -80), INT8_C(  79),
                           INT8_C( 120), INT8_C( -68), INT8_C( -84), INT8_C( -49),
                           INT8_C(  87), INT8_C( -79), INT8_C( -74), INT8_C(  92),
                           INT8_C(  64), INT8_C(-128), INT8_C( -63), INT8_C( -93),
                           INT8_C(  85), INT8_C( -44), INT8_C(  26), INT8_C(-115)),
      simde_mm256_set_epi8(INT8_C( -73), INT8_C(  61), INT8_C(  67), INT8_C( -62),
                           INT8_C(   2), INT8_C(  50), INT8_C( -54), INT8_C(  -9),
                           INT8_C( -22), INT8_C( -88), INT8_C(-110), INT8_C( -48),
                           INT8_C(  76), INT8_C( -59), INT8_C(  68), INT8_C( -74),
                           INT8_C(-118), INT8_C(  -5), INT8_C( 100), INT8_C(  20),
                           INT8_C(  96), INT8_C(-121), INT8_C(  54), INT8_C( 113),
                           INT8_C( -38), INT8_C(  70), INT8_C( -49), INT8_C(   4),
                           INT8_C( -35), INT8_C(  89), INT8_C(-103), INT8_C(  21)),
      simde_mm256_set_epi8(INT8_C( -35), INT8_C(   0), INT8_C(   0), INT8_C( -43),
                           INT8_C(  -7), INT8_C(   0), INT8_C(   0), INT8_C( -82),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -99), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -57), INT8_C(  18),
                           INT8_C( -17), INT8_C(  29), INT8_C(  -9), INT8_C(   0),
                           INT8_C(-112), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -14), INT8_C(   0)) },
    { UINT32_C(1985916722),
      simde_mm256_set_epi8(INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                           INT8_C( -97), INT8_C(  62), INT8_C(  26), INT8_C(  78),
                           INT8_C( -69), INT8_C( -62), INT8_C(-105), INT8_C(  38),
                           INT8_C(  99), INT8_C( -23), INT8_C(  54), INT8_C( -37),
                           INT8_C( 100), INT8_C(  45), INT8_C( -71), INT8_C(-119),
                           INT8_C(  49), INT8_C( -65), INT8_C(  94), INT8_C(  96),
                           INT8_C( -71), INT8_C( 118), INT8_C( -91), INT8_C( -10),
                           INT8_C(  38), INT8_C( -84), INT8_C( -72), INT8_C( -61)),
      simde_mm256_set_epi8(INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                           INT8_C( -62), INT8_C(  72), INT8_C(  66), INT8_C(-110),
                           INT8_C(  56), INT8_C( -71), INT8_C(  70), INT8_C(  52),
                           INT8_C( 105), INT8_C(  74), INT8_C( -52), INT8_C( 125),
                           INT8_C(  71), INT8_C(  78), INT8_C( 102), INT8_C( -87),
                           INT8_C( -42), INT8_C(  16), INT8_C( 120), INT8_C(  -7),
                           INT8_C(  86), INT8_C( 101), INT8_C(  24), INT8_C( 125),
                           INT8_C( -69), INT8_C(  65), INT8_C(  12), INT8_C( -54)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  61), INT8_C( -38), INT8_C(  55),
                           INT8_C(   0), INT8_C( -82), INT8_C(  57), INT8_C(   0),
                           INT8_C(   0), INT8_C( 108), INT8_C(   0), INT8_C(  84),
                           INT8_C( -11), INT8_C(-111), INT8_C(  -7), INT8_C(   0),
                           INT8_C( -22), INT8_C(   0), INT8_C(  44), INT8_C(   0),
                           INT8_C(  55), INT8_C( -48), INT8_C( -20), INT8_C(-114),
                           INT8_C(   0), INT8_C(   0), INT8_C(  53), INT8_C( -43),
                           INT8_C(   0), INT8_C(   0), INT8_C(-123), INT8_C(   0)) },
    { UINT32_C(3903928195),
      simde_mm256_set_epi8(INT8_C(  17), INT8_C(  59), INT8_C( -92), INT8_C( -92),
                           INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84),
                           INT8_C(  12), INT8_C(  33), INT8_C( -50), INT8_C( -22),
                           INT8_C(  88), INT8_C(   0), INT8_C(  48), INT8_C( -74),
                           INT8_C( -26), INT8_C(  57), INT8_C( -91), INT8_C(  79),
                           INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                           INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                           INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121)),
      simde_mm256_set_epi8(INT8_C(   8), INT8_C( -41), INT8_C(  78), INT8_C( -24),
                           INT8_C( -85), INT8_C( -99), INT8_C( -85), INT8_C( -95),
                           INT8_C( 105), INT8_C(   4), INT8_C(   0), INT8_C( 126),
                           INT8_C(  17), INT8_C( -37), INT8_C( 124), INT8_C(  81),
                           INT8_C( -49), INT8_C( -80), INT8_C(  50), INT8_C( 114),
                           INT8_C( 103), INT8_C( 115), INT8_C(  11), INT8_C( 121),
                           INT8_C(  83), INT8_C( -70), INT8_C( -20), INT8_C( -26),
                           INT8_C( 113), INT8_C(  81), INT8_C(-104), INT8_C(  87)),
      simde_mm256_set_epi8(INT8_C(  88), INT8_C(  87), INT8_C( 123), INT8_C(   0),
                           INT8_C(  89), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -17), INT8_C(   0), INT8_C(  52), INT8_C(-100),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  79),
                           INT8_C(   0), INT8_C(   0), INT8_C( -84), INT8_C(  78),
                           INT8_C(   0), INT8_C(  95), INT8_C(  19), INT8_C(  37),
                           INT8_C(  24), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  81), INT8_C(  55)) },
    { UINT32_C(2054724551),
      simde_mm256_set_epi8(INT8_C(  10), INT8_C( 111), INT8_C(   0), INT8_C( 102),
                           INT8_C( -29), INT8_C( -79), INT8_C( -33), INT8_C( -18),
                           INT8_C(-126), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                           INT8_C(  45), INT8_C(  80), INT8_C(-116), INT8_C(   9),
                           INT8_C(  97), INT8_C(-126), INT8_C( -49), INT8_C(  31),
                           INT8_C(  80), INT8_C( -15), INT8_C(-103), INT8_C( -93),
                           INT8_C( 122), INT8_C(  28), INT8_C(  31), INT8_C(  41),
                           INT8_C( -69), INT8_C(  33), INT8_C(  70), INT8_C(  26)),
      simde_mm256_set_epi8(INT8_C(  85), INT8_C( -50), INT8_C(-124), INT8_C( -51),
                           INT8_C( -15), INT8_C( 123), INT8_C( -57), INT8_C(  49),
                           INT8_C( -56), INT8_C( -96), INT8_C(-107), INT8_C(  81),
                           INT8_C(  28), INT8_C(  89), INT8_C(-117), INT8_C(-113),
                           INT8_C(  93), INT8_C(  34), INT8_C( -81), INT8_C(  29),
                           INT8_C( -48), INT8_C( -91), INT8_C(-101), INT8_C(  33),
                           INT8_C( -32), INT8_C(-111), INT8_C( -86), INT8_C(  81),
                           INT8_C( -69), INT8_C( -40), INT8_C(-105), INT8_C(  25)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( -50), INT8_C( 126), INT8_C(  82),
                           INT8_C(  90), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C( -68), INT8_C( 105), INT8_C(-107),
                           INT8_C( -61), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  16), INT8_C(   0), INT8_C(   0), INT8_C( -77),
                           INT8_C(  48), INT8_C(   0), INT8_C(  10), INT8_C( -80),
                           INT8_C( -38), INT8_C( -75), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -30), INT8_C(  85), INT8_C( -31)) },
    { UINT32_C(3223503422),
      simde_mm256_set_epi8(INT8_C(  37), INT8_C( 113), INT8_C( -54), INT8_C(  15),
                           INT8_C(-119), INT8_C(-119), INT8_C( 102), INT8_C(  12),
                           INT8_C( -50), INT8_C(-100), INT8_C(  91), INT8_C( -73),
                           INT8_C(-128), INT8_C( -69), INT8_C(  75), INT8_C(  41),
                           INT8_C(  62), INT8_C( -50), INT8_C(  30), INT8_C(  -6),
                           INT8_C(  85), INT8_C(  -1), INT8_C(  20), INT8_C( -57),
                           INT8_C( -39), INT8_C(  81), INT8_C( -54), INT8_C( 103),
                           INT8_C( -31), INT8_C(  76), INT8_C(  -6), INT8_C(  19)),
      simde_mm256_set_epi8(INT8_C(  20), INT8_C(  -1), INT8_C( 126), INT8_C( -58),
                           INT8_C(-122), INT8_C( -63), INT8_C(   0), INT8_C(  21),
                           INT8_C( 125), INT8_C(-120), INT8_C(  11), INT8_C(  36),
                           INT8_C( -16), INT8_C(  30), INT8_C( -96), INT8_C(  28),
                           INT8_C(  10), INT8_C(  16), INT8_C(  30), INT8_C(-118),
                           INT8_C( -14), INT8_C(  16), INT8_C( -24), INT8_C( 121),
                           INT8_C(  27), INT8_C(  42), INT8_C( -96), INT8_C( -57),
                           INT8_C(-122), INT8_C(  20), INT8_C(  54), INT8_C(  94)),
      simde_mm256_set_epi8(INT8_C( 107), INT8_C( -26), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -43), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -18), INT8_C(   0),
                           INT8_C(  85), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -35), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -59), INT8_C(  36),
                           INT8_C(  12), INT8_C( -17), INT8_C(  35), INT8_C(   0)) },
    { UINT32_C(  89329770),
      simde_mm256_set_epi8(INT8_C(  75), INT8_C( -79), INT8_C( 108), INT8_C( -46),
                           INT8_C(-111), INT8_C( 109), INT8_C(  40), INT8_C(  40),
                           INT8_C( -24), INT8_C( -34), INT8_C(  68), INT8_C(  73),
                           INT8_C(  83), INT8_C( -82), INT8_C( 100), INT8_C( 122),
                           INT8_C(-100), INT8_C(-111), INT8_C(  81), INT8_C( -18),
                           INT8_C(  81), INT8_C(   2), INT8_C(  40), INT8_C( -14),
                           INT8_C( -37), INT8_C(   0), INT8_C(  84), INT8_C( 112),
                           INT8_C(  67), INT8_C(-128), INT8_C( -76), INT8_C( -90)),
      simde_mm256_set_epi8(INT8_C( 115), INT8_C( -91), INT8_C(-114), INT8_C( -33),
                           INT8_C( 119), INT8_C( -27), INT8_C( -46), INT8_C( -37),
                           INT8_C(-114), INT8_C(  33), INT8_C( 101), INT8_C( -50),
                           INT8_C(  17), INT8_C(  -4), INT8_C(  39), INT8_C( -76),
                           INT8_C( -64), INT8_C( 109), INT8_C(   8), INT8_C(  18),
                           INT8_C(  97), INT8_C( -33), INT8_C(  74), INT8_C( 101),
                           INT8_C( 114), INT8_C(  73), INT8_C(  13), INT8_C( -15),
                           INT8_C( -63), INT8_C( -87), INT8_C(  43), INT8_C( -66)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  47), INT8_C(   0), INT8_C( -46),
                           INT8_C(   0), INT8_C( 103), INT8_C(   0), INT8_C(  89),
                           INT8_C(   0), INT8_C(   0), INT8_C(  45), INT8_C(  75),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -6),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 126), INT8_C(   7), INT8_C(   0),
                           INT8_C( -73), INT8_C(   0), INT8_C(-119), INT8_C(   0)) },
    { UINT32_C(2319640833),
      simde_mm256_set_epi8(INT8_C( 113), INT8_C(  -3), INT8_C( -82), INT8_C(  61),
                           INT8_C( 114), INT8_C(  95), INT8_C(  56), INT8_C(  11),
                           INT8_C(  39), INT8_C( 125), INT8_C(  59), INT8_C(  11),
                           INT8_C(  10), INT8_C(  91), INT8_C(  91), INT8_C(-118),
                           INT8_C(-117), INT8_C( 125), INT8_C( -40), INT8_C(  88),
                           INT8_C(  24), INT8_C( -96), INT8_C(  22), INT8_C(-107),
                           INT8_C(  49), INT8_C(  63), INT8_C( -20), INT8_C(  36),
                           INT8_C(  62), INT8_C(  14), INT8_C( -92), INT8_C(  -1)),
      simde_mm256_set_epi8(INT8_C( -16), INT8_C(  16), INT8_C( -21), INT8_C(-128),
                           INT8_C(  14), INT8_C( -28), INT8_C(  76), INT8_C(-108),
                           INT8_C( -40), INT8_C( -35), INT8_C(  36), INT8_C( -38),
                           INT8_C(   3), INT8_C( -17), INT8_C(  32), INT8_C( 103),
                           INT8_C(-115), INT8_C(  83), INT8_C( -28), INT8_C( -74),
                           INT8_C(  50), INT8_C( 126), INT8_C( 112), INT8_C( 106),
                           INT8_C( -37), INT8_C(  29), INT8_C(  33), INT8_C( -67),
                           INT8_C( -58), INT8_C(  64), INT8_C( -22), INT8_C( 127)),
      simde_mm256_set_epi8(INT8_C(-107), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -80), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C(-126), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  17), INT8_C(   0),
                           INT8_C(  77), INT8_C(   8), INT8_C(  36), INT8_C(   0),
                           INT8_C(  67), INT8_C(   0), INT8_C(   0), INT8_C( 104),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -92)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_maskz_gf2p8affineinv_epi64_epi8(test_vec[i].k, test_vec[i].x, test_vec[i].A, INT8_C( 126));
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_gf2p8affineinv_epi64_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i x;
    simde__m512i A;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C( 2674908657002217093),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C( -70), INT8_C(   8), INT8_C( -28),
                           INT8_C( -17), INT8_C( 126), INT8_C(-111), INT8_C(-124),
                           INT8_C( -60), INT8_C(-108), INT8_C(  94), INT8_C( -85),
                           INT8_C(  51), INT8_C(  20), INT8_C(  52), INT8_C(-114),
                           INT8_C(  -6), INT8_C(  43), INT8_C(  55), INT8_C(  12),
                           INT8_C(  60), INT8_C(  72), INT8_C(  58), INT8_C( 119),
                           INT8_C(-125), INT8_C(-116), INT8_C(  -2), INT8_C(  35),
                           INT8_C(  46), INT8_C( -63), INT8_C( -77), INT8_C( -15),
                           INT8_C( -42), INT8_C(  62), INT8_C(  88), INT8_C(   7),
                           INT8_C(  61), INT8_C( 116), INT8_C( -89), INT8_C( 122),
                           INT8_C( 102), INT8_C( -48), INT8_C( 124), INT8_C(  70),
                           INT8_C(  47), INT8_C(  38), INT8_C( 113), INT8_C( -68),
                           INT8_C( -88), INT8_C(  75), INT8_C(  45), INT8_C( 101),
                           INT8_C( -48), INT8_C(  40), INT8_C(  43), INT8_C(-120),
                           INT8_C(  86), INT8_C(-109), INT8_C(-116), INT8_C(  52),
                           INT8_C( -80), INT8_C( -39), INT8_C( -82), INT8_C(  33)),
      simde_mm512_set_epi8(INT8_C( -22), INT8_C( -88), INT8_C(-110), INT8_C( -48),
                           INT8_C(  76), INT8_C( -59), INT8_C(  68), INT8_C( -74),
                           INT8_C(-118), INT8_C(  -5), INT8_C( 100), INT8_C(  20),
                           INT8_C(  96), INT8_C(-121), INT8_C(  54), INT8_C( 113),
                           INT8_C( -38), INT8_C(  70), INT8_C( -49), INT8_C(   4),
                           INT8_C( -35), INT8_C(  89), INT8_C(-103), INT8_C(  21),
                           INT8_C(  58), INT8_C( -45), INT8_C( 126), INT8_C(  -7),
                           INT8_C(  69), INT8_C(   5), INT8_C( -82), INT8_C(-111),
                           INT8_C( -84), INT8_C(  28), INT8_C( -27), INT8_C(-123),
                           INT8_C(  82), INT8_C(-107), INT8_C( -80), INT8_C(  79),
                           INT8_C( 120), INT8_C( -68), INT8_C( -84), INT8_C( -49),
                           INT8_C(  87), INT8_C( -79), INT8_C( -74), INT8_C(  92),
                           INT8_C(  64), INT8_C(-128), INT8_C( -63), INT8_C( -93),
                           INT8_C(  85), INT8_C( -44), INT8_C(  26), INT8_C(-115),
                           INT8_C(-101), INT8_C(  76), INT8_C(-128), INT8_C( -17),
                           INT8_C(-103), INT8_C(   2), INT8_C(  62), INT8_C(-126)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(  -5), INT8_C(   0),
                           INT8_C(   0), INT8_C(  50), INT8_C(   0), INT8_C( -21),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  75),
                           INT8_C(-110), INT8_C( -11), INT8_C( -43), INT8_C(  35),
                           INT8_C(   0), INT8_C(   0), INT8_C(-115), INT8_C(   0),
                           INT8_C(  22), INT8_C(-123), INT8_C( -67), INT8_C( -89),
                           INT8_C(   0), INT8_C(  34), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 116), INT8_C(   0), INT8_C(-102),
                           INT8_C(   0), INT8_C(   0), INT8_C( -86), INT8_C(  54),
                           INT8_C(   0), INT8_C(   0), INT8_C(-116), INT8_C(  56),
                           INT8_C(  18), INT8_C(   0), INT8_C(  -7), INT8_C(  46),
                           INT8_C(  77), INT8_C(  25), INT8_C(  56), INT8_C( -29),
                           INT8_C( 120), INT8_C( -70), INT8_C( -31), INT8_C(   0),
                           INT8_C(-102), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(   0), INT8_C(   7)) },
    { UINT64_C(13203784183059761911),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -71), INT8_C(  70), INT8_C(  52),
                           INT8_C( 105), INT8_C(  74), INT8_C( -52), INT8_C( 125),
                           INT8_C(  71), INT8_C(  78), INT8_C( 102), INT8_C( -87),
                           INT8_C( -42), INT8_C(  16), INT8_C( 120), INT8_C(  -7),
                           INT8_C(  86), INT8_C( 101), INT8_C(  24), INT8_C( 125),
                           INT8_C( -69), INT8_C(  65), INT8_C(  12), INT8_C( -54),
                           INT8_C( 103), INT8_C(  -8), INT8_C(  63), INT8_C( 127),
                           INT8_C( -97), INT8_C(  62), INT8_C(  26), INT8_C(  78),
                           INT8_C( -69), INT8_C( -62), INT8_C(-105), INT8_C(  38),
                           INT8_C(  99), INT8_C( -23), INT8_C(  54), INT8_C( -37),
                           INT8_C( 100), INT8_C(  45), INT8_C( -71), INT8_C(-119),
                           INT8_C(  49), INT8_C( -65), INT8_C(  94), INT8_C(  96),
                           INT8_C( -71), INT8_C( 118), INT8_C( -91), INT8_C( -10),
                           INT8_C(  38), INT8_C( -84), INT8_C( -72), INT8_C( -61),
                           INT8_C(  27), INT8_C(  -2), INT8_C(  62), INT8_C(  34),
                           INT8_C( 118), INT8_C(  94), INT8_C( -81), INT8_C(  50)),
      simde_mm512_set_epi8(INT8_C( -49), INT8_C( -80), INT8_C(  50), INT8_C( 114),
                           INT8_C( 103), INT8_C( 115), INT8_C(  11), INT8_C( 121),
                           INT8_C(  83), INT8_C( -70), INT8_C( -20), INT8_C( -26),
                           INT8_C( 113), INT8_C(  81), INT8_C(-104), INT8_C(  87),
                           INT8_C(  17), INT8_C(  59), INT8_C( -92), INT8_C( -92),
                           INT8_C( -62), INT8_C(  84), INT8_C( -91), INT8_C(  84),
                           INT8_C(  12), INT8_C(  33), INT8_C( -50), INT8_C( -22),
                           INT8_C(  88), INT8_C(   0), INT8_C(  48), INT8_C( -74),
                           INT8_C( -26), INT8_C(  57), INT8_C( -91), INT8_C(  79),
                           INT8_C(  72), INT8_C( -31), INT8_C(-110), INT8_C(  35),
                           INT8_C( -42), INT8_C(  93), INT8_C( -26), INT8_C(  48),
                           INT8_C(  88), INT8_C(  90), INT8_C(  73), INT8_C(-121),
                           INT8_C(-115), INT8_C(  83), INT8_C( -51), INT8_C(-117),
                           INT8_C( -24), INT8_C( -79), INT8_C(  55), INT8_C(-125),
                           INT8_C(-119), INT8_C(-109), INT8_C( -25), INT8_C(  26),
                           INT8_C( -62), INT8_C(  72), INT8_C(  66), INT8_C(-110)),
      simde_mm512_set_epi8(INT8_C( 106), INT8_C(   0), INT8_C(  -9), INT8_C(-101),
                           INT8_C(   0), INT8_C(  77), INT8_C(  94), INT8_C( -85),
                           INT8_C(   0), INT8_C(   0), INT8_C(  87), INT8_C(   8),
                           INT8_C( -37), INT8_C(  97), INT8_C(   0), INT8_C( -54),
                           INT8_C(   0), INT8_C(  81), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  12), INT8_C(  -1),
                           INT8_C(  47), INT8_C( 103), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -83), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -25), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( 104), INT8_C(  83),
                           INT8_C(   0), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(-110), INT8_C( -59), INT8_C(   0), INT8_C(   0),
                           INT8_C( 109), INT8_C(   0), INT8_C( -38), INT8_C(   0),
                           INT8_C( 115), INT8_C( -50), INT8_C( 109), INT8_C( -76),
                           INT8_C(   0), INT8_C( -54), INT8_C(  19), INT8_C( 126)) },
    { UINT64_C( 7567173815354752081),
      simde_mm512_set_epi8(INT8_C(  93), INT8_C(  34), INT8_C( -81), INT8_C(  29),
                           INT8_C( -48), INT8_C( -91), INT8_C(-101), INT8_C(  33),
                           INT8_C( -32), INT8_C(-111), INT8_C( -86), INT8_C(  81),
                           INT8_C( -69), INT8_C( -40), INT8_C(-105), INT8_C(  25),
                           INT8_C(  10), INT8_C( 111), INT8_C(   0), INT8_C( 102),
                           INT8_C( -29), INT8_C( -79), INT8_C( -33), INT8_C( -18),
                           INT8_C(-126), INT8_C(  90), INT8_C( 106), INT8_C(-128),
                           INT8_C(  45), INT8_C(  80), INT8_C(-116), INT8_C(   9),
                           INT8_C(  97), INT8_C(-126), INT8_C( -49), INT8_C(  31),
                           INT8_C(  80), INT8_C( -15), INT8_C(-103), INT8_C( -93),
                           INT8_C( 122), INT8_C(  28), INT8_C(  31), INT8_C(  41),
                           INT8_C( -69), INT8_C(  33), INT8_C(  70), INT8_C(  26),
                           INT8_C( -60), INT8_C( 101), INT8_C(  20), INT8_C( -20),
                           INT8_C( 122), INT8_C( 120), INT8_C(-101), INT8_C( -57),
                           INT8_C(   8), INT8_C( -41), INT8_C(  78), INT8_C( -24),
                           INT8_C( -85), INT8_C( -99), INT8_C( -85), INT8_C( -95)),
      simde_mm512_set_epi8(INT8_C(  27), INT8_C(  42), INT8_C( -96), INT8_C( -57),
                           INT8_C(-122), INT8_C(  20), INT8_C(  54), INT8_C(  94),
                           INT8_C(  37), INT8_C( 113), INT8_C( -54), INT8_C(  15),
                           INT8_C(-119), INT8_C(-119), INT8_C( 102), INT8_C(  12),
                           INT8_C( -50), INT8_C(-100), INT8_C(  91), INT8_C( -73),
                           INT8_C(-128), INT8_C( -69), INT8_C(  75), INT8_C(  41),
                           INT8_C(  62), INT8_C( -50), INT8_C(  30), INT8_C(  -6),
                           INT8_C(  85), INT8_C(  -1), INT8_C(  20), INT8_C( -57),
                           INT8_C( -39), INT8_C(  81), INT8_C( -54), INT8_C( 103),
                           INT8_C( -31), INT8_C(  76), INT8_C(  -6), INT8_C(  19),
                           INT8_C(   0), INT8_C( -53), INT8_C( -62), INT8_C(  52),
                           INT8_C( -64), INT8_C(  34), INT8_C( -62), INT8_C(  62),
                           INT8_C(  85), INT8_C( -50), INT8_C(-124), INT8_C( -51),
                           INT8_C( -15), INT8_C( 123), INT8_C( -57), INT8_C(  49),
                           INT8_C( -56), INT8_C( -96), INT8_C(-107), INT8_C(  81),
                           INT8_C(  28), INT8_C(  89), INT8_C(-117), INT8_C(-113)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(-116), INT8_C( -88), INT8_C(   0),
                           INT8_C( -54), INT8_C(   0), INT8_C(   0), INT8_C( -45),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  66), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  59), INT8_C( -38), INT8_C(   8),
                           INT8_C( -16), INT8_C( -20), INT8_C(  17), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -65),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -64),
                           INT8_C(  53), INT8_C( 115), INT8_C(   0), INT8_C( -39),
                           INT8_C(-107), INT8_C(   0), INT8_C(  23), INT8_C(-107),
                           INT8_C(   0), INT8_C( 126), INT8_C(-127), INT8_C( -21),
                           INT8_C(  41), INT8_C( -49), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  96), INT8_C(   0), INT8_C(  76),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -49)) },
    { UINT64_C(  725113122122164345),
      simde_mm512_set_epi8(INT8_C( 114), INT8_C(  73), INT8_C(  13), INT8_C( -15),
                           INT8_C( -63), INT8_C( -87), INT8_C(  43), INT8_C( -66),
                           INT8_C(  75), INT8_C( -79), INT8_C( 108), INT8_C( -46),
                           INT8_C(-111), INT8_C( 109), INT8_C(  40), INT8_C(  40),
                           INT8_C( -24), INT8_C( -34), INT8_C(  68), INT8_C(  73),
                           INT8_C(  83), INT8_C( -82), INT8_C( 100), INT8_C( 122),
                           INT8_C(-100), INT8_C(-111), INT8_C(  81), INT8_C( -18),
                           INT8_C(  81), INT8_C(   2), INT8_C(  40), INT8_C( -14),
                           INT8_C( -37), INT8_C(   0), INT8_C(  84), INT8_C( 112),
                           INT8_C(  67), INT8_C(-128), INT8_C( -76), INT8_C( -90),
                           INT8_C( -77), INT8_C(  21), INT8_C(  79), INT8_C(  -2),
                           INT8_C(   5), INT8_C(  83), INT8_C(  16), INT8_C( 106),
                           INT8_C(  20), INT8_C(  -1), INT8_C( 126), INT8_C( -58),
                           INT8_C(-122), INT8_C( -63), INT8_C(   0), INT8_C(  21),
                           INT8_C( 125), INT8_C(-120), INT8_C(  11), INT8_C(  36),
                           INT8_C( -16), INT8_C(  30), INT8_C( -96), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  -3), INT8_C( -82), INT8_C(  61),
                           INT8_C( 114), INT8_C(  95), INT8_C(  56), INT8_C(  11),
                           INT8_C(  39), INT8_C( 125), INT8_C(  59), INT8_C(  11),
                           INT8_C(  10), INT8_C(  91), INT8_C(  91), INT8_C(-118),
                           INT8_C(-117), INT8_C( 125), INT8_C( -40), INT8_C(  88),
                           INT8_C(  24), INT8_C( -96), INT8_C(  22), INT8_C(-107),
                           INT8_C(  49), INT8_C(  63), INT8_C( -20), INT8_C(  36),
                           INT8_C(  62), INT8_C(  14), INT8_C( -92), INT8_C(  -1),
                           INT8_C(  45), INT8_C(  43), INT8_C( -36), INT8_C( -24),
                           INT8_C(-118), INT8_C(  66), INT8_C( -23), INT8_C(   1),
                           INT8_C( 115), INT8_C( -91), INT8_C(-114), INT8_C( -33),
                           INT8_C( 119), INT8_C( -27), INT8_C( -46), INT8_C( -37),
                           INT8_C(-114), INT8_C(  33), INT8_C( 101), INT8_C( -50),
                           INT8_C(  17), INT8_C(  -4), INT8_C(  39), INT8_C( -76),
                           INT8_C( -64), INT8_C( 109), INT8_C(   8), INT8_C(  18),
                           INT8_C(  97), INT8_C( -33), INT8_C(  74), INT8_C( 101)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  12), INT8_C(   0), INT8_C(  67), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  58),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  83),
                           INT8_C(  72), INT8_C(-119), INT8_C(  47), INT8_C(   0),
                           INT8_C(-124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -30), INT8_C(   0), INT8_C( 126), INT8_C(   0),
                           INT8_C(  79), INT8_C( -67), INT8_C(-117), INT8_C(   2),
                           INT8_C(   0), INT8_C(   0), INT8_C( 122), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -37), INT8_C( -55), INT8_C(  66), INT8_C(   0),
                           INT8_C( -49), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   8), INT8_C( 111), INT8_C( 118),
                           INT8_C( -38), INT8_C(   0), INT8_C(   0), INT8_C( -53)) },
    { UINT64_C(15788812967589505663),
      simde_mm512_set_epi8(INT8_C(  69), INT8_C( -79), INT8_C(  96), INT8_C(  14),
                           INT8_C(  27), INT8_C( 115), INT8_C(  -2), INT8_C( -45),
                           INT8_C(  88), INT8_C( -52), INT8_C(  70), INT8_C(-120),
                           INT8_C(  78), INT8_C(  99), INT8_C(  69), INT8_C(-111),
                           INT8_C( 113), INT8_C(  76), INT8_C(  28), INT8_C(   7),
                           INT8_C( -98), INT8_C( -99), INT8_C(-123), INT8_C(  88),
                           INT8_C( 122), INT8_C( 119), INT8_C(   9), INT8_C(  26),
                           INT8_C( 110), INT8_C( -42), INT8_C( -67), INT8_C(  -7),
                           INT8_C( 125), INT8_C( 120), INT8_C( -78), INT8_C( -83),
                           INT8_C( -76), INT8_C(  43), INT8_C(  -6), INT8_C(  63),
                           INT8_C( -16), INT8_C(  16), INT8_C( -21), INT8_C(-128),
                           INT8_C(  14), INT8_C( -28), INT8_C(  76), INT8_C(-108),
                           INT8_C( -40), INT8_C( -35), INT8_C(  36), INT8_C( -38),
                           INT8_C(   3), INT8_C( -17), INT8_C(  32), INT8_C( 103),
                           INT8_C(-115), INT8_C(  83), INT8_C( -28), INT8_C( -74),
                           INT8_C(  50), INT8_C( 126), INT8_C( 112), INT8_C( 106)),
      simde_mm512_set_epi8(INT8_C( -98), INT8_C( 125), INT8_C( 126), INT8_C(  47),
                           INT8_C( -61), INT8_C( 119), INT8_C(  16), INT8_C( -89),
                           INT8_C( 113), INT8_C( -56), INT8_C( -82), INT8_C(-119),
                           INT8_C(  18), INT8_C( -58), INT8_C(  99), INT8_C( -43),
                           INT8_C(  63), INT8_C(  74), INT8_C(  76), INT8_C( -51),
                           INT8_C( -21), INT8_C( -51), INT8_C( 122), INT8_C( -85),
                           INT8_C(  54), INT8_C( -69), INT8_C(  72), INT8_C( 111),
                           INT8_C(  33), INT8_C( -99), INT8_C(  -4), INT8_C(  32),
                           INT8_C(-118), INT8_C( 119), INT8_C( 126), INT8_C( -30),
                           INT8_C( -60), INT8_C( -48), INT8_C( -93), INT8_C( 113),
                           INT8_C(  44), INT8_C(  13), INT8_C(  40), INT8_C(  25),
                           INT8_C( -54), INT8_C( -49), INT8_C(-104), INT8_C(-106),
                           INT8_C(  -8), INT8_C(  71), INT8_C(  97), INT8_C( -37),
                           INT8_C( -97), INT8_C( 104), INT8_C( -72), INT8_C( -12),
                           INT8_C( -92), INT8_C( -10), INT8_C( -37), INT8_C( -55),
                           INT8_C(  26), INT8_C(  99), INT8_C( 118), INT8_C( 104)),
      simde_mm512_set_epi8(INT8_C( -50), INT8_C( -76), INT8_C(   0), INT8_C( -95),
                           INT8_C( -70), INT8_C(   0), INT8_C(  49), INT8_C(  34),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  49),
                           INT8_C( 114), INT8_C( -36), INT8_C(   0), INT8_C(  97),
                           INT8_C(   0), INT8_C(   0), INT8_C(  83), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   3),
                           INT8_C( -16), INT8_C(   0), INT8_C( -57), INT8_C(  22),
                           INT8_C(  92), INT8_C(  67), INT8_C(   0), INT8_C( -69),
                           INT8_C(  88), INT8_C( -11), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -49), INT8_C( -70), INT8_C(   0),
                           INT8_C(   0), INT8_C( -29), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  47), INT8_C(-114), INT8_C(  71), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C( -74), INT8_C( 105), INT8_C( 122),
                           INT8_C(-110), INT8_C( -98), INT8_C(  86), INT8_C( -56)) },
    { UINT64_C(12731945964385124885),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C(  28), INT8_C( -98), INT8_C( -75),
                           INT8_C(  86), INT8_C( -13), INT8_C( -71), INT8_C( -97),
                           INT8_C(-109), INT8_C( -82), INT8_C(  68), INT8_C(  69),
                           INT8_C(   3), INT8_C(  91), INT8_C( -46), INT8_C(  55),
                           INT8_C( -27), INT8_C( -27), INT8_C( -39), INT8_C( -77),
                           INT8_C(  21), INT8_C(  50), INT8_C(  79), INT8_C( -83),
                           INT8_C( 113), INT8_C( -85), INT8_C( -34), INT8_C(  49),
                           INT8_C(  43), INT8_C( -40), INT8_C( -68), INT8_C(  40),
                           INT8_C( 117), INT8_C(  67), INT8_C( -53), INT8_C(   2),
                           INT8_C( -36), INT8_C(  64), INT8_C( -49), INT8_C(  42),
                           INT8_C( -73), INT8_C(  13), INT8_C(  54), INT8_C(-116),
                           INT8_C(-102), INT8_C( -83), INT8_C( -29), INT8_C(  55),
                           INT8_C(  57), INT8_C(  87), INT8_C(  73), INT8_C( -70),
                           INT8_C(-103), INT8_C(-105), INT8_C( -99), INT8_C(   2),
                           INT8_C(  51), INT8_C(  38), INT8_C( -90), INT8_C(  14),
                           INT8_C( -23), INT8_C( 121), INT8_C(  31), INT8_C( -78)),
      simde_mm512_set_epi8(INT8_C( -62), INT8_C( -47), INT8_C(-114), INT8_C(  87),
                           INT8_C( -23), INT8_C( -34), INT8_C( -44), INT8_C(   6),
                           INT8_C(  21), INT8_C( -94), INT8_C( -31), INT8_C(  89),
                           INT8_C(  -3), INT8_C( 101), INT8_C(  62), INT8_C( -72),
                           INT8_C(  38), INT8_C( -41), INT8_C( 112), INT8_C( 117),
                           INT8_C(  58), INT8_C(  17), INT8_C(-102), INT8_C( -45),
                           INT8_C(   5), INT8_C(  37), INT8_C(  20), INT8_C( -10),
                           INT8_C( 125), INT8_C( -30), INT8_C( -78), INT8_C(-119),
                           INT8_C( -34), INT8_C( -69), INT8_C(   5), INT8_C(  -4),
                           INT8_C(  57), INT8_C( -46), INT8_C(  38), INT8_C(-103),
                           INT8_C(  38), INT8_C(  94), INT8_C(   6), INT8_C( 108),
                           INT8_C( 102), INT8_C( 123), INT8_C( 103), INT8_C( 112),
                           INT8_C( -27), INT8_C(-114), INT8_C(-101), INT8_C(-115),
                           INT8_C(-101), INT8_C(  69), INT8_C(-119), INT8_C( -14),
                           INT8_C(  14), INT8_C(  10), INT8_C(  41), INT8_C(  17),
                           INT8_C( -27), INT8_C(-110), INT8_C(  84), INT8_C( -17)),
      simde_mm512_set_epi8(INT8_C( -24), INT8_C(   0), INT8_C( -28), INT8_C(  74),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -29), INT8_C(   0), INT8_C( -33), INT8_C( -81),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(  86), INT8_C( -50),
                           INT8_C(   0), INT8_C(  82), INT8_C(   0), INT8_C( -98),
                           INT8_C(   0), INT8_C( 125), INT8_C(   9), INT8_C(   0),
                           INT8_C(   0), INT8_C(  22), INT8_C(   0), INT8_C(  -2),
                           INT8_C(  44), INT8_C( 118), INT8_C(   0), INT8_C(  86),
                           INT8_C( -19), INT8_C(   0), INT8_C(  75), INT8_C(   0),
                           INT8_C( 124), INT8_C(   0), INT8_C(-106), INT8_C(   0),
                           INT8_C(   0), INT8_C( -10), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -2), INT8_C( -23), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  34), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   4),
                           INT8_C(   0), INT8_C(-111), INT8_C(   0), INT8_C( -68)) },
    { UINT64_C( 3574159949714469990),
      simde_mm512_set_epi8(INT8_C(   7), INT8_C( -12), INT8_C( 120), INT8_C(  61),
                           INT8_C( -91), INT8_C( 115), INT8_C(   9), INT8_C(  59),
                           INT8_C( -83), INT8_C(-127), INT8_C(  36), INT8_C( -14),
                           INT8_C( -98), INT8_C(  13), INT8_C( -23), INT8_C( -82),
                           INT8_C( -57), INT8_C(-100), INT8_C( -48), INT8_C(-103),
                           INT8_C( 117), INT8_C(-122), INT8_C( -71), INT8_C( 115),
                           INT8_C( 123), INT8_C(  45), INT8_C(  89), INT8_C( -95),
                           INT8_C(-117), INT8_C( -47), INT8_C(  71), INT8_C( 107),
                           INT8_C( -86), INT8_C( -74), INT8_C(  66), INT8_C( -36),
                           INT8_C(  -2), INT8_C(  91), INT8_C( -51), INT8_C(  23),
                           INT8_C( -45), INT8_C( -60), INT8_C( -99), INT8_C(  65),
                           INT8_C(-113), INT8_C(  -7), INT8_C( -76), INT8_C(  51),
                           INT8_C(  18), INT8_C(  27), INT8_C( -14), INT8_C( 124),
                           INT8_C( -66), INT8_C( -18), INT8_C(  -5), INT8_C(   0),
                           INT8_C(  98), INT8_C(  31), INT8_C( -53), INT8_C( 122),
                           INT8_C( -44), INT8_C( 121), INT8_C( -29), INT8_C( -24)),
      simde_mm512_set_epi8(INT8_C( -43), INT8_C(-128), INT8_C( 122), INT8_C( -97),
                           INT8_C(  32), INT8_C( -77), INT8_C( -10), INT8_C(  -9),
                           INT8_C(  -5), INT8_C( -84), INT8_C(-115), INT8_C(-106),
                           INT8_C(  40), INT8_C(-127), INT8_C(  47), INT8_C( -89),
                           INT8_C(   7), INT8_C(  50), INT8_C(-110), INT8_C(  70),
                           INT8_C( -40), INT8_C(  59), INT8_C( 127), INT8_C( -94),
                           INT8_C( -96), INT8_C( -66), INT8_C( -54), INT8_C(-111),
                           INT8_C( -88), INT8_C( -27), INT8_C( -51), INT8_C( -96),
                           INT8_C( 118), INT8_C( -71), INT8_C( 125), INT8_C( 110),
                           INT8_C(-115), INT8_C(-128), INT8_C(  71), INT8_C(-120),
                           INT8_C(-113), INT8_C(  21), INT8_C( -93), INT8_C(-123),
                           INT8_C( -55), INT8_C( -21), INT8_C( -23), INT8_C(  47),
                           INT8_C( 101), INT8_C(-127), INT8_C(  66), INT8_C(  -9),
                           INT8_C( -88), INT8_C( -89), INT8_C(  79), INT8_C( -89),
                           INT8_C(-125), INT8_C(  89), INT8_C(  66), INT8_C(  35),
                           INT8_C( -61), INT8_C(  48), INT8_C( -39), INT8_C( 121)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( 106), INT8_C(   6),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  12),
                           INT8_C(  34), INT8_C(   0), INT8_C(   0), INT8_C(  48),
                           INT8_C( -96), INT8_C(   0), INT8_C(   0), INT8_C( -45),
                           INT8_C(  10), INT8_C( -12), INT8_C( -18), INT8_C(-126),
                           INT8_C(   0), INT8_C( 107), INT8_C(  -1), INT8_C(   1),
                           INT8_C( -39), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  18), INT8_C(   0), INT8_C(   0), INT8_C( 118),
                           INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C( -99),
                           INT8_C( -90), INT8_C(  74), INT8_C(   0), INT8_C(  43),
                           INT8_C(   0), INT8_C(   0), INT8_C( -56), INT8_C(   0),
                           INT8_C( -81), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   2), INT8_C(   0), INT8_C(  92), INT8_C(  85),
                           INT8_C(   0), INT8_C( -32), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -69), INT8_C( -67), INT8_C(   0),
                           INT8_C(   0), INT8_C(  33), INT8_C(-106), INT8_C(   0)) },
    { UINT64_C( 7245014237231228482),
      simde_mm512_set_epi8(INT8_C( 102), INT8_C(  39), INT8_C( -51), INT8_C(   5),
                           INT8_C( -36), INT8_C( -70), INT8_C(  38), INT8_C(-126),
                           INT8_C( -24), INT8_C(-125), INT8_C( -94), INT8_C( -42),
                           INT8_C( 104), INT8_C( -11), INT8_C( -43), INT8_C(  61),
                           INT8_C( -61), INT8_C( -93), INT8_C( 105), INT8_C(  12),
                           INT8_C( -70), INT8_C( 125), INT8_C(  23), INT8_C( -91),
                           INT8_C( -30), INT8_C( 110), INT8_C( -97), INT8_C( -76),
                           INT8_C( -96), INT8_C( 126), INT8_C( -48), INT8_C(-117),
                           INT8_C(  20), INT8_C(  23), INT8_C(  95), INT8_C( -52),
                           INT8_C(  15), INT8_C( -26), INT8_C( -88), INT8_C(  -3),
                           INT8_C(  69), INT8_C( -98), INT8_C(-100), INT8_C(  33),
                           INT8_C( -17), INT8_C( -10), INT8_C( -53), INT8_C(  53),
                           INT8_C( -25), INT8_C(  38), INT8_C(  75), INT8_C(  71),
                           INT8_C( 106), INT8_C( -45), INT8_C( -51), INT8_C(  79),
                           INT8_C(  54), INT8_C( -50), INT8_C( -94), INT8_C(  16),
                           INT8_C(   3), INT8_C( -22), INT8_C( -34), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C( 123), INT8_C( -61), INT8_C( -18), INT8_C(  14),
                           INT8_C(  36), INT8_C(  -5), INT8_C(  29), INT8_C(  95),
                           INT8_C( -38), INT8_C( -24), INT8_C(  52), INT8_C( -93),
                           INT8_C(-118), INT8_C( -53), INT8_C(  97), INT8_C( -62),
                           INT8_C(  93), INT8_C( -85), INT8_C( 110), INT8_C(  78),
                           INT8_C(  27), INT8_C( -48), INT8_C( -31), INT8_C( -33),
                           INT8_C(  29), INT8_C(  58), INT8_C(  95), INT8_C(  42),
                           INT8_C(  15), INT8_C(  43), INT8_C( 119), INT8_C(  59),
                           INT8_C(-127), INT8_C( -47), INT8_C( -59), INT8_C(  -3),
                           INT8_C( -51), INT8_C(  41), INT8_C(   7), INT8_C(  -3),
                           INT8_C(  80), INT8_C(  88), INT8_C( 103), INT8_C( -43),
                           INT8_C(-102), INT8_C(  82), INT8_C( -24), INT8_C( -40),
                           INT8_C( -58), INT8_C(  26), INT8_C(  95), INT8_C(  -4),
                           INT8_C(  -1), INT8_C(-103), INT8_C( -99), INT8_C( -29),
                           INT8_C(  -5), INT8_C(   1), INT8_C( -57), INT8_C(  73),
                           INT8_C( -83), INT8_C(  48), INT8_C(  42), INT8_C(-113)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  50), INT8_C( -39), INT8_C(   0),
                           INT8_C(   0), INT8_C( -67), INT8_C(   0), INT8_C(   0),
                           INT8_C(-114), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -86), INT8_C(   0), INT8_C(   2), INT8_C( -81),
                           INT8_C(   0), INT8_C(  -1), INT8_C(-112), INT8_C( -88),
                           INT8_C(   0), INT8_C(  68), INT8_C( -66), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-113),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  84), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-119), INT8_C(   0),
                           INT8_C(  78), INT8_C( -69), INT8_C(   0), INT8_C(  -4),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  11), INT8_C(   0), INT8_C( -96), INT8_C(   0),
                           INT8_C(   0), INT8_C( -37), INT8_C(  28), INT8_C(   0),
                           INT8_C(   0), INT8_C(  20), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   9), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_gf2p8affineinv_epi64_epi8(test_vec[i].k, test_vec[i].x, test_vec[i].A, 189);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -58), INT8_C( 123), INT8_C(  47), INT8_C( -69),
                        INT8_C(-122), INT8_C(-128), INT8_C(  42), INT8_C( 103),
                        INT8_C(-125), INT8_C(   0), INT8_C(  21), INT8_C(  57),
                        INT8_C(-125), INT8_C(  27), INT8_C( 126), INT8_C(  26)),
      simde_mm_set_epi8(INT8_C( 125), INT8_C(-110), INT8_C( -61), INT8_C( -52),
                        INT8_C(  91), INT8_C( -51), INT8_C(  46), INT8_C(  77),
                        INT8_C( 126), INT8_C( 102), INT8_C(  36), INT8_C(  89),
                        INT8_C(  53), INT8_C(  15), INT8_C(  47), INT8_C( -91)),
      simde_mm_set_epi8(INT8_C(-125), INT8_C( -50), INT8_C(  46), INT8_C( 100),
                        INT8_C( -93), INT8_C(  13), INT8_C(-128), INT8_C(  93),
                        INT8_C(  -3), INT8_C(   0), INT8_C( -62), INT8_C(-107),
                        INT8_C(-102), INT8_C(-103), INT8_C( -27), INT8_C( -80)) },
    { simde_mm_set_epi8(INT8_C(-105), INT8_C(  84), INT8_C(  32), INT8_C(  -1),
                        INT8_C( -57), INT8_C( -96), INT8_C(  93), INT8_C( -24),
                        INT8_C(  47), INT8_C(  26), INT8_C(-124), INT8_C( -74),
                        INT8_C(  44), INT8_C(-100), INT8_C(  65), INT8_C( -86)),
      simde_mm_set_epi8(INT8_C(  74), INT8_C(  13), INT8_C( -32), INT8_C( -64),
                        INT8_C(  89), INT8_C(  97), INT8_C( -84), INT8_C(   6),
                        INT8_C(  20), INT8_C(  76), INT8_C(  95), INT8_C(  31),
                        INT8_C(  84), INT8_C(  99), INT8_C(-109), INT8_C( -83)),
      simde_mm_set_epi8(INT8_C(  27), INT8_C(-119), INT8_C(  31), INT8_C( -38),
                        INT8_C(  92), INT8_C( -14), INT8_C( -85), INT8_C(  70),
                        INT8_C( 122), INT8_C(  98), INT8_C(  51), INT8_C( 125),
                        INT8_C( -77), INT8_C( -75), INT8_C( 114), INT8_C( -55)) },
    { simde_mm_set_epi8(INT8_C( -91), INT8_C( -71), INT8_C(  87), INT8_C( -92),
                        INT8_C(  75), INT8_C( -44), INT8_C(  61), INT8_C(  96),
                        INT8_C( -18), INT8_C( -37), INT8_C(  -6), INT8_C( -31),
                        INT8_C(  31), INT8_C(  58), INT8_C( 110), INT8_C(  64)),
      simde_mm_set_epi8(INT8_C(  47), INT8_C(  -7), INT8_C(  97), INT8_C(  96),
                        INT8_C(  79), INT8_C( 104), INT8_C(  -1), INT8_C(  57),
                        INT8_C(  34), INT8_C( 115), INT8_C(  45), INT8_C(-100),
                        INT8_C( -72), INT8_C( 125), INT8_C( -10), INT8_C(   6)),
      simde_mm_set_epi8(INT8_C( 110), INT8_C(  35), INT8_C(  69), INT8_C( -55),
                        INT8_C( -39), INT8_C( -82), INT8_C(  44), INT8_C( -93),
                        INT8_C(   3), INT8_C(  43), INT8_C( -36), INT8_C(-114),
                        INT8_C( -57), INT8_C(-105), INT8_C( -45), INT8_C(-101)) },
    { simde_mm_set_epi8(INT8_C(-128), INT8_C(  25), INT8_C( -81), INT8_C( -53),
                        INT8_C( -19), INT8_C(  25), INT8_C( -96), INT8_C(  81),
                        INT8_C(  14), INT8_C( -65), INT8_C(  80), INT8_C(  40),
                        INT8_C( -41), INT8_C(  42), INT8_C(  54), INT8_C(  95)),
      simde_mm_set_epi8(INT8_C( -67), INT8_C(-113), INT8_C( -30), INT8_C( -24),
                        INT8_C(-126), INT8_C( -91), INT8_C( 113), INT8_C( 114),
                        INT8_C( -22), INT8_C(  54), INT8_C( -86), INT8_C(  85),
                        INT8_C(  50), INT8_C(-122), INT8_C( -72), INT8_C(  27)),
      simde_mm_set_epi8(INT8_C(  51), INT8_C( -77), INT8_C( -15), INT8_C(  58),
                        INT8_C( 103), INT8_C(  68), INT8_C(  28), INT8_C(-116),
                        INT8_C(  91), INT8_C( -96), INT8_C( 109), INT8_C( -48),
                        INT8_C( -49), INT8_C(  32), INT8_C(  34), INT8_C( -88)) },
    { simde_mm_set_epi8(INT8_C(  91), INT8_C( -42), INT8_C( 121), INT8_C( 102),
                        INT8_C( -61), INT8_C( -31), INT8_C(  58), INT8_C( 119),
                        INT8_C(  82), INT8_C( -13), INT8_C( -95), INT8_C( 125),
                        INT8_C( -30), INT8_C( -60), INT8_C(  23), INT8_C( -52)),
      simde_mm_set_epi8(INT8_C(-125), INT8_C(-124), INT8_C( -84), INT8_C( -88),
                        INT8_C(-108), INT8_C( -61), INT8_C(  56), INT8_C(  72),
                        INT8_C(  -2), INT8_C(  79), INT8_C(   1), INT8_C(  -6),
                        INT8_C( 116), INT8_C(  83), INT8_C(  48), INT8_C( -70)),
      simde_mm_set_epi8(INT8_C(-113), INT8_C(  87), INT8_C( 113), INT8_C( -94),
                        INT8_C( -23), INT8_C( -70), INT8_C(  71), INT8_C(  81),
                        INT8_C(  97), INT8_C( -92), INT8_C( -95), INT8_C(   1),
                        INT8_C( -26), INT8_C(  94), INT8_C( -67), INT8_C( -88)) },
    { simde_mm_set_epi8(INT8_C(  -7), INT8_C( 123), INT8_C( -98), INT8_C( -17),
                        INT8_C(  95), INT8_C( -15), INT8_C(  17), INT8_C( 113),
                        INT8_C( -45), INT8_C( -59), INT8_C( 123), INT8_C( 108),
                        INT8_C( -51), INT8_C( 102), INT8_C( -38), INT8_C( -29)),
      simde_mm_set_epi8(INT8_C( -21), INT8_C( -80), INT8_C(  86), INT8_C( 103),
                        INT8_C(  12), INT8_C( -96), INT8_C(  24), INT8_C( 118),
                        INT8_C(  -7), INT8_C( -63), INT8_C( -34), INT8_C( -12),
                        INT8_C( 117), INT8_C( 111), INT8_C(-126), INT8_C( -74)),
      simde_mm_set_epi8(INT8_C( -25), INT8_C( -63), INT8_C( -58), INT8_C(-116),
                        INT8_C( -87), INT8_C(  45), INT8_C(-125), INT8_C(-111),
                        INT8_C( 117), INT8_C(  25), INT8_C(  37), INT8_C(  -4),
                        INT8_C( -13), INT8_C( -88), INT8_C( -41), INT8_C(  86)) },
    { simde_mm_set_epi8(INT8_C(  17), INT8_C(  14), INT8_C( -61), INT8_C(   9),
                        INT8_C( -68), INT8_C(  42), INT8_C( -15), INT8_C(-123),
                        INT8_C( -11), INT8_C(   1), INT8_C(  19), INT8_C(  11),
                        INT8_C(  27), INT8_C( -47), INT8_C( -84), INT8_C( 127)),
      simde_mm_set_epi8(INT8_C( 102), INT8_C(  62), INT8_C(-100), INT8_C(  53),
                        INT8_C( -45), INT8_C(-125), INT8_C(  97), INT8_C( -82),
                        INT8_C( -10), INT8_C( -29), INT8_C(   9), INT8_C( 117),
                        INT8_C(  31), INT8_C( -55), INT8_C( -99), INT8_C(   8)),
      simde_mm_set_epi8(INT8_C(  92), INT8_C( 111), INT8_C( -85), INT8_C(-122),
                        INT8_C(-115), INT8_C( -94), INT8_C( -22), INT8_C(  80),
                        INT8_C(  83), INT8_C( -29), INT8_C(-117), INT8_C(  26),
                        INT8_C(  50), INT8_C(  70), INT8_C( 120), INT8_C( -43)) },
    { simde_mm_set_epi8(INT8_C( -69), INT8_C( 107), INT8_C( -90), INT8_C(  49),
                        INT8_C(  80), INT8_C( 122), INT8_C( -46), INT8_C(-115),
                        INT8_C(  85), INT8_C(-120), INT8_C( -81), INT8_C( -30),
                        INT8_C( -51), INT8_C( -64), INT8_C( -74), INT8_C(-110)),
      simde_mm_set_epi8(INT8_C( 112), INT8_C(  61), INT8_C( -18), INT8_C( -23),
                        INT8_C(   3), INT8_C( -88), INT8_C( -95), INT8_C(  37),
                        INT8_C(  16), INT8_C( -91), INT8_C(  91), INT8_C( -61),
                        INT8_C(  41), INT8_C( -70), INT8_C(  71), INT8_C( 106)),
      simde_mm_set_epi8(INT8_C( -64), INT8_C(-116), INT8_C( -85), INT8_C( -33),
                        INT8_C( -16), INT8_C( 109), INT8_C( -61), INT8_C( -97),
                        INT8_C(  39), INT8_C( -40), INT8_C(-125), INT8_C( -28),
                        INT8_C(  55), INT8_C( -47), INT8_C(  77), INT8_C( -65)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_gf2p8mul_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( -64), INT8_C(   5), INT8_C( -52), INT8_C(  61),
                           INT8_C(  44), INT8_C( 127), INT8_C(  41), INT8_C( 104),
                           INT8_C(-104), INT8_C(   0), INT8_C(  31), INT8_C(-117),
                           INT8_C(  23), INT8_C(-108), INT8_C( 112), INT8_C(  80),
                           INT8_C(  49), INT8_C(-108), INT8_C( 117), INT8_C( -92),
                           INT8_C( 104), INT8_C(  74), INT8_C(-105), INT8_C(  65),
                           INT8_C( -42), INT8_C(-113), INT8_C( -11), INT8_C(  61),
                           INT8_C( 123), INT8_C( -51), INT8_C(  60), INT8_C( -55)),
      simde_mm256_set_epi8(INT8_C(   9), INT8_C(  66), INT8_C(  63), INT8_C(-117),
                           INT8_C(  98), INT8_C( -93), INT8_C( 123), INT8_C(-119),
                           INT8_C( -37), INT8_C(-125), INT8_C(  28), INT8_C( 106),
                           INT8_C(   9), INT8_C( -53), INT8_C(  11), INT8_C( -65),
                           INT8_C(-105), INT8_C( -83), INT8_C(  35), INT8_C( -41),
                           INT8_C( -68), INT8_C(  71), INT8_C( -97), INT8_C(-119),
                           INT8_C(  76), INT8_C(  41), INT8_C(  47), INT8_C( -23),
                           INT8_C( 107), INT8_C( 108), INT8_C(   6), INT8_C(   9)),
      simde_mm256_set_epi8(INT8_C(-102), INT8_C(  81), INT8_C( -12), INT8_C(  29),
                           INT8_C(  90), INT8_C(   7), INT8_C( 119), INT8_C(-113),
                           INT8_C( 101), INT8_C(   0), INT8_C( 111), INT8_C(  82),
                           INT8_C( -81), INT8_C(  37), INT8_C(  61), INT8_C(  17),
                           INT8_C(  89), INT8_C(  87), INT8_C( -67), INT8_C( 118),
                           INT8_C(  41), INT8_C( -16), INT8_C(  64), INT8_C( -78),
                           INT8_C(-114), INT8_C( -53), INT8_C( -99), INT8_C(  95),
                           INT8_C( 104), INT8_C( 104), INT8_C(-120), INT8_C( -37)) },
    { simde_mm256_set_epi8(INT8_C( 109), INT8_C( 111), INT8_C(  -4), INT8_C(-109),
                           INT8_C(  87), INT8_C( -68), INT8_C(  77), INT8_C( 111),
                           INT8_C(-125), INT8_C( -95), INT8_C(   5), INT8_C(  54),
                           INT8_C( -26), INT8_C( -96), INT8_C(  42), INT8_C(  54),
                           INT8_C( -13), INT8_C( 113), INT8_C( -23), INT8_C(  95),
                           INT8_C(  52), INT8_C(  70), INT8_C( -41), INT8_C(  48),
                           INT8_C( -32), INT8_C( -33), INT8_C( -47), INT8_C( 114),
                           INT8_C(  -7), INT8_C( -79), INT8_C( 124), INT8_C(  54)),
      simde_mm256_set_epi8(INT8_C( -13), INT8_C(  56), INT8_C(  -1), INT8_C( -30),
                           INT8_C( -15), INT8_C(  -2), INT8_C(  36), INT8_C(  56),
                           INT8_C( -23), INT8_C(   5), INT8_C( -38), INT8_C( -84),
                           INT8_C(  22), INT8_C(  -3), INT8_C(-108), INT8_C(  92),
                           INT8_C( -79), INT8_C(  88), INT8_C(  56), INT8_C(  72),
                           INT8_C(-105), INT8_C( -59), INT8_C( -78), INT8_C(  22),
                           INT8_C( 108), INT8_C( 107), INT8_C(  87), INT8_C( -27),
                           INT8_C(  -6), INT8_C(   7), INT8_C( 111), INT8_C(  73)),
      simde_mm256_set_epi8(INT8_C(  16), INT8_C( -80), INT8_C(   9), INT8_C(  -8),
                           INT8_C( 122), INT8_C(  10), INT8_C(  76), INT8_C( -80),
                           INT8_C( -80), INT8_C(  19), INT8_C( -97), INT8_C( -73),
                           INT8_C(-128), INT8_C( -20), INT8_C( -30), INT8_C(  17),
                           INT8_C(  44), INT8_C( -85), INT8_C(  63), INT8_C( -28),
                           INT8_C( -92), INT8_C(  21), INT8_C( 109), INT8_C(-115),
                           INT8_C( -51), INT8_C(   1), INT8_C( 116), INT8_C( -39),
                           INT8_C(  23), INT8_C(  58), INT8_C(-119), INT8_C( -78)) },
    { simde_mm256_set_epi8(INT8_C( -47), INT8_C(  94), INT8_C( -65), INT8_C(  47),
                           INT8_C( -15), INT8_C(  76), INT8_C(  46), INT8_C( -47),
                           INT8_C( 127), INT8_C( -95), INT8_C(-108), INT8_C(  25),
                           INT8_C( 127), INT8_C(  20), INT8_C(  84), INT8_C(  14),
                           INT8_C(-101), INT8_C( 118), INT8_C(  44), INT8_C( 105),
                           INT8_C(  84), INT8_C(   8), INT8_C( -86), INT8_C( -72),
                           INT8_C(   3), INT8_C(  97), INT8_C(-127), INT8_C(  72),
                           INT8_C( -12), INT8_C(  62), INT8_C(  21), INT8_C(-118)),
      simde_mm256_set_epi8(INT8_C( -91), INT8_C(  95), INT8_C(  10), INT8_C( -45),
                           INT8_C( -37), INT8_C(  13), INT8_C( -37), INT8_C(  29),
                           INT8_C(  23), INT8_C(  79), INT8_C( -38), INT8_C( 123),
                           INT8_C( -40), INT8_C(  80), INT8_C(  90), INT8_C(  -3),
                           INT8_C(-128), INT8_C( -44), INT8_C(  29), INT8_C(  89),
                           INT8_C(  84), INT8_C( -98), INT8_C(  62), INT8_C( -67),
                           INT8_C(  44), INT8_C(  35), INT8_C(  39), INT8_C(  48),
                           INT8_C( -65), INT8_C(  11), INT8_C(  20), INT8_C( -83)),
      simde_mm256_set_epi8(INT8_C(  82), INT8_C( -70), INT8_C( -22), INT8_C( -24),
                           INT8_C( 126), INT8_C(  49), INT8_C(  80), INT8_C( -43),
                           INT8_C( -41), INT8_C( -32), INT8_C(  50), INT8_C( 127),
                           INT8_C( 105), INT8_C(  44), INT8_C( -43), INT8_C(-111),
                           INT8_C( -75), INT8_C( 117), INT8_C(  17), INT8_C( -61),
                           INT8_C( -96), INT8_C(-100), INT8_C(  36), INT8_C( -61),
                           INT8_C( 116), INT8_C(  55), INT8_C(  33), INT8_C(  47),
                           INT8_C(  -7), INT8_C( -87), INT8_C(  31), INT8_C( -75)) },
    { simde_mm256_set_epi8(INT8_C( -87), INT8_C(   1), INT8_C(  86), INT8_C(  46),
                           INT8_C(  82), INT8_C( -21), INT8_C(-103), INT8_C(  67),
                           INT8_C(  41), INT8_C( -98), INT8_C( 111), INT8_C(  83),
                           INT8_C( -84), INT8_C(  75), INT8_C( -53), INT8_C(  41),
                           INT8_C( -83), INT8_C(  56), INT8_C(-112), INT8_C( -60),
                           INT8_C(  31), INT8_C( -28), INT8_C(-106), INT8_C( 106),
                           INT8_C( -91), INT8_C( -27), INT8_C(  55), INT8_C(  18),
                           INT8_C(-100), INT8_C( 105), INT8_C(  73), INT8_C( -31)),
      simde_mm256_set_epi8(INT8_C(  28), INT8_C(-125), INT8_C( 109), INT8_C(  10),
                           INT8_C(  55), INT8_C(-108), INT8_C( 122), INT8_C( 107),
                           INT8_C( 115), INT8_C(  51), INT8_C( 105), INT8_C( -65),
                           INT8_C( -95), INT8_C( -77), INT8_C( -14), INT8_C( -35),
                           INT8_C( 117), INT8_C(-115), INT8_C(  85), INT8_C( -81),
                           INT8_C( -75), INT8_C(  80), INT8_C(  61), INT8_C(  67),
                           INT8_C(  49), INT8_C(-121), INT8_C(-126), INT8_C( 113),
                           INT8_C( 118), INT8_C( 104), INT8_C(-114), INT8_C(-124)),
      simde_mm256_set_epi8(INT8_C( -45), INT8_C(-125), INT8_C( -31), INT8_C(  55),
                           INT8_C(  92), INT8_C(  56), INT8_C(  47), INT8_C(  56),
                           INT8_C(  36), INT8_C( -36), INT8_C( -21), INT8_C( -53),
                           INT8_C(-101), INT8_C(  24), INT8_C( -79), INT8_C(-111),
                           INT8_C(-107), INT8_C(  28), INT8_C(   4), INT8_C(   2),
                           INT8_C(  92), INT8_C( -25), INT8_C( -38), INT8_C( 123),
                           INT8_C( 124), INT8_C(  71), INT8_C( -80), INT8_C( -77),
                           INT8_C( 108), INT8_C( -17), INT8_C( 114), INT8_C(  85)) },
    { simde_mm256_set_epi8(INT8_C( 114), INT8_C(-109), INT8_C(  63), INT8_C( 126),
                           INT8_C(  -5), INT8_C( 116), INT8_C( 117), INT8_C(   7),
                           INT8_C( -37), INT8_C(-120), INT8_C(  98), INT8_C( -61),
                           INT8_C( -52), INT8_C(  72), INT8_C( -17), INT8_C( -96),
                           INT8_C( 120), INT8_C(-106), INT8_C( -53), INT8_C(-128),
                           INT8_C(  83), INT8_C(  90), INT8_C(  -1), INT8_C( -38),
                           INT8_C(  61), INT8_C(  90), INT8_C(  66), INT8_C(  11),
                           INT8_C(  28), INT8_C(  59), INT8_C(  65), INT8_C( -43)),
      simde_mm256_set_epi8(INT8_C(  13), INT8_C(  -5), INT8_C(-110), INT8_C(  28),
                           INT8_C( -82), INT8_C( -14), INT8_C(  26), INT8_C(  50),
                           INT8_C( -38), INT8_C( -44), INT8_C( -75), INT8_C(  65),
                           INT8_C(  -1), INT8_C( -39), INT8_C( -61), INT8_C( 107),
                           INT8_C(  88), INT8_C( 116), INT8_C(  14), INT8_C( -78),
                           INT8_C(  48), INT8_C( 107), INT8_C( 119), INT8_C( -26),
                           INT8_C(-118), INT8_C(  36), INT8_C(  90), INT8_C(  95),
                           INT8_C(-115), INT8_C(  31), INT8_C( 100), INT8_C(  59)),
      simde_mm256_set_epi8(INT8_C(  28), INT8_C( 108), INT8_C(  17), INT8_C( -97),
                           INT8_C( -76), INT8_C( -25), INT8_C( 126), INT8_C( -98),
                           INT8_C( -76), INT8_C( -61), INT8_C(-126), INT8_C( -27),
                           INT8_C( -78), INT8_C( 110), INT8_C(  68), INT8_C( -34),
                           INT8_C(   5), INT8_C(  42), INT8_C(-114), INT8_C( -14),
                           INT8_C( -55), INT8_C( -52), INT8_C( -49), INT8_C( -80),
                           INT8_C(  32), INT8_C( -58), INT8_C( -59), INT8_C(  47),
                           INT8_C(  14), INT8_C(  -1), INT8_C(  12), INT8_C(-116)) },
    { simde_mm256_set_epi8(INT8_C( 124), INT8_C( -99), INT8_C( -16), INT8_C( -83),
                           INT8_C(   4), INT8_C( 119), INT8_C(-113), INT8_C( -73),
                           INT8_C( -61), INT8_C(  -4), INT8_C( -56), INT8_C(  44),
                           INT8_C(-102), INT8_C( -29), INT8_C( -70), INT8_C( 103),
                           INT8_C(  10), INT8_C( 112), INT8_C( -76), INT8_C( -75),
                           INT8_C( -63), INT8_C(  -6), INT8_C( -93), INT8_C(  14),
                           INT8_C(  64), INT8_C( -16), INT8_C(  98), INT8_C(  22),
                           INT8_C( -15), INT8_C(   4), INT8_C( 109), INT8_C(  54)),
      simde_mm256_set_epi8(INT8_C(  83), INT8_C( -21), INT8_C(  47), INT8_C( 102),
                           INT8_C(  74), INT8_C(  92), INT8_C(  76), INT8_C( -29),
                           INT8_C( -56), INT8_C( 123), INT8_C(  82), INT8_C(-108),
                           INT8_C( 122), INT8_C(  41), INT8_C(-112), INT8_C(  64),
                           INT8_C(  20), INT8_C(  33), INT8_C(-101), INT8_C( -46),
                           INT8_C( -38), INT8_C(  16), INT8_C(-109), INT8_C( -97),
                           INT8_C(  53), INT8_C(  76), INT8_C(  -8), INT8_C( -77),
                           INT8_C(-106), INT8_C(   4), INT8_C(  38), INT8_C(   9)),
      simde_mm256_set_epi8(INT8_C(  55), INT8_C( -54), INT8_C(  14), INT8_C(  71),
                           INT8_C(  51), INT8_C( -89), INT8_C( -66), INT8_C( -75),
                           INT8_C(  40), INT8_C(  42), INT8_C( 111), INT8_C( -73),
                           INT8_C( -95), INT8_C( -59), INT8_C( -53), INT8_C( -88),
                           INT8_C(-120), INT8_C( -14), INT8_C( 122), INT8_C(  41),
                           INT8_C( -98), INT8_C(  57), INT8_C(-118), INT8_C(  -5),
                           INT8_C( -17), INT8_C( 126), INT8_C( -67), INT8_C(  66),
                           INT8_C( -67), INT8_C(  16), INT8_C( 122), INT8_C( -99)) },
    { simde_mm256_set_epi8(INT8_C( -80), INT8_C(  32), INT8_C( -33), INT8_C(  47),
                           INT8_C(-126), INT8_C(-105), INT8_C(  54), INT8_C( -79),
                           INT8_C( -78), INT8_C(-125), INT8_C( -29), INT8_C(  27),
                           INT8_C(  43), INT8_C( 111), INT8_C(  -3), INT8_C(  66),
                           INT8_C(-107), INT8_C(  82), INT8_C( -81), INT8_C( 118),
                           INT8_C( -96), INT8_C(  44), INT8_C(  84), INT8_C(  19),
                           INT8_C( -58), INT8_C( -34), INT8_C(   5), INT8_C(   7),
                           INT8_C( 120), INT8_C( 104), INT8_C( 117), INT8_C( -13)),
      simde_mm256_set_epi8(INT8_C( -42), INT8_C( -83), INT8_C(  -1), INT8_C( -91),
                           INT8_C(-106), INT8_C( -87), INT8_C( -79), INT8_C(-103),
                           INT8_C( -35), INT8_C(   0), INT8_C( 122), INT8_C(  25),
                           INT8_C(-103), INT8_C( 107), INT8_C( -40), INT8_C(  90),
                           INT8_C(  -4), INT8_C( -20), INT8_C( -85), INT8_C(-125),
                           INT8_C( -77), INT8_C( -60), INT8_C( -82), INT8_C(  16),
                           INT8_C( 127), INT8_C(   8), INT8_C(-109), INT8_C( -71),
                           INT8_C( -52), INT8_C( -33), INT8_C(  97), INT8_C(  66)),
      simde_mm256_set_epi8(INT8_C( 104), INT8_C( 124), INT8_C( -63), INT8_C( 110),
                           INT8_C(  88), INT8_C( -47), INT8_C( -65), INT8_C( -62),
                           INT8_C( -11), INT8_C(   0), INT8_C( -73), INT8_C( 104),
                           INT8_C( -78), INT8_C(  53), INT8_C( -95), INT8_C( -59),
                           INT8_C(-122), INT8_C(-110), INT8_C(  41), INT8_C(-119),
                           INT8_C( -29), INT8_C( -76), INT8_C( -72), INT8_C(  43),
                           INT8_C(  20), INT8_C( -86), INT8_C( -23), INT8_C(   2),
                           INT8_C( 109), INT8_C( 123), INT8_C(  19), INT8_C( 111)) },
    { simde_mm256_set_epi8(INT8_C( 103), INT8_C( 114), INT8_C(   5), INT8_C( -85),
                           INT8_C(  92), INT8_C( 100), INT8_C(  42), INT8_C(-120),
                           INT8_C( -89), INT8_C( 109), INT8_C(   5), INT8_C(  42),
                           INT8_C(  40), INT8_C(  95), INT8_C( -31), INT8_C(-119),
                           INT8_C(  31), INT8_C(  56), INT8_C( -94), INT8_C( 107),
                           INT8_C(-116), INT8_C(  33), INT8_C(   0), INT8_C(-121),
                           INT8_C( 119), INT8_C( -25), INT8_C(  42), INT8_C(  10),
                           INT8_C(  65), INT8_C(-105), INT8_C( -79), INT8_C(  11)),
      simde_mm256_set_epi8(INT8_C( -74), INT8_C( -88), INT8_C( -86), INT8_C(  80),
                           INT8_C(  68), INT8_C(  25), INT8_C( -82), INT8_C(  21),
                           INT8_C( -25), INT8_C( 108), INT8_C(  70), INT8_C( -18),
                           INT8_C( -29), INT8_C(  82), INT8_C( -24), INT8_C(  -6),
                           INT8_C( -97), INT8_C(  91), INT8_C(  91), INT8_C(-124),
                           INT8_C(-115), INT8_C( -57), INT8_C(  83), INT8_C(  -1),
                           INT8_C(-120), INT8_C( 103), INT8_C(  40), INT8_C(-122),
                           INT8_C( 121), INT8_C(  30), INT8_C( -79), INT8_C( -92)),
      simde_mm256_set_epi8(INT8_C( 124), INT8_C(  90), INT8_C(  52), INT8_C(  61),
                           INT8_C(-127), INT8_C( 115), INT8_C(  92), INT8_C( -58),
                           INT8_C( -83), INT8_C(  -5), INT8_C(  69), INT8_C(  50),
                           INT8_C(  38), INT8_C(  19), INT8_C( -12), INT8_C( -72),
                           INT8_C(  87), INT8_C( -68), INT8_C(  65), INT8_C( -90),
                           INT8_C(  70), INT8_C(  84), INT8_C(   0), INT8_C( -82),
                           INT8_C(   6), INT8_C(-103), INT8_C( 124), INT8_C(  75),
                           INT8_C(  16), INT8_C(  56), INT8_C( -20), INT8_C( -96)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_gf2p8mul_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  -4), INT8_C( -99), INT8_C(  -5), INT8_C(  60),
                           INT8_C( -45), INT8_C(  78), INT8_C( -33), INT8_C(  92),
                           INT8_C(  53), INT8_C( -32), INT8_C( 109), INT8_C( -22),
                           INT8_C( -84), INT8_C( 118), INT8_C(  86), INT8_C( -65),
                           INT8_C(-122), INT8_C(  15), INT8_C(  72), INT8_C(  67),
                           INT8_C(  66), INT8_C( 122), INT8_C( -51), INT8_C(  61),
                           INT8_C(  85), INT8_C(  78), INT8_C(  46), INT8_C( -91),
                           INT8_C( -77), INT8_C( -87), INT8_C(  21), INT8_C(-107),
                           INT8_C(-117), INT8_C(  93), INT8_C(  83), INT8_C( -77),
                           INT8_C(-119), INT8_C( -17), INT8_C( -95), INT8_C(   4),
                           INT8_C( -62), INT8_C( -96), INT8_C(  27), INT8_C(  -4),
                           INT8_C( -68), INT8_C(  -9), INT8_C(  59), INT8_C(  90),
                           INT8_C(  45), INT8_C(-111), INT8_C(  29), INT8_C(  76),
                           INT8_C(  12), INT8_C( -34), INT8_C(   9), INT8_C( -31),
                           INT8_C(  87), INT8_C(  64), INT8_C( -55), INT8_C( -10),
                           INT8_C( -99), INT8_C(  -8), INT8_C(  49), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C( -73), INT8_C( -62), INT8_C(-104), INT8_C(  43),
                           INT8_C( -14), INT8_C( -77), INT8_C(-110), INT8_C( -27),
                           INT8_C(  39), INT8_C( -90), INT8_C(  61), INT8_C(  95),
                           INT8_C(   0), INT8_C( -99), INT8_C( 111), INT8_C( -43),
                           INT8_C(  93), INT8_C(  29), INT8_C(  80), INT8_C( -59),
                           INT8_C(   4), INT8_C(  54), INT8_C( -23), INT8_C(  91),
                           INT8_C(  35), INT8_C( 119), INT8_C( -89), INT8_C( -95),
                           INT8_C( -31), INT8_C( -75), INT8_C(  30), INT8_C(-102),
                           INT8_C(  31), INT8_C(-124), INT8_C( -19), INT8_C(-105),
                           INT8_C(-127), INT8_C( -12), INT8_C( -14), INT8_C( -63),
                           INT8_C( -34), INT8_C(   8), INT8_C( -37), INT8_C(   2),
                           INT8_C( -57), INT8_C(-117), INT8_C(  33), INT8_C(  54),
                           INT8_C(  92), INT8_C( 112), INT8_C(-110), INT8_C(  65),
                           INT8_C( 118), INT8_C( -69), INT8_C(  91), INT8_C( -29),
                           INT8_C( 115), INT8_C(  82), INT8_C(  92), INT8_C( -47),
                           INT8_C( -89), INT8_C(-107), INT8_C(  77), INT8_C(-124)),
      simde_mm512_set_epi8(INT8_C( -41), INT8_C( -11), INT8_C( -29), INT8_C( 126),
                           INT8_C( -39), INT8_C(  81), INT8_C(  52), INT8_C( 103),
                           INT8_C( 113), INT8_C(  21), INT8_C(   2), INT8_C(  27),
                           INT8_C(   0), INT8_C(  26), INT8_C(  77), INT8_C(  76),
                           INT8_C(-102), INT8_C( -69), INT8_C( 113), INT8_C( -23),
                           INT8_C(  19), INT8_C(  63), INT8_C( -79), INT8_C(-112),
                           INT8_C( -79), INT8_C( 120), INT8_C(-105), INT8_C(  69),
                           INT8_C( 105), INT8_C( 100), INT8_C( -99), INT8_C(-110),
                           INT8_C( -64), INT8_C(  32), INT8_C(  45), INT8_C(-125),
                           INT8_C(  -1), INT8_C( 105), INT8_C(  36), INT8_C(  41),
                           INT8_C( -50), INT8_C( 119), INT8_C( -21), INT8_C( -29),
                           INT8_C( 126), INT8_C( -14), INT8_C(  26), INT8_C( -91),
                           INT8_C(-108), INT8_C(  15), INT8_C( -13), INT8_C( -54),
                           INT8_C(  94), INT8_C(  76), INT8_C( -75), INT8_C(-123),
                           INT8_C( -20), INT8_C(  71), INT8_C( -81), INT8_C(  79),
                           INT8_C(  64), INT8_C( -28), INT8_C(-110), INT8_C(  -3)) },
    { simde_mm512_set_epi8(INT8_C(  -5), INT8_C(  74), INT8_C(-121), INT8_C( -14),
                           INT8_C(  64), INT8_C(  79), INT8_C( -35), INT8_C( -56),
                           INT8_C( -76), INT8_C( -75), INT8_C(  63), INT8_C(  84),
                           INT8_C(-118), INT8_C(  38), INT8_C(  75), INT8_C(  74),
                           INT8_C(  81), INT8_C(-120), INT8_C(  19), INT8_C( -37),
                           INT8_C( -94), INT8_C(  16), INT8_C(  48), INT8_C( -62),
                           INT8_C(  -7), INT8_C( -62), INT8_C(  16), INT8_C(  74),
                           INT8_C( -28), INT8_C(  37), INT8_C( 113), INT8_C( -95),
                           INT8_C(  28), INT8_C(  57), INT8_C( -25), INT8_C(  99),
                           INT8_C(  10), INT8_C( 126), INT8_C( -39), INT8_C(  71),
                           INT8_C(  42), INT8_C( -81), INT8_C( -68), INT8_C( 111),
                           INT8_C( -94), INT8_C(  58), INT8_C(  41), INT8_C(  41),
                           INT8_C(  10), INT8_C(-105), INT8_C(-126), INT8_C(-109),
                           INT8_C(-112), INT8_C( -69), INT8_C(  26), INT8_C( -60),
                           INT8_C(  40), INT8_C( -74), INT8_C(  51), INT8_C(  95),
                           INT8_C(-102), INT8_C( 114), INT8_C( 108), INT8_C(-102)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(  25), INT8_C( -27), INT8_C(  65),
                           INT8_C(  89), INT8_C(-115), INT8_C(  91), INT8_C(  61),
                           INT8_C(  80), INT8_C( -68), INT8_C(  74), INT8_C( 103),
                           INT8_C( -94), INT8_C( -54), INT8_C( -40), INT8_C(  56),
                           INT8_C( -28), INT8_C(  49), INT8_C(  62), INT8_C( -41),
                           INT8_C( -21), INT8_C(  30), INT8_C( -37), INT8_C( 117),
                           INT8_C( 100), INT8_C(  44), INT8_C(   7), INT8_C( -14),
                           INT8_C( -84), INT8_C(-105), INT8_C(  23), INT8_C(   2),
                           INT8_C(  29), INT8_C( 100), INT8_C(  78), INT8_C( -50),
                           INT8_C( -62), INT8_C(  98), INT8_C(  46), INT8_C( -26),
                           INT8_C(  83), INT8_C(-123), INT8_C(  25), INT8_C( -45),
                           INT8_C(  40), INT8_C( -21), INT8_C(-111), INT8_C(-102),
                           INT8_C( -57), INT8_C(  24), INT8_C(   8), INT8_C( 108),
                           INT8_C(  31), INT8_C( -15), INT8_C(  25), INT8_C( -63),
                           INT8_C( -11), INT8_C(  23), INT8_C( -32), INT8_C( -46),
                           INT8_C(  29), INT8_C( -51), INT8_C( -22), INT8_C(  42)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C( -32), INT8_C(  71), INT8_C(  32),
                           INT8_C( -79), INT8_C( -86), INT8_C(  86), INT8_C(-125),
                           INT8_C(  87), INT8_C(-106), INT8_C( -60), INT8_C(   5),
                           INT8_C(  18), INT8_C( -94), INT8_C(  85), INT8_C(  41),
                           INT8_C(   3), INT8_C(  96), INT8_C(-113), INT8_C( -84),
                           INT8_C(  34), INT8_C(  -5), INT8_C(  33), INT8_C(  38),
                           INT8_C(  -1), INT8_C(  92), INT8_C( 112), INT8_C(  -4),
                           INT8_C(   9), INT8_C(-128), INT8_C(  29), INT8_C(  89),
                           INT8_C(  87), INT8_C(  71), INT8_C(  -8), INT8_C( -86),
                           INT8_C( -43), INT8_C(  23), INT8_C(  12), INT8_C(  33),
                           INT8_C(-122), INT8_C( -43), INT8_C(  30), INT8_C( -94),
                           INT8_C( -32), INT8_C(-126), INT8_C( -56), INT8_C( -32),
                           INT8_C(  -9), INT8_C( 103), INT8_C( 124), INT8_C(-110),
                           INT8_C( -14), INT8_C( 101), INT8_C( 113), INT8_C( -40),
                           INT8_C(  96), INT8_C( -70), INT8_C( -90), INT8_C(  71),
                           INT8_C(  27), INT8_C( -90), INT8_C(  88), INT8_C(  85)) },
    { simde_mm512_set_epi8(INT8_C( -51), INT8_C( -16), INT8_C(  20), INT8_C(  64),
                           INT8_C( -10), INT8_C(   6), INT8_C( -17), INT8_C(  63),
                           INT8_C(  42), INT8_C(  59), INT8_C( -61), INT8_C(  -8),
                           INT8_C( -94), INT8_C(  -9), INT8_C( -35), INT8_C( -25),
                           INT8_C(  77), INT8_C(  23), INT8_C(  81), INT8_C( -11),
                           INT8_C( -38), INT8_C( -20), INT8_C( -57), INT8_C(  96),
                           INT8_C(  -2), INT8_C(  59), INT8_C(  52), INT8_C( -34),
                           INT8_C(-128), INT8_C(  58), INT8_C(  64), INT8_C(  13),
                           INT8_C(   8), INT8_C( 113), INT8_C(  70), INT8_C(  79),
                           INT8_C( -45), INT8_C( 116), INT8_C( -81), INT8_C(  -2),
                           INT8_C( -75), INT8_C( -34), INT8_C( -53), INT8_C( 106),
                           INT8_C(  39), INT8_C( 109), INT8_C(  44), INT8_C( 110),
                           INT8_C( -32), INT8_C(  70), INT8_C( -97), INT8_C( -32),
                           INT8_C(  18), INT8_C(-104), INT8_C(  24), INT8_C( -67),
                           INT8_C(  84), INT8_C( 119), INT8_C(   4), INT8_C(-114),
                           INT8_C( 117), INT8_C( -79), INT8_C( 117), INT8_C( -27)),
      simde_mm512_set_epi8(INT8_C( -58), INT8_C( -25), INT8_C( -39), INT8_C( -81),
                           INT8_C(   1), INT8_C(  -9), INT8_C( -77), INT8_C(-100),
                           INT8_C( -25), INT8_C(-116), INT8_C(  50), INT8_C(  21),
                           INT8_C(   8), INT8_C(  32), INT8_C( -55), INT8_C( -35),
                           INT8_C( 101), INT8_C(   0), INT8_C(   8), INT8_C(  35),
                           INT8_C( -69), INT8_C( -14), INT8_C(   1), INT8_C(  93),
                           INT8_C( 103), INT8_C( -51), INT8_C(  23), INT8_C( -61),
                           INT8_C(-106), INT8_C( -78), INT8_C(  61), INT8_C(-128),
                           INT8_C(   8), INT8_C(  55), INT8_C(  50), INT8_C( -11),
                           INT8_C(  30), INT8_C( -21), INT8_C( -39), INT8_C(  76),
                           INT8_C( -43), INT8_C(   6), INT8_C( 126), INT8_C(  77),
                           INT8_C( -11), INT8_C(-113), INT8_C( -24), INT8_C( -61),
                           INT8_C( -88), INT8_C(-103), INT8_C(  36), INT8_C(  97),
                           INT8_C(  -1), INT8_C( -96), INT8_C(  98), INT8_C(  61),
                           INT8_C( 121), INT8_C(  55), INT8_C(  80), INT8_C(-109),
                           INT8_C( -86), INT8_C(  43), INT8_C(  15), INT8_C(-118)),
      simde_mm512_set_epi8(INT8_C(  30), INT8_C(  57), INT8_C( 118), INT8_C( 120),
                           INT8_C( -10), INT8_C(   4), INT8_C(   1), INT8_C( 112),
                           INT8_C(  83), INT8_C( -85), INT8_C(  10), INT8_C(  44),
                           INT8_C( 103), INT8_C( -55), INT8_C(  93), INT8_C( -23),
                           INT8_C( -57), INT8_C(   0), INT8_C( -66), INT8_C(-115),
                           INT8_C(-106), INT8_C(  48), INT8_C( -57), INT8_C(  -1),
                           INT8_C( -63), INT8_C( -46), INT8_C( -31), INT8_C(  16),
                           INT8_C( 111), INT8_C(  -4), INT8_C( -39), INT8_C( -38),
                           INT8_C(  64), INT8_C( -65), INT8_C(-104), INT8_C(  29),
                           INT8_C(-127), INT8_C(  31), INT8_C(  54), INT8_C(-101),
                           INT8_C(  15), INT8_C( -14), INT8_C(-110), INT8_C(  97),
                           INT8_C( 116), INT8_C(  97), INT8_C(-120), INT8_C( -53),
                           INT8_C(  34), INT8_C(  44), INT8_C(  44), INT8_C( -63),
                           INT8_C(-116), INT8_C( -88), INT8_C(  71), INT8_C(-113),
                           INT8_C(  71), INT8_C(  13), INT8_C(  91), INT8_C( 106),
                           INT8_C( -59), INT8_C( -26), INT8_C( -43), INT8_C( 114)) },
    { simde_mm512_set_epi8(INT8_C( -29), INT8_C( -63), INT8_C(-113), INT8_C(  44),
                           INT8_C( 114), INT8_C(-121), INT8_C(  65), INT8_C(  73),
                           INT8_C(  93), INT8_C( -51), INT8_C(  47), INT8_C( -96),
                           INT8_C(  16), INT8_C(  19), INT8_C(  61), INT8_C( -73),
                           INT8_C( -90), INT8_C(  88), INT8_C( -56), INT8_C(-111),
                           INT8_C( -21), INT8_C(   6), INT8_C(  -9), INT8_C(  59),
                           INT8_C( -52), INT8_C(   6), INT8_C( -14), INT8_C( -21),
                           INT8_C(-113), INT8_C(  52), INT8_C(  -7), INT8_C(  32),
                           INT8_C(  62), INT8_C( -45), INT8_C( -81), INT8_C( -22),
                           INT8_C(  43), INT8_C( -35), INT8_C(  67), INT8_C(  -9),
                           INT8_C(  37), INT8_C(  53), INT8_C(  30), INT8_C(  96),
                           INT8_C(  33), INT8_C(  66), INT8_C(  34), INT8_C(  87),
                           INT8_C(-107), INT8_C( -51), INT8_C(  57), INT8_C( -97),
                           INT8_C( -38), INT8_C(  -2), INT8_C(  93), INT8_C( -61),
                           INT8_C( -43), INT8_C( 116), INT8_C( -51), INT8_C( 106),
                           INT8_C(  79), INT8_C(  58), INT8_C(  49), INT8_C(  69)),
      simde_mm512_set_epi8(INT8_C( -68), INT8_C(  49), INT8_C(  86), INT8_C( -50),
                           INT8_C(-126), INT8_C( -45), INT8_C( -71), INT8_C( -40),
                           INT8_C(  83), INT8_C(  81), INT8_C(  91), INT8_C( -57),
                           INT8_C( -48), INT8_C( -76), INT8_C( -92), INT8_C( 108),
                           INT8_C(-106), INT8_C( -64), INT8_C(-101), INT8_C(  88),
                           INT8_C( 100), INT8_C( -66), INT8_C( -52), INT8_C( -42),
                           INT8_C( 121), INT8_C( -44), INT8_C( -99), INT8_C( 102),
                           INT8_C( -99), INT8_C( -31), INT8_C( -96), INT8_C( 103),
                           INT8_C( 107), INT8_C(  46), INT8_C( -99), INT8_C( -60),
                           INT8_C(  10), INT8_C(  89), INT8_C( 120), INT8_C( -32),
                           INT8_C( 120), INT8_C(  29), INT8_C(  34), INT8_C(  67),
                           INT8_C(  84), INT8_C(   0), INT8_C( -12), INT8_C( -71),
                           INT8_C(-123), INT8_C(  19), INT8_C( -10), INT8_C(  38),
                           INT8_C(-123), INT8_C( 126), INT8_C(  39), INT8_C( -58),
                           INT8_C( -71), INT8_C( -58), INT8_C(  99), INT8_C( -60),
                           INT8_C( -68), INT8_C(  -3), INT8_C(  75), INT8_C(  46)),
      simde_mm512_set_epi8(INT8_C( -46), INT8_C(  54), INT8_C(-121), INT8_C(-105),
                           INT8_C( -63), INT8_C(-101), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -22), INT8_C(  34), INT8_C( -31), INT8_C( -23),
                           INT8_C( -81), INT8_C( 114), INT8_C( -68), INT8_C(  22),
                           INT8_C( 107), INT8_C(   8), INT8_C( -42), INT8_C(  86),
                           INT8_C(  45), INT8_C( -87), INT8_C(-120), INT8_C( -63),
                           INT8_C( -95), INT8_C( -50), INT8_C( -64), INT8_C( -32),
                           INT8_C( -30), INT8_C(   4), INT8_C(  90), INT8_C(  84),
                           INT8_C(  49), INT8_C(  59), INT8_C( -60), INT8_C(   6),
                           INT8_C(  21), INT8_C(  -9), INT8_C( -95), INT8_C(  73),
                           INT8_C(  26), INT8_C(  47), INT8_C( -47), INT8_C( -45),
                           INT8_C(  58), INT8_C(   0), INT8_C(  90), INT8_C( -24),
                           INT8_C(   3), INT8_C(  40), INT8_C(  23), INT8_C(   9),
                           INT8_C( -25), INT8_C(  -9), INT8_C( -35), INT8_C( -42),
                           INT8_C(-124), INT8_C(  47), INT8_C(  15), INT8_C( -25),
                           INT8_C(  90), INT8_C(-109), INT8_C(  52), INT8_C( -29)) },
    { simde_mm512_set_epi8(INT8_C(  41), INT8_C(  68), INT8_C(-104), INT8_C( -96),
                           INT8_C(-111), INT8_C( 125), INT8_C(  11), INT8_C(  -6),
                           INT8_C( -21), INT8_C( -87), INT8_C( -54), INT8_C(  82),
                           INT8_C(-123), INT8_C(-127), INT8_C(  73), INT8_C( -34),
                           INT8_C(  77), INT8_C(  87), INT8_C(-123), INT8_C(-102),
                           INT8_C(-108), INT8_C(  93), INT8_C(  26), INT8_C(  -3),
                           INT8_C(  27), INT8_C(  18), INT8_C(-111), INT8_C( 105),
                           INT8_C(  89), INT8_C(  55), INT8_C(  68), INT8_C( 113),
                           INT8_C(-125), INT8_C(  61), INT8_C(  52), INT8_C(  73),
                           INT8_C(  27), INT8_C( -42), INT8_C( -95), INT8_C(  45),
                           INT8_C(  79), INT8_C( -40), INT8_C(-118), INT8_C(  34),
                           INT8_C(  -1), INT8_C(  75), INT8_C( -51), INT8_C( -19),
                           INT8_C(  57), INT8_C( -23), INT8_C(  12), INT8_C( -71),
                           INT8_C(  97), INT8_C(  34), INT8_C(  -4), INT8_C(  18),
                           INT8_C(   1), INT8_C(  13), INT8_C( -64), INT8_C( -42),
                           INT8_C(-121), INT8_C(  33), INT8_C( -43), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -91), INT8_C( -61), INT8_C( -63),
                           INT8_C( -93), INT8_C(  89), INT8_C( -67), INT8_C(-116),
                           INT8_C( -66), INT8_C( -94), INT8_C(  89), INT8_C( 102),
                           INT8_C(  -4), INT8_C(  48), INT8_C( -83), INT8_C(  66),
                           INT8_C(   9), INT8_C(-126), INT8_C( -25), INT8_C(  16),
                           INT8_C(  73), INT8_C( 103), INT8_C( -81), INT8_C(-128),
                           INT8_C(  15), INT8_C(  22), INT8_C(  55), INT8_C(  80),
                           INT8_C( -81), INT8_C(   0), INT8_C( -38), INT8_C(  82),
                           INT8_C(  95), INT8_C(  92), INT8_C(  76), INT8_C(-103),
                           INT8_C( -34), INT8_C( 124), INT8_C(  35), INT8_C( -89),
                           INT8_C(-117), INT8_C(  39), INT8_C( -86), INT8_C( -79),
                           INT8_C(  27), INT8_C(-117), INT8_C(  39), INT8_C(  98),
                           INT8_C(  43), INT8_C( 114), INT8_C( -27), INT8_C( 105),
                           INT8_C( 115), INT8_C( -73), INT8_C( -36), INT8_C(  88),
                           INT8_C(  24), INT8_C( -46), INT8_C( -79), INT8_C( -20),
                           INT8_C(  37), INT8_C( -42), INT8_C( 109), INT8_C(-108)),
      simde_mm512_set_epi8(INT8_C( -94), INT8_C( 108), INT8_C(-118), INT8_C(   4),
                           INT8_C( -41), INT8_C(  91), INT8_C(  67), INT8_C(-121),
                           INT8_C(-120), INT8_C( 104), INT8_C(-124), INT8_C(  30),
                           INT8_C( -33), INT8_C(  67), INT8_C(  74), INT8_C(-128),
                           INT8_C(  19), INT8_C(-106), INT8_C(-121), INT8_C(  99),
                           INT8_C(  98), INT8_C( 119), INT8_C(  84), INT8_C( 126),
                           INT8_C(-103), INT8_C(  87), INT8_C( -76), INT8_C( -49),
                           INT8_C( -58), INT8_C(   0), INT8_C( 121), INT8_C( -20),
                           INT8_C( -75), INT8_C(  35), INT8_C( -60), INT8_C( 106),
                           INT8_C(-100), INT8_C( -60), INT8_C(  31), INT8_C( 101),
                           INT8_C(  19), INT8_C(  96), INT8_C(  46), INT8_C( -88),
                           INT8_C( -54), INT8_C(   9), INT8_C( -99), INT8_C(  54),
                           INT8_C(  -7), INT8_C( -73), INT8_C( -48), INT8_C(  67),
                           INT8_C(  78), INT8_C( 100), INT8_C( -92), INT8_C(  71),
                           INT8_C(  24), INT8_C( 125), INT8_C( -48), INT8_C(  41),
                           INT8_C( -26), INT8_C(  83), INT8_C( 106), INT8_C(-114)) },
    { simde_mm512_set_epi8(INT8_C( -17), INT8_C( -17), INT8_C( -13), INT8_C(-118),
                           INT8_C(  63), INT8_C( -11), INT8_C( 118), INT8_C(  73),
                           INT8_C(  99), INT8_C(  93), INT8_C(  61), INT8_C( 101),
                           INT8_C( 102), INT8_C(  27), INT8_C(   7), INT8_C(   7),
                           INT8_C(  97), INT8_C( -39), INT8_C( 109), INT8_C(  38),
                           INT8_C(  28), INT8_C(  25), INT8_C(  88), INT8_C( -93),
                           INT8_C( -85), INT8_C( -67), INT8_C( -93), INT8_C( -38),
                           INT8_C( -92), INT8_C(   8), INT8_C(  92), INT8_C( 121),
                           INT8_C( -63), INT8_C( 124), INT8_C( -30), INT8_C(  49),
                           INT8_C(  16), INT8_C( -64), INT8_C( -63), INT8_C(  45),
                           INT8_C(  71), INT8_C(   7), INT8_C(  60), INT8_C(  -4),
                           INT8_C(  35), INT8_C( -33), INT8_C( 103), INT8_C( -39),
                           INT8_C( -52), INT8_C( -76), INT8_C(-111), INT8_C(  -1),
                           INT8_C( -81), INT8_C( -28), INT8_C( -54), INT8_C( -58),
                           INT8_C(  29), INT8_C( -65), INT8_C( -28), INT8_C(   0),
                           INT8_C( -86), INT8_C(  55), INT8_C( 112), INT8_C(  13)),
      simde_mm512_set_epi8(INT8_C(  82), INT8_C(  26), INT8_C(  80), INT8_C( 123),
                           INT8_C(   3), INT8_C( -26), INT8_C( 118), INT8_C( 101),
                           INT8_C(   0), INT8_C(  98), INT8_C(  62), INT8_C(-104),
                           INT8_C( -29), INT8_C(  74), INT8_C( -77), INT8_C(  16),
                           INT8_C( -28), INT8_C( -44), INT8_C( 127), INT8_C( -23),
                           INT8_C(  -3), INT8_C(   0), INT8_C(  50), INT8_C(-100),
                           INT8_C(-126), INT8_C(  48), INT8_C( 112), INT8_C( -71),
                           INT8_C( -63), INT8_C( 121), INT8_C(  13), INT8_C( -19),
                           INT8_C( 121), INT8_C(-109), INT8_C(  50), INT8_C(-104),
                           INT8_C(  42), INT8_C( -21), INT8_C(  94), INT8_C(  63),
                           INT8_C(  17), INT8_C( 110), INT8_C(  23), INT8_C(-117),
                           INT8_C(  45), INT8_C( 101), INT8_C( -36), INT8_C( -70),
                           INT8_C(  46), INT8_C( -39), INT8_C( -42), INT8_C( -56),
                           INT8_C(-104), INT8_C(  22), INT8_C( 125), INT8_C( -45),
                           INT8_C( -28), INT8_C( -26), INT8_C( 115), INT8_C( 116),
                           INT8_C( -70), INT8_C( 120), INT8_C(  67), INT8_C( -37)),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C(-114), INT8_C(  59), INT8_C( -54),
                           INT8_C(  65), INT8_C(-102), INT8_C( -56), INT8_C(  72),
                           INT8_C(   0), INT8_C(  69), INT8_C(  97), INT8_C(  95),
                           INT8_C(  -3), INT8_C( 116), INT8_C(  52), INT8_C( 112),
                           INT8_C(  94), INT8_C( 105), INT8_C( -58), INT8_C( 100),
                           INT8_C(  57), INT8_C(   0), INT8_C( -78), INT8_C( -95),
                           INT8_C(-117), INT8_C( 111), INT8_C(  44), INT8_C(  57),
                           INT8_C(  45), INT8_C( -27), INT8_C( -31), INT8_C(  97),
                           INT8_C( -62), INT8_C(  97), INT8_C(  34), INT8_C(  93),
                           INT8_C(-106), INT8_C(  67), INT8_C( -32), INT8_C(-127),
                           INT8_C(  91), INT8_C(  17), INT8_C(  89), INT8_C(  64),
                           INT8_C( -96), INT8_C(  87), INT8_C(  91), INT8_C(-103),
                           INT8_C(  76), INT8_C( -21), INT8_C(  59), INT8_C(  99),
                           INT8_C( -31), INT8_C( -84), INT8_C( -87), INT8_C(   2),
                           INT8_C(  -6), INT8_C(-103), INT8_C(  79), INT8_C(   0),
                           INT8_C(  -4), INT8_C(  43), INT8_C(-113), INT8_C(  24)) },
    { simde_mm512_set_epi8(INT8_C(  12), INT8_C(  35), INT8_C( -11), INT8_C(  12),
                           INT8_C(  84), INT8_C( 110), INT8_C( -78), INT8_C(  50),
                           INT8_C( 123), INT8_C( -38), INT8_C(-112), INT8_C( -95),
                           INT8_C(  77), INT8_C( 100), INT8_C( -99), INT8_C( -64),
                           INT8_C( -50), INT8_C( 118), INT8_C( 122), INT8_C(   6),
                           INT8_C(  87), INT8_C(  75), INT8_C( 100), INT8_C(-128),
                           INT8_C(  28), INT8_C(  71), INT8_C(  64), INT8_C( 100),
                           INT8_C(-113), INT8_C(  80), INT8_C( -17), INT8_C(  21),
                           INT8_C(  54), INT8_C( -61), INT8_C(-110), INT8_C(  25),
                           INT8_C(  -7), INT8_C( -32), INT8_C(  -1), INT8_C(  38),
                           INT8_C( 126), INT8_C(  80), INT8_C( -50), INT8_C(-119),
                           INT8_C( -41), INT8_C( 126), INT8_C( -56), INT8_C(  43),
                           INT8_C(  -1), INT8_C(  73), INT8_C(  86), INT8_C(  16),
                           INT8_C(  55), INT8_C(-107), INT8_C(  43), INT8_C(  20),
                           INT8_C(  38), INT8_C( 123), INT8_C(  35), INT8_C( -39),
                           INT8_C(  90), INT8_C( -87), INT8_C(  -4), INT8_C( 113)),
      simde_mm512_set_epi8(INT8_C(-127), INT8_C( -25), INT8_C( 112), INT8_C(  97),
                           INT8_C( -63), INT8_C(  24), INT8_C(-111), INT8_C(  37),
                           INT8_C( -32), INT8_C( -41), INT8_C( -92), INT8_C(  72),
                           INT8_C( -61), INT8_C(-126), INT8_C( 127), INT8_C( -11),
                           INT8_C(  62), INT8_C( -28), INT8_C( -67), INT8_C(  70),
                           INT8_C( -14), INT8_C( -57), INT8_C( -40), INT8_C( -89),
                           INT8_C( -18), INT8_C( 113), INT8_C(  12), INT8_C( -64),
                           INT8_C( 115), INT8_C(-102), INT8_C( -42), INT8_C(  40),
                           INT8_C(  47), INT8_C( 110), INT8_C(  50), INT8_C(  34),
                           INT8_C(  49), INT8_C( 108), INT8_C( -93), INT8_C( -73),
                           INT8_C( -86), INT8_C(  37), INT8_C( -57), INT8_C(  32),
                           INT8_C(-107), INT8_C(  51), INT8_C(  73), INT8_C(  69),
                           INT8_C( 101), INT8_C( -91), INT8_C(  39), INT8_C( -46),
                           INT8_C(  30), INT8_C( -85), INT8_C( -17), INT8_C(  56),
                           INT8_C(  77), INT8_C(  36), INT8_C( -26), INT8_C(  37),
                           INT8_C( -74), INT8_C( -56), INT8_C( -54), INT8_C( -42)),
      simde_mm512_set_epi8(INT8_C(  86), INT8_C( -51), INT8_C(  73), INT8_C( -70),
                           INT8_C(  43), INT8_C( -25), INT8_C(-107), INT8_C( -32),
                           INT8_C( -39), INT8_C( 123), INT8_C( -87), INT8_C( -86),
                           INT8_C(-122), INT8_C(  24), INT8_C(   3), INT8_C(  27),
                           INT8_C(  68), INT8_C(  22), INT8_C(   5), INT8_C(-113),
                           INT8_C(-125), INT8_C(  13), INT8_C( -81), INT8_C(-100),
                           INT8_C( -58), INT8_C(  19), INT8_C(  45), INT8_C( -72),
                           INT8_C(  82), INT8_C( -12), INT8_C(  72), INT8_C(  62),
                           INT8_C( -77), INT8_C( -53), INT8_C(   1), INT8_C(  63),
                           INT8_C( -30), INT8_C( -51), INT8_C( -83), INT8_C(-114),
                           INT8_C(   7), INT8_C( -27), INT8_C(-127), INT8_C(-112),
                           INT8_C( -37), INT8_C( 122), INT8_C(   2), INT8_C( -87),
                           INT8_C(  67), INT8_C(  52), INT8_C(-105), INT8_C(-113),
                           INT8_C(  76), INT8_C( -87), INT8_C(  -9), INT8_C(  77),
                           INT8_C( -42), INT8_C(  14), INT8_C( -18), INT8_C( -18),
                           INT8_C(  71), INT8_C(   1), INT8_C( -61), INT8_C(-115)) },
    { simde_mm512_set_epi8(INT8_C( 101), INT8_C(  35), INT8_C(  11), INT8_C(  63),
                           INT8_C(  -2), INT8_C(  92), INT8_C(  46), INT8_C( -43),
                           INT8_C( -37), INT8_C( -24), INT8_C(-107), INT8_C(  71),
                           INT8_C(  69), INT8_C(  90), INT8_C( 122), INT8_C( -45),
                           INT8_C( -15), INT8_C(  79), INT8_C( -81), INT8_C( -64),
                           INT8_C( 120), INT8_C( -97), INT8_C( 103), INT8_C(   6),
                           INT8_C( -33), INT8_C(   3), INT8_C(  25), INT8_C( -43),
                           INT8_C( -10), INT8_C(-118), INT8_C( -19), INT8_C(  -1),
                           INT8_C(  90), INT8_C(  80), INT8_C( -78), INT8_C( -35),
                           INT8_C(-116), INT8_C( -61), INT8_C( -53), INT8_C(  15),
                           INT8_C(  16), INT8_C( -21), INT8_C(  25), INT8_C( -84),
                           INT8_C(  73), INT8_C(  33), INT8_C(-115), INT8_C(  46),
                           INT8_C( -54), INT8_C( -80), INT8_C(-111), INT8_C( -99),
                           INT8_C( -32), INT8_C(  18), INT8_C(  19), INT8_C(  32),
                           INT8_C( -40), INT8_C( -86), INT8_C(  56), INT8_C(  38),
                           INT8_C(-101), INT8_C(  28), INT8_C( -24), INT8_C( -51)),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(  -7), INT8_C(-121), INT8_C( -36),
                           INT8_C( -76), INT8_C( 123), INT8_C(-107), INT8_C( -57),
                           INT8_C(  81), INT8_C( -39), INT8_C(-114), INT8_C(  36),
                           INT8_C( -55), INT8_C(   6), INT8_C( -15), INT8_C( 116),
                           INT8_C(  18), INT8_C(  61), INT8_C(  63), INT8_C(  89),
                           INT8_C(-120), INT8_C(  76), INT8_C(  -4), INT8_C( -22),
                           INT8_C( -49), INT8_C(  -2), INT8_C(  62), INT8_C(-126),
                           INT8_C(  34), INT8_C( -29), INT8_C(  86), INT8_C( -25),
                           INT8_C(  22), INT8_C(  83), INT8_C( 105), INT8_C( -57),
                           INT8_C( -20), INT8_C(  78), INT8_C(  88), INT8_C(  17),
                           INT8_C(  75), INT8_C(-105), INT8_C(  98), INT8_C(  98),
                           INT8_C( -70), INT8_C( -99), INT8_C(  -8), INT8_C(   6),
                           INT8_C( -22), INT8_C(  12), INT8_C( 105), INT8_C(  79),
                           INT8_C(  94), INT8_C( -23), INT8_C( 126), INT8_C( -81),
                           INT8_C( -52), INT8_C( 127), INT8_C(-121), INT8_C( 105),
                           INT8_C(  22), INT8_C(  82), INT8_C( -12), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C(  -7), INT8_C(   2), INT8_C( -58), INT8_C(  41),
                           INT8_C( -69), INT8_C(  26), INT8_C( -86), INT8_C( 117),
                           INT8_C( -72), INT8_C( -13), INT8_C(  99), INT8_C(  63),
                           INT8_C(  80), INT8_C( -57), INT8_C( -94), INT8_C(-111),
                           INT8_C( 112), INT8_C(-103), INT8_C(  77), INT8_C( -56),
                           INT8_C( -65), INT8_C(  18), INT8_C(  15), INT8_C(  74),
                           INT8_C(  32), INT8_C(  25), INT8_C(  24), INT8_C(   8),
                           INT8_C(  30), INT8_C(  99), INT8_C(  89), INT8_C( -61),
                           INT8_C(  16), INT8_C(  64), INT8_C( -99), INT8_C(  23),
                           INT8_C(-102), INT8_C( -40), INT8_C(  22), INT8_C(  -1),
                           INT8_C( -36), INT8_C(  30), INT8_C(  37), INT8_C( -89),
                           INT8_C(  82), INT8_C( -69), INT8_C( 124), INT8_C( -28),
                           INT8_C(  93), INT8_C(   1), INT8_C( -87), INT8_C(  54),
                           INT8_C(-117), INT8_C( -37), INT8_C(  35), INT8_C(  60),
                           INT8_C(   8), INT8_C( -83), INT8_C( -73), INT8_C( -30),
                           INT8_C(   4), INT8_C( -94), INT8_C(-109), INT8_C(  -6)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_gf2p8mul_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

#if !(defined(__clang__) && defined(__arm__) && defined(__ARM_EABI__) && !defined(__ARM_PCS_VFP))

static int
test_simde_mm_mask_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i src;
    simde__mmask16 k;
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -78), INT8_C(-104), INT8_C( -68), INT8_C( -85),
                        INT8_C( -44), INT8_C( -82), INT8_C(-123), INT8_C( -25),
                        INT8_C(  17), INT8_C( -39), INT8_C(-122), INT8_C(  -7),
                        INT8_C( -27), INT8_C(-102), INT8_C( -45), INT8_C( -70)),
      UINT16_C(13630),
      simde_mm_set_epi8(INT8_C( -57), INT8_C(  80), INT8_C(   4), INT8_C(  91),
                        INT8_C(   8), INT8_C(   3), INT8_C(  85), INT8_C(  32),
                        INT8_C(   3), INT8_C(-125), INT8_C( -81), INT8_C(  47),
                        INT8_C(-124), INT8_C( -92), INT8_C(  -4), INT8_C( -78)),
      simde_mm_set_epi8(INT8_C( -92), INT8_C( -33), INT8_C(  92), INT8_C(   1),
                        INT8_C(  -2), INT8_C( -90), INT8_C( -22), INT8_C( -96),
                        INT8_C(-104), INT8_C( -34), INT8_C(-102), INT8_C( 121),
                        INT8_C( -13), INT8_C( 124), INT8_C( 118), INT8_C( -38)),
      simde_mm_set_epi8(INT8_C( -78), INT8_C(-104), INT8_C( 107), INT8_C(  91),
                        INT8_C( -44), INT8_C( -15), INT8_C(-123), INT8_C( -57),
                        INT8_C(  17), INT8_C( -39), INT8_C( -92), INT8_C(  40),
                        INT8_C( -34), INT8_C(-106), INT8_C( -86), INT8_C( -70)) },
    { simde_mm_set_epi8(INT8_C(   8), INT8_C(  16), INT8_C(-112), INT8_C(  88),
                        INT8_C(-114), INT8_C( 116), INT8_C( -93), INT8_C(-113),
                        INT8_C( 103), INT8_C(   3), INT8_C( 104), INT8_C(  32),
                        INT8_C(  61), INT8_C( 121), INT8_C(-120), INT8_C(  66)),
      UINT16_C(12254),
      simde_mm_set_epi8(INT8_C(   8), INT8_C(  41), INT8_C(  -4), INT8_C(  11),
                        INT8_C( 102), INT8_C( -75), INT8_C( 105), INT8_C( 124),
                        INT8_C( -63), INT8_C( -72), INT8_C( -35), INT8_C( -84),
                        INT8_C( -54), INT8_C( 124), INT8_C( -28), INT8_C( -52)),
      simde_mm_set_epi8(INT8_C(-119), INT8_C(  -4), INT8_C( -96), INT8_C( 111),
                        INT8_C(-105), INT8_C( -93), INT8_C( -51), INT8_C(  60),
                        INT8_C(  97), INT8_C( -89), INT8_C(  84), INT8_C( -74),
                        INT8_C(  11), INT8_C(  54), INT8_C( -91), INT8_C(  93)),
      simde_mm_set_epi8(INT8_C(   8), INT8_C(  16), INT8_C(  76), INT8_C(  88),
                        INT8_C( -40), INT8_C( -54), INT8_C( -68), INT8_C( -66),
                        INT8_C(  52), INT8_C( 106), INT8_C( 104), INT8_C( -36),
                        INT8_C(  79), INT8_C(-117), INT8_C(-116), INT8_C(  66)) },
    { simde_mm_set_epi8(INT8_C( -84), INT8_C(  19), INT8_C(-119), INT8_C( -46),
                        INT8_C( -34), INT8_C(-109), INT8_C( -78), INT8_C(-106),
                        INT8_C(-116), INT8_C(  40), INT8_C( 112), INT8_C(  53),
                        INT8_C(  44), INT8_C(  10), INT8_C( 106), INT8_C(  86)),
      UINT16_C(13667),
      simde_mm_set_epi8(INT8_C( -54), INT8_C( -74), INT8_C(  70), INT8_C( -82),
                        INT8_C( -26), INT8_C(  44), INT8_C(  12), INT8_C( 103),
                        INT8_C(  15), INT8_C(  32), INT8_C(   3), INT8_C( -77),
                        INT8_C( -94), INT8_C(  22), INT8_C( -50), INT8_C( -43)),
      simde_mm_set_epi8(INT8_C(  -3), INT8_C( -12), INT8_C( 125), INT8_C(  88),
                        INT8_C( -82), INT8_C(  40), INT8_C(  88), INT8_C(  17),
                        INT8_C( 125), INT8_C(-128), INT8_C( -99), INT8_C(-101),
                        INT8_C(  -3), INT8_C(  16), INT8_C(   9), INT8_C( 121)),
      simde_mm_set_epi8(INT8_C( -84), INT8_C(  19), INT8_C( 103), INT8_C(  49),
                        INT8_C( -34), INT8_C(-116), INT8_C( -78), INT8_C(  77),
                        INT8_C(-116), INT8_C( -85), INT8_C( -68), INT8_C(  53),
                        INT8_C(  44), INT8_C(  10), INT8_C( -28), INT8_C( -20)) },
    { simde_mm_set_epi8(INT8_C( 121), INT8_C( -75), INT8_C( -88), INT8_C(   9),
                        INT8_C(  92), INT8_C(-103), INT8_C( 113), INT8_C( 103),
                        INT8_C(  78), INT8_C( 118), INT8_C(-117), INT8_C(  32),
                        INT8_C(-109), INT8_C( 124), INT8_C(-123), INT8_C( -55)),
      UINT16_C(50954),
      simde_mm_set_epi8(INT8_C(  23), INT8_C( -20), INT8_C( 101), INT8_C(  49),
                        INT8_C(  -3), INT8_C(  66), INT8_C(-123), INT8_C( 122),
                        INT8_C(-127), INT8_C(  22), INT8_C( 125), INT8_C( -47),
                        INT8_C(  61), INT8_C(  11), INT8_C( 117), INT8_C(  23)),
      simde_mm_set_epi8(INT8_C(  30), INT8_C(  65), INT8_C(  84), INT8_C(  81),
                        INT8_C(-101), INT8_C( -97), INT8_C(  50), INT8_C( -25),
                        INT8_C(  95), INT8_C( 103), INT8_C( -13), INT8_C( -85),
                        INT8_C(  77), INT8_C(   3), INT8_C(  29), INT8_C(-110)),
      simde_mm_set_epi8(INT8_C( -95), INT8_C(  -1), INT8_C( -88), INT8_C(   9),
                        INT8_C(  92), INT8_C( -23), INT8_C(-110), INT8_C(  68),
                        INT8_C(  78), INT8_C( 118), INT8_C(-117), INT8_C(  32),
                        INT8_C( -29), INT8_C( 124), INT8_C(  46), INT8_C( -55)) },
    { simde_mm_set_epi8(INT8_C(  46), INT8_C(  44), INT8_C( 122), INT8_C(  80),
                        INT8_C( -75), INT8_C(  74), INT8_C( 120), INT8_C(  80),
                        INT8_C( -90), INT8_C(  48), INT8_C( -67), INT8_C(  -1),
                        INT8_C(  46), INT8_C( -13), INT8_C( 100), INT8_C(-128)),
      UINT16_C(60019),
      simde_mm_set_epi8(INT8_C(  67), INT8_C(  62), INT8_C(  20), INT8_C(  19),
                        INT8_C(  63), INT8_C( -95), INT8_C(-114), INT8_C( -93),
                        INT8_C( -46), INT8_C(-104), INT8_C(  -3), INT8_C( -91),
                        INT8_C( -90), INT8_C( -96), INT8_C( -86), INT8_C(  65)),
      simde_mm_set_epi8(INT8_C( 118), INT8_C( 124), INT8_C(  95), INT8_C( -87),
                        INT8_C(  46), INT8_C(-105), INT8_C(  28), INT8_C( -77),
                        INT8_C(  35), INT8_C( -75), INT8_C( -22), INT8_C( -22),
                        INT8_C( -29), INT8_C( -57), INT8_C( -40), INT8_C(-108)),
      simde_mm_set_epi8(INT8_C(  30), INT8_C(  70), INT8_C( -32), INT8_C(  80),
                        INT8_C( -64), INT8_C(  74), INT8_C(  42), INT8_C(  80),
                        INT8_C( -90), INT8_C(  37), INT8_C(-101), INT8_C(  32),
                        INT8_C(  46), INT8_C( -13), INT8_C(  12), INT8_C( -82)) },
    { simde_mm_set_epi8(INT8_C(  73), INT8_C( -62), INT8_C(  -6), INT8_C(  28),
                        INT8_C( 122), INT8_C(  63), INT8_C(  33), INT8_C(  56),
                        INT8_C( 124), INT8_C(-123), INT8_C(  40), INT8_C( -58),
                        INT8_C( -75), INT8_C(-124), INT8_C(  56), INT8_C(  47)),
      UINT16_C(59040),
      simde_mm_set_epi8(INT8_C( -94), INT8_C( -16), INT8_C(  58), INT8_C( 115),
                        INT8_C(  58), INT8_C(  92), INT8_C(-119), INT8_C(  20),
                        INT8_C( -50), INT8_C( -33), INT8_C(  46), INT8_C( 102),
                        INT8_C(  14), INT8_C(  87), INT8_C( -93), INT8_C(  26)),
      simde_mm_set_epi8(INT8_C(-108), INT8_C( -77), INT8_C( 121), INT8_C( 106),
                        INT8_C(  57), INT8_C( -95), INT8_C(-114), INT8_C(  50),
                        INT8_C(  28), INT8_C( -67), INT8_C( -23), INT8_C(  89),
                        INT8_C( -64), INT8_C( -49), INT8_C(  76), INT8_C( -55)),
      simde_mm_set_epi8(INT8_C(  90), INT8_C(  31), INT8_C( 127), INT8_C(  28),
                        INT8_C( 122), INT8_C( -26), INT8_C(  73), INT8_C(  56),
                        INT8_C( 107), INT8_C(-123), INT8_C( 109), INT8_C( -58),
                        INT8_C( -75), INT8_C(-124), INT8_C(  56), INT8_C(  47)) },
    { simde_mm_set_epi8(INT8_C( 105), INT8_C(  65), INT8_C( 100), INT8_C( 127),
                        INT8_C( -79), INT8_C(  71), INT8_C(-127), INT8_C(  57),
                        INT8_C(-124), INT8_C(  74), INT8_C( -70), INT8_C(  66),
                        INT8_C( 110), INT8_C(  68), INT8_C(-127), INT8_C(  15)),
      UINT16_C(28581),
      simde_mm_set_epi8(INT8_C( 115), INT8_C(  16), INT8_C( -82), INT8_C(  55),
                        INT8_C( -37), INT8_C( 123), INT8_C( -34), INT8_C( 120),
                        INT8_C( -28), INT8_C( -74), INT8_C(  93), INT8_C( -65),
                        INT8_C(  18), INT8_C(-107), INT8_C(-126), INT8_C( -54)),
      simde_mm_set_epi8(INT8_C( -50), INT8_C( -60), INT8_C( -91), INT8_C(  71),
                        INT8_C(  57), INT8_C(   2), INT8_C(-112), INT8_C(   2),
                        INT8_C( -12), INT8_C(  47), INT8_C( -10), INT8_C( -44),
                        INT8_C(  70), INT8_C( 121), INT8_C( -16), INT8_C(  28)),
      simde_mm_set_epi8(INT8_C( 105), INT8_C( -12), INT8_C(  76), INT8_C( 127),
                        INT8_C( 120), INT8_C( -10), INT8_C(   1), INT8_C( -16),
                        INT8_C(-113), INT8_C(  74), INT8_C( -62), INT8_C(  66),
                        INT8_C( 110), INT8_C(-123), INT8_C(-127), INT8_C(  27)) },
    { simde_mm_set_epi8(INT8_C( -16), INT8_C(  27), INT8_C(  91), INT8_C( -68),
                        INT8_C( -69), INT8_C( -47), INT8_C(  -9), INT8_C( -68),
                        INT8_C( -93), INT8_C(  57), INT8_C( -55), INT8_C( -75),
                        INT8_C(  14), INT8_C( -42), INT8_C(  18), INT8_C(  98)),
      UINT16_C(11737),
      simde_mm_set_epi8(INT8_C(  67), INT8_C(  65), INT8_C(  46), INT8_C(  78),
                        INT8_C(   7), INT8_C( -97), INT8_C(-111), INT8_C( -83),
                        INT8_C( 116), INT8_C(  51), INT8_C( -98), INT8_C(  85),
                        INT8_C( -36), INT8_C( 121), INT8_C(  86), INT8_C(  14)),
      simde_mm_set_epi8(INT8_C( -29), INT8_C(  35), INT8_C(  25), INT8_C( -17),
                        INT8_C( -88), INT8_C(  94), INT8_C(  10), INT8_C(  30),
                        INT8_C( -99), INT8_C( -94), INT8_C(   3), INT8_C(   6),
                        INT8_C(  13), INT8_C(-105), INT8_C( -54), INT8_C(  42)),
      simde_mm_set_epi8(INT8_C( -16), INT8_C(  27), INT8_C(-109), INT8_C( -68),
                        INT8_C( 117), INT8_C(   4), INT8_C(  -9), INT8_C( -30),
                        INT8_C(  59), INT8_C( -76), INT8_C( -55), INT8_C( -27),
                        INT8_C(  59), INT8_C( -42), INT8_C(  18), INT8_C( -73)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_mask_gf2p8mul_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_mask_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m256i src;
    simde__mmask32 k;
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( -91), INT8_C(  -2), INT8_C( -76), INT8_C(  64),
                           INT8_C( -37), INT8_C(  76), INT8_C( -74), INT8_C(  84),
                           INT8_C(  46), INT8_C(-109), INT8_C( -48), INT8_C( -25),
                           INT8_C( -53), INT8_C(   4), INT8_C(  47), INT8_C( -25),
                           INT8_C( 127), INT8_C(  44), INT8_C(-128), INT8_C(  -9),
                           INT8_C(   2), INT8_C( -74), INT8_C( 109), INT8_C( -46),
                           INT8_C(  68), INT8_C( -38), INT8_C(  39), INT8_C( -69),
                           INT8_C( -24), INT8_C( -82), INT8_C(  77), INT8_C(  53)),
      UINT32_C( 192195297),
      simde_mm256_set_epi8(INT8_C(  25), INT8_C( 115), INT8_C( -10), INT8_C(-115),
                           INT8_C(  42), INT8_C(  35), INT8_C(  71), INT8_C( 118),
                           INT8_C(   2), INT8_C(   3), INT8_C( -13), INT8_C(  18),
                           INT8_C( -70), INT8_C(  47), INT8_C( -37), INT8_C( -23),
                           INT8_C( -75), INT8_C(  90), INT8_C( -46), INT8_C( -66),
                           INT8_C(  88), INT8_C( 127), INT8_C(   1), INT8_C(  80),
                           INT8_C(-110), INT8_C(-125), INT8_C( -55), INT8_C( 121),
                           INT8_C(  27), INT8_C(  18), INT8_C( -47), INT8_C( -14)),
      simde_mm256_set_epi8(INT8_C(  44), INT8_C( -43), INT8_C(  19), INT8_C(-117),
                           INT8_C(  72), INT8_C(-122), INT8_C(  32), INT8_C(  -8),
                           INT8_C(  49), INT8_C( 100), INT8_C(-117), INT8_C( -73),
                           INT8_C(  86), INT8_C(-117), INT8_C(  93), INT8_C( -15),
                           INT8_C(  32), INT8_C(  41), INT8_C(  52), INT8_C( 102),
                           INT8_C(-116), INT8_C(  95), INT8_C(-110), INT8_C(-100),
                           INT8_C( -46), INT8_C( -18), INT8_C(  18), INT8_C(  29),
                           INT8_C(  59), INT8_C(  -3), INT8_C(-126), INT8_C(-100)),
      simde_mm256_set_epi8(INT8_C( -91), INT8_C(  -2), INT8_C( -76), INT8_C(  64),
                           INT8_C(  37), INT8_C(  76), INT8_C(  56), INT8_C( 105),
                           INT8_C(  46), INT8_C( -84), INT8_C( -24), INT8_C( -16),
                           INT8_C( -53), INT8_C( 120), INT8_C(  47), INT8_C( -25),
                           INT8_C(  81), INT8_C(  44), INT8_C( -17), INT8_C(  -9),
                           INT8_C( 116), INT8_C( -74), INT8_C(-110), INT8_C( -46),
                           INT8_C(  36), INT8_C(  20), INT8_C( -83), INT8_C( -69),
                           INT8_C( -24), INT8_C( -82), INT8_C(  77), INT8_C(  50)) },
    { simde_mm256_set_epi8(INT8_C( -98), INT8_C( -77), INT8_C(-113), INT8_C(  36),
                           INT8_C( -15), INT8_C(  69), INT8_C(  25), INT8_C(  84),
                           INT8_C( -26), INT8_C(  60), INT8_C(-123), INT8_C( -24),
                           INT8_C( 102), INT8_C( -21), INT8_C( -59), INT8_C( -55),
                           INT8_C(  60), INT8_C( -75), INT8_C(  43), INT8_C( 127),
                           INT8_C( -69), INT8_C(   6), INT8_C( -47), INT8_C(  20),
                           INT8_C( -17), INT8_C( 115), INT8_C( -76), INT8_C(  83),
                           INT8_C(  65), INT8_C(  21), INT8_C( -52), INT8_C( 111)),
      UINT32_C(4285006847),
      simde_mm256_set_epi8(INT8_C( -30), INT8_C( 116), INT8_C( -42), INT8_C( -27),
                           INT8_C(  76), INT8_C(  18), INT8_C(   4), INT8_C( 119),
                           INT8_C(  -3), INT8_C(  32), INT8_C( -48), INT8_C( -28),
                           INT8_C( -49), INT8_C( -35), INT8_C( -48), INT8_C(  36),
                           INT8_C(  73), INT8_C( -87), INT8_C(  24), INT8_C(  25),
                           INT8_C( -95), INT8_C(  -9), INT8_C( 114), INT8_C(  29),
                           INT8_C( -98), INT8_C( -68), INT8_C( -90), INT8_C( -92),
                           INT8_C(  36), INT8_C(   3), INT8_C( -12), INT8_C(  68)),
      simde_mm256_set_epi8(INT8_C(  73), INT8_C(  22), INT8_C( -48), INT8_C(-104),
                           INT8_C(  37), INT8_C( 121), INT8_C(  59), INT8_C( -39),
                           INT8_C(  75), INT8_C( -53), INT8_C(  54), INT8_C(  71),
                           INT8_C(  86), INT8_C(  79), INT8_C(-116), INT8_C(-116),
                           INT8_C(  82), INT8_C(  60), INT8_C( -13), INT8_C(  91),
                           INT8_C(  29), INT8_C( -30), INT8_C( -14), INT8_C(  53),
                           INT8_C(  60), INT8_C( -17), INT8_C(  18), INT8_C( 121),
                           INT8_C( 109), INT8_C( -61), INT8_C( -32), INT8_C( -37)),
      simde_mm256_set_epi8(INT8_C(  13), INT8_C(  34), INT8_C(  -4), INT8_C( 113),
                           INT8_C(  36), INT8_C(  35), INT8_C( -20), INT8_C(-124),
                           INT8_C( -26), INT8_C(   8), INT8_C(  60), INT8_C( -24),
                           INT8_C( -37), INT8_C( -21), INT8_C( -59), INT8_C( -55),
                           INT8_C(  60), INT8_C( -75), INT8_C(  43), INT8_C( 127),
                           INT8_C( -69), INT8_C(   6), INT8_C(  -3), INT8_C(  47),
                           INT8_C( -73), INT8_C(-125), INT8_C( -39), INT8_C(-108),
                           INT8_C( -96), INT8_C(  94), INT8_C( 114), INT8_C(  61)) },
    { simde_mm256_set_epi8(INT8_C( -22), INT8_C( -97), INT8_C( -20), INT8_C( -42),
                           INT8_C( 103), INT8_C( -36), INT8_C(  60), INT8_C(  86),
                           INT8_C(  45), INT8_C(  81), INT8_C(-106), INT8_C( -30),
                           INT8_C(-122), INT8_C( -41), INT8_C( -20), INT8_C(   2),
                           INT8_C( -90), INT8_C( -62), INT8_C(  50), INT8_C( 118),
                           INT8_C( -23), INT8_C(-115), INT8_C( -58), INT8_C(  17),
                           INT8_C(  34), INT8_C( -55), INT8_C(  56), INT8_C(-123),
                           INT8_C( -62), INT8_C( -51), INT8_C( -75), INT8_C( -84)),
      UINT32_C( 326632141),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(-103), INT8_C(  74), INT8_C(  71),
                           INT8_C( 102), INT8_C(  79), INT8_C( -88), INT8_C( -21),
                           INT8_C( -55), INT8_C( -47), INT8_C(  60), INT8_C(-128),
                           INT8_C( -92), INT8_C(   4), INT8_C(-127), INT8_C(  39),
                           INT8_C(  48), INT8_C( -18), INT8_C( -62), INT8_C( -30),
                           INT8_C( -55), INT8_C(  85), INT8_C( -74), INT8_C( -71),
                           INT8_C(  33), INT8_C( -48), INT8_C( -45), INT8_C(  13),
                           INT8_C(  65), INT8_C( -14), INT8_C(  34), INT8_C( -49)),
      simde_mm256_set_epi8(INT8_C(  59), INT8_C( 113), INT8_C(  22), INT8_C(-109),
                           INT8_C(  95), INT8_C(  41), INT8_C( -94), INT8_C( 123),
                           INT8_C(  74), INT8_C( -82), INT8_C(  77), INT8_C( -25),
                           INT8_C(  83), INT8_C( -15), INT8_C(  28), INT8_C( -50),
                           INT8_C(-128), INT8_C( -11), INT8_C(  57), INT8_C(  -2),
                           INT8_C(-108), INT8_C( 106), INT8_C(  35), INT8_C(   1),
                           INT8_C(   5), INT8_C(  -6), INT8_C(-104), INT8_C( -92),
                           INT8_C( -39), INT8_C( 110), INT8_C( -82), INT8_C(-103)),
      simde_mm256_set_epi8(INT8_C( -22), INT8_C( -97), INT8_C( -20), INT8_C(  53),
                           INT8_C( 103), INT8_C( -36), INT8_C( -54), INT8_C( -95),
                           INT8_C(  45), INT8_C( -24), INT8_C( -82), INT8_C( -47),
                           INT8_C( -41), INT8_C( -41), INT8_C( -20), INT8_C(   2),
                           INT8_C( -90), INT8_C( -62), INT8_C(  50), INT8_C( 118),
                           INT8_C( -23), INT8_C(-115), INT8_C( -16), INT8_C(  17),
                           INT8_C( -91), INT8_C(  14), INT8_C(  56), INT8_C(-123),
                           INT8_C(  37), INT8_C( 112), INT8_C( -75), INT8_C( -65)) },
    { simde_mm256_set_epi8(INT8_C( -69), INT8_C(  -5), INT8_C(  96), INT8_C( -19),
                           INT8_C( -24), INT8_C(  46), INT8_C(-107), INT8_C( -57),
                           INT8_C(  92), INT8_C( -53), INT8_C( -87), INT8_C( 121),
                           INT8_C(-124), INT8_C(  40), INT8_C(  24), INT8_C(-107),
                           INT8_C(-103), INT8_C(  -6), INT8_C( -77), INT8_C( -88),
                           INT8_C(  21), INT8_C(  39), INT8_C( 120), INT8_C( -43),
                           INT8_C(-111), INT8_C(-107), INT8_C(  26), INT8_C(  43),
                           INT8_C( 101), INT8_C(  24), INT8_C( -62), INT8_C( -16)),
      UINT32_C(4165065595),
      simde_mm256_set_epi8(INT8_C( -81), INT8_C(  75), INT8_C( 109), INT8_C( -86),
                           INT8_C(-107), INT8_C(   7), INT8_C( -83), INT8_C( 113),
                           INT8_C(-128), INT8_C( -49), INT8_C( -84), INT8_C( 113),
                           INT8_C( -36), INT8_C(  21), INT8_C(  99), INT8_C( 100),
                           INT8_C(  66), INT8_C( 114), INT8_C(-105), INT8_C( -62),
                           INT8_C( -37), INT8_C(  48), INT8_C(  65), INT8_C(-118),
                           INT8_C( -84), INT8_C(  37), INT8_C( -40), INT8_C(  48),
                           INT8_C( -82), INT8_C( 127), INT8_C(  21), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C(  76), INT8_C( -66), INT8_C(-100), INT8_C( -14),
                           INT8_C( -13), INT8_C( -55), INT8_C(  35), INT8_C( -56),
                           INT8_C(  29), INT8_C(  22), INT8_C(  29), INT8_C(  96),
                           INT8_C(-115), INT8_C( -69), INT8_C( -39), INT8_C( -34),
                           INT8_C(-111), INT8_C( -78), INT8_C( 105), INT8_C(  29),
                           INT8_C(  63), INT8_C( -14), INT8_C(  47), INT8_C( -81),
                           INT8_C( -23), INT8_C(  40), INT8_C( 110), INT8_C(  29),
                           INT8_C( -69), INT8_C(  86), INT8_C(  67), INT8_C( 123)),
      simde_mm256_set_epi8(INT8_C(  -3), INT8_C(  10), INT8_C(  92), INT8_C(  -8),
                           INT8_C(-124), INT8_C(  46), INT8_C(-107), INT8_C( -57),
                           INT8_C(  92), INT8_C( -48), INT8_C( -87), INT8_C( 121),
                           INT8_C(-124), INT8_C(  40), INT8_C(  24), INT8_C( -20),
                           INT8_C(  88), INT8_C(  98), INT8_C( -77), INT8_C(  57),
                           INT8_C(-108), INT8_C(  39), INT8_C(  26), INT8_C( -70),
                           INT8_C(-111), INT8_C(  -1), INT8_C( -98), INT8_C(  70),
                           INT8_C(-116), INT8_C(  24), INT8_C(   8), INT8_C( -88)) },
    { simde_mm256_set_epi8(INT8_C(-114), INT8_C( -40), INT8_C( -54), INT8_C( -97),
                           INT8_C( -71), INT8_C( 124), INT8_C(  89), INT8_C( -34),
                           INT8_C(  70), INT8_C( -84), INT8_C(  86), INT8_C(-125),
                           INT8_C(  53), INT8_C(  93), INT8_C( -15), INT8_C( -38),
                           INT8_C( -17), INT8_C( -84), INT8_C( -87), INT8_C( -41),
                           INT8_C(   4), INT8_C(   6), INT8_C( -55), INT8_C(  16),
                           INT8_C(  79), INT8_C(  94), INT8_C( -49), INT8_C(   7),
                           INT8_C(  36), INT8_C(  55), INT8_C(   3), INT8_C(  -4)),
      UINT32_C( 494773061),
      simde_mm256_set_epi8(INT8_C( -26), INT8_C(  33), INT8_C( -10), INT8_C(-107),
                           INT8_C( -30), INT8_C(  42), INT8_C( 123), INT8_C( -24),
                           INT8_C( -15), INT8_C( 125), INT8_C(  24), INT8_C(  60),
                           INT8_C( 111), INT8_C( -28), INT8_C( -11), INT8_C( -35),
                           INT8_C( -64), INT8_C(  64), INT8_C(  89), INT8_C(  -4),
                           INT8_C(-116), INT8_C(  18), INT8_C(  31), INT8_C(  82),
                           INT8_C( -22), INT8_C(  38), INT8_C(  77), INT8_C(-108),
                           INT8_C( -27), INT8_C( -92), INT8_C(  86), INT8_C(-118)),
      simde_mm256_set_epi8(INT8_C(  -6), INT8_C(-119), INT8_C(  65), INT8_C( -71),
                           INT8_C(  49), INT8_C( -54), INT8_C(   9), INT8_C(  31),
                           INT8_C(  64), INT8_C(  27), INT8_C(-127), INT8_C(  -4),
                           INT8_C( -16), INT8_C( -20), INT8_C(  22), INT8_C( -73),
                           INT8_C( 107), INT8_C( -27), INT8_C(  46), INT8_C(-114),
                           INT8_C( -84), INT8_C( -92), INT8_C(  17), INT8_C( -19),
                           INT8_C(  85), INT8_C(  89), INT8_C( -54), INT8_C( -15),
                           INT8_C( -27), INT8_C(-123), INT8_C( -97), INT8_C(  55)),
      simde_mm256_set_epi8(INT8_C(-114), INT8_C( -40), INT8_C( -54), INT8_C(  11),
                           INT8_C(  31), INT8_C( -83), INT8_C(  89), INT8_C( -83),
                           INT8_C(  70), INT8_C( -45), INT8_C( -84), INT8_C(-105),
                           INT8_C(  92), INT8_C(  44), INT8_C( -15), INT8_C( 113),
                           INT8_C(-108), INT8_C( -84), INT8_C( -26), INT8_C( -41),
                           INT8_C(   4), INT8_C(   6), INT8_C( -12), INT8_C( -64),
                           INT8_C(  79), INT8_C(  24), INT8_C( -49), INT8_C(   7),
                           INT8_C(  36), INT8_C(   5), INT8_C(   3), INT8_C(  19)) },
    { simde_mm256_set_epi8(INT8_C( 106), INT8_C(  11), INT8_C(  13), INT8_C(  35),
                           INT8_C(  50), INT8_C(  77), INT8_C( -99), INT8_C( 106),
                           INT8_C(  71), INT8_C( -97), INT8_C(  97), INT8_C( 115),
                           INT8_C( 125), INT8_C( -47), INT8_C( -39), INT8_C( -88),
                           INT8_C( 107), INT8_C(   0), INT8_C(  12), INT8_C(   1),
                           INT8_C( -45), INT8_C( -47), INT8_C( 108), INT8_C(   7),
                           INT8_C( -30), INT8_C(  56), INT8_C( -69), INT8_C( 109),
                           INT8_C(  62), INT8_C( 124), INT8_C(-119), INT8_C(  13)),
      UINT32_C( 992532866),
      simde_mm256_set_epi8(INT8_C(  33), INT8_C(  26), INT8_C(  71), INT8_C(  -5),
                           INT8_C(-126), INT8_C(-109), INT8_C( 104), INT8_C(  16),
                           INT8_C(  76), INT8_C( -14), INT8_C( -26), INT8_C( -63),
                           INT8_C( 100), INT8_C(  82), INT8_C(   9), INT8_C(  30),
                           INT8_C(-118), INT8_C(  84), INT8_C( -83), INT8_C(  95),
                           INT8_C(  80), INT8_C( -48), INT8_C(-127), INT8_C( -15),
                           INT8_C( -58), INT8_C(  36), INT8_C(-124), INT8_C(  71),
                           INT8_C( -64), INT8_C( -55), INT8_C(  46), INT8_C(   5)),
      simde_mm256_set_epi8(INT8_C(  25), INT8_C(  72), INT8_C( -18), INT8_C( -20),
                           INT8_C(-114), INT8_C( -17), INT8_C(-113), INT8_C( -97),
                           INT8_C( 115), INT8_C(   3), INT8_C(  72), INT8_C( -46),
                           INT8_C( -91), INT8_C( -72), INT8_C( -23), INT8_C(  44),
                           INT8_C( -40), INT8_C(-122), INT8_C( 119), INT8_C(  -9),
                           INT8_C( -14), INT8_C( -27), INT8_C( 124), INT8_C(  49),
                           INT8_C(-122), INT8_C(  72), INT8_C(  86), INT8_C(   3),
                           INT8_C(-121), INT8_C(  78), INT8_C( -16), INT8_C( -20)),
      simde_mm256_set_epi8(INT8_C( 106), INT8_C(  11), INT8_C(  47), INT8_C(  -3),
                           INT8_C( -36), INT8_C(  77), INT8_C( -28), INT8_C(  51),
                           INT8_C(  71), INT8_C( -97), INT8_C( -44), INT8_C( 115),
                           INT8_C(  11), INT8_C( -47), INT8_C( -39), INT8_C( -88),
                           INT8_C(  82), INT8_C(  64), INT8_C(  12), INT8_C( 106),
                           INT8_C( 107), INT8_C( -47), INT8_C( 108), INT8_C( 113),
                           INT8_C(  88), INT8_C(  56), INT8_C( -69), INT8_C( 109),
                           INT8_C(  62), INT8_C( 124), INT8_C(  -2), INT8_C(  13)) },
    { simde_mm256_set_epi8(INT8_C( -51), INT8_C(  19), INT8_C(  98), INT8_C(  -5),
                           INT8_C( -37), INT8_C( -88), INT8_C( -92), INT8_C( -13),
                           INT8_C( -69), INT8_C( -50), INT8_C(  32), INT8_C(-117),
                           INT8_C( 116), INT8_C(-102), INT8_C(-124), INT8_C( -28),
                           INT8_C(  73), INT8_C( 123), INT8_C(  43), INT8_C(  -7),
                           INT8_C( -30), INT8_C( -95), INT8_C(  90), INT8_C( 120),
                           INT8_C(  95), INT8_C( 109), INT8_C( -55), INT8_C(-125),
                           INT8_C( 104), INT8_C( -93), INT8_C(   0), INT8_C(  30)),
      UINT32_C( 261247883),
      simde_mm256_set_epi8(INT8_C(  49), INT8_C(  93), INT8_C(  31), INT8_C( -47),
                           INT8_C( 118), INT8_C( 121), INT8_C(-116), INT8_C(  80),
                           INT8_C(  41), INT8_C(-105), INT8_C( 111), INT8_C( -16),
                           INT8_C( 123), INT8_C(  66), INT8_C( -25), INT8_C(-128),
                           INT8_C( -10), INT8_C( -38), INT8_C( -67), INT8_C( -19),
                           INT8_C( -21), INT8_C(  89), INT8_C(  36), INT8_C(  76),
                           INT8_C( -50), INT8_C(   9), INT8_C(  35), INT8_C(  67),
                           INT8_C( 104), INT8_C( -68), INT8_C( 121), INT8_C( -77)),
      simde_mm256_set_epi8(INT8_C(  35), INT8_C(  21), INT8_C(  83), INT8_C( -76),
                           INT8_C(  58), INT8_C( -71), INT8_C(   4), INT8_C(   1),
                           INT8_C( 112), INT8_C( -37), INT8_C( -98), INT8_C( 116),
                           INT8_C(-115), INT8_C( -49), INT8_C(  48), INT8_C(  61),
                           INT8_C( -87), INT8_C( -23), INT8_C( -78), INT8_C(  61),
                           INT8_C(-103), INT8_C(-124), INT8_C(  22), INT8_C( -33),
                           INT8_C(-126), INT8_C(  48), INT8_C( 116), INT8_C(  77),
                           INT8_C( -81), INT8_C(-109), INT8_C( -93), INT8_C(  18)),
      simde_mm256_set_epi8(INT8_C( -51), INT8_C(  19), INT8_C(  98), INT8_C(  -5),
                           INT8_C(  18), INT8_C(  38), INT8_C(   6), INT8_C(  80),
                           INT8_C(  95), INT8_C( -50), INT8_C(  32), INT8_C(  15),
                           INT8_C( 116), INT8_C(-102), INT8_C(  13), INT8_C( -28),
                           INT8_C(  73), INT8_C(  10), INT8_C(  43), INT8_C( -85),
                           INT8_C( -30), INT8_C( -95), INT8_C( -82), INT8_C(-108),
                           INT8_C(  17), INT8_C( 109), INT8_C( -55), INT8_C(-125),
                           INT8_C(  75), INT8_C( -93), INT8_C( -32), INT8_C( -72)) },
    { simde_mm256_set_epi8(INT8_C(-122), INT8_C(   7), INT8_C(-104), INT8_C( -70),
                           INT8_C( 100), INT8_C(  82), INT8_C( 124), INT8_C(-114),
                           INT8_C( -43), INT8_C( -26), INT8_C(   6), INT8_C( -56),
                           INT8_C(  88), INT8_C( -11), INT8_C(  17), INT8_C(  70),
                           INT8_C( -71), INT8_C(  77), INT8_C( 118), INT8_C(  52),
                           INT8_C(  40), INT8_C(  53), INT8_C( -66), INT8_C(  96),
                           INT8_C(  16), INT8_C( 115), INT8_C(  73), INT8_C(-110),
                           INT8_C( 117), INT8_C( -92), INT8_C(  -4), INT8_C( -36)),
      UINT32_C(3600672243),
      simde_mm256_set_epi8(INT8_C(  26), INT8_C(  11), INT8_C(  41), INT8_C(  33),
                           INT8_C(-112), INT8_C(  22), INT8_C(  74), INT8_C( -31),
                           INT8_C(  40), INT8_C( -36), INT8_C( 102), INT8_C(  98),
                           INT8_C( -33), INT8_C( -94), INT8_C(-102), INT8_C( 123),
                           INT8_C(  15), INT8_C( 121), INT8_C( -65), INT8_C( -97),
                           INT8_C(  -4), INT8_C( -34), INT8_C(  -4), INT8_C( -26),
                           INT8_C(  55), INT8_C( -78), INT8_C(-101), INT8_C( 114),
                           INT8_C(-106), INT8_C( -60), INT8_C( -56), INT8_C(  45)),
      simde_mm256_set_epi8(INT8_C( -62), INT8_C( 113), INT8_C(-120), INT8_C(  75),
                           INT8_C( -11), INT8_C( -23), INT8_C( -14), INT8_C( -91),
                           INT8_C(  98), INT8_C(  84), INT8_C(-127), INT8_C( -73),
                           INT8_C( -23), INT8_C(  19), INT8_C( -28), INT8_C(  10),
                           INT8_C( -94), INT8_C(  52), INT8_C( -78), INT8_C( 109),
                           INT8_C( -50), INT8_C( 112), INT8_C( -89), INT8_C(  81),
                           INT8_C(-117), INT8_C( -78), INT8_C(-116), INT8_C(  16),
                           INT8_C(   2), INT8_C(  54), INT8_C(  39), INT8_C( -22)),
      simde_mm256_set_epi8(INT8_C(  65), INT8_C(  54), INT8_C(-104), INT8_C( -24),
                           INT8_C( 100), INT8_C(  82), INT8_C(  -4), INT8_C(-114),
                           INT8_C( -55), INT8_C( -26), INT8_C(   6), INT8_C(  70),
                           INT8_C( 106), INT8_C(  51), INT8_C(  17), INT8_C(   3),
                           INT8_C(  36), INT8_C(-105), INT8_C(  66), INT8_C(  52),
                           INT8_C(  40), INT8_C( -10), INT8_C( -66), INT8_C( -95),
                           INT8_C(  36), INT8_C( -23), INT8_C(  91), INT8_C(  97),
                           INT8_C( 117), INT8_C( -92), INT8_C(  38), INT8_C(  58)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_mask_gf2p8mul_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -60), INT8_C( 108), INT8_C( -83), INT8_C( -82),
                           INT8_C(  83), INT8_C( 115), INT8_C(  91), INT8_C(  16),
                           INT8_C( -37), INT8_C( -12), INT8_C( -15), INT8_C(  -3),
                           INT8_C(  11), INT8_C(  -4), INT8_C( -51), INT8_C(  33),
                           INT8_C(  47), INT8_C( 126), INT8_C(-125), INT8_C( -56),
                           INT8_C(  -7), INT8_C(  90), INT8_C( -35), INT8_C( -10),
                           INT8_C(-123), INT8_C( -76), INT8_C( -34), INT8_C(  14),
                           INT8_C(  81), INT8_C(-107), INT8_C(  67), INT8_C(  83),
                           INT8_C( 111), INT8_C( -30), INT8_C(  29), INT8_C( -75),
                           INT8_C( -31), INT8_C( -33), INT8_C(  84), INT8_C( 119),
                           INT8_C(-127), INT8_C( -76), INT8_C(  60), INT8_C(  55),
                           INT8_C( -47), INT8_C( -11), INT8_C(  -2), INT8_C( -56),
                           INT8_C( -92), INT8_C(  40), INT8_C(   0), INT8_C(-123),
                           INT8_C(   2), INT8_C(  48), INT8_C(-127), INT8_C(-114),
                           INT8_C(  34), INT8_C(   5), INT8_C( 111), INT8_C( -64),
                           INT8_C(  86), INT8_C(  93), INT8_C( -59), INT8_C(  72)),
      UINT64_C( 9042485797202566251),
      simde_mm512_set_epi8(INT8_C( -52), INT8_C(  16), INT8_C( -41), INT8_C( 113),
                           INT8_C(  80), INT8_C( -23), INT8_C( 111), INT8_C(-116),
                           INT8_C(  66), INT8_C(  19), INT8_C(  99), INT8_C(  47),
                           INT8_C(-121), INT8_C(  52), INT8_C(  55), INT8_C(  84),
                           INT8_C(-118), INT8_C( -50), INT8_C( 104), INT8_C(  17),
                           INT8_C(  60), INT8_C(  70), INT8_C(  15), INT8_C( -35),
                           INT8_C(-110), INT8_C( -93), INT8_C(   9), INT8_C( -88),
                           INT8_C( 112), INT8_C( -61), INT8_C( -39), INT8_C(  11),
                           INT8_C( -74), INT8_C(-114), INT8_C( -45), INT8_C(  55),
                           INT8_C(  62), INT8_C( 126), INT8_C( -20), INT8_C(  55),
                           INT8_C( -72), INT8_C(  75), INT8_C(-120), INT8_C(-119),
                           INT8_C( 123), INT8_C( -34), INT8_C( -73), INT8_C(-123),
                           INT8_C(-101), INT8_C( -43), INT8_C(-116), INT8_C( -63),
                           INT8_C( -10), INT8_C( -51), INT8_C( -93), INT8_C( -84),
                           INT8_C(  47), INT8_C(-117), INT8_C( -67), INT8_C( -19),
                           INT8_C(  61), INT8_C(  13), INT8_C(  12), INT8_C( 114)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C( 117), INT8_C( 127), INT8_C(  68),
                           INT8_C( -69), INT8_C( 117), INT8_C( 102), INT8_C( -21),
                           INT8_C( -16), INT8_C( -38), INT8_C( 121), INT8_C(  93),
                           INT8_C(  29), INT8_C(  -6), INT8_C(  16), INT8_C( -65),
                           INT8_C( -80), INT8_C(   4), INT8_C( -36), INT8_C(-112),
                           INT8_C(   9), INT8_C(  -7), INT8_C(  94), INT8_C( -68),
                           INT8_C(  -5), INT8_C( -87), INT8_C(  68), INT8_C(  24),
                           INT8_C( -32), INT8_C(-119), INT8_C( 106), INT8_C(  64),
                           INT8_C( -62), INT8_C( -70), INT8_C( 123), INT8_C(  13),
                           INT8_C( -44), INT8_C(  -1), INT8_C(-119), INT8_C( -23),
                           INT8_C(  42), INT8_C( -86), INT8_C( -57), INT8_C(-127),
                           INT8_C( -75), INT8_C(  82), INT8_C( 117), INT8_C(   8),
                           INT8_C( -85), INT8_C(  58), INT8_C( -87), INT8_C(  32),
                           INT8_C(  52), INT8_C( -70), INT8_C( -17), INT8_C(-115),
                           INT8_C(  97), INT8_C(  94), INT8_C( -99), INT8_C( 121),
                           INT8_C( -25), INT8_C( -15), INT8_C( -40), INT8_C( -25)),
      simde_mm512_set_epi8(INT8_C( -60), INT8_C(  17), INT8_C( -38), INT8_C(-128),
                           INT8_C(  74), INT8_C(  30), INT8_C(  91), INT8_C(  19),
                           INT8_C( -37), INT8_C( 122), INT8_C(  91), INT8_C(   3),
                           INT8_C(  81), INT8_C(-114), INT8_C( -51), INT8_C( -37),
                           INT8_C(  47), INT8_C(  21), INT8_C(-125), INT8_C(  83),
                           INT8_C( -57), INT8_C(   4), INT8_C( -35), INT8_C( -10),
                           INT8_C(-105), INT8_C( -63), INT8_C(  82), INT8_C(  14),
                           INT8_C( -93), INT8_C( -51), INT8_C(  67), INT8_C(  83),
                           INT8_C( 111), INT8_C(-120), INT8_C(  92), INT8_C( -75),
                           INT8_C( -31), INT8_C(-119), INT8_C(  84), INT8_C( 119),
                           INT8_C(  54), INT8_C( -31), INT8_C(  60), INT8_C(  55),
                           INT8_C( -47), INT8_C( -49), INT8_C( -21), INT8_C( -56),
                           INT8_C( -92), INT8_C(  40), INT8_C(   0), INT8_C(  83),
                           INT8_C( -27), INT8_C(  18), INT8_C(-127), INT8_C(-114),
                           INT8_C(  34), INT8_C( -16), INT8_C( -10), INT8_C( -64),
                           INT8_C(  34), INT8_C(  93), INT8_C( -41), INT8_C(  61)) },
    { simde_mm512_set_epi8(INT8_C(  44), INT8_C(  82), INT8_C( 126), INT8_C(  -9),
                           INT8_C( -66), INT8_C(   2), INT8_C( -88), INT8_C( 110),
                           INT8_C(-110), INT8_C( -36), INT8_C(  43), INT8_C(  92),
                           INT8_C( 101), INT8_C( -61), INT8_C(  81), INT8_C( -12),
                           INT8_C(  79), INT8_C(  58), INT8_C(   2), INT8_C(-105),
                           INT8_C(  15), INT8_C(-109), INT8_C( -77), INT8_C(  32),
                           INT8_C(  15), INT8_C(   8), INT8_C( -14), INT8_C(-128),
                           INT8_C( -25), INT8_C(-113), INT8_C(   0), INT8_C(  20),
                           INT8_C( 104), INT8_C(-104), INT8_C(  23), INT8_C( -53),
                           INT8_C( -95), INT8_C(  23), INT8_C( -13), INT8_C(-106),
                           INT8_C(-108), INT8_C(-108), INT8_C(-107), INT8_C( 102),
                           INT8_C(  55), INT8_C(   5), INT8_C(  -1), INT8_C( 122),
                           INT8_C( 107), INT8_C( -68), INT8_C(  21), INT8_C( -60),
                           INT8_C(  19), INT8_C(  79), INT8_C(  73), INT8_C(  69),
                           INT8_C( -76), INT8_C( 116), INT8_C(  -6), INT8_C( 121),
                           INT8_C(  60), INT8_C(  67), INT8_C( 112), INT8_C( -18)),
      UINT64_C(   73569253378751484),
      simde_mm512_set_epi8(INT8_C(   6), INT8_C( -84), INT8_C(  92), INT8_C( -25),
                           INT8_C(  18), INT8_C( 109), INT8_C( -63), INT8_C( -13),
                           INT8_C(  -9), INT8_C( -29), INT8_C( -53), INT8_C( -70),
                           INT8_C(  94), INT8_C(  29), INT8_C(  26), INT8_C(  82),
                           INT8_C(  92), INT8_C( -86), INT8_C(  48), INT8_C(  61),
                           INT8_C( -99), INT8_C( 106), INT8_C(-120), INT8_C( 116),
                           INT8_C(  75), INT8_C(-105), INT8_C(-107), INT8_C( 104),
                           INT8_C( -27), INT8_C( -81), INT8_C( -23), INT8_C( -51),
                           INT8_C(  -4), INT8_C(  48), INT8_C(  -8), INT8_C( -41),
                           INT8_C(   5), INT8_C(-113), INT8_C( 112), INT8_C( -40),
                           INT8_C( -87), INT8_C(-117), INT8_C( 117), INT8_C(  50),
                           INT8_C( 100), INT8_C(  10), INT8_C(-102), INT8_C( -59),
                           INT8_C(  -1), INT8_C(  33), INT8_C(  78), INT8_C(   5),
                           INT8_C(  44), INT8_C(  41), INT8_C( -90), INT8_C(-111),
                           INT8_C( 108), INT8_C(  66), INT8_C( -27), INT8_C(  52),
                           INT8_C( -58), INT8_C( -74), INT8_C(   9), INT8_C( -86)),
      simde_mm512_set_epi8(INT8_C(  75), INT8_C(  87), INT8_C(  76), INT8_C(   1),
                           INT8_C( 102), INT8_C(  81), INT8_C(  11), INT8_C(  95),
                           INT8_C(  68), INT8_C(-126), INT8_C(  16), INT8_C(-115),
                           INT8_C(-103), INT8_C(  28), INT8_C( -85), INT8_C( -40),
                           INT8_C( -73), INT8_C(-106), INT8_C(  13), INT8_C(  80),
                           INT8_C(   3), INT8_C(  86), INT8_C( -66), INT8_C(  43),
                           INT8_C( -82), INT8_C(  33), INT8_C(  75), INT8_C(  49),
                           INT8_C( -19), INT8_C( 105), INT8_C( -42), INT8_C( 105),
                           INT8_C( -47), INT8_C(-126), INT8_C(  47), INT8_C( -64),
                           INT8_C( 100), INT8_C( -59), INT8_C(  87), INT8_C( -74),
                           INT8_C( 110), INT8_C( -19), INT8_C(  46), INT8_C(  69),
                           INT8_C( -19), INT8_C(  50), INT8_C( 107), INT8_C( -50),
                           INT8_C( 109), INT8_C( -80), INT8_C(  36), INT8_C( -57),
                           INT8_C(  37), INT8_C( 115), INT8_C(-117), INT8_C(  90),
                           INT8_C( -63), INT8_C( -76), INT8_C(  78), INT8_C( -35),
                           INT8_C(  32), INT8_C(-106), INT8_C( 123), INT8_C( -25)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C(  82), INT8_C( 126), INT8_C(  -9),
                           INT8_C( -66), INT8_C(   2), INT8_C( -88), INT8_C(  13),
                           INT8_C(-110), INT8_C( -36), INT8_C(  43), INT8_C(  92),
                           INT8_C( 101), INT8_C(  87), INT8_C(  81), INT8_C(  56),
                           INT8_C(  79), INT8_C( -39), INT8_C(   2), INT8_C(  36),
                           INT8_C( -68), INT8_C(  88), INT8_C(  47), INT8_C(  32),
                           INT8_C( -42), INT8_C( -22), INT8_C( -14), INT8_C(  29),
                           INT8_C(  37), INT8_C(-113), INT8_C(   0), INT8_C(  20),
                           INT8_C(  36), INT8_C(-104), INT8_C(  23), INT8_C( -13),
                           INT8_C( -17), INT8_C( 126), INT8_C(  21), INT8_C(-106),
                           INT8_C(-108), INT8_C(-108), INT8_C(-107), INT8_C( 102),
                           INT8_C(  55), INT8_C( -17), INT8_C(  88), INT8_C(   6),
                           INT8_C(  -6), INT8_C(  65), INT8_C(  32), INT8_C( -10),
                           INT8_C( 107), INT8_C(  79), INT8_C( -86), INT8_C( 111),
                           INT8_C(-114), INT8_C(-111), INT8_C( 100), INT8_C( -40),
                           INT8_C( -77), INT8_C( -56), INT8_C( 112), INT8_C( -18)) },
    { simde_mm512_set_epi8(INT8_C(  60), INT8_C(-120), INT8_C( -42), INT8_C(-124),
                           INT8_C(   8), INT8_C( -37), INT8_C(-106), INT8_C(  14),
                           INT8_C(  67), INT8_C( -50), INT8_C( 121), INT8_C(  84),
                           INT8_C( -68), INT8_C( -98), INT8_C( -25), INT8_C(-109),
                           INT8_C(  45), INT8_C( 109), INT8_C(  12), INT8_C(  96),
                           INT8_C( -57), INT8_C( 107), INT8_C( -54), INT8_C(-115),
                           INT8_C(  41), INT8_C( -50), INT8_C(  31), INT8_C( -53),
                           INT8_C( 127), INT8_C(  89), INT8_C( -60), INT8_C(-105),
                           INT8_C(  82), INT8_C(  80), INT8_C(-112), INT8_C( -28),
                           INT8_C(  60), INT8_C(  46), INT8_C(  78), INT8_C(  54),
                           INT8_C(  44), INT8_C( 100), INT8_C(  93), INT8_C( -69),
                           INT8_C( 103), INT8_C(  22), INT8_C( -91), INT8_C(-117),
                           INT8_C(   6), INT8_C(  11), INT8_C(  74), INT8_C( -33),
                           INT8_C(  52), INT8_C( -33), INT8_C(  27), INT8_C(-116),
                           INT8_C(  17), INT8_C( -16), INT8_C(  55), INT8_C(  89),
                           INT8_C( -22), INT8_C(-105), INT8_C(  16), INT8_C(  53)),
      UINT64_C( 4895941386511560426),
      simde_mm512_set_epi8(INT8_C( -58), INT8_C( 107), INT8_C( 108), INT8_C(  44),
                           INT8_C(  63), INT8_C(  23), INT8_C(-111), INT8_C(  45),
                           INT8_C(-124), INT8_C(  15), INT8_C(  66), INT8_C(  41),
                           INT8_C( -67), INT8_C(  85), INT8_C( -77), INT8_C(-107),
                           INT8_C( -87), INT8_C(   8), INT8_C( -14), INT8_C( -36),
                           INT8_C( -62), INT8_C( -81), INT8_C( -95), INT8_C( -56),
                           INT8_C(-119), INT8_C( 121), INT8_C(  17), INT8_C( -21),
                           INT8_C(  26), INT8_C(  -3), INT8_C(  81), INT8_C(  19),
                           INT8_C(-118), INT8_C( -71), INT8_C(-118), INT8_C( -42),
                           INT8_C(-124), INT8_C(  94), INT8_C( 108), INT8_C(-112),
                           INT8_C( -84), INT8_C(  75), INT8_C(-109), INT8_C( -61),
                           INT8_C(  82), INT8_C( 103), INT8_C(-112), INT8_C(  60),
                           INT8_C( -13), INT8_C( 104), INT8_C(  72), INT8_C(  14),
                           INT8_C(  -7), INT8_C(   8), INT8_C( -12), INT8_C(  40),
                           INT8_C(   1), INT8_C(-117), INT8_C(   3), INT8_C(-113),
                           INT8_C( -82), INT8_C(  28), INT8_C(-126), INT8_C( -51)),
      simde_mm512_set_epi8(INT8_C(  39), INT8_C(  69), INT8_C(  62), INT8_C(  39),
                           INT8_C( 115), INT8_C( 118), INT8_C( -66), INT8_C( -78),
                           INT8_C( -59), INT8_C(-115), INT8_C(  51), INT8_C( 110),
                           INT8_C( 119), INT8_C(-101), INT8_C(  33), INT8_C(  56),
                           INT8_C(-106), INT8_C(  -7), INT8_C( -15), INT8_C(   2),
                           INT8_C(  34), INT8_C(  71), INT8_C( 105), INT8_C(-101),
                           INT8_C( -79), INT8_C( -68), INT8_C( -32), INT8_C(  37),
                           INT8_C( -95), INT8_C(  31), INT8_C(-121), INT8_C( 120),
                           INT8_C(  52), INT8_C( -13), INT8_C( 114), INT8_C(   9),
                           INT8_C( 109), INT8_C( -67), INT8_C( -91), INT8_C( 125),
                           INT8_C( 114), INT8_C(  94), INT8_C( -75), INT8_C( -31),
                           INT8_C( 115), INT8_C(   0), INT8_C( -73), INT8_C( -89),
                           INT8_C(  22), INT8_C(-127), INT8_C(  84), INT8_C( -21),
                           INT8_C( -84), INT8_C( -59), INT8_C( -52), INT8_C(  86),
                           INT8_C( 101), INT8_C( -65), INT8_C(-118), INT8_C( -28),
                           INT8_C(-104), INT8_C(-109), INT8_C(  70), INT8_C(  82)),
      simde_mm512_set_epi8(INT8_C(  60), INT8_C(  89), INT8_C( -42), INT8_C(-124),
                           INT8_C(   8), INT8_C( -37), INT8_C(   3), INT8_C(  26),
                           INT8_C(  88), INT8_C(-118), INT8_C(  18), INT8_C(  92),
                           INT8_C( -68), INT8_C( -98), INT8_C( -25), INT8_C( 106),
                           INT8_C( 120), INT8_C(-119), INT8_C(  79), INT8_C(  96),
                           INT8_C( -57), INT8_C( 107), INT8_C( -54), INT8_C(-115),
                           INT8_C(  39), INT8_C( -96), INT8_C(  31), INT8_C( -53),
                           INT8_C( 127), INT8_C(  89), INT8_C( -60), INT8_C(-105),
                           INT8_C(  82), INT8_C( -11), INT8_C(-112), INT8_C(  60),
                           INT8_C(  60), INT8_C(  46), INT8_C(  78), INT8_C(  54),
                           INT8_C(  44), INT8_C( 100), INT8_C(  62), INT8_C( -69),
                           INT8_C( 103), INT8_C(   0), INT8_C( -63), INT8_C(  92),
                           INT8_C( -75), INT8_C(  11), INT8_C(  74), INT8_C( -33),
                           INT8_C(  26), INT8_C( 114), INT8_C( -57), INT8_C(-116),
                           INT8_C( 101), INT8_C( 125), INT8_C(-123), INT8_C(  89),
                           INT8_C( 121), INT8_C(-105), INT8_C( -20), INT8_C(  53)) },
    { simde_mm512_set_epi8(INT8_C(  93), INT8_C(-100), INT8_C( -64), INT8_C( -33),
                           INT8_C(  14), INT8_C( -92), INT8_C( -89), INT8_C( -55),
                           INT8_C( -10), INT8_C(  45), INT8_C( 126), INT8_C( -55),
                           INT8_C( -68), INT8_C( -21), INT8_C(-104), INT8_C(   8),
                           INT8_C(  63), INT8_C(-125), INT8_C( -76), INT8_C(-105),
                           INT8_C(  46), INT8_C(  21), INT8_C(   6), INT8_C( -49),
                           INT8_C(-107), INT8_C( -51), INT8_C(  -9), INT8_C( -74),
                           INT8_C(  35), INT8_C(   7), INT8_C(  -7), INT8_C( -91),
                           INT8_C(   8), INT8_C( -32), INT8_C( -98), INT8_C( -11),
                           INT8_C(  69), INT8_C(  57), INT8_C(   7), INT8_C(  43),
                           INT8_C(-112), INT8_C( -37), INT8_C( -25), INT8_C(-127),
                           INT8_C(  -4), INT8_C( -92), INT8_C( -28), INT8_C( 117),
                           INT8_C(  56), INT8_C( -85), INT8_C( -59), INT8_C(-123),
                           INT8_C(-120), INT8_C(  53), INT8_C( -24), INT8_C(   7),
                           INT8_C(  22), INT8_C(  42), INT8_C( -90), INT8_C( -17),
                           INT8_C( 113), INT8_C(  37), INT8_C(-120), INT8_C(-104)),
      UINT64_C( 1522514442861711303),
      simde_mm512_set_epi8(INT8_C( 103), INT8_C( -59), INT8_C(   7), INT8_C(-120),
                           INT8_C( 113), INT8_C( -69), INT8_C(  22), INT8_C(  38),
                           INT8_C( 124), INT8_C( -61), INT8_C( -20), INT8_C( 109),
                           INT8_C(-103), INT8_C(-127), INT8_C( -19), INT8_C(  82),
                           INT8_C( -84), INT8_C(  88), INT8_C( -40), INT8_C( -35),
                           INT8_C( -65), INT8_C(  11), INT8_C( -16), INT8_C( 117),
                           INT8_C( -14), INT8_C(  32), INT8_C(   2), INT8_C( -30),
                           INT8_C(  65), INT8_C( -22), INT8_C( -87), INT8_C(   2),
                           INT8_C(  21), INT8_C( -49), INT8_C(  55), INT8_C( -48),
                           INT8_C( -96), INT8_C( -37), INT8_C(  21), INT8_C(  40),
                           INT8_C( 107), INT8_C(-118), INT8_C(  62), INT8_C( -71),
                           INT8_C( 102), INT8_C( -54), INT8_C(  28), INT8_C( -89),
                           INT8_C(  90), INT8_C( -88), INT8_C(  51), INT8_C(-123),
                           INT8_C(  82), INT8_C(   7), INT8_C( -87), INT8_C( -10),
                           INT8_C(-123), INT8_C(  90), INT8_C( -21), INT8_C( -40),
                           INT8_C( -95), INT8_C( -75), INT8_C(  68), INT8_C( -36)),
      simde_mm512_set_epi8(INT8_C( -25), INT8_C( 126), INT8_C(  90), INT8_C(-102),
                           INT8_C( -35), INT8_C( -55), INT8_C( -99), INT8_C(  35),
                           INT8_C(   8), INT8_C(  42), INT8_C(  44), INT8_C( 115),
                           INT8_C(  24), INT8_C(-103), INT8_C(-117), INT8_C( -37),
                           INT8_C(-102), INT8_C( 116), INT8_C( -73), INT8_C( 117),
                           INT8_C( -39), INT8_C(  21), INT8_C(-106), INT8_C(  54),
                           INT8_C(-121), INT8_C(  20), INT8_C(-122), INT8_C( -82),
                           INT8_C(  46), INT8_C(  40), INT8_C( 111), INT8_C( -44),
                           INT8_C( -64), INT8_C( -62), INT8_C( -85), INT8_C(-117),
                           INT8_C( 122), INT8_C( -22), INT8_C(   2), INT8_C( 102),
                           INT8_C(  54), INT8_C( -43), INT8_C( -69), INT8_C( -40),
                           INT8_C(  57), INT8_C(   5), INT8_C( -81), INT8_C( -27),
                           INT8_C(-125), INT8_C( 110), INT8_C(-105), INT8_C(-103),
                           INT8_C( -37), INT8_C(-124), INT8_C( -56), INT8_C(-126),
                           INT8_C(   1), INT8_C(-116), INT8_C(  89), INT8_C(  18),
                           INT8_C(   9), INT8_C( 115), INT8_C(  39), INT8_C(-126)),
      simde_mm512_set_epi8(INT8_C(  93), INT8_C(-100), INT8_C( -64), INT8_C(-119),
                           INT8_C(  14), INT8_C(   5), INT8_C( -89), INT8_C( -58),
                           INT8_C( -10), INT8_C(  45), INT8_C(  56), INT8_C( -55),
                           INT8_C( -68), INT8_C( -21), INT8_C(-104), INT8_C( -50),
                           INT8_C(  63), INT8_C(-125), INT8_C( -76), INT8_C(-105),
                           INT8_C(   9), INT8_C(-105), INT8_C(  43), INT8_C( -49),
                           INT8_C(  87), INT8_C( -74), INT8_C(  -9), INT8_C(  19),
                           INT8_C(  35), INT8_C(   7), INT8_C(  -7), INT8_C( -77),
                           INT8_C(  89), INT8_C( -32), INT8_C( -98), INT8_C( -66),
                           INT8_C(  69), INT8_C(-107), INT8_C(   7), INT8_C(  43),
                           INT8_C(-112), INT8_C( -37), INT8_C( -41), INT8_C(-127),
                           INT8_C(  53), INT8_C( -49), INT8_C( -28), INT8_C( 117),
                           INT8_C(  12), INT8_C( -85), INT8_C( -59), INT8_C(-123),
                           INT8_C( -50), INT8_C( -79), INT8_C(   1), INT8_C( 126),
                           INT8_C(-123), INT8_C( 119), INT8_C( -90), INT8_C( -17),
                           INT8_C( 113), INT8_C(-110), INT8_C( -97), INT8_C( -10)) },
    { simde_mm512_set_epi8(INT8_C( -16), INT8_C( -86), INT8_C( -49), INT8_C( -47),
                           INT8_C(  51), INT8_C( -95), INT8_C(-106), INT8_C(  23),
                           INT8_C(-116), INT8_C(-105), INT8_C( -79), INT8_C( -83),
                           INT8_C(  -9), INT8_C(  63), INT8_C( -98), INT8_C( -11),
                           INT8_C(  -9), INT8_C(  -7), INT8_C(  24), INT8_C(  14),
                           INT8_C( -52), INT8_C(  32), INT8_C( -30), INT8_C(  34),
                           INT8_C(  22), INT8_C(  13), INT8_C( -76), INT8_C( -68),
                           INT8_C( -68), INT8_C(   6), INT8_C( -62), INT8_C( -44),
                           INT8_C( 101), INT8_C( -62), INT8_C( 117), INT8_C( -65),
                           INT8_C(  70), INT8_C(-105), INT8_C(-122), INT8_C(  44),
                           INT8_C(  57), INT8_C( -52), INT8_C( 104), INT8_C( -45),
                           INT8_C( -74), INT8_C(-128), INT8_C( -55), INT8_C(  81),
                           INT8_C( -35), INT8_C( 118), INT8_C(-122), INT8_C( -10),
                           INT8_C( -27), INT8_C(-106), INT8_C( -23), INT8_C(  36),
                           INT8_C( -96), INT8_C( -41), INT8_C(  31), INT8_C( -96),
                           INT8_C( -28), INT8_C(  71), INT8_C( -69), INT8_C(  13)),
      UINT64_C(17791771045880406762),
      simde_mm512_set_epi8(INT8_C( -59), INT8_C( 122), INT8_C(-123), INT8_C( 104),
                           INT8_C( -66), INT8_C(-122), INT8_C( -54), INT8_C( 109),
                           INT8_C(-116), INT8_C(  25), INT8_C(  86), INT8_C( -75),
                           INT8_C( 123), INT8_C(   2), INT8_C( -95), INT8_C( -53),
                           INT8_C(  82), INT8_C(-124), INT8_C( 122), INT8_C( -24),
                           INT8_C(-112), INT8_C(   6), INT8_C( -42), INT8_C(  57),
                           INT8_C( -79), INT8_C( -67), INT8_C(  91), INT8_C(  25),
                           INT8_C( 123), INT8_C( -63), INT8_C(  18), INT8_C( -11),
                           INT8_C(  27), INT8_C( -47), INT8_C(  98), INT8_C(  75),
                           INT8_C(  50), INT8_C( -38), INT8_C( -29), INT8_C(  78),
                           INT8_C(  88), INT8_C(-122), INT8_C(  99), INT8_C(   4),
                           INT8_C( -97), INT8_C(  44), INT8_C( -12), INT8_C( -32),
                           INT8_C(-105), INT8_C( -57), INT8_C( -84), INT8_C(-105),
                           INT8_C(  75), INT8_C(  16), INT8_C(  15), INT8_C( -88),
                           INT8_C(  86), INT8_C(  94), INT8_C(  44), INT8_C( -31),
                           INT8_C(  83), INT8_C(  56), INT8_C(  31), INT8_C(-109)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C( -74), INT8_C(   4), INT8_C(   7),
                           INT8_C( 104), INT8_C(-117), INT8_C( 125), INT8_C(  47),
                           INT8_C(  78), INT8_C( -53), INT8_C(  60), INT8_C( -62),
                           INT8_C( 100), INT8_C(  -7), INT8_C( -80), INT8_C( -18),
                           INT8_C(  68), INT8_C(  12), INT8_C(  63), INT8_C(  27),
                           INT8_C(  87), INT8_C( -25), INT8_C(-102), INT8_C(-117),
                           INT8_C(  -9), INT8_C(   7), INT8_C(-117), INT8_C(  -5),
                           INT8_C(  64), INT8_C( 111), INT8_C(   9), INT8_C(  20),
                           INT8_C( -40), INT8_C( -35), INT8_C( -16), INT8_C( -81),
                           INT8_C( 114), INT8_C(  80), INT8_C(-124), INT8_C( -58),
                           INT8_C(-110), INT8_C( 113), INT8_C(  -6), INT8_C(  59),
                           INT8_C(  48), INT8_C( -34), INT8_C(  27), INT8_C( -87),
                           INT8_C(-109), INT8_C(-112), INT8_C( -86), INT8_C(-108),
                           INT8_C( -83), INT8_C( -63), INT8_C( -64), INT8_C(-125),
                           INT8_C( 125), INT8_C( -33), INT8_C(  25), INT8_C(  49),
                           INT8_C( -11), INT8_C(  39), INT8_C( 115), INT8_C( -12)),
      simde_mm512_set_epi8(INT8_C( -53), INT8_C( 118), INT8_C(  34), INT8_C(   3),
                           INT8_C(  51), INT8_C( 122), INT8_C( -87), INT8_C(  23),
                           INT8_C( 105), INT8_C( -51), INT8_C(  -4), INT8_C( -83),
                           INT8_C( -25), INT8_C(  63), INT8_C( -98), INT8_C( -74),
                           INT8_C(  -9), INT8_C(  -7), INT8_C(  24), INT8_C(  32),
                           INT8_C( -52), INT8_C(  32), INT8_C( -30), INT8_C(   7),
                           INT8_C( -34), INT8_C(  13), INT8_C( -76), INT8_C( -68),
                           INT8_C( -68), INT8_C(   6), INT8_C( -62), INT8_C( -44),
                           INT8_C( 101), INT8_C(-112), INT8_C( 117), INT8_C( -99),
                           INT8_C(  71), INT8_C(-105), INT8_C(  70), INT8_C(  44),
                           INT8_C( -66), INT8_C(-125), INT8_C( 104), INT8_C( -45),
                           INT8_C(  85), INT8_C(-128), INT8_C( -55), INT8_C(  81),
                           INT8_C( -35), INT8_C( 118), INT8_C(  99), INT8_C( -10),
                           INT8_C( -27), INT8_C(-106), INT8_C(  44), INT8_C(  36),
                           INT8_C( -10), INT8_C( 110), INT8_C( -95), INT8_C( -96),
                           INT8_C( -60), INT8_C(  71), INT8_C(-122), INT8_C(  13)) },
    { simde_mm512_set_epi8(INT8_C( -82), INT8_C(   8), INT8_C(  44), INT8_C( 122),
                           INT8_C( -73), INT8_C(  -6), INT8_C(-102), INT8_C(  73),
                           INT8_C( 123), INT8_C( 117), INT8_C(  75), INT8_C(  44),
                           INT8_C(  67), INT8_C( -86), INT8_C(  16), INT8_C( -61),
                           INT8_C( 119), INT8_C( -20), INT8_C(  21), INT8_C( 125),
                           INT8_C(  12), INT8_C( 117), INT8_C(  57), INT8_C( -17),
                           INT8_C( -31), INT8_C( -68), INT8_C( 117), INT8_C( -57),
                           INT8_C(-106), INT8_C(  52), INT8_C(  -9), INT8_C( -33),
                           INT8_C( -99), INT8_C( -47), INT8_C(  84), INT8_C(  18),
                           INT8_C(-122), INT8_C(  36), INT8_C( -89), INT8_C( -23),
                           INT8_C( -91), INT8_C( -73), INT8_C(   2), INT8_C(  78),
                           INT8_C( -22), INT8_C(  45), INT8_C(-119), INT8_C(  40),
                           INT8_C( -56), INT8_C(  14), INT8_C(  48), INT8_C( -63),
                           INT8_C(-122), INT8_C(  34), INT8_C(-110), INT8_C(  31),
                           INT8_C(  96), INT8_C( 110), INT8_C( -90), INT8_C(-122),
                           INT8_C(  73), INT8_C(  42), INT8_C(  46), INT8_C( 121)),
      UINT64_C(11267890912837098650),
      simde_mm512_set_epi8(INT8_C(  11), INT8_C( -76), INT8_C( -53), INT8_C(  -7),
                           INT8_C( -81), INT8_C(  74), INT8_C(  93), INT8_C( -99),
                           INT8_C( 127), INT8_C( -84), INT8_C( 117), INT8_C( -10),
                           INT8_C(  62), INT8_C( -82), INT8_C(   5), INT8_C( -52),
                           INT8_C(  44), INT8_C(  46), INT8_C( -12), INT8_C(  95),
                           INT8_C( 126), INT8_C(  19), INT8_C(  86), INT8_C( -57),
                           INT8_C( -74), INT8_C(  86), INT8_C(  91), INT8_C(-111),
                           INT8_C(  29), INT8_C( 108), INT8_C(   6), INT8_C( -86),
                           INT8_C(  68), INT8_C( -55), INT8_C(-117), INT8_C( -50),
                           INT8_C(-116), INT8_C(  66), INT8_C( 103), INT8_C( -37),
                           INT8_C( -58), INT8_C(  19), INT8_C(  36), INT8_C(  -6),
                           INT8_C( -57), INT8_C(-127), INT8_C( -70), INT8_C( 101),
                           INT8_C( -73), INT8_C(  78), INT8_C(  49), INT8_C( -43),
                           INT8_C( -26), INT8_C(  87), INT8_C( -63), INT8_C( -52),
                           INT8_C( 105), INT8_C( 122), INT8_C( -13), INT8_C(-124),
                           INT8_C(  79), INT8_C(   9), INT8_C(  64), INT8_C(  -1)),
      simde_mm512_set_epi8(INT8_C( -36), INT8_C( -58), INT8_C(  45), INT8_C(  55),
                           INT8_C(   4), INT8_C(  32), INT8_C( -82), INT8_C( 116),
                           INT8_C( -74), INT8_C( 107), INT8_C(-116), INT8_C(  71),
                           INT8_C( -85), INT8_C(   5), INT8_C(  -6), INT8_C( -50),
                           INT8_C(-118), INT8_C( -56), INT8_C( -39), INT8_C( -31),
                           INT8_C(-118), INT8_C( -97), INT8_C(  25), INT8_C(  84),
                           INT8_C(  85), INT8_C( 111), INT8_C( -62), INT8_C(-113),
                           INT8_C( -52), INT8_C( -16), INT8_C( -45), INT8_C( 104),
                           INT8_C( -73), INT8_C(  14), INT8_C( -17), INT8_C(  10),
                           INT8_C( -32), INT8_C( -25), INT8_C( -32), INT8_C( 113),
                           INT8_C(  23), INT8_C( -77), INT8_C(   6), INT8_C( -76),
                           INT8_C(  66), INT8_C(-124), INT8_C( -41), INT8_C( 124),
                           INT8_C( -67), INT8_C(-104), INT8_C( -20), INT8_C( -65),
                           INT8_C( -26), INT8_C( 102), INT8_C(   0), INT8_C( -81),
                           INT8_C( -33), INT8_C(  37), INT8_C(  70), INT8_C( 106),
                           INT8_C( 114), INT8_C(  31), INT8_C(-116), INT8_C( -46)),
      simde_mm512_set_epi8(INT8_C( -59), INT8_C(   8), INT8_C(  44), INT8_C( -62),
                           INT8_C(-118), INT8_C(-125), INT8_C(-102), INT8_C(  73),
                           INT8_C( 123), INT8_C(  28), INT8_C(  75), INT8_C(  61),
                           INT8_C(  26), INT8_C(  32), INT8_C(  63), INT8_C( -30),
                           INT8_C( -46), INT8_C( -20), INT8_C(  21), INT8_C(  52),
                           INT8_C(  12), INT8_C(-119), INT8_C( -57), INT8_C( -56),
                           INT8_C( -31), INT8_C( -68), INT8_C( 117), INT8_C(  -4),
                           INT8_C(-106), INT8_C(  87), INT8_C(  -9), INT8_C(-104),
                           INT8_C( -56), INT8_C(-110), INT8_C(  84), INT8_C( -83),
                           INT8_C(-112), INT8_C(  36), INT8_C( -73), INT8_C(-122),
                           INT8_C( -80), INT8_C( -73), INT8_C(   2), INT8_C(  78),
                           INT8_C( -22), INT8_C(  45), INT8_C(-119), INT8_C( -68),
                           INT8_C(  66), INT8_C( -58), INT8_C(  48), INT8_C(  76),
                           INT8_C(  73), INT8_C(  -5), INT8_C(-110), INT8_C(  31),
                           INT8_C( -92), INT8_C( 110), INT8_C( -90), INT8_C(  34),
                           INT8_C( 103), INT8_C(  42), INT8_C(  96), INT8_C( 121)) },
    { simde_mm512_set_epi8(INT8_C(  50), INT8_C(  69), INT8_C( -72), INT8_C( -43),
                           INT8_C(-119), INT8_C( -95), INT8_C(  87), INT8_C( -97),
                           INT8_C(-126), INT8_C( 126), INT8_C(  57), INT8_C( 112),
                           INT8_C(  12), INT8_C(-105), INT8_C( -43), INT8_C(  27),
                           INT8_C(  37), INT8_C( -53), INT8_C(  44), INT8_C(   2),
                           INT8_C( -47), INT8_C( 117), INT8_C(  52), INT8_C(  37),
                           INT8_C(-113), INT8_C( -95), INT8_C(-114), INT8_C( 121),
                           INT8_C( 123), INT8_C(  15), INT8_C(  21), INT8_C(  26),
                           INT8_C(  84), INT8_C(  25), INT8_C(-108), INT8_C( -88),
                           INT8_C( -21), INT8_C( -63), INT8_C( 120), INT8_C(   2),
                           INT8_C( -96), INT8_C( -76), INT8_C( -43), INT8_C(  25),
                           INT8_C(  38), INT8_C( 117), INT8_C( -54), INT8_C( -27),
                           INT8_C( 105), INT8_C(  -3), INT8_C(   8), INT8_C( -91),
                           INT8_C(  53), INT8_C( -99), INT8_C(  98), INT8_C( 127),
                           INT8_C(   1), INT8_C( -55), INT8_C( -38), INT8_C(-120),
                           INT8_C(  94), INT8_C( 108), INT8_C( -84), INT8_C( -34)),
      UINT64_C( 2897475998749673702),
      simde_mm512_set_epi8(INT8_C( -99), INT8_C(  11), INT8_C(-127), INT8_C( -35),
                           INT8_C(  -6), INT8_C(-124), INT8_C(  91), INT8_C( -85),
                           INT8_C(  99), INT8_C( -25), INT8_C( -96), INT8_C(  99),
                           INT8_C(  22), INT8_C( -94), INT8_C( -42), INT8_C(  18),
                           INT8_C( -36), INT8_C( -57), INT8_C( -77), INT8_C( -35),
                           INT8_C(   1), INT8_C( 112), INT8_C(  97), INT8_C(-108),
                           INT8_C( -71), INT8_C(  -6), INT8_C(  28), INT8_C(  80),
                           INT8_C( 127), INT8_C(  29), INT8_C( -10), INT8_C( -91),
                           INT8_C(  59), INT8_C(  67), INT8_C( -23), INT8_C(  23),
                           INT8_C( -23), INT8_C( -25), INT8_C(  21), INT8_C( -90),
                           INT8_C(  93), INT8_C( -29), INT8_C(  36), INT8_C(  92),
                           INT8_C( -10), INT8_C( -93), INT8_C(-120), INT8_C( -83),
                           INT8_C( -15), INT8_C(-128), INT8_C(-114), INT8_C(  66),
                           INT8_C( -85), INT8_C(  31), INT8_C( -36), INT8_C(  77),
                           INT8_C(  -6), INT8_C(  99), INT8_C(   9), INT8_C( -69),
                           INT8_C(  26), INT8_C(   7), INT8_C(  53), INT8_C(-125)),
      simde_mm512_set_epi8(INT8_C( 111), INT8_C( 123), INT8_C( -56), INT8_C(  52),
                           INT8_C( -78), INT8_C( -44), INT8_C(  78), INT8_C( -71),
                           INT8_C(-102), INT8_C(  70), INT8_C( -41), INT8_C( 107),
                           INT8_C( 127), INT8_C(-122), INT8_C( -80), INT8_C( -63),
                           INT8_C(  91), INT8_C( -71), INT8_C( 105), INT8_C( -59),
                           INT8_C( -39), INT8_C( -58), INT8_C( -13), INT8_C(  24),
                           INT8_C( -67), INT8_C(  96), INT8_C( -28), INT8_C(  36),
                           INT8_C( -24), INT8_C( 107), INT8_C( -62), INT8_C(  91),
                           INT8_C( 123), INT8_C(  68), INT8_C(  22), INT8_C(  64),
                           INT8_C(  -7), INT8_C(  62), INT8_C(  38), INT8_C( 117),
                           INT8_C( 125), INT8_C( -93), INT8_C( -71), INT8_C( -13),
                           INT8_C( -13), INT8_C(   0), INT8_C( -44), INT8_C(  38),
                           INT8_C(-116), INT8_C(  64), INT8_C(-125), INT8_C(  76),
                           INT8_C( 126), INT8_C( 125), INT8_C(-102), INT8_C( -49),
                           INT8_C( 105), INT8_C( 100), INT8_C(  87), INT8_C(  85),
                           INT8_C(  33), INT8_C( -82), INT8_C(-122), INT8_C(-115)),
      simde_mm512_set_epi8(INT8_C(  50), INT8_C(  69), INT8_C( 115), INT8_C( -43),
                           INT8_C( 119), INT8_C( -95), INT8_C(  87), INT8_C( -97),
                           INT8_C(-126), INT8_C( 126), INT8_C(   7), INT8_C(  -9),
                           INT8_C(  12), INT8_C( -53), INT8_C( -43), INT8_C(  61),
                           INT8_C(  13), INT8_C(-120), INT8_C( -12), INT8_C(   2),
                           INT8_C( -47), INT8_C(  26), INT8_C(  40), INT8_C(  79),
                           INT8_C(-113), INT8_C( -95), INT8_C(-114), INT8_C( -75),
                           INT8_C( 123), INT8_C(  15), INT8_C(  21), INT8_C( -37),
                           INT8_C( 112), INT8_C( 124), INT8_C(-108), INT8_C( -88),
                           INT8_C( -21), INT8_C( -63), INT8_C( -24), INT8_C(   2),
                           INT8_C( -76), INT8_C( -76), INT8_C(  24), INT8_C(   3),
                           INT8_C(  38), INT8_C( 117), INT8_C( -54), INT8_C( -65),
                           INT8_C(   4), INT8_C(  77), INT8_C(   8), INT8_C( -91),
                           INT8_C( 121), INT8_C( -99), INT8_C(  98), INT8_C( 127),
                           INT8_C(  -3), INT8_C( -16), INT8_C( -39), INT8_C(-120),
                           INT8_C(  94), INT8_C( 103), INT8_C( 123), INT8_C( -34)) },
    { simde_mm512_set_epi8(INT8_C(  42), INT8_C(-115), INT8_C( 123), INT8_C(  21),
                           INT8_C( 107), INT8_C(  83), INT8_C(   8), INT8_C(  -8),
                           INT8_C( -95), INT8_C(  23), INT8_C( -44), INT8_C( 116),
                           INT8_C( -12), INT8_C(  83), INT8_C(  52), INT8_C(   2),
                           INT8_C(  15), INT8_C(  81), INT8_C(  76), INT8_C(  85),
                           INT8_C( -35), INT8_C(  93), INT8_C(  27), INT8_C( -46),
                           INT8_C( -42), INT8_C(   1), INT8_C( -14), INT8_C( 121),
                           INT8_C( -47), INT8_C( -92), INT8_C(  21), INT8_C(  25),
                           INT8_C( -50), INT8_C(  56), INT8_C(  -1), INT8_C( -27),
                           INT8_C(-104), INT8_C( -84), INT8_C(  97), INT8_C(  47),
                           INT8_C(  24), INT8_C(  91), INT8_C( 112), INT8_C( -60),
                           INT8_C(  30), INT8_C(-107), INT8_C(-111), INT8_C(  96),
                           INT8_C(  30), INT8_C(  -2), INT8_C(-109), INT8_C( 127),
                           INT8_C( -64), INT8_C( -18), INT8_C( -75), INT8_C( -64),
                           INT8_C( -48), INT8_C(  57), INT8_C(  27), INT8_C(  26),
                           INT8_C(-119), INT8_C( -95), INT8_C(  15), INT8_C( -95)),
      UINT64_C(10629194982122454645),
      simde_mm512_set_epi8(INT8_C(  62), INT8_C(  73), INT8_C( -67), INT8_C(  27),
                           INT8_C( -60), INT8_C(-109), INT8_C(  33), INT8_C(  36),
                           INT8_C( -13), INT8_C(  42), INT8_C(  41), INT8_C( -70),
                           INT8_C(  94), INT8_C(  39), INT8_C(-123), INT8_C(  38),
                           INT8_C( -66), INT8_C(-110), INT8_C(  55), INT8_C( -62),
                           INT8_C( -32), INT8_C(  61), INT8_C(  21), INT8_C(-111),
                           INT8_C(  20), INT8_C(-117), INT8_C(-105), INT8_C(-126),
                           INT8_C(  -6), INT8_C(  47), INT8_C( -54), INT8_C( 116),
                           INT8_C( -85), INT8_C(  57), INT8_C(-112), INT8_C(  31),
                           INT8_C(-109), INT8_C( -19), INT8_C(  86), INT8_C(-126),
                           INT8_C( -89), INT8_C( -72), INT8_C( -35), INT8_C(  82),
                           INT8_C( -99), INT8_C(   1), INT8_C( -28), INT8_C( 124),
                           INT8_C(  52), INT8_C( 115), INT8_C(  85), INT8_C(  40),
                           INT8_C(-124), INT8_C( -25), INT8_C(  95), INT8_C( -49),
                           INT8_C(  26), INT8_C(  78), INT8_C( -88), INT8_C(  95),
                           INT8_C( -42), INT8_C(-119), INT8_C( -27), INT8_C(  46)),
      simde_mm512_set_epi8(INT8_C( -62), INT8_C(  -7), INT8_C( -53), INT8_C(  59),
                           INT8_C(  14), INT8_C( -30), INT8_C( 104), INT8_C( -55),
                           INT8_C(   7), INT8_C( 102), INT8_C( -93), INT8_C( -26),
                           INT8_C( -17), INT8_C(-127), INT8_C(-119), INT8_C( -98),
                           INT8_C(  65), INT8_C( -48), INT8_C( 121), INT8_C(  66),
                           INT8_C( -69), INT8_C( -56), INT8_C(  87), INT8_C(  -4),
                           INT8_C( -55), INT8_C( 111), INT8_C(  50), INT8_C( 124),
                           INT8_C(  43), INT8_C( 104), INT8_C(   0), INT8_C( -55),
                           INT8_C(  71), INT8_C(  44), INT8_C( -51), INT8_C( -76),
                           INT8_C(  67), INT8_C( 119), INT8_C( -71), INT8_C( -67),
                           INT8_C( -88), INT8_C(  53), INT8_C( -42), INT8_C( -53),
                           INT8_C( -99), INT8_C( -89), INT8_C(-118), INT8_C(  -2),
                           INT8_C( -84), INT8_C( -65), INT8_C( -66), INT8_C( 121),
                           INT8_C( -61), INT8_C( -77), INT8_C( 116), INT8_C( -70),
                           INT8_C( 113), INT8_C( -63), INT8_C( -68), INT8_C( -78),
                           INT8_C( -23), INT8_C( -40), INT8_C(  54), INT8_C( -12)),
      simde_mm512_set_epi8(INT8_C(  87), INT8_C(-115), INT8_C( 123), INT8_C(  19),
                           INT8_C( 107), INT8_C(  83), INT8_C( -57), INT8_C(  65),
                           INT8_C( -17), INT8_C(  23), INT8_C( -44), INT8_C( 116),
                           INT8_C( -12), INT8_C(  83), INT8_C( -19), INT8_C(   2),
                           INT8_C(  15), INT8_C(  27), INT8_C(  28), INT8_C(  -7),
                           INT8_C(-101), INT8_C(-125), INT8_C(  27), INT8_C( -46),
                           INT8_C(  45), INT8_C(   1), INT8_C( -14), INT8_C( 121),
                           INT8_C( -47), INT8_C( -63), INT8_C(  21), INT8_C( -11),
                           INT8_C( -50), INT8_C(  56), INT8_C( 105), INT8_C(  67),
                           INT8_C(-104), INT8_C(  16), INT8_C(  97), INT8_C(  82),
                           INT8_C( -12), INT8_C( -15), INT8_C( 112), INT8_C( -60),
                           INT8_C(  30), INT8_C( -89), INT8_C(-111), INT8_C(  16),
                           INT8_C( -12), INT8_C( -63), INT8_C(  49), INT8_C(  92),
                           INT8_C( 109), INT8_C( -18), INT8_C( -33), INT8_C( -64),
                           INT8_C( -48), INT8_C(  68), INT8_C(  78), INT8_C( 120),
                           INT8_C(-119), INT8_C(  33), INT8_C(  15), INT8_C(  70)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_gf2p8mul_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm_maskz_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask16 k;
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { UINT16_C(29185),
      simde_mm_set_epi8(INT8_C( -10), INT8_C(  32), INT8_C( 126), INT8_C(-118),
                        INT8_C(  97), INT8_C( -54), INT8_C( -78), INT8_C(  30),
                        INT8_C(   6), INT8_C(  88), INT8_C(   8), INT8_C( -88),
                        INT8_C(  37), INT8_C(-105), INT8_C( -43), INT8_C(  10)),
      simde_mm_set_epi8(INT8_C(  86), INT8_C(  34), INT8_C(  53), INT8_C(-104),
                        INT8_C(  65), INT8_C(  51), INT8_C(  68), INT8_C(  58),
                        INT8_C(  41), INT8_C( -52), INT8_C( 100), INT8_C( -28),
                        INT8_C( -14), INT8_C(  92), INT8_C(  63), INT8_C(-111)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(  44), INT8_C( 101), INT8_C( -87),
                        INT8_C(   0), INT8_C(   0), INT8_C(-121), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -35)) },
    { UINT16_C(59388),
      simde_mm_set_epi8(INT8_C(-109), INT8_C(  72), INT8_C(  43), INT8_C( 122),
                        INT8_C( 102), INT8_C( -82), INT8_C(  18), INT8_C(-114),
                        INT8_C(  68), INT8_C( -77), INT8_C(-112), INT8_C( -24),
                        INT8_C(  48), INT8_C( -78), INT8_C(  -9), INT8_C(  12)),
      simde_mm_set_epi8(INT8_C( 117), INT8_C( -80), INT8_C(  47), INT8_C( -43),
                        INT8_C(  69), INT8_C( -22), INT8_C(  13), INT8_C(  76),
                        INT8_C( -31), INT8_C( -18), INT8_C(  35), INT8_C( -68),
                        INT8_C( -94), INT8_C( -30), INT8_C( -17), INT8_C(  44)),
      simde_mm_set_epi8(INT8_C(   6), INT8_C(  14), INT8_C(-123), INT8_C(   0),
                        INT8_C(   0), INT8_C(  20), INT8_C( -54), INT8_C( -14),
                        INT8_C( -41), INT8_C( -78), INT8_C(  54), INT8_C(-102),
                        INT8_C(  73), INT8_C(  69), INT8_C(   0), INT8_C(   0)) },
    { UINT16_C(26979),
      simde_mm_set_epi8(INT8_C(  -8), INT8_C( -14), INT8_C( -53), INT8_C(-117),
                        INT8_C( -21), INT8_C(  27), INT8_C(  63), INT8_C(  11),
                        INT8_C(-100), INT8_C( 101), INT8_C( -23), INT8_C(  95),
                        INT8_C(  77), INT8_C(  86), INT8_C(  90), INT8_C(  79)),
      simde_mm_set_epi8(INT8_C( -69), INT8_C(   7), INT8_C( -57), INT8_C(  95),
                        INT8_C( 119), INT8_C( -13), INT8_C(  52), INT8_C( -49),
                        INT8_C( -57), INT8_C(  36), INT8_C(  17), INT8_C( -61),
                        INT8_C( -43), INT8_C( -58), INT8_C( 107), INT8_C(  88)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C( -24), INT8_C( 119), INT8_C(   0),
                        INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C( 104),
                        INT8_C(   0), INT8_C(-101), INT8_C(  -5), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C( -52), INT8_C(-108)) },
    { UINT16_C(42638),
      simde_mm_set_epi8(INT8_C( -29), INT8_C( -92), INT8_C(  29), INT8_C( -85),
                        INT8_C( -19), INT8_C( -87), INT8_C(  68), INT8_C( -71),
                        INT8_C(  11), INT8_C( 124), INT8_C(  70), INT8_C( -95),
                        INT8_C( -56), INT8_C(  58), INT8_C( -18), INT8_C( 102)),
      simde_mm_set_epi8(INT8_C(   7), INT8_C( -64), INT8_C(  82), INT8_C( 103),
                        INT8_C( 103), INT8_C(  41), INT8_C( -38), INT8_C( -41),
                        INT8_C(  30), INT8_C( -59), INT8_C(  99), INT8_C(  31),
                        INT8_C( -62), INT8_C( -42), INT8_C( -76), INT8_C( -24)),
      simde_mm_set_epi8(INT8_C( -97), INT8_C(   0), INT8_C( -16), INT8_C(   0),
                        INT8_C(   0), INT8_C( 106), INT8_C( 121), INT8_C(   0),
                        INT8_C( -46), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C( -32), INT8_C(  23), INT8_C(  14), INT8_C(   0)) },
    { UINT16_C( 7351),
      simde_mm_set_epi8(INT8_C( -85), INT8_C( -52), INT8_C(  38), INT8_C(  11),
                        INT8_C(  18), INT8_C( -75), INT8_C( 112), INT8_C( -81),
                        INT8_C( 105), INT8_C(  79), INT8_C( -70), INT8_C(  11),
                        INT8_C( -86), INT8_C(  72), INT8_C(  43), INT8_C(-118)),
      simde_mm_set_epi8(INT8_C( -12), INT8_C(  82), INT8_C( -77), INT8_C( -57),
                        INT8_C( 106), INT8_C( -53), INT8_C( -59), INT8_C(  69),
                        INT8_C(-110), INT8_C(  -9), INT8_C(  80), INT8_C(   7),
                        INT8_C(   7), INT8_C( 113), INT8_C( -36), INT8_C(  -3)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  48),
                        INT8_C(  46), INT8_C( -26), INT8_C(   0), INT8_C(   0),
                        INT8_C(  18), INT8_C(   0), INT8_C(  26), INT8_C(  49),
                        INT8_C(   0), INT8_C(  -6), INT8_C(  27), INT8_C(  54)) },
    { UINT16_C(26851),
      simde_mm_set_epi8(INT8_C(-118), INT8_C( 121), INT8_C(-118), INT8_C(  72),
                        INT8_C( -13), INT8_C( -73), INT8_C(  99), INT8_C(-100),
                        INT8_C(  70), INT8_C( -52), INT8_C(  55), INT8_C(  31),
                        INT8_C( 122), INT8_C(-104), INT8_C( -45), INT8_C( -49)),
      simde_mm_set_epi8(INT8_C(-120), INT8_C(-116), INT8_C(  -9), INT8_C(  25),
                        INT8_C( 115), INT8_C( 123), INT8_C(  61), INT8_C(-108),
                        INT8_C( 126), INT8_C( 107), INT8_C( -34), INT8_C( 121),
                        INT8_C( -93), INT8_C( -91), INT8_C( -44), INT8_C( 120)),
      simde_mm_set_epi8(INT8_C(   0), INT8_C( -56), INT8_C(   5), INT8_C(   0),
                        INT8_C( 124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                        INT8_C( -83), INT8_C(  86), INT8_C(  -3), INT8_C(   0),
                        INT8_C(   0), INT8_C(   0), INT8_C(  32), INT8_C( -27)) },
    { UINT16_C(42651),
      simde_mm_set_epi8(INT8_C(  87), INT8_C(   3), INT8_C(  34), INT8_C(  16),
                        INT8_C(  12), INT8_C(  64), INT8_C(  85), INT8_C( -66),
                        INT8_C(  70), INT8_C( -63), INT8_C( -19), INT8_C(  10),
                        INT8_C(  31), INT8_C( -86), INT8_C( -82), INT8_C( -92)),
      simde_mm_set_epi8(INT8_C(  16), INT8_C(-112), INT8_C( -76), INT8_C(  22),
                        INT8_C( -61), INT8_C(  17), INT8_C(  14), INT8_C(  50),
                        INT8_C(-126), INT8_C(  74), INT8_C( -39), INT8_C( 102),
                        INT8_C(   3), INT8_C( 101), INT8_C( -19), INT8_C(  41)),
      simde_mm_set_epi8(INT8_C(   7), INT8_C(   0), INT8_C(   2), INT8_C(   0),
                        INT8_C(   0), INT8_C(  44), INT8_C( 123), INT8_C(   0),
                        INT8_C( -20), INT8_C(   0), INT8_C(   0), INT8_C( -47),
                        INT8_C(  33), INT8_C(   0), INT8_C( 115), INT8_C( -76)) },
    { UINT16_C(47845),
      simde_mm_set_epi8(INT8_C(  87), INT8_C(  53), INT8_C( -89), INT8_C( -46),
                        INT8_C(  26), INT8_C(-123), INT8_C( -52), INT8_C( -54),
                        INT8_C(-106), INT8_C( -59), INT8_C(-103), INT8_C( -45),
                        INT8_C( -29), INT8_C(  90), INT8_C(  23), INT8_C(-121)),
      simde_mm_set_epi8(INT8_C(  36), INT8_C(  38), INT8_C(  66), INT8_C( -47),
                        INT8_C( -23), INT8_C( -52), INT8_C( -74), INT8_C( -39),
                        INT8_C(  27), INT8_C( -34), INT8_C( -39), INT8_C(  18),
                        INT8_C( -29), INT8_C(  16), INT8_C(  82), INT8_C(-107)),
      simde_mm_set_epi8(INT8_C(  73), INT8_C(   0), INT8_C(  27), INT8_C(  67),
                        INT8_C( -46), INT8_C(   0), INT8_C(-113), INT8_C(   0),
                        INT8_C( -34), INT8_C( -30), INT8_C(-105), INT8_C(   0),
                        INT8_C(   0), INT8_C( -41), INT8_C(   0), INT8_C(  50)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_maskz_gf2p8mul_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm256_maskz_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask32 k;
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { UINT32_C(2075432365),
      simde_mm256_set_epi8(INT8_C(  86), INT8_C( 126), INT8_C( -66), INT8_C( -91),
                           INT8_C(  -5), INT8_C(-106), INT8_C( -15), INT8_C(  89),
                           INT8_C( -94), INT8_C(  -2), INT8_C(-101), INT8_C(  60),
                           INT8_C(-124), INT8_C( -68), INT8_C(  -2), INT8_C( 111),
                           INT8_C( -61), INT8_C( -18), INT8_C( 111), INT8_C( -99),
                           INT8_C( -83), INT8_C(  74), INT8_C(  44), INT8_C( 121),
                           INT8_C(  68), INT8_C( -43), INT8_C( 102), INT8_C( -12),
                           INT8_C( -75), INT8_C( 115), INT8_C( 102), INT8_C(  30)),
      simde_mm256_set_epi8(INT8_C(  83), INT8_C( -80), INT8_C( -53), INT8_C(  73),
                           INT8_C(  44), INT8_C( -89), INT8_C(-125), INT8_C(  21),
                           INT8_C(  52), INT8_C(-114), INT8_C(  44), INT8_C(  76),
                           INT8_C( 111), INT8_C( -49), INT8_C( -31), INT8_C( -69),
                           INT8_C( -77), INT8_C(  69), INT8_C( -95), INT8_C(-121),
                           INT8_C( -56), INT8_C( -77), INT8_C(-118), INT8_C(  83),
                           INT8_C(  89), INT8_C(-108), INT8_C( -45), INT8_C(  75),
                           INT8_C(  52), INT8_C(  44), INT8_C( -49), INT8_C( 106)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(-121), INT8_C( -94), INT8_C(  52),
                           INT8_C(  10), INT8_C(   0), INT8_C(  44), INT8_C( -63),
                           INT8_C(  -9), INT8_C(   0), INT8_C(   8), INT8_C(-110),
                           INT8_C(   0), INT8_C( -23), INT8_C(   0), INT8_C(   0),
                           INT8_C(-123), INT8_C(   0), INT8_C(   0), INT8_C( 102),
                           INT8_C(   0), INT8_C( -85), INT8_C(   0), INT8_C(  51),
                           INT8_C( -50), INT8_C(   0), INT8_C( -77), INT8_C(   0),
                           INT8_C(  22), INT8_C(-128), INT8_C(   0), INT8_C( -32)) },
    { UINT32_C(1069894965),
      simde_mm256_set_epi8(INT8_C( -54), INT8_C(  16), INT8_C(  24), INT8_C( -22),
                           INT8_C(  61), INT8_C( 108), INT8_C(  61), INT8_C(  52),
                           INT8_C(-116), INT8_C( -40), INT8_C(  94), INT8_C(-119),
                           INT8_C( -35), INT8_C(  -8), INT8_C(  32), INT8_C(  -5),
                           INT8_C( -65), INT8_C(  21), INT8_C( -98), INT8_C(-108),
                           INT8_C(  33), INT8_C( -44), INT8_C( 105), INT8_C( -50),
                           INT8_C(  63), INT8_C(  -8), INT8_C(  33), INT8_C(  91),
                           INT8_C( -25), INT8_C( 114), INT8_C(  75), INT8_C(  17)),
      simde_mm256_set_epi8(INT8_C( -88), INT8_C( -18), INT8_C( -33), INT8_C(  59),
                           INT8_C(  62), INT8_C( -54), INT8_C( -64), INT8_C(  55),
                           INT8_C( 106), INT8_C( -53), INT8_C( 118), INT8_C( 100),
                           INT8_C( -51), INT8_C( 119), INT8_C( 124), INT8_C(-117),
                           INT8_C(  10), INT8_C(-115), INT8_C(  59), INT8_C(  50),
                           INT8_C(  -2), INT8_C(  21), INT8_C(  66), INT8_C(  92),
                           INT8_C(-122), INT8_C( -88), INT8_C( -10), INT8_C( -64),
                           INT8_C( -80), INT8_C( -20), INT8_C(  46), INT8_C( -74)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(  -3), INT8_C(  82),
                           INT8_C(  97), INT8_C( 119), INT8_C( 112), INT8_C(  59),
                           INT8_C(  95), INT8_C(  54), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-111), INT8_C(   0), INT8_C( -36),
                           INT8_C(   0), INT8_C(-121), INT8_C(   0), INT8_C(   0),
                           INT8_C(  12), INT8_C(  70), INT8_C(   0), INT8_C(  32),
                           INT8_C(   0), INT8_C(   0), INT8_C(  31), INT8_C(  83),
                           INT8_C(   0), INT8_C(  22), INT8_C(   0), INT8_C(  35)) },
    { UINT32_C(4143594711),
      simde_mm256_set_epi8(INT8_C( -56), INT8_C(  41), INT8_C(  98), INT8_C( -20),
                           INT8_C(  45), INT8_C( -36), INT8_C( -44), INT8_C(  43),
                           INT8_C(  59), INT8_C( -52), INT8_C(  81), INT8_C(-111),
                           INT8_C(  13), INT8_C(  79), INT8_C( -10), INT8_C( -28),
                           INT8_C(  27), INT8_C( 109), INT8_C( -96), INT8_C(  29),
                           INT8_C( -11), INT8_C(   6), INT8_C( -28), INT8_C(  -2),
                           INT8_C(-120), INT8_C(  13), INT8_C( -21), INT8_C(-118),
                           INT8_C(  58), INT8_C( 122), INT8_C(   9), INT8_C( -90)),
      simde_mm256_set_epi8(INT8_C( -80), INT8_C(  23), INT8_C(  22), INT8_C( 112),
                           INT8_C( -19), INT8_C(   5), INT8_C( 121), INT8_C(-111),
                           INT8_C(-110), INT8_C( 102), INT8_C(  -7), INT8_C(   1),
                           INT8_C( -93), INT8_C(  15), INT8_C( 111), INT8_C(-121),
                           INT8_C( -48), INT8_C(-113), INT8_C( 117), INT8_C(  42),
                           INT8_C( -20), INT8_C( -35), INT8_C( 127), INT8_C(  40),
                           INT8_C( -34), INT8_C(  91), INT8_C( -77), INT8_C( -48),
                           INT8_C( -63), INT8_C( 115), INT8_C( 111), INT8_C(  25)),
      simde_mm256_set_epi8(INT8_C( -25), INT8_C( 121), INT8_C(  45), INT8_C( -43),
                           INT8_C(   0), INT8_C(-127), INT8_C(-107), INT8_C(   0),
                           INT8_C( 111), INT8_C( -67), INT8_C( -44), INT8_C(-111),
                           INT8_C( 118), INT8_C(   0), INT8_C(  37), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -86), INT8_C(  95),
                           INT8_C(-126), INT8_C(  -8), INT8_C(   0), INT8_C(   0),
                           INT8_C( -28), INT8_C( -62), INT8_C(   0), INT8_C( 110),
                           INT8_C(   0), INT8_C(  31), INT8_C(  58), INT8_C( 111)) },
    { UINT32_C(2889346475),
      simde_mm256_set_epi8(INT8_C(  -3), INT8_C(  41), INT8_C(  18), INT8_C(  80),
                           INT8_C( -91), INT8_C( -20), INT8_C( 113), INT8_C(   8),
                           INT8_C(  78), INT8_C( -34), INT8_C( 125), INT8_C(  84),
                           INT8_C( 101), INT8_C( -30), INT8_C( -57), INT8_C(-112),
                           INT8_C(  22), INT8_C(-119), INT8_C(   6), INT8_C(  60),
                           INT8_C( 125), INT8_C(  -3), INT8_C( -85), INT8_C(  72),
                           INT8_C( 113), INT8_C(-117), INT8_C(  15), INT8_C(  -1),
                           INT8_C( -32), INT8_C(  51), INT8_C(  36), INT8_C(  98)),
      simde_mm256_set_epi8(INT8_C( -87), INT8_C( 102), INT8_C( -12), INT8_C( -17),
                           INT8_C( -14), INT8_C(  39), INT8_C( -22), INT8_C(-103),
                           INT8_C( -72), INT8_C(  33), INT8_C( -49), INT8_C( -96),
                           INT8_C(  65), INT8_C( -66), INT8_C(  -3), INT8_C(-104),
                           INT8_C(   2), INT8_C( -22), INT8_C(  13), INT8_C( -73),
                           INT8_C( 103), INT8_C( 104), INT8_C(  98), INT8_C(   2),
                           INT8_C( -43), INT8_C(-128), INT8_C(  33), INT8_C( -53),
                           INT8_C(  34), INT8_C(  -9), INT8_C(  66), INT8_C(  38)),
      simde_mm256_set_epi8(INT8_C( -72), INT8_C(   0), INT8_C(  42), INT8_C(   0),
                           INT8_C( -63), INT8_C(  54), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  59), INT8_C( -51),
                           INT8_C(   0), INT8_C( -79), INT8_C(-124), INT8_C( 109),
                           INT8_C(  44), INT8_C( -16), INT8_C(  46), INT8_C(   0),
                           INT8_C(  35), INT8_C(   4), INT8_C(   0), INT8_C(-112),
                           INT8_C(  30), INT8_C(   0), INT8_C( -12), INT8_C(   0),
                           INT8_C( -60), INT8_C(   0), INT8_C(-117), INT8_C( -93)) },
    { UINT32_C(1359163250),
      simde_mm256_set_epi8(INT8_C(  13), INT8_C(-110), INT8_C( -86), INT8_C(  63),
                           INT8_C(  24), INT8_C( -72), INT8_C(  79), INT8_C(  53),
                           INT8_C( -69), INT8_C(  59), INT8_C(  10), INT8_C( -63),
                           INT8_C(   4), INT8_C( -51), INT8_C(  -2), INT8_C( -60),
                           INT8_C(-103), INT8_C(  50), INT8_C(  98), INT8_C(  94),
                           INT8_C( -99), INT8_C(  42), INT8_C( -66), INT8_C( -32),
                           INT8_C(  23), INT8_C( 123), INT8_C( -82), INT8_C( -15),
                           INT8_C(  59), INT8_C( 103), INT8_C(  -4), INT8_C( -72)),
      simde_mm256_set_epi8(INT8_C( -38), INT8_C(  35), INT8_C( -53), INT8_C(  81),
                           INT8_C(-120), INT8_C( -95), INT8_C( -95), INT8_C( -44),
                           INT8_C(  40), INT8_C( 122), INT8_C( -72), INT8_C( -65),
                           INT8_C(  39), INT8_C(  19), INT8_C( -27), INT8_C(  27),
                           INT8_C(  75), INT8_C( -14), INT8_C( 124), INT8_C(  -3),
                           INT8_C( -83), INT8_C(  78), INT8_C( -51), INT8_C( -75),
                           INT8_C(  59), INT8_C( -65), INT8_C(  73), INT8_C(  17),
                           INT8_C(-109), INT8_C( -83), INT8_C(  62), INT8_C(  50)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( 112), INT8_C(   0), INT8_C( -69),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-125),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -61), INT8_C( -39),
                           INT8_C(   0), INT8_C(   0), INT8_C( -45), INT8_C(   0),
                           INT8_C( -27), INT8_C( -39), INT8_C(  11), INT8_C( -84),
                           INT8_C(   0), INT8_C(  78), INT8_C(-111), INT8_C( 120),
                           INT8_C(   0), INT8_C(   0), INT8_C( 116), INT8_C(   0)) },
    { UINT32_C(2859068752),
      simde_mm256_set_epi8(INT8_C( -47), INT8_C(-118), INT8_C( -29), INT8_C(  72),
                           INT8_C(-124), INT8_C( -55), INT8_C( -53), INT8_C(  65),
                           INT8_C(  23), INT8_C(  73), INT8_C(  28), INT8_C( -74),
                           INT8_C(  83), INT8_C(-104), INT8_C( -52), INT8_C( 109),
                           INT8_C(  75), INT8_C(  19), INT8_C(-105), INT8_C(-116),
                           INT8_C(  68), INT8_C(-123), INT8_C( -79), INT8_C(  45),
                           INT8_C(  38), INT8_C(  52), INT8_C( -74), INT8_C(  23),
                           INT8_C(  41), INT8_C(-113), INT8_C(-106), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C(-114), INT8_C( -80), INT8_C( -55), INT8_C(  63),
                           INT8_C( -38), INT8_C(  48), INT8_C(  56), INT8_C(-128),
                           INT8_C( -96), INT8_C( -24), INT8_C( -83), INT8_C(-108),
                           INT8_C(  54), INT8_C(  28), INT8_C(  -3), INT8_C(  68),
                           INT8_C(  11), INT8_C(  -6), INT8_C( -89), INT8_C(  10),
                           INT8_C(  46), INT8_C(-109), INT8_C(  46), INT8_C(  -5),
                           INT8_C(  89), INT8_C(  15), INT8_C(  89), INT8_C( 124),
                           INT8_C( -68), INT8_C( -68), INT8_C(  62), INT8_C(   5)),
      simde_mm256_set_epi8(INT8_C(-115), INT8_C(   0), INT8_C( -93), INT8_C(   0),
                           INT8_C(  61), INT8_C(   0), INT8_C(  14), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -93), INT8_C(   0),
                           INT8_C(  56), INT8_C(   0), INT8_C(   0), INT8_C( -79),
                           INT8_C( -77), INT8_C(  44), INT8_C(  90), INT8_C(   0),
                           INT8_C( -51), INT8_C(  48), INT8_C(   0), INT8_C( -15),
                           INT8_C(   0), INT8_C(  55), INT8_C(   0), INT8_C( -18),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT32_C(2285590888),
      simde_mm256_set_epi8(INT8_C( -11), INT8_C(  65), INT8_C(-119), INT8_C(  51),
                           INT8_C( -33), INT8_C( 126), INT8_C( -87), INT8_C( -81),
                           INT8_C(  -7), INT8_C(-105), INT8_C(  -7), INT8_C( -24),
                           INT8_C(  -7), INT8_C(  43), INT8_C(  89), INT8_C( 116),
                           INT8_C(  76), INT8_C( -69), INT8_C( -38), INT8_C( 109),
                           INT8_C(  35), INT8_C(  30), INT8_C(  19), INT8_C( -43),
                           INT8_C(  57), INT8_C( -65), INT8_C( -74), INT8_C(  55),
                           INT8_C( -77), INT8_C(  10), INT8_C( -78), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C(  64), INT8_C( 118), INT8_C( 102), INT8_C(  -9),
                           INT8_C(-124), INT8_C(   6), INT8_C( -90), INT8_C( 117),
                           INT8_C( -62), INT8_C(  60), INT8_C(  88), INT8_C( -59),
                           INT8_C(  32), INT8_C(  -2), INT8_C(   5), INT8_C(  91),
                           INT8_C( -41), INT8_C(  74), INT8_C(  -4), INT8_C(  18),
                           INT8_C(  42), INT8_C( 125), INT8_C(  -2), INT8_C(  93),
                           INT8_C( -35), INT8_C( -70), INT8_C(  95), INT8_C( -50),
                           INT8_C( -56), INT8_C( -79), INT8_C(  12), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C(   9), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -97), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -92), INT8_C( 125),
                           INT8_C(  18), INT8_C(   0), INT8_C(  38), INT8_C(  20),
                           INT8_C(   0), INT8_C( -51), INT8_C(   0), INT8_C(  80),
                           INT8_C(  73), INT8_C(   0), INT8_C(   0), INT8_C( 112),
                           INT8_C(   0), INT8_C( -51), INT8_C(  31), INT8_C(   0),
                           INT8_C( -92), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT32_C(2241497041),
      simde_mm256_set_epi8(INT8_C(  59), INT8_C( -12), INT8_C(   3), INT8_C(  -7),
                           INT8_C(-126), INT8_C( -43), INT8_C( -72), INT8_C(  85),
                           INT8_C( -18), INT8_C(  26), INT8_C( 113), INT8_C( -76),
                           INT8_C(  -9), INT8_C(  83), INT8_C(   1), INT8_C( -60),
                           INT8_C( -28), INT8_C( -90), INT8_C(  13), INT8_C( -79),
                           INT8_C( -86), INT8_C(  33), INT8_C( -41), INT8_C( 104),
                           INT8_C( -60), INT8_C( -11), INT8_C( 108), INT8_C(   4),
                           INT8_C(  14), INT8_C(  12), INT8_C(  33), INT8_C(  63)),
      simde_mm256_set_epi8(INT8_C(  70), INT8_C( -70), INT8_C( -65), INT8_C( -40),
                           INT8_C( -56), INT8_C( 122), INT8_C(  34), INT8_C(  73),
                           INT8_C(  72), INT8_C( 107), INT8_C( -32), INT8_C(  89),
                           INT8_C(  87), INT8_C(-114), INT8_C( -55), INT8_C( -35),
                           INT8_C(-101), INT8_C( -75), INT8_C(-120), INT8_C( -18),
                           INT8_C(-103), INT8_C(   8), INT8_C( -32), INT8_C(  18),
                           INT8_C(-106), INT8_C( 119), INT8_C( -99), INT8_C(  10),
                           INT8_C( -27), INT8_C( -28), INT8_C(  54), INT8_C(  13)),
      simde_mm256_set_epi8(INT8_C( -40), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-120), INT8_C(   0), INT8_C(  87),
                           INT8_C( -94), INT8_C(   0), INT8_C(   0), INT8_C(  52),
                           INT8_C(-109), INT8_C(   0), INT8_C( -55), INT8_C(   0),
                           INT8_C( -34), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  19), INT8_C(  86), INT8_C(  10),
                           INT8_C( -69), INT8_C( -76), INT8_C(   0), INT8_C(  40),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  32)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_maskz_gf2p8mul_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_gf2p8mul_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(  563128178629459346),
      simde_mm512_set_epi8(INT8_C( -18), INT8_C( 102), INT8_C(  52), INT8_C( -28),
                           INT8_C( -18), INT8_C(  37), INT8_C(-101), INT8_C( -22),
                           INT8_C( -18), INT8_C( -25), INT8_C( -40), INT8_C(  60),
                           INT8_C(  37), INT8_C(  31), INT8_C(  13), INT8_C( -86),
                           INT8_C( 118), INT8_C( 118), INT8_C(  10), INT8_C( 111),
                           INT8_C( -70), INT8_C( -98), INT8_C( -17), INT8_C(  17),
                           INT8_C( -87), INT8_C(  72), INT8_C(  94), INT8_C( -67),
                           INT8_C( 111), INT8_C(-117), INT8_C(  87), INT8_C( -37),
                           INT8_C(  72), INT8_C(-111), INT8_C( 127), INT8_C( 114),
                           INT8_C( -14), INT8_C(  52), INT8_C( -67), INT8_C(-107),
                           INT8_C(  33), INT8_C( -76), INT8_C( -61), INT8_C( -70),
                           INT8_C( -47), INT8_C( -46), INT8_C( -17), INT8_C(  -5),
                           INT8_C(  36), INT8_C(-122), INT8_C(  -2), INT8_C( 118),
                           INT8_C(-112), INT8_C(  86), INT8_C(   8), INT8_C(  36),
                           INT8_C( -62), INT8_C( 114), INT8_C(-111), INT8_C(   6),
                           INT8_C( -62), INT8_C(-114), INT8_C( -28), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C(  20), INT8_C( 112), INT8_C( -65), INT8_C(  63),
                           INT8_C( -38), INT8_C( -92), INT8_C(  35), INT8_C( -68),
                           INT8_C(  24), INT8_C(-112), INT8_C( 117), INT8_C( 120),
                           INT8_C( -74), INT8_C(  16), INT8_C(  14), INT8_C(  12),
                           INT8_C( -90), INT8_C(  66), INT8_C( 100), INT8_C(   3),
                           INT8_C( -62), INT8_C( -98), INT8_C(  63), INT8_C( 104),
                           INT8_C(  -1), INT8_C( -89), INT8_C( -83), INT8_C( -86),
                           INT8_C(  -3), INT8_C( -25), INT8_C( 115), INT8_C( -60),
                           INT8_C(-112), INT8_C( -70), INT8_C(  46), INT8_C(  98),
                           INT8_C(  -8), INT8_C(  89), INT8_C(  75), INT8_C(  90),
                           INT8_C( -71), INT8_C( -73), INT8_C( 118), INT8_C(  84),
                           INT8_C( -47), INT8_C( -14), INT8_C(-128), INT8_C( -85),
                           INT8_C( 101), INT8_C( -88), INT8_C( -62), INT8_C( -52),
                           INT8_C( 117), INT8_C(-103), INT8_C( 102), INT8_C( -43),
                           INT8_C(-120), INT8_C( 111), INT8_C(  -3), INT8_C( 122),
                           INT8_C( -66), INT8_C( -65), INT8_C( -88), INT8_C( 107)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  69), INT8_C(  80), INT8_C(  -7),
                           INT8_C(  83), INT8_C(  35), INT8_C(   0), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 126), INT8_C(   0), INT8_C( -59), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  20), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-121),
                           INT8_C( -63), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 113), INT8_C(   0), INT8_C(   0),
                           INT8_C( 108), INT8_C(   0), INT8_C( -41), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  13), INT8_C( -60),
                           INT8_C(  43), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-101), INT8_C(   0), INT8_C(  -3), INT8_C( -55),
                           INT8_C(-103), INT8_C( 127), INT8_C(   0), INT8_C(-100),
                           INT8_C(-122), INT8_C(   0), INT8_C(   0), INT8_C(   7),
                           INT8_C(   0), INT8_C(   0), INT8_C( -76), INT8_C(   0)) },
    { UINT64_C( 2181765975377201771),
      simde_mm512_set_epi8(INT8_C( -72), INT8_C( -88), INT8_C( -65), INT8_C(  59),
                           INT8_C(  13), INT8_C(  91), INT8_C( -20), INT8_C( -40),
                           INT8_C( -98), INT8_C( -43), INT8_C(  79), INT8_C( 111),
                           INT8_C(  73), INT8_C( -73), INT8_C(  96), INT8_C(  51),
                           INT8_C( -65), INT8_C( -70), INT8_C(   8), INT8_C(  49),
                           INT8_C( 105), INT8_C( -14), INT8_C(-119), INT8_C( 105),
                           INT8_C(   6), INT8_C(  79), INT8_C( -38), INT8_C(  73),
                           INT8_C(-120), INT8_C(  -3), INT8_C(  91), INT8_C(  88),
                           INT8_C( -77), INT8_C( -81), INT8_C( -18), INT8_C(  72),
                           INT8_C( -96), INT8_C(  15), INT8_C( -73), INT8_C( -59),
                           INT8_C(  -2), INT8_C( -52), INT8_C( -45), INT8_C(-122),
                           INT8_C(-110), INT8_C(  47), INT8_C(  73), INT8_C(  50),
                           INT8_C(  44), INT8_C(  40), INT8_C(  95), INT8_C(  89),
                           INT8_C( -46), INT8_C(  90), INT8_C(-119), INT8_C( 106),
                           INT8_C(-117), INT8_C( -78), INT8_C( -91), INT8_C(  30),
                           INT8_C( 102), INT8_C(-102), INT8_C(  93), INT8_C(   8)),
      simde_mm512_set_epi8(INT8_C(  98), INT8_C( -34), INT8_C(  92), INT8_C( 106),
                           INT8_C( -99), INT8_C( -55), INT8_C(  79), INT8_C( -90),
                           INT8_C( -71), INT8_C(  74), INT8_C(-102), INT8_C( 119),
                           INT8_C( -96), INT8_C(  34), INT8_C(  78), INT8_C(  73),
                           INT8_C(  57), INT8_C( -86), INT8_C( -53), INT8_C(  60),
                           INT8_C( -46), INT8_C(   9), INT8_C(  58), INT8_C( -42),
                           INT8_C(  -8), INT8_C(  70), INT8_C(-125), INT8_C( -42),
                           INT8_C(  80), INT8_C( 123), INT8_C( 112), INT8_C(  80),
                           INT8_C(  -4), INT8_C(  54), INT8_C(  48), INT8_C(   2),
                           INT8_C(  -2), INT8_C(-106), INT8_C(  35), INT8_C( -73),
                           INT8_C( 109), INT8_C(-128), INT8_C(  40), INT8_C( -16),
                           INT8_C(  58), INT8_C(-108), INT8_C(-128), INT8_C( -80),
                           INT8_C( -38), INT8_C(  49), INT8_C(  15), INT8_C(-105),
                           INT8_C(  26), INT8_C(   1), INT8_C(  70), INT8_C( -26),
                           INT8_C( -39), INT8_C( -82), INT8_C( -94), INT8_C(  41),
                           INT8_C( -39), INT8_C( -70), INT8_C( -64), INT8_C(  69)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C(  91), INT8_C( -26), INT8_C(-128), INT8_C(   0),
                           INT8_C(   0), INT8_C(-110), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 100), INT8_C(   5), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C(   2), INT8_C(  16),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  38), INT8_C(   0), INT8_C(   0), INT8_C(  45),
                           INT8_C(  35), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -19), INT8_C(   0), INT8_C(-112),
                           INT8_C(  23), INT8_C(   0), INT8_C(   0), INT8_C(  59),
                           INT8_C(   0), INT8_C(-115), INT8_C( -25), INT8_C(   0),
                           INT8_C(   0), INT8_C(  16), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -23), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -6), INT8_C(   0), INT8_C(  32), INT8_C(   0),
                           INT8_C(   0), INT8_C(  37), INT8_C( -79), INT8_C(   0),
                           INT8_C(  98), INT8_C(   0), INT8_C( -27), INT8_C(  30)) },
    { UINT64_C(10345383608333278604),
      simde_mm512_set_epi8(INT8_C( -16), INT8_C(-104), INT8_C(  52), INT8_C( -18),
                           INT8_C(  70), INT8_C( 121), INT8_C( 105), INT8_C(-111),
                           INT8_C(-105), INT8_C(  24), INT8_C(-109), INT8_C( 107),
                           INT8_C( -55), INT8_C( -18), INT8_C(  61), INT8_C(  62),
                           INT8_C(  80), INT8_C( -60), INT8_C(-118), INT8_C(  49),
                           INT8_C( -65), INT8_C( -46), INT8_C( -50), INT8_C(  -7),
                           INT8_C( -13), INT8_C(   7), INT8_C(  42), INT8_C(  64),
                           INT8_C(  71), INT8_C( -32), INT8_C(-113), INT8_C( 118),
                           INT8_C(  68), INT8_C( -74), INT8_C(  37), INT8_C( -72),
                           INT8_C(-103), INT8_C(  12), INT8_C( 101), INT8_C( -17),
                           INT8_C( 110), INT8_C(  57), INT8_C(-120), INT8_C( 103),
                           INT8_C(   9), INT8_C(  66), INT8_C( -12), INT8_C( 117),
                           INT8_C(   9), INT8_C(  24), INT8_C(  41), INT8_C( 102),
                           INT8_C(  28), INT8_C(  72), INT8_C(  46), INT8_C(  91),
                           INT8_C( -93), INT8_C( -58), INT8_C(-105), INT8_C(-111),
                           INT8_C(-104), INT8_C(  20), INT8_C( -29), INT8_C(  92)),
      simde_mm512_set_epi8(INT8_C(-108), INT8_C( 121), INT8_C(  26), INT8_C(  74),
                           INT8_C( 101), INT8_C(  96), INT8_C( -96), INT8_C( 102),
                           INT8_C(  -3), INT8_C(  34), INT8_C(-128), INT8_C(   1),
                           INT8_C( -84), INT8_C(  34), INT8_C(-107), INT8_C( -40),
                           INT8_C( -85), INT8_C( -12), INT8_C( -19), INT8_C(  68),
                           INT8_C( 109), INT8_C( 112), INT8_C( -23), INT8_C(  53),
                           INT8_C(  52), INT8_C(  15), INT8_C( -24), INT8_C( -97),
                           INT8_C(  52), INT8_C( -11), INT8_C( -32), INT8_C( -69),
                           INT8_C(-108), INT8_C( -89), INT8_C(   2), INT8_C( -73),
                           INT8_C(  16), INT8_C(  33), INT8_C(  25), INT8_C( -54),
                           INT8_C(  44), INT8_C( -79), INT8_C(  89), INT8_C(  43),
                           INT8_C(  76), INT8_C(  64), INT8_C(-106), INT8_C(  24),
                           INT8_C(-114), INT8_C( 120), INT8_C(  81), INT8_C(-120),
                           INT8_C(   9), INT8_C( 118), INT8_C( 115), INT8_C( 125),
                           INT8_C(  95), INT8_C(  78), INT8_C(  20), INT8_C( 120),
                           INT8_C( 108), INT8_C( -55), INT8_C(   0), INT8_C(  49)),
      simde_mm512_set_epi8(INT8_C( -48), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 109), INT8_C( -48), INT8_C(-123), INT8_C(-105),
                           INT8_C( -14), INT8_C(   0), INT8_C(   0), INT8_C( 107),
                           INT8_C(   0), INT8_C(   0), INT8_C( -99), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(   0),
                           INT8_C( -28), INT8_C(-128), INT8_C(-111), INT8_C(  43),
                           INT8_C(   1), INT8_C(   0), INT8_C(   0), INT8_C( -52),
                           INT8_C(   0), INT8_C(-110), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -38), INT8_C(   0), INT8_C(  31),
                           INT8_C(  83), INT8_C(-105), INT8_C( 106), INT8_C(-110),
                           INT8_C(-111), INT8_C( 122), INT8_C(   0), INT8_C( -24),
                           INT8_C(  26), INT8_C(   0), INT8_C(  69), INT8_C(   0),
                           INT8_C(-110), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C(  -4), INT8_C(  25), INT8_C(   0), INT8_C( -95),
                           INT8_C( -96), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 107), INT8_C(  45), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 8690992657061241782),
      simde_mm512_set_epi8(INT8_C( 108), INT8_C( -46), INT8_C( -39), INT8_C(  38),
                           INT8_C(  25), INT8_C( -15), INT8_C( -31), INT8_C( 123),
                           INT8_C( -79), INT8_C(  58), INT8_C(  29), INT8_C( -40),
                           INT8_C(  58), INT8_C( -58), INT8_C( 101), INT8_C( -19),
                           INT8_C( -10), INT8_C( -73), INT8_C(-128), INT8_C( -74),
                           INT8_C( -14), INT8_C(  95), INT8_C(  63), INT8_C( -17),
                           INT8_C( -47), INT8_C(  19), INT8_C(  -5), INT8_C( -48),
                           INT8_C(-125), INT8_C(  -6), INT8_C(  73), INT8_C(   9),
                           INT8_C( 107), INT8_C( 124), INT8_C(   5), INT8_C( -88),
                           INT8_C(  49), INT8_C( 112), INT8_C( -22), INT8_C( 107),
                           INT8_C(  32), INT8_C(-108), INT8_C(  54), INT8_C(-109),
                           INT8_C( 100), INT8_C(  59), INT8_C( -18), INT8_C( -24),
                           INT8_C(-102), INT8_C( 122), INT8_C(   8), INT8_C( -47),
                           INT8_C( 124), INT8_C(  30), INT8_C( -80), INT8_C(  14),
                           INT8_C( -74), INT8_C(  37), INT8_C( -30), INT8_C( -99),
                           INT8_C( -11), INT8_C(   8), INT8_C(  44), INT8_C( -78)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C( -68), INT8_C(-119), INT8_C( -42),
                           INT8_C( -49), INT8_C(-118), INT8_C( -65), INT8_C( -79),
                           INT8_C( -54), INT8_C( 103), INT8_C(  16), INT8_C(  75),
                           INT8_C(   9), INT8_C( -19), INT8_C( 116), INT8_C(-100),
                           INT8_C(-118), INT8_C( -38), INT8_C( -33), INT8_C(  20),
                           INT8_C( -91), INT8_C(   3), INT8_C(  -9), INT8_C(-109),
                           INT8_C( -49), INT8_C(  87), INT8_C(  38), INT8_C(  52),
                           INT8_C( -86), INT8_C(  11), INT8_C(-111), INT8_C(  41),
                           INT8_C( -51), INT8_C( 101), INT8_C( -93), INT8_C( -14),
                           INT8_C(  16), INT8_C( -59), INT8_C(  17), INT8_C(  83),
                           INT8_C(  68), INT8_C( 119), INT8_C( -56), INT8_C(  85),
                           INT8_C(   3), INT8_C(  25), INT8_C(  87), INT8_C(  34),
                           INT8_C( -18), INT8_C(  -1), INT8_C(  16), INT8_C( -68),
                           INT8_C(-125), INT8_C(  -4), INT8_C( -85), INT8_C( -94),
                           INT8_C( -56), INT8_C(-108), INT8_C( -53), INT8_C( -32),
                           INT8_C(  19), INT8_C(  29), INT8_C(-121), INT8_C(  55)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  49), INT8_C( -88), INT8_C(  71),
                           INT8_C( -87), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  86), INT8_C(   0), INT8_C(   0), INT8_C(  85),
                           INT8_C( -15), INT8_C( -83), INT8_C(   0), INT8_C(   0),
                           INT8_C(-113), INT8_C(   0), INT8_C(   0), INT8_C( 123),
                           INT8_C( -63), INT8_C(   0), INT8_C(  42), INT8_C( -27),
                           INT8_C(-106), INT8_C(  -2), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-124), INT8_C(  20), INT8_C(   0),
                           INT8_C(   0), INT8_C( -68), INT8_C(   0), INT8_C(   7),
                           INT8_C(   0), INT8_C(-118), INT8_C(   0), INT8_C( -46),
                           INT8_C(  88), INT8_C(   0), INT8_C( -38), INT8_C(   0),
                           INT8_C( -84), INT8_C(   0), INT8_C(   0), INT8_C( -49),
                           INT8_C( -87), INT8_C(  88), INT8_C(-128), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  36), INT8_C(-122),
                           INT8_C(  97), INT8_C(   0), INT8_C( -75), INT8_C( -14),
                           INT8_C(   0), INT8_C( -24), INT8_C(  53), INT8_C(   0)) },
    { UINT64_C(  524532266746496782),
      simde_mm512_set_epi8(INT8_C(-114), INT8_C(  83), INT8_C(   4), INT8_C( 120),
                           INT8_C(-113), INT8_C(  -9), INT8_C(-110), INT8_C(  26),
                           INT8_C( -55), INT8_C(-124), INT8_C(  92), INT8_C( -58),
                           INT8_C( -61), INT8_C( -48), INT8_C(  87), INT8_C(-111),
                           INT8_C(-125), INT8_C( -44), INT8_C( -30), INT8_C(  87),
                           INT8_C( -96), INT8_C( -49), INT8_C(-116), INT8_C( -48),
                           INT8_C(  73), INT8_C( -23), INT8_C(  32), INT8_C( -54),
                           INT8_C( -76), INT8_C( -15), INT8_C( 122), INT8_C( -84),
                           INT8_C(  95), INT8_C(-105), INT8_C(  21), INT8_C(  44),
                           INT8_C( 115), INT8_C( -40), INT8_C(  21), INT8_C(-128),
                           INT8_C( -83), INT8_C(  22), INT8_C( -84), INT8_C( -21),
                           INT8_C( -15), INT8_C(  15), INT8_C(  -1), INT8_C( -79),
                           INT8_C(  97), INT8_C( 116), INT8_C( -66), INT8_C(  17),
                           INT8_C(  39), INT8_C( -92), INT8_C(  46), INT8_C( -87),
                           INT8_C( 114), INT8_C(  77), INT8_C( 119), INT8_C( -79),
                           INT8_C(  99), INT8_C( -92), INT8_C( -13), INT8_C( -32)),
      simde_mm512_set_epi8(INT8_C(  99), INT8_C(  77), INT8_C( -25), INT8_C( -30),
                           INT8_C( 118), INT8_C( -65), INT8_C(  57), INT8_C(  84),
                           INT8_C(  75), INT8_C(  -7), INT8_C(  13), INT8_C(  86),
                           INT8_C(  51), INT8_C(  -2), INT8_C(  37), INT8_C( 103),
                           INT8_C( -36), INT8_C(  90), INT8_C( -86), INT8_C( -68),
                           INT8_C( 118), INT8_C(  76), INT8_C( -81), INT8_C( -69),
                           INT8_C( -18), INT8_C(  -3), INT8_C( -24), INT8_C(  44),
                           INT8_C(  49), INT8_C( -57), INT8_C(   3), INT8_C( -46),
                           INT8_C(  -4), INT8_C(-105), INT8_C( -32), INT8_C( -12),
                           INT8_C(-108), INT8_C(  10), INT8_C(  65), INT8_C( -56),
                           INT8_C( -22), INT8_C(-125), INT8_C(  27), INT8_C(  91),
                           INT8_C(-121), INT8_C(  13), INT8_C(   3), INT8_C(  85),
                           INT8_C( -67), INT8_C(  62), INT8_C(   9), INT8_C(  59),
                           INT8_C( -12), INT8_C(-126), INT8_C(  89), INT8_C(  92),
                           INT8_C(  27), INT8_C( 109), INT8_C(  81), INT8_C( 124),
                           INT8_C( -26), INT8_C(-124), INT8_C(  97), INT8_C( -76)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  35), INT8_C(  80), INT8_C(   9),
                           INT8_C(   0), INT8_C(-127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  99), INT8_C(  30), INT8_C(   6),
                           INT8_C(  42), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( 117), INT8_C(  84),
                           INT8_C(   0), INT8_C(-121), INT8_C(   0), INT8_C(  39),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -66),
                           INT8_C(   0), INT8_C(-108), INT8_C(   0), INT8_C(   0),
                           INT8_C(   3), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  49), INT8_C(   0), INT8_C( -42), INT8_C(   0),
                           INT8_C(   0), INT8_C(  75), INT8_C(  26), INT8_C(  31),
                           INT8_C(  99), INT8_C( -83), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  84), INT8_C( -26), INT8_C(  48),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  75), INT8_C( -95), INT8_C(  40), INT8_C(   0)) },
    { UINT64_C(11088747391775221819),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C(  68), INT8_C( -36), INT8_C(  40),
                           INT8_C(  -7), INT8_C(  57), INT8_C( -45), INT8_C( -65),
                           INT8_C(  90), INT8_C(  -9), INT8_C( -50), INT8_C(-111),
                           INT8_C( -42), INT8_C(  56), INT8_C( 101), INT8_C( -20),
                           INT8_C( 109), INT8_C(  99), INT8_C(  45), INT8_C( -70),
                           INT8_C( 109), INT8_C(  24), INT8_C( -93), INT8_C(  76),
                           INT8_C( -69), INT8_C(  30), INT8_C(  82), INT8_C(  53),
                           INT8_C( 109), INT8_C(-114), INT8_C(  13), INT8_C( 106),
                           INT8_C( -49), INT8_C(  -1), INT8_C(  83), INT8_C(  64),
                           INT8_C( -87), INT8_C( 113), INT8_C(-107), INT8_C(-124),
                           INT8_C( -84), INT8_C( -86), INT8_C( -69), INT8_C(  17),
                           INT8_C(  21), INT8_C(   0), INT8_C(-112), INT8_C(-124),
                           INT8_C( -36), INT8_C(  67), INT8_C(  -3), INT8_C( -91),
                           INT8_C( -58), INT8_C(  40), INT8_C( -55), INT8_C(  -7),
                           INT8_C( -26), INT8_C(  33), INT8_C( -53), INT8_C(-109),
                           INT8_C( -74), INT8_C( -52), INT8_C(  35), INT8_C(  74)),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C( -16), INT8_C( -61), INT8_C(   8),
                           INT8_C( 123), INT8_C( -86), INT8_C( 101), INT8_C( 111),
                           INT8_C( -22), INT8_C(  66), INT8_C( -59), INT8_C(  41),
                           INT8_C( -88), INT8_C(   9), INT8_C(  -2), INT8_C(  40),
                           INT8_C(  16), INT8_C(   2), INT8_C( -72), INT8_C(  92),
                           INT8_C(   5), INT8_C(  -1), INT8_C(  68), INT8_C(  57),
                           INT8_C( 119), INT8_C( -69), INT8_C( 106), INT8_C(  93),
                           INT8_C( 103), INT8_C( -78), INT8_C( -70), INT8_C( -37),
                           INT8_C(  86), INT8_C(  88), INT8_C( -70), INT8_C(  62),
                           INT8_C( -82), INT8_C(  -3), INT8_C( 127), INT8_C( -76),
                           INT8_C(-120), INT8_C(  11), INT8_C(  -6), INT8_C( 106),
                           INT8_C( -38), INT8_C(-103), INT8_C( -23), INT8_C( -21),
                           INT8_C( -37), INT8_C(  33), INT8_C(  -5), INT8_C( -21),
                           INT8_C(-105), INT8_C( -10), INT8_C( -36), INT8_C(-101),
                           INT8_C( -57), INT8_C( -56), INT8_C( -24), INT8_C( 100),
                           INT8_C( -47), INT8_C( 113), INT8_C( -88), INT8_C( -75)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(   0), INT8_C(   0), INT8_C(  91),
                           INT8_C( -90), INT8_C(   0), INT8_C(   0), INT8_C(-127),
                           INT8_C( 116), INT8_C( 124), INT8_C(   6), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  38), INT8_C( -91),
                           INT8_C(   0), INT8_C(   0), INT8_C(  51), INT8_C(   0),
                           INT8_C(   0), INT8_C( -48), INT8_C(   0), INT8_C( -11),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -37), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -59), INT8_C(   0), INT8_C( -42), INT8_C(   0),
                           INT8_C( 124), INT8_C( -62), INT8_C(   0), INT8_C(   0),
                           INT8_C(-112), INT8_C(   0), INT8_C(   0), INT8_C(  10),
                           INT8_C(   0), INT8_C(   0), INT8_C(  47), INT8_C(   0),
                           INT8_C(  74), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  58), INT8_C( 102),
                           INT8_C(-123), INT8_C(   0), INT8_C(  63), INT8_C(  12)) },
    { UINT64_C( 8965231002922847986),
      simde_mm512_set_epi8(INT8_C(  41), INT8_C( -56), INT8_C( -91), INT8_C(  45),
                           INT8_C(  74), INT8_C(-122), INT8_C( 117), INT8_C( -40),
                           INT8_C( -25), INT8_C( -60), INT8_C( -35), INT8_C(  54),
                           INT8_C( -44), INT8_C( -13), INT8_C( -32), INT8_C(  25),
                           INT8_C( -25), INT8_C( -95), INT8_C( -11), INT8_C(  75),
                           INT8_C( -45), INT8_C( -97), INT8_C(-128), INT8_C( 103),
                           INT8_C( -59), INT8_C( -93), INT8_C( -10), INT8_C( -86),
                           INT8_C(-109), INT8_C( 100), INT8_C( -78), INT8_C(  46),
                           INT8_C(  68), INT8_C(-102), INT8_C(-120), INT8_C( 114),
                           INT8_C(-115), INT8_C( -50), INT8_C( -78), INT8_C( -74),
                           INT8_C(  15), INT8_C( 121), INT8_C(-126), INT8_C(  49),
                           INT8_C(-101), INT8_C(  86), INT8_C( -39), INT8_C( -38),
                           INT8_C(  88), INT8_C( 114), INT8_C( 112), INT8_C(  44),
                           INT8_C(  69), INT8_C( -15), INT8_C( -95), INT8_C( -87),
                           INT8_C(  66), INT8_C( 105), INT8_C( -16), INT8_C( -88),
                           INT8_C( -15), INT8_C( -82), INT8_C( 102), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(   7), INT8_C( -68), INT8_C(-100), INT8_C( -35),
                           INT8_C( 107), INT8_C(  69), INT8_C( -57), INT8_C(  95),
                           INT8_C(  88), INT8_C( -70), INT8_C(-117), INT8_C(  33),
                           INT8_C(-104), INT8_C( -98), INT8_C(  31), INT8_C( -37),
                           INT8_C(-115), INT8_C(  11), INT8_C(  44), INT8_C(  74),
                           INT8_C( -24), INT8_C(  49), INT8_C( -72), INT8_C( -55),
                           INT8_C( -44), INT8_C( -40), INT8_C(  16), INT8_C(  -5),
                           INT8_C(   8), INT8_C(  25), INT8_C(  46), INT8_C(  95),
                           INT8_C( -76), INT8_C(-109), INT8_C(  22), INT8_C( -82),
                           INT8_C(  81), INT8_C( -64), INT8_C(  26), INT8_C( -23),
                           INT8_C(  89), INT8_C(  25), INT8_C(  -6), INT8_C(-121),
                           INT8_C(  17), INT8_C( -11), INT8_C(   3), INT8_C(   7),
                           INT8_C( 119), INT8_C(  -5), INT8_C(  23), INT8_C( -59),
                           INT8_C( -12), INT8_C(  76), INT8_C( -47), INT8_C(  85),
                           INT8_C(  94), INT8_C(-125), INT8_C(  -3), INT8_C( -36),
                           INT8_C(  97), INT8_C(  -2), INT8_C(  33), INT8_C( 108)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -16), INT8_C( -60), INT8_C( -56),
                           INT8_C(  38), INT8_C( 126), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(  27), INT8_C(   0),
                           INT8_C(  44), INT8_C(   0), INT8_C(  85), INT8_C(   0),
                           INT8_C(  -2), INT8_C(-121), INT8_C(-103), INT8_C(   0),
                           INT8_C(   0), INT8_C( -54), INT8_C(-123), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 117),
                           INT8_C( -12), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   4), INT8_C( -29), INT8_C(  69), INT8_C(   0),
                           INT8_C( -91), INT8_C(   0), INT8_C(  77), INT8_C(   0),
                           INT8_C( 106), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -24), INT8_C(   0), INT8_C(   0), INT8_C(  48),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  64), INT8_C(  50), INT8_C(  59), INT8_C(   0),
                           INT8_C( -42), INT8_C( -79), INT8_C(-102), INT8_C(  49),
                           INT8_C(   0), INT8_C(   0), INT8_C(  18), INT8_C(   0)) },
    { UINT64_C(12281436803553867002),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -68), INT8_C(  76), INT8_C( -42),
                           INT8_C( -94), INT8_C( -89), INT8_C(-100), INT8_C(  77),
                           INT8_C( 115), INT8_C( 103), INT8_C( 102), INT8_C( -67),
                           INT8_C( 110), INT8_C( -50), INT8_C(  -7), INT8_C( -51),
                           INT8_C(  62), INT8_C( 120), INT8_C(  63), INT8_C( -65),
                           INT8_C( -72), INT8_C( 111), INT8_C( -11), INT8_C( -35),
                           INT8_C(  67), INT8_C( -48), INT8_C( -29), INT8_C( -80),
                           INT8_C( 107), INT8_C( -37), INT8_C(  38), INT8_C( -54),
                           INT8_C(  34), INT8_C(  80), INT8_C( -47), INT8_C(  84),
                           INT8_C(  76), INT8_C(-111), INT8_C( 126), INT8_C(  94),
                           INT8_C( 105), INT8_C( 103), INT8_C(  19), INT8_C( -95),
                           INT8_C( 110), INT8_C(  48), INT8_C(  58), INT8_C( -16),
                           INT8_C(  64), INT8_C(  97), INT8_C(  74), INT8_C( 117),
                           INT8_C(-108), INT8_C( -89), INT8_C(  30), INT8_C(   8),
                           INT8_C( -15), INT8_C( -36), INT8_C( -53), INT8_C( -86),
                           INT8_C( 115), INT8_C( 102), INT8_C(  23), INT8_C(  50)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  57), INT8_C(  -7), INT8_C( -33),
                           INT8_C( -50), INT8_C(  52), INT8_C( -77), INT8_C( 103),
                           INT8_C(  96), INT8_C(  14), INT8_C(  62), INT8_C(-117),
                           INT8_C(  25), INT8_C( 126), INT8_C(  71), INT8_C( -60),
                           INT8_C(  92), INT8_C( -34), INT8_C(-107), INT8_C( -83),
                           INT8_C(-117), INT8_C(-107), INT8_C(  48), INT8_C( 123),
                           INT8_C(  -3), INT8_C( 100), INT8_C( -20), INT8_C(  48),
                           INT8_C( -43), INT8_C( 120), INT8_C(  88), INT8_C( -88),
                           INT8_C(  46), INT8_C( 112), INT8_C( -72), INT8_C( -77),
                           INT8_C(  11), INT8_C(  21), INT8_C(  18), INT8_C(  38),
                           INT8_C( 121), INT8_C(  83), INT8_C(  92), INT8_C(  66),
                           INT8_C(  84), INT8_C(   8), INT8_C(  -4), INT8_C(-110),
                           INT8_C( -81), INT8_C( 108), INT8_C( -16), INT8_C(  70),
                           INT8_C( -25), INT8_C(  27), INT8_C(  14), INT8_C(  59),
                           INT8_C( 104), INT8_C(  34), INT8_C( 111), INT8_C( 122),
                           INT8_C( -81), INT8_C( -30), INT8_C( 115), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C( -46), INT8_C(   0), INT8_C( 100), INT8_C(   0),
                           INT8_C( -71), INT8_C(   0), INT8_C( -94), INT8_C(   0),
                           INT8_C(   0), INT8_C(  92), INT8_C(  28), INT8_C( 112),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  92), INT8_C( -84), INT8_C(   0),
                           INT8_C( -31), INT8_C(  69), INT8_C(   0), INT8_C( -88),
                           INT8_C(  35), INT8_C(   0), INT8_C( -98), INT8_C(   4),
                           INT8_C(   0), INT8_C(   0), INT8_C(  62), INT8_C(-126),
                           INT8_C( -21), INT8_C(  94), INT8_C(-121), INT8_C(   6),
                           INT8_C(   0), INT8_C(  48), INT8_C(  93), INT8_C( -22),
                           INT8_C(   0), INT8_C(   0), INT8_C(  83), INT8_C(-116),
                           INT8_C( -57), INT8_C(-101), INT8_C(   0), INT8_C(   0),
                           INT8_C( 120), INT8_C(   0), INT8_C( 104), INT8_C(  97),
                           INT8_C(   0), INT8_C(  35), INT8_C(   0), INT8_C(   0),
                           INT8_C( -46), INT8_C( 125), INT8_C(  93), INT8_C(-103),
                           INT8_C( -80), INT8_C(   0), INT8_C(  51), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_gf2p8mul_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

#endif // armel clang skip

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm_gf2p8affine_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_gf2p8affine_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_gf2p8affine_epi64_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_mask_gf2p8affine_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_mask_gf2p8affine_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_gf2p8affine_epi64_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_maskz_gf2p8affine_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_maskz_gf2p8affine_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_gf2p8affine_epi64_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_gf2p8affineinv_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_gf2p8affineinv_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_gf2p8affineinv_epi64_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_mask_gf2p8affineinv_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_mask_gf2p8affineinv_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_gf2p8affineinv_epi64_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_maskz_gf2p8affineinv_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_maskz_gf2p8affineinv_epi64_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_gf2p8affineinv_epi64_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_gf2p8mul_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_gf2p8mul_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_gf2p8mul_epi8)

  #if !(defined(__clang__) && defined(__arm__) && defined(__ARM_EABI__) && !defined(__ARM_PCS_VFP))
  SIMDE_TEST_FUNC_LIST_ENTRY(mm_mask_gf2p8mul_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_mask_gf2p8mul_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_gf2p8mul_epi8)

  SIMDE_TEST_FUNC_LIST_ENTRY(mm_maskz_gf2p8mul_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm256_maskz_gf2p8mul_epi8)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_maskz_gf2p8mul_epi8)
  #endif
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/test-x86-footer.h>
