/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.macro.Macro;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class LineConstructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    ConstructionObject O;
    boolean Fix;
    boolean ShowsValue;
    boolean ShowsName;
    boolean Moved;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else {
            this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P2 != null) {
                if (this.P2 == this.P1) {
                    this.P2 = null;
                    return;
                }
                ConstructionObject constructionObject = this.create(zirkelCanvas.getConstruction(), this.P1, this.P2);
                zirkelCanvas.addObject(constructionObject);
                constructionObject.setDefaults();
                boolean bl = this.Fix = mouseEvent.isShiftDown() || this.isFixed();
                if (this.P2.moveable() && !this.P2.isPointOn() && zirkelCanvas.isNewPoint()) {
                    this.Dragging = true;
                    this.Moved = false;
                    this.O = constructionObject;
                    this.ShowsValue = constructionObject.showValue();
                    this.ShowsName = constructionObject.showName();
                    if (this.Fix && Global.getParameter("options.movefixname", true) || !this.Fix && Global.getParameter("options.movename", false)) {
                        constructionObject.setShowValue(true);
                        constructionObject.setShowName(true);
                    }
                } else {
                    this.Dragging = false;
                    if (this.Fix) {
                        this.setFixed(zirkelCanvas, constructionObject);
                    }
                    this.P2 = null;
                    this.P1 = null;
                    zirkelCanvas.clearSelected();
                    this.showStatus(zirkelCanvas);
                }
            } else {
                this.Dragging = false;
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 == null;
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
        if (this.P2 != null) {
            ConstructionObject constructionObject = this.create(zirkelCanvas.getConstruction(), this.P1, this.P2);
            zirkelCanvas.addObject(constructionObject);
            constructionObject.setDefaults();
            zirkelCanvas.validate();
            zirkelCanvas.repaint();
            this.P2 = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.Moved = true;
        this.P2.move(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.setShowValue(this.ShowsValue);
        this.O.setShowName(this.ShowsName);
        if (this.Fix) {
            this.O.round();
        }
        zirkelCanvas.repaint();
        if (this.Fix && !this.Moved) {
            this.setFixed(zirkelCanvas, this.O);
        }
        this.reset(zirkelCanvas);
    }

    public boolean isFixed() {
        return false;
    }

    public void setFixed(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
    }

    public PointObject select(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectCreatePoint(n, n2);
    }

    public ConstructionObject create(Construction construction, PointObject pointObject, PointObject pointObject2) {
        return new LineObject(construction, pointObject, pointObject2);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            zirkelCanvas.setPrompt(this.getPrompt());
        } else {
            zirkelCanvas.clearSelected();
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zirkelCanvas);
        }
    }

    public String getPrompt() {
        return Zirkel.name("prompt.line");
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.line.first", "Line: Set the first point!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.line.second", "Line: Set the second point!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Line")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("from") || !xmlTag.hasParam("to")) {
            if (!(construction instanceof Macro)) {
                throw new ConstructionException("Line points missing!");
            }
            PrimitiveLineObject primitiveLineObject = new PrimitiveLineObject(construction);
            this.setName(xmlTag, primitiveLineObject);
            this.set(xmlTree, primitiveLineObject);
            construction.add(primitiveLineObject);
            this.setConditionals(xmlTree, construction, primitiveLineObject);
        } else {
            try {
                PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("from"));
                PointObject pointObject2 = (PointObject)construction.find(xmlTag.getValue("to"));
                LineObject lineObject = new LineObject(construction, pointObject, pointObject2);
                if (xmlTag.hasParam("partial")) {
                    lineObject.setPartial(true);
                }
                this.setName(xmlTag, lineObject);
                this.set(xmlTree, lineObject);
                construction.add(lineObject);
                this.setConditionals(xmlTree, construction, lineObject);
            }
            catch (ConstructionException constructionException) {
                throw constructionException;
            }
            catch (Exception exception) {
                throw new ConstructionException("Line points illegal!");
            }
        }
        return true;
    }

    public String getTag() {
        return "Line";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[1]);
        }
        if (!(constructionObject instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        LineObject lineObject = new LineObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
        construction.add(lineObject);
        lineObject.setDefaults();
        if (!string.equals("")) {
            lineObject.setNameCheck(string);
        }
    }
}

