# SPDX-License-Identifier: Apache-2.0
# Copyright (C) 2023-2025, Advanced Micro Devices, Inc. All rights reserved.

execute_process(
  COMMAND awk -F= "$1==\"ID\" {print $2}" /etc/os-release
  COMMAND tr -d "\""
  OUTPUT_VARIABLE XDNA_CPACK_LINUX_FLAVOR
  OUTPUT_STRIP_TRAILING_WHITESPACE
  )

if ("${XDNA_CPACK_LINUX_FLAVOR}" MATCHES "^(ubuntu)")
  execute_process(
    COMMAND dpkg --print-architecture
    OUTPUT_VARIABLE XDNA_CPACK_ARCH
    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
else("${XDNA_CPACK_LINUX_FLAVOR}" MATCHES "^(ubuntu)")
  execute_process(
    COMMAND uname -m
    OUTPUT_VARIABLE XDNA_CPACK_ARCH
    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
endif("${XDNA_CPACK_LINUX_FLAVOR}" MATCHES "^(ubuntu)")

execute_process(
  COMMAND awk -F= "$1==\"VERSION_ID\" {print $2}" /etc/os-release
  COMMAND tr -d "\""
  OUTPUT_VARIABLE XDNA_CPACK_LINUX_VERSION
  OUTPUT_STRIP_TRAILING_WHITESPACE
  )
execute_process(
  COMMAND bash -c "source /etc/os-release && echo \"\$ID \$ID_LIKE\""
  OUTPUT_VARIABLE XDNA_CPACK_LINUX_PKG_FLAVOR
  OUTPUT_STRIP_TRAILING_WHITESPACE
  )
execute_process(
  COMMAND echo ${XRT_VERSION_STRING}
  COMMAND awk -F. "{print $1}"
  OUTPUT_VARIABLE CPACK_PACKAGE_VERSION_MAJOR
  OUTPUT_STRIP_TRAILING_WHITESPACE
  )
execute_process(
  COMMAND echo ${XRT_VERSION_STRING}
  COMMAND awk -F. "{print $2}"
  OUTPUT_VARIABLE CPACK_PACKAGE_VERSION_MINOR
  OUTPUT_STRIP_TRAILING_WHITESPACE
  )

set(XRT_PLUGIN_VERSION_STRING
  ${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${XRT_PLUGIN_VERSION_PATCH})
set(CPACK_SET_DESTDIR ON)
set(CPACK_COMPONENTS_ALL ${XDNA_COMPONENT})
set(CPACK_PACKAGE_VENDOR "AMD Inc")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "XDNA driver plugin for Xilinx RunTime")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/xrt/LICENSE")
set(CPACK_PACKAGE_CONTACT "max.zhen@amd.com")
set(CPACK_PACKAGE_NAME "xrt_plugin")
set(CPACK_PACKAGE_FILE_NAME
  "${CPACK_PACKAGE_NAME}.${XRT_PLUGIN_VERSION_STRING}_${XDNA_CPACK_LINUX_VERSION}-${XDNA_CPACK_ARCH}")
math(EXPR next_minor "${CPACK_PACKAGE_VERSION_MINOR} + 1")
set(XDNA_CPACK_XRT_BASE_VERSION ${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR})
set(XDNA_CPACK_XRT_BASE_NEXT_VERSION ${CPACK_PACKAGE_VERSION_MAJOR}.${next_minor})

install(DIRECTORY ${AMDXDNA_BINS_DIR}/download_raw/xbutil_validate/bins/
  DESTINATION ${XDNA_PKG_DATA_DIR}/bins
  COMPONENT ${XDNA_COMPONENT}
  FILES_MATCHING
  PATTERN "*.xclbin"
  PATTERN "*.txt"
  PATTERN "*.elf"
  PATTERN "*.bin"
  PATTERN "*.json"
  PATTERN "*.yaml"
  )

# VTD archives are downloaded by build script based on info.json configuration
set(VTD_ARCHIVES_DIR "${CMAKE_CURRENT_BINARY_DIR}/../amdxdna_bins/vtd_archives")
message(STATUS "Using VTD archives from ${VTD_ARCHIVES_DIR}")

install(DIRECTORY ${VTD_ARCHIVES_DIR}/
  DESTINATION ${XDNA_PKG_DATA_DIR}/bins
  COMPONENT ${XDNA_COMPONENT}
  FILES_MATCHING
  PATTERN "*.a"
  )

if(NOT SKIP_KMOD)

install(DIRECTORY ${AMDXDNA_BINS_DIR}/firmware/
  DESTINATION ${XDNA_PKG_FW_DIR}
  COMPONENT ${XDNA_COMPONENT}
  FILES_MATCHING
  PATTERN "*.sbin"
  PATTERN "download_raw" EXCLUDE
  )

if(XDNA_DRV_PF_SRC_DIR)
  set(PF_RMMOD "rmmod amdxdna_pf > /dev/null 2>&1")
  set(PF_DBG_INSMOD "modprobe amdxdna_pf dyndbg=+pf")
  set(PF_INSMOD "modprobe amdxdna_pf")
endif(XDNA_DRV_PF_SRC_DIR)

configure_file(
  ${CMAKE_CURRENT_SOURCE_DIR}/CMake/config/postinst.in
  ${CMAKE_CURRENT_BINARY_DIR}/package/postinst
  @ONLY
  )
configure_file(
  ${CMAKE_CURRENT_SOURCE_DIR}/CMake/config/prerm.in
  ${CMAKE_CURRENT_BINARY_DIR}/package/prerm
  @ONLY
  )

endif(NOT SKIP_KMOD)

if("${XDNA_CPACK_LINUX_PKG_FLAVOR}" MATCHES "debian")
  set(CPACK_GENERATOR "DEB")
  set(CPACK_DEB_COMPONENT_INSTALL ON)
  set(CPACK_DEBIAN_PACKAGE_DEPENDS "xrt-base (>= ${XDNA_CPACK_XRT_BASE_VERSION}), xrt-base (<< ${XDNA_CPACK_XRT_BASE_NEXT_VERSION})")
  if(NOT SKIP_KMOD)
    set(CPACK_DEBIAN_PACKAGE_CONTROL_EXTRA "${CMAKE_CURRENT_BINARY_DIR}/package/postinst"
      "${CMAKE_CURRENT_BINARY_DIR}/package/prerm")
  endif()
elseif("${XDNA_CPACK_LINUX_PKG_FLAVOR}" MATCHES "fedora")
  set(CPACK_GENERATOR "RPM")
  set(CPACK_RPM_COMPONENT_INSTALL ON)
  set(CPACK_RPM_PACKAGE_REQUIRES "xrt-base >= ${XDNA_CPACK_XRT_BASE_VERSION}, xrt-base < ${XDNA_CPACK_XRT_BASE_NEXT_VERSION}")
  if(NOT SKIP_KMOD)
    set(CPACK_RPM_POST_INSTALL_SCRIPT_FILE "${CMAKE_CURRENT_BINARY_DIR}/package/postinst")
    set(CPACK_RPM_PRE_UNINSTALL_SCRIPT_FILE "${CMAKE_CURRENT_BINARY_DIR}/package/prerm")
  endif()
else("${XDNA_CPACK_LINUX_PKG_FLAVOR}" MATCHES "debian")
  message(WARNING "Unknown Linux package flavor: ${XDNA_CPACK_LINUX_PKG_FLAVOR}")
endif("${XDNA_CPACK_LINUX_PKG_FLAVOR}" MATCHES "debian")

include(CPack)
