/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "ExtensionTabPresenter.h"

#include "QtPropertyFieldEditor.h"
#include "TextFieldEditor.h"

// -------------------- constructor --------------------
ExtensionTabPresenter::ExtensionTabPresenter(CamiTKExtensionModelPresenter* presenter, VariantDataModel& dataModel, QWidget* parent) : QScrollArea(parent) {
    QWidget* container = new QWidget(parent);

    setWidget(container);
    setWidgetResizable(true);
    setStyleSheet("QScrollArea { background-color: palette(button); }");

    extensionTabLayout = new QGridLayout(container);
    extensionTabLayout->setContentsMargins(0, 0, 0, 0);

    QtPropertyFieldEditor* qtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["name"], "Name", "Name of the extension (cannot be modified interactively).");
    qtPropertyFieldEditor->setReadOnly(true); // name is read only as consequences of modifying names on the fly are hard to manage
    qtPropertyFieldEditor->appendRowTo(extensionTabLayout);

    TextFieldEditor* textFieldEditor = new TextFieldEditor(presenter, dataModel["description"], "Description", "Description of the extension.");
    textFieldEditor->appendRowTo(extensionTabLayout);

    QStringList licenseEnum = {"LGPL-3 CamiTK", "LGPL-3", "GPL-3", "BSD"};
    qtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["license"], "License", "Source code license. You can choose one of the known licenses or edit the last combo box item to add your own.", "LGPL-3 CamiTK");
    qtPropertyFieldEditor->setEnumValues(licenseEnum);
    qtPropertyFieldEditor->setPlaceHolderText("Edit to specify another license");
    qtPropertyFieldEditor->setEditableEnum(true); // if the user wants to enter other license
    qtPropertyFieldEditor->appendRowTo(extensionTabLayout);

    VariantDataModel& contactInfo = dataModel["contact"];
    if (!contactInfo.isValid()) {
        // if contactInfo does not exists, creates an empty map so that adding name and email are valid actions
        dataModel["contact"] = VariantDataModel(QVariantMap());
    }
    // Check if "contact" exists
    qtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["contact"]["author"], "Author", "Name of the extension author", "");
    qtPropertyFieldEditor->appendRowTo(extensionTabLayout);

    qtPropertyFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["contact"]["email"], "Email", "Email of the extension author", "");
    qtPropertyFieldEditor->setRegExp(R"(^[\w.-]+@[a-zA-Z\d.-]+\.[a-zA-Z]{2,}$)");
    qtPropertyFieldEditor->appendRowTo(extensionTabLayout);

}
