/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef TRANSFORMATION_MANAGER_BINDINGS_H
#define TRANSFORMATION_MANAGER_BINDINGS_H


#pragma push_macro("slots")
#undef slots
#include <pybind11/pybind11.h>
#pragma pop_macro("slots")

#include <QVector>

#include <vtkSmartPointer.h>
#include <vtkTransform.h>

namespace camitk {
class FrameOfReference;
class Transformation;
}

namespace py = pybind11;

namespace pybind11::detail {
template <>
struct type_caster<QVector<camitk::FrameOfReference*>> {
public:
    PYBIND11_TYPE_CASTER(QVector<camitk::FrameOfReference*>, const_name("list[FrameOfReference]"));
    bool load(handle src, bool);
    static handle cast(const QVector<camitk::FrameOfReference*>& src, return_value_policy, handle);
};

template <>
struct type_caster<QVector<camitk::Transformation*>> {
public:
    PYBIND11_TYPE_CASTER(QVector<camitk::Transformation*>, const_name("list[FrameOfReference]"));
    bool load(handle src, bool);
    static handle cast(const QVector<camitk::Transformation*>& src, return_value_policy, handle);
};

template<>
struct type_caster<vtkSmartPointer<vtkTransform>> {
public:
    PYBIND11_TYPE_CASTER(vtkSmartPointer<vtkTransform>, const_name("numpy.ndarray"));
    bool load(handle src, bool);
    static handle cast(vtkSmartPointer<vtkTransform> src, return_value_policy, handle);
};

} // namespace pybind11::detail


void add_transformation_manager_bindings(py::module_&);


#endif // TRANSFORMATION_MANAGER_BINDINGS_H