/* SPDX-FileCopyrightText: 2013 - Paolo Borelli
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <gtksourceview/gtksource.h>
#include "gtksourceview/gtksourceregex.h"

static void
test_backslash_c_pattern (void)
{
	GtkSourceRegex *regex;
	GError *error = NULL;

	regex = _gtk_source_regex_new ("\\C", 0, &error);
	g_assert_error (error, G_REGEX_ERROR, G_REGEX_ERROR_COMPILE);
	g_assert_null (regex);
}

int
main (int    argc,
      char **argv)
{
	gint ret;

	gtk_test_init (&argc, &argv);
	gtk_source_init ();

	g_test_add_func ("/Regex/backslash_c_pattern", test_backslash_c_pattern);

	ret = g_test_run ();
	gtk_source_finalize ();

	return ret;
}
