# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerorchestratorruntime import ContainerOrchestratorRuntimeMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerOrchestratorRuntimeMgmtStorageClassOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerOrchestratorRuntimeMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_class_get(self, resource_group):
        response = self.client.storage_class.get(
            resource_uri="str",
            storage_class_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_class_begin_create_or_update(self, resource_group):
        response = self.client.storage_class.begin_create_or_update(
            resource_uri="str",
            storage_class_name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "typeProperties": "storage_class_type_properties",
                    "accessModes": ["str"],
                    "allowVolumeExpansion": "str",
                    "dataResilience": "str",
                    "failoverSpeed": "str",
                    "limitations": ["str"],
                    "mountOptions": ["str"],
                    "performance": "str",
                    "priority": 0,
                    "provisioner": "str",
                    "provisioningState": "str",
                    "volumeBindingMode": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_class_begin_update(self, resource_group):
        response = self.client.storage_class.begin_update(
            resource_uri="str",
            storage_class_name="str",
            properties={
                "properties": {
                    "accessModes": ["str"],
                    "allowVolumeExpansion": "str",
                    "dataResilience": "str",
                    "failoverSpeed": "str",
                    "limitations": ["str"],
                    "mountOptions": ["str"],
                    "performance": "str",
                    "priority": 0,
                    "typeProperties": {
                        "azureStorageAccountKey": "str",
                        "azureStorageAccountName": "str",
                        "backingStorageClassName": "str",
                        "domain": "str",
                        "mountPermissions": "str",
                        "onDelete": "str",
                        "password": "str",
                        "server": "str",
                        "share": "str",
                        "source": "str",
                        "subDir": "str",
                        "username": "str",
                    },
                }
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_class_begin_delete(self, resource_group):
        response = self.client.storage_class.begin_delete(
            resource_uri="str",
            storage_class_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_class_list(self, resource_group):
        response = self.client.storage_class.list(
            resource_uri="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
