% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration5.R
\name{IntegrateLayers}
\alias{IntegrateLayers}
\title{Integrate Layers}
\usage{
IntegrateLayers(
  object,
  method,
  orig.reduction = "pca",
  assay = NULL,
  features = NULL,
  layers = NULL,
  scale.layer = "scale.data",
  ...
)
}
\arguments{
\item{object}{A \code{\link[SeuratObject]{Seurat}} object}

\item{method}{Integration method function}

\item{orig.reduction}{Name of dimensional reduction for correction}

\item{assay}{Name of assay for integration}

\item{features}{A vector of features to use for integration}

\item{layers}{Names of normalized layers in \code{assay}}

\item{scale.layer}{Name(s) of scaled layer(s) in \code{assay}}

\item{...}{Arguments passed on to \code{method}}
}
\value{
\code{object} with integration data added to it
}
\description{
Integrate Layers
}
\section{Integration Method Functions}{

The following integration method functions are available:
\Sexpr[stage=render,results=rd]{Seurat:::.rd_methods("integration")}
}

\seealso{
\link[Seurat:writing-integration]{Writing integration method functions}
}
\concept{integration}
